/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.util.Vector;
import pogo.gene.PogoException;
import pogo.gene.PogoUtil;

public class CheckLicence {
    private int licence;
    private static final int GPL = 0;
    private static final int LGPL = 1;
    private Vector results = new Vector();

    public CheckLicence(String[] filenames, String type) throws PogoException {
        if (type.toUpperCase().equals("GPL")) {
            this.licence = 0;
        } else if (type.toUpperCase().equals("LGPL")) {
            this.licence = 1;
        } else {
            throw new PogoException(type + "  ?? \n Unknown licence type", "CheckLicence.CheckLicence()");
        }
        String licencePart = this.getLicencePart();
        for (String filename : filenames) {
            try {
                String code = PogoUtil.readFile(filename);
                code = this.removeEndOfHeader(code);
                code = this.addLicencePart(code, licencePart);
                PogoUtil.writeFile(filename, code);
                this.results.add(new SourceFile(filename, "done"));
            }
            catch (Exception e) {
                this.results.add(new SourceFile(filename, e.toString()));
            }
        }
    }

    private String addLicencePart(String code, String licencePart) throws PogoException {
        if (code.indexOf(licencePart) > 0) {
            throw new PogoException("Alread done.");
        }
        int start = code.indexOf("$Author:");
        if (start < 0) {
            throw new PogoException("\"$Author:\"  tag not found");
        }
        start = code.indexOf("\n", start) + 1;
        int end = code.indexOf("$Revision:");
        end = end < 0 ? start : code.lastIndexOf("\n", end) + 1;
        code = code.substring(0, start) + licencePart + code.substring(end);
        return code;
    }

    private String removeEndOfHeader(String code) {
        int end = code.indexOf("$Revision:");
        if (end < 0) {
            return code;
        }
        if ((end = code.lastIndexOf("//", end)) < 0) {
            return code;
        }
        boolean found = false;
        while (!found) {
            if (code.substring(end = code.indexOf("\n", end) + 1).startsWith("//")) continue;
            end = code.lastIndexOf("//", end);
            found = true;
        }
        int start = code.lastIndexOf("//", end - 1);
        String bottom = code.substring(start = code.lastIndexOf("//", start - 1), end);
        if (bottom.indexOf("Software Engineering Group") > 0) {
            code = code.substring(0, start) + code.substring(end);
            end = start;
            start = code.lastIndexOf("//", end - 1);
        }
        if ((bottom = code.substring(start = code.lastIndexOf("//", start - 1), end)).toLowerCase().indexOf("copyright") > 0 || bottom.toLowerCase().indexOf("copyleft") > 0) {
            code = code.substring(0, start) + code.substring(end);
        }
        return code;
    }

    private String getLicencePart() throws PogoException {
        String add_part;
        String path = System.getProperty("TEMPL_HOME");
        if (path == null) {
            throw new PogoException("TEMPL_HOME (template home directory) is not set.", "CheckLicence.getLicencePart()");
        }
        try {
            String header = PogoUtil.readFile(path + "/licences/LGPL");
            int start = header.indexOf("Copyright");
            if (start < 0) {
                throw new PogoException("Bad syntax in template.");
            }
            start = header.lastIndexOf(10, start - 1);
            start = header.lastIndexOf(10, start - 1) + 1;
            int end = header.indexOf("$Revision");
            if (end < 0) {
                throw new PogoException("Bad syntax in template.");
            }
            end = header.lastIndexOf(10, end) + 1;
            add_part = header.substring(start, end);
            if (this.licence == 0) {
                add_part = this.convertToGPL(add_part);
            }
        }
        catch (Exception e) {
            throw new PogoException(e.toString(), "CheckLicence.getLicencePart()");
        }
        return add_part;
    }

    private String convertToGPL(String str) {
        int start;
        String lesser = "Lesser ";
        while ((start = str.indexOf(lesser)) > 0) {
            int end = start + lesser.length();
            if (end > start) {
                str = str.substring(0, start) + str.substring(end);
                continue;
            }
            str = str.substring(0, start);
        }
        return str;
    }

    private String buildLine(SourceFile sf, int max_len) {
        StringBuffer sb = new StringBuffer(sf.name);
        for (int i = sf.name.length(); i < max_len; ++i) {
            sb.append('.');
        }
        sb.append("....");
        sb.append(sf.result);
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Modify header for " + (this.licence == 0 ? "GPL" : "LGPL") + " licence\n");
        int length = 0;
        for (Object o : this.results) {
            if (((SourceFile)o).name.length() <= length) continue;
            length = ((SourceFile)o).name.length();
        }
        for (Object o : this.results) {
            sb.append(this.buildLine((SourceFile)o, length)).append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("CheckLicence <type> file1 file2 file3 ....");
            System.out.println("      - where type is GPL or LGP");
            System.exit(-1);
        }
        String type = args[0];
        String[] filenames = new String[args.length - 1];
        for (int i = 0; i < args.length - 1; ++i) {
            filenames[i] = args[i + 1];
        }
        try {
            CheckLicence cl = new CheckLicence(filenames, type);
            System.out.println(cl);
        }
        catch (PogoException e) {
            System.out.println(e);
        }
    }

    private class SourceFile {
        String name;
        String result;

        SourceFile(String name, String result) {
            this.name = name;
            String except = "PogoException:\n";
            int pos = result.indexOf(10);
            if (pos < 0) {
                pos = result.indexOf(58);
            }
            this.result = pos < 0 ? result : result.substring(pos + 1);
        }

        public String toString() {
            return this.name + ":\t" + this.result;
        }
    }
}

