/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jgl3dchart;

import com.braju.format.Format;
import fr.esrf.tangoatk.widget.util.jgl3dchart.JGL3DView;
import fr.esrf.tangoatk.widget.util.jgl3dchart.LabelInfo;
import fr.esrf.tangoatk.widget.util.jgl3dchart.Utils;
import fr.esrf.tangoatk.widget.util.jgl3dchart.VERTEX3D;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;
import javax.media.opengl.GL;

public class JGL3DAxis {
    public static final int XAXIS = 0;
    public static final int YAXIS = 1;
    public static final int ZAXIS = 2;
    public static final int AUTO_FORMAT = 0;
    public static final int SCIENTIFIC_FORMAT = 1;
    public static final int TIME_FORMAT = 2;
    public static final int DECINT_FORMAT = 3;
    public static final int HEXINT_FORMAT = 4;
    public static final int BININT_FORMAT = 5;
    public static final int SCIENTIFICINT_FORMAT = 6;
    public static final int LINEAR_SCALE = 0;
    public static final int LOG_SCALE = 1;
    static final String[] labelFomats = new String[]{"%g", "", "%02d:%02d:%02d", "%d", "%X", "%b"};
    VERTEX3D p1;
    VERTEX3D p2;
    VERTEX3D normal;
    private JGL3DView parent;
    private Color labelColor;
    private Font labelFont;
    private Color nameColor;
    private Font nameFont;
    private int labelFormat;
    private int scale;
    Vector labelInfo;
    LabelInfo nameInfo;
    private int type;
    private String name;
    private boolean drawAble;
    private boolean visible;
    private double min;
    private double max;
    private double minimum;
    private double maximum;
    private boolean autoScale;
    private int tickSpacing;
    private double offLabel;
    private double atOffset;
    private double atGain;

    public JGL3DAxis(JGL3DView jGL3DView, int n) {
        this.type = n;
        this.parent = jGL3DView;
        this.labelFont = new Font("Dialog", 0, 11);
        this.nameFont = new Font("Dialog", 1, 11);
        this.labelColor = Color.black;
        this.labelFormat = 0;
        this.scale = 0;
        this.labelInfo = new Vector();
        this.name = "";
        this.drawAble = true;
        this.visible = true;
        this.min = 0.0;
        this.max = 100.0;
        this.minimum = 0.0;
        this.maximum = 100.0;
        this.autoScale = true;
        this.tickSpacing = 30;
        this.offLabel = 4.0;
        this.atOffset = 0.0;
        this.atGain = 1.0;
    }

    public void setLabelFormat(int n) {
        this.labelFormat = n;
    }

    public int getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setNameFont(Font font) {
        this.nameFont = font;
    }

    public Font getNameFont() {
        return this.nameFont;
    }

    public void setNameColor(Color color) {
        this.nameColor = color;
    }

    public Color getNameColor() {
        return this.nameColor;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setMaximum(double d) {
        this.maximum = d;
        this.parent.computeScale();
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMinimum(double d) {
        this.minimum = d;
        this.parent.computeScale();
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setAutoScale(boolean bl) {
        this.autoScale = bl;
        this.parent.computeScale();
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setTickSpacing(int n) {
        this.tickSpacing = n;
    }

    public int getTickSpacing() {
        return this.tickSpacing;
    }

    public void setTitleOffset(double d) {
        this.offLabel = d;
    }

    public double getTitleOffset() {
        return this.offLabel;
    }

    public void setOffsetTransform(double d) {
        this.atOffset = d;
        this.parent.computeScale();
    }

    public double getOffsetTransform() {
        return this.atOffset;
    }

    public void setGainTransform(double d) {
        this.atGain = d;
        this.parent.computeScale();
    }

    public double getGainTransform() {
        return this.atGain;
    }

    boolean isDrawAble() {
        return this.drawAble;
    }

    double getMin() {
        return this.min;
    }

    double getMax() {
        return this.max;
    }

    void setMin(double d) {
        this.min = d;
    }

    void setMax(double d) {
        this.max = d;
    }

    void setPosition(VERTEX3D vERTEX3D, VERTEX3D vERTEX3D2) {
        this.p1 = vERTEX3D;
        this.p2 = vERTEX3D2;
    }

    void setNormal(VERTEX3D vERTEX3D) {
        this.normal = vERTEX3D;
    }

    private String toScientific(double d) {
        double d2 = Math.abs(d);
        int n = 0;
        String string = "%.2fe%d";
        if (d2 != 0.0) {
            if (d2 < 1.0) {
                while (d2 < 1.0) {
                    d2 *= 10.0;
                    --n;
                }
            } else {
                while (d2 >= 10.0) {
                    d2 /= 10.0;
                    ++n;
                }
            }
        }
        if (d2 >= 9.999999999) {
            d2 /= 10.0;
            ++n;
        }
        if (d < 0.0) {
            d2 = -d2;
        }
        Object[] objectArray = new Object[]{new Double(d2), new Integer(n)};
        return Format.sprintf((String)string, (Object[])objectArray);
    }

    private String toScientificInt(double d) {
        double d2 = Math.abs(d);
        int n = 0;
        String string = "%de%d";
        if (d2 != 0.0) {
            if (d2 < 1.0) {
                while (d2 < 1.0) {
                    d2 *= 10.0;
                    --n;
                }
            } else {
                while (d2 >= 10.0) {
                    d2 /= 10.0;
                    ++n;
                }
            }
        }
        if (d2 >= 9.999999999) {
            d2 /= 10.0;
            ++n;
        }
        if (d < 0.0) {
            d2 = -d2;
        }
        Object[] objectArray = new Object[]{new Integer((int)Math.rint(d2)), new Integer(n)};
        return Format.sprintf((String)string, (Object[])objectArray);
    }

    private String suppressZero(String string) {
        boolean bl;
        boolean bl2 = bl = string.indexOf(46) != -1;
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = stringBuffer.length() - 1;
            while (stringBuffer.charAt(n) == '0') {
                stringBuffer.deleteCharAt(n);
                --n;
            }
            if (stringBuffer.charAt(n) == '.') {
                stringBuffer.deleteCharAt(n);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    private String formatValue(double d, double d2) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d2 != 0.0 && this.scale == 0) {
            boolean bl;
            boolean bl2 = bl = d < 0.0;
            if (bl) {
                d = -d;
            }
            double d3 = Math.floor(d / d2 + 0.5);
            d = d3 * d2;
            if (bl) {
                d = -d;
            }
        }
        switch (this.labelFormat) {
            case 1: {
                return this.toScientific(d);
            }
            case 6: {
                return this.toScientificInt(d);
            }
            case 3: 
            case 4: 
            case 5: {
                Object[] objectArray = new Object[]{new Integer((int)(Math.abs(d) + 0.5))};
                if (d < 0.0) {
                    return "-" + Format.sprintf((String)labelFomats[this.labelFormat], (Object[])objectArray);
                }
                return Format.sprintf((String)labelFomats[this.labelFormat], (Object[])objectArray);
            }
            case 2: {
                int n = (int)Math.abs(d);
                Object[] objectArray = new Object[]{new Integer(n / 3600), new Integer(n % 3600 / 60), new Integer(n % 60)};
                if (d < 0.0) {
                    return "-" + Format.sprintf((String)labelFomats[this.labelFormat], (Object[])objectArray);
                }
                return Format.sprintf((String)labelFomats[this.labelFormat], (Object[])objectArray);
            }
        }
        if (d == 0.0) {
            return "0";
        }
        if (Math.abs(d) <= 1.0E-4) {
            return this.toScientific(d);
        }
        int n = -((int)Math.floor(Math.log10(d2)));
        if (n <= 0) {
            return this.suppressZero(Double.toString(d));
        }
        String string = "%." + n + "f";
        return this.suppressZero(Format.sprintf((String)string, (Object[])new Object[]{new Double(d)}));
    }

    private void computeTicks(GL gL, double d) {
        Object object;
        double d2;
        double d3;
        double d4 = 0.0;
        double d5 = 0.0;
        VERTEX3D vERTEX3D = new VERTEX3D();
        boolean bl = false;
        double[] dArray = new double[2];
        switch (this.type) {
            case 0: {
                d4 = this.p1.x;
                d5 = this.p2.x;
                vERTEX3D.x = 0.0;
                vERTEX3D.y = this.p1.y;
                vERTEX3D.z = this.p1.z;
                break;
            }
            case 1: {
                d4 = this.p1.y;
                d5 = this.p2.y;
                vERTEX3D.x = this.p1.x;
                vERTEX3D.y = 0.0;
                vERTEX3D.z = this.p1.z;
                break;
            }
            case 2: {
                d4 = this.p1.z;
                d5 = this.p2.z;
                vERTEX3D.x = this.p1.x;
                vERTEX3D.y = this.p1.y;
                vERTEX3D.z = 0.0;
            }
        }
        double d6 = this.computeLowTen(d5 - d4);
        int n = (int)Math.rint((d5 - d4) / d6);
        int n2 = (int)d / this.tickSpacing;
        if (n2 > 20) {
            n2 = 20;
        }
        double d7 = d5 - d4;
        int n3 = 10;
        double d8 = d7 / d;
        if (n <= n2) {
            n = (int)Math.rint((d5 - d4) / (d6 / 2.0));
            while (n <= n2) {
                n3 = 5;
                n = (int)Math.rint((d5 - d4) / ((d6 /= 2.0) / 5.0));
                if (n > n2) continue;
                n3 = 10;
                n = (int)Math.rint((d5 - d4) / ((d6 /= 5.0) / 2.0));
            }
        } else {
            while (n > n2) {
                n3 = 5;
                n = (int)Math.rint((d5 - d4) / (d6 *= 5.0));
                if (n <= n2) continue;
                n3 = 10;
                n = (int)Math.rint((d5 - d4) / (d6 *= 2.0));
            }
        }
        long l = (long)Math.floor(d4 / d6);
        int n4 = 0;
        for (d3 = d2 = (double)l * d6; d3 <= d5 + d8; d3 += d6) {
            if (!(d3 >= d4 - d8)) continue;
            ++n4;
        }
        if (n4 <= 2) {
            if (n3 == 10) {
                n3 = 5;
                d6 /= 2.0;
            } else {
                n3 = 10;
                d6 /= 5.0;
            }
            bl = true;
        }
        VERTEX3D vERTEX3D2 = new VERTEX3D(this.p2.x - this.p1.x, this.p2.y - this.p1.y, this.p2.z - this.p1.z);
        vERTEX3D2.normalize();
        while (d2 <= d5 + d8) {
            if (d2 > d4 - d8) {
                object = new LabelInfo();
                d3 = d2;
                ((LabelInfo)object).p1 = new VERTEX3D(d3 * vERTEX3D2.x + vERTEX3D.x, d3 * vERTEX3D2.y + vERTEX3D.y, d3 * vERTEX3D2.z + vERTEX3D.z);
                ((LabelInfo)object).p2 = new VERTEX3D(d3 * vERTEX3D2.x + this.normal.x + vERTEX3D.x, d3 * vERTEX3D2.y + this.normal.y + vERTEX3D.y, d3 * vERTEX3D2.z + this.normal.z + vERTEX3D.z);
                ((LabelInfo)object).value = this.formatValue(d2, d6);
                ((LabelInfo)object).labelFont = this.labelFont;
                ((LabelInfo)object).labelColor = this.labelColor;
                double d9 = 1.5;
                Utils.project(gL, d3 * vERTEX3D2.x + vERTEX3D.x, d3 * vERTEX3D2.y + vERTEX3D.y, d3 * vERTEX3D2.z + vERTEX3D.z, dArray);
                ((LabelInfo)object).x1 = dArray[0];
                ((LabelInfo)object).y1 = dArray[1];
                Utils.project(gL, d3 * vERTEX3D2.x + vERTEX3D.x + this.normal.x * d9, d3 * vERTEX3D2.y + vERTEX3D.y + this.normal.y * d9, d3 * vERTEX3D2.z + vERTEX3D.z + this.normal.z * d9, dArray);
                ((LabelInfo)object).x2 = dArray[0];
                ((LabelInfo)object).y2 = dArray[1];
                this.labelInfo.add(object);
            }
            d2 += d6;
        }
        if (bl && this.labelInfo.size() > 2) {
            object = new Vector();
            LabelInfo labelInfo = (LabelInfo)this.labelInfo.get(0);
            LabelInfo labelInfo2 = (LabelInfo)this.labelInfo.get(this.labelInfo.size() - 1);
            ((Vector)object).add(labelInfo);
            ((Vector)object).add(labelInfo2);
            this.labelInfo = object;
        }
        double d10 = (d5 + d4) / 2.0;
        this.nameInfo = new LabelInfo();
        this.nameInfo.value = this.name;
        this.nameInfo.labelFont = this.nameFont;
        this.nameInfo.labelColor = this.nameColor;
        Utils.project(gL, d10 * vERTEX3D2.x + vERTEX3D.x, d10 * vERTEX3D2.y + vERTEX3D.y, d10 * vERTEX3D2.z + vERTEX3D.z, dArray);
        this.nameInfo.x1 = dArray[0];
        this.nameInfo.y1 = dArray[1];
        Utils.project(gL, d10 * vERTEX3D2.x + vERTEX3D.x + this.normal.x * this.offLabel, d10 * vERTEX3D2.y + vERTEX3D.y + this.normal.y * this.offLabel, d10 * vERTEX3D2.z + vERTEX3D.z + this.normal.z * this.offLabel, dArray);
        this.nameInfo.x2 = dArray[0];
        this.nameInfo.y2 = dArray[1];
    }

    private double computeHighTen(double d) {
        int n = (int)Math.log10(d);
        return Math.pow(10.0, n + 1);
    }

    private double computeLowTen(double d) {
        int n = (int)Math.log10(d);
        return Math.pow(10.0, n);
    }

    void measureAxis(GL gL) {
        this.labelInfo.clear();
        double[] dArray = new double[2];
        Utils.project(gL, this.p1.x, this.p1.y, this.p1.z, dArray);
        double d = dArray[0];
        double d2 = dArray[1];
        Utils.project(gL, this.p2.x, this.p2.y, this.p2.z, dArray);
        double d3 = dArray[0];
        double d4 = dArray[1];
        double d5 = Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        this.drawAble = !(d5 < 10.0);
        if (this.drawAble) {
            this.computeTicks(gL, d5);
        }
    }

    void paintAxis(GL gL) {
        if (!this.drawAble || !this.visible) {
            return;
        }
        gL.glDisable(2896);
        gL.glDisable(3553);
        gL.glDisable(2929);
        gL.glDisable(2852);
        gL.glLineWidth(2.0f);
        gL.glColor3f((float)this.labelColor.getRed() / 255.0f, (float)this.labelColor.getGreen() / 255.0f, (float)this.labelColor.getBlue() / 255.0f);
        gL.glBegin(1);
        gL.glVertex3d(this.p1.x, this.p1.y, this.p1.z);
        gL.glVertex3d(this.p2.x, this.p2.y, this.p2.z);
        gL.glEnd();
        gL.glLineWidth(1.0f);
        gL.glBegin(1);
        for (int i = 0; i < this.labelInfo.size(); ++i) {
            LabelInfo labelInfo = (LabelInfo)this.labelInfo.get(i);
            gL.glVertex3d(labelInfo.p1.x, labelInfo.p1.y, labelInfo.p1.z);
            gL.glVertex3d(labelInfo.p2.x, labelInfo.p2.y, labelInfo.p2.z);
        }
        gL.glEnd();
    }
}

