/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.properties;

import fr.esrf.tangoatk.core.Property;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class PropertyFieldEditor
extends JTextField
implements PropertyChangeListener {
    private boolean askConfirmation = false;
    private String titleAskConfirmation = "Confirmation";
    private String textAskConfirmation = "Do you want to modify the property ?";
    private Property model = null;

    public PropertyFieldEditor() {
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyFieldEditor.this.setProperty();
            }
        });
        this.setEditable(false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("presentation".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof Property) {
            this.setText(((Property)propertyChangeEvent.getSource()).getPresentation());
            this.setEditable(((Property)propertyChangeEvent.getSource()).isEditable());
        }
    }

    protected void setProperty() {
        int n;
        if (this.askConfirmation && (n = JOptionPane.showConfirmDialog(this, this.textAskConfirmation, this.titleAskConfirmation, 0)) != 0) {
            if (this.model != null) {
                this.setText(this.model.getPresentation());
            } else {
                this.setText("");
            }
            return;
        }
        if (this.model != null) {
            if (this.model.isEditable()) {
                this.model.setValueFromString(this.getText());
                this.setText(this.model.getPresentation());
                this.model.store();
            } else {
                this.setText(this.model.getPresentation());
            }
        } else {
            this.setText("");
        }
    }

    public Property getModel() {
        return this.model;
    }

    public void setModel(Property property) {
        if (this.model != null) {
            this.model.removePresentationListener((PropertyChangeListener)this);
        }
        this.model = property;
        if (property != null) {
            property.addPresentationListener((PropertyChangeListener)this);
            this.setText(property.getPresentation());
            this.setEditable(property.isEditable());
        } else {
            this.setText("");
            this.setEditable(false);
        }
    }

    public void clearModel() {
        this.setModel(null);
    }

    public boolean isAskConfirmation() {
        return this.askConfirmation;
    }

    public void setAskConfirmation(boolean bl) {
        this.askConfirmation = bl;
    }

    public String getTextAskConfirmation() {
        return this.textAskConfirmation;
    }

    public void setTextAskConfirmation(String string) {
        this.textAskConfirmation = string;
    }

    public String getTitleAskConfirmation() {
        return this.titleAskConfirmation;
    }

    public void setTitleAskConfirmation(String string) {
        this.titleAskConfirmation = string;
    }
}

