/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.image.IImageFormat;
import java.io.IOException;

public class RGB24ImageFormat
extends IImageFormat {
    public void setData(byte[] byArray) throws IOException {
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = (n <<= 8) | n2;
        int n4 = byArray[2] & 0xFF;
        int n5 = byArray[3] & 0xFF;
        int n6 = (n4 <<= 8) | n5;
        int n7 = 4;
        this.data = new byte[n6][n3 * 3];
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n3; ++j) {
                this.data[i][j * 3 + 2] = byArray[n7++];
                this.data[i][j * 3 + 1] = byArray[n7++];
                this.data[i][j * 3 + 0] = byArray[n7++];
            }
        }
    }

    public int getWidth() {
        if (this.getHeight() == 0) {
            return 0;
        }
        return this.data[0].length / 3;
    }

    public String getName() {
        return "RGB24";
    }

    public boolean isColorFormat() {
        return true;
    }

    public int getHistogramWidth() {
        return 256;
    }

    public double getValue(int n, int n2) {
        int n3 = this.data[n2][n * 3 + 1] & 0xFF;
        return n3;
    }

    public String getValueStr(int n, int n2) {
        int n3 = this.data[n2][n * 3 + 2] & 0xFF;
        int n4 = this.data[n2][n * 3 + 1] & 0xFF;
        int n5 = this.data[n2][n * 3 + 0] & 0xFF;
        return "(" + n3 + "," + n4 + "," + n5 + ")";
    }

    public void computeFitting() {
    }

    public int getRGB(boolean bl, int[] nArray, int n, int n2) {
        if (!bl) {
            int n3 = this.data[n2][n * 3 + 2] & 0xFF;
            int n4 = this.data[n2][n * 3 + 1] & 0xFF;
            int n5 = this.data[n2][n * 3 + 0] & 0xFF;
            return (n3 << 16) + (n4 << 8) + n5;
        }
        int n6 = ~this.data[n2][n * 3 + 2] & 0xFF;
        int n7 = ~this.data[n2][n * 3 + 1] & 0xFF;
        int n8 = ~this.data[n2][n * 3 + 0] & 0xFF;
        return (n6 << 16) + (n7 << 8) + n8;
    }
}

