/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.image.IImageFormat;
import java.io.IOException;

public class Mono16ImageFormat
extends IImageFormat {
    public void setData(byte[] byArray) throws IOException {
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = (n <<= 8) | n2;
        int n4 = byArray[2] & 0xFF;
        int n5 = byArray[3] & 0xFF;
        int n6 = (n4 <<= 8) | n5;
        int n7 = 4;
        this.data = new byte[n6][n3 * 2];
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n3; ++j) {
                this.data[i][j * 2 + 0] = byArray[n7++];
                this.data[i][j * 2 + 1] = byArray[n7++];
            }
        }
    }

    public int getWidth() {
        if (this.getHeight() == 0) {
            return 0;
        }
        return this.data[0].length / 2;
    }

    public String getName() {
        return "MONO16";
    }

    public boolean isColorFormat() {
        return false;
    }

    public int getHistogramWidth() {
        return 65536;
    }

    public double getValue(int n, int n2) {
        int n3 = this.data[n2][2 * n] & 0xFF;
        int n4 = this.data[n2][2 * n + 1] & 0xFF;
        return (n3 << 8) + n4;
    }

    public String getValueStr(int n, int n2) {
        return Double.toString(this.getValue(n, n2));
    }

    public void computeFitting() {
        if (!this.bestFit) {
            this.tool.getAxis().setMinimum(-this.bfA0);
            this.tool.getAxis().setMaximum(-this.bfA0 + 1.0 / this.bfA1 * 65536.0);
        } else {
            double d = 65536.0;
            double d2 = 0.0;
            for (int i = 0; i < this.data.length; ++i) {
                for (int j = 0; j < this.data[i].length / 2; ++j) {
                    int n = this.data[i][2 * j] & 0xFF;
                    int n2 = this.data[i][2 * j + 1] & 0xFF;
                    double d3 = (n << 8) + n2;
                    if (d3 > d2) {
                        d2 = d3;
                    }
                    if (!(d3 < d)) continue;
                    d = d3;
                }
            }
            this.bfA0 = -d;
            if (d2 == d) {
                this.bfA1 = 0.0;
                this.tool.getAxis().setMinimum(d);
                this.tool.getAxis().setMaximum(d2 + 1.0);
            } else {
                this.bfA1 = 65536.0 / (d2 - d);
                this.tool.getAxis().setMinimum(d);
                this.tool.getAxis().setMaximum(d2);
            }
        }
    }

    private int bestFit(int n) {
        int n2 = (int)((this.bfA0 + (double)n) * this.bfA1);
        if (n2 < 0) {
            return 0;
        }
        if (n2 > 65535) {
            return 65535;
        }
        return n2;
    }

    public int getRGB(boolean bl, int[] nArray, int n, int n2) {
        int n3 = this.data[n2][2 * n] & 0xFF;
        int n4 = this.data[n2][2 * n + 1] & 0xFF;
        int n5 = (n3 << 8) + n4;
        if (bl) {
            return nArray[~this.bestFit(n5) & 0xFFFF];
        }
        return nArray[this.bestFit(n5)];
    }
}

