/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class JpegDecoder
extends InputStream {
    public static final int RGB24 = 1;
    public static final int GRAY8 = 2;
    private byte[] cache;
    private int pos;
    private int type;

    public JpegDecoder(byte[] byArray) {
        this.cache = byArray;
        this.pos = 0;
        this.type = 0;
    }

    public int GetType() {
        return this.type;
    }

    public byte[][] decode() throws IOException {
        byte[][] byArray = null;
        this.pos = 0;
        BufferedImage bufferedImage = ImageIO.read(this);
        if (bufferedImage == null) {
            throw new IOException("Jpeg decoding error");
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage.getType();
        int n4 = 0;
        switch (n3) {
            case 5: {
                n3 = 1;
                byArray = new byte[n2][n * 3];
                DataBufferByte dataBufferByte = (DataBufferByte)bufferedImage.getRaster().getDataBuffer();
                for (int i = 0; i < n2; ++i) {
                    System.arraycopy(dataBufferByte.getData(), n4, byArray[i], 0, n * 3);
                    n4 += n * 3;
                }
                break;
            }
            case 10: {
                n3 = 2;
                byArray = new byte[n2][n];
                DataBufferByte dataBufferByte = (DataBufferByte)bufferedImage.getRaster().getDataBuffer();
                for (int i = 0; i < n2; ++i) {
                    System.arraycopy(dataBufferByte.getData(), n4, byArray[i], 0, n);
                    n4 += n;
                }
                break;
            }
            default: {
                throw new IOException("Unsupported jpeg format");
            }
        }
        return byArray;
    }

    public int read() throws IOException {
        if (this.pos >= this.cache.length) {
            return -1;
        }
        int n = this.cache[this.pos];
        ++this.pos;
        return n &= 0xFF;
    }

    public int available() throws IOException {
        return this.cache.length - this.pos;
    }
}

