/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.device;

import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IDeviceApplication;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.widget.device.IDevicePopUp;
import fr.esrf.tangoatk.widget.device.SingletonStatusViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class SimpleStateViewer
extends JSmoothLabel
implements IStateListener,
IErrorListener {
    private Device device;
    String state = "UNKNOWN";
    boolean externalSetText = false;
    boolean stateClickable = true;
    IDeviceApplication application;
    IDevicePopUp popUp = SingletonStatusViewer.getInstance();

    public SimpleStateViewer() {
        this.setFont(ATKConstant.labelFont);
        this.setPreferredSize(new Dimension(40, 14));
        this.setOpaque(true);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SimpleStateViewer.this.valueLabelMouseClicked(mouseEvent);
            }
        });
    }

    private void valueLabelMouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            if (this.application == null) {
                return;
            }
            this.application.setModel((IDevice)this.device);
            this.application.run();
            return;
        }
        if (this.stateClickable && this.device != null) {
            this.popUp.setModel((IDevice)this.device);
            this.popUp.setVisible(true);
        }
    }

    public void setModel(Device device) {
        if (this.device != null) {
            this.clearModel();
        }
        if (device == null) {
            return;
        }
        this.device = device;
        if (!this.device.areDevPropertiesLoaded()) {
            this.device.loadDevProperties();
        }
        this.device.addStateListener((IStateListener)this);
        this.device.addErrorListener((IErrorListener)this);
        this.setState(this.device.getState());
        this.setToolTipText(this.device.getName());
    }

    public void clearModel() {
        if (this.device != null) {
            this.device.removeStateListener((IStateListener)this);
            this.device.removeErrorListener((IErrorListener)this);
            this.device = null;
            this.setState("UNKNOWN");
            this.setToolTipText("no device");
        }
    }

    public Device getModel() {
        return this.device;
    }

    private void setState(String string) {
        this.state = string;
        if (this.device != null) {
            this.setBackground(ATKConstant.getColor4State(string, this.device.getInvertedOpenClose(), this.device.getInvertedInsertExtract()));
        } else {
            this.setBackground(ATKConstant.getColor4State(string));
        }
    }

    public String getState() {
        return this.state;
    }

    public void stateChange(StateEvent stateEvent) {
        this.setState(stateEvent.getState());
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setState("UNKNOWN");
    }

    public void setStateClickable(boolean bl) {
        this.stateClickable = bl;
    }

    public boolean isStateClickable() {
        return this.stateClickable;
    }

    public void setApplication(IDeviceApplication iDeviceApplication) {
        this.application = iDeviceApplication;
    }

    public IDeviceApplication getApplication() {
        return this.application;
    }

    public IDevicePopUp getPopUp() {
        return this.popUp;
    }

    public void setPopUp(IDevicePopUp iDevicePopUp) {
        this.popUp = iDevicePopUp;
    }
}

