/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import com.braju.format.Format;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateSpectrumEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IDevStateSpectrum;
import fr.esrf.tangoatk.core.IDevStateSpectrumListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.core.IStringSpectrumListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.core.StringSpectrumEvent;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.chart.ColorItem;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.border.EtchedBorder;

public class NumberSpectrumStateBarChartViewer
extends JLChart
implements IJLChartListener,
ISpectrumListener,
IDevStateSpectrumListener,
IStringSpectrumListener,
INumberScalarListener {
    private INumberSpectrum numberModel = null;
    private IDevStateSpectrum stateModel = null;
    private IStringSpectrum nameModel = null;
    private INumberScalar minAlarmModel = null;
    private INumberScalar maxAlarmModel = null;
    private JLDataView dvy = null;
    private JLDataView minAlarmDv = null;
    private JLDataView maxAlarmDv = null;
    private SimplePropertyFrame pf = null;
    private double A0 = 0.0;
    private double A1 = 1.0;
    private String format = null;
    private String[] currentStates = null;
    private String[] names = null;
    private Color defaultBarChartColor = Color.BLUE;

    public NumberSpectrumStateBarChartViewer() {
        this.setBorder(new EtchedBorder());
        this.getY1Axis().setAutoScale(true);
        this.getXAxis().setAutoScale(true);
        this.getXAxis().setAnnotation(2);
        this.dvy = new JLDataView();
        this.dvy.setViewType(1);
        this.dvy.setBarWidth(5);
        this.dvy.setFillStyle(1);
        this.dvy.setLineWidth(0);
        this.dvy.setColor(this.defaultBarChartColor);
        this.dvy.setFillColor(this.defaultBarChartColor);
        this.dvy.setLabelVisible(false);
        this.getY1Axis().addDataView(this.dvy);
        this.minAlarmDv = new JLDataView();
        this.minAlarmDv.setName("Min Alarm");
        this.minAlarmDv.setStyle(3);
        this.minAlarmDv.setColor(Color.BLACK);
        this.maxAlarmDv = new JLDataView();
        this.maxAlarmDv.setName("Max Alarm");
        this.maxAlarmDv.setStyle(3);
        this.maxAlarmDv.setColor(Color.BLACK);
        this.setJLChartListener(this);
    }

    public Color getDefaultBarChartColor() {
        return this.defaultBarChartColor;
    }

    public void setDefaultBarChartColor(Color color) {
        if (this.defaultBarChartColor != color) {
            this.defaultBarChartColor = color;
            this.dvy.setColor(this.defaultBarChartColor);
            this.dvy.setFillColor(this.defaultBarChartColor);
            this.repaint();
        }
    }

    public void setModel(INumberSpectrum iNumberSpectrum) {
        this.clearNumberModel();
        if (iNumberSpectrum == null) {
            this.repaint();
            return;
        }
        this.numberModel = iNumberSpectrum;
        this.format = this.numberModel.getFormat();
        this.dvy.setUserFormat(this.format);
        this.dvy.setUnit(iNumberSpectrum.getUnit());
        this.dvy.setName(iNumberSpectrum.getName());
        this.numberModel.addSpectrumListener((ISpectrumListener)this);
        if (this.pf != null) {
            this.pf.setModel((IAttribute)this.numberModel);
        }
        this.repaint();
    }

    public void clearNumberModel() {
        if (this.numberModel != null) {
            this.numberModel.removeSpectrumListener((ISpectrumListener)this);
            if (this.pf != null) {
                this.pf.setModel(null);
            }
            this.numberModel = null;
        }
        this.setToolTipText(null);
    }

    public void setModel(IDevStateSpectrum iDevStateSpectrum) {
        this.clearStateModel();
        if (iDevStateSpectrum == null) {
            this.repaint();
            return;
        }
        this.stateModel = iDevStateSpectrum;
        this.stateModel.addDevStateSpectrumListener((IDevStateSpectrumListener)this);
        this.repaint();
    }

    public void clearStateModel() {
        if (this.stateModel != null) {
            this.stateModel.removeDevStateSpectrumListener((IDevStateSpectrumListener)this);
            this.stateModel = null;
            for (int i = 0; i < this.currentStates.length; ++i) {
                this.dvy.setBarFillColorAt(i, ATKConstant.getColor4State("UNKNOWN"));
            }
        }
        this.currentStates = null;
    }

    public void setModel(IStringSpectrum iStringSpectrum) {
        this.clearNameModel();
        if (iStringSpectrum == null) {
            return;
        }
        this.nameModel = iStringSpectrum;
        this.nameModel.addListener((IStringSpectrumListener)this);
    }

    public void clearNameModel() {
        if (this.nameModel != null) {
            this.nameModel.removeListener((IStringSpectrumListener)this);
            this.nameModel = null;
        }
    }

    public void setMinAlarmModel(INumberScalar iNumberScalar) {
        this.clearMinAlarmModel();
        if (iNumberScalar == null) {
            return;
        }
        this.getY1Axis().addDataView(this.minAlarmDv);
        this.minAlarmModel = iNumberScalar;
        this.minAlarmModel.addNumberScalarListener((INumberScalarListener)this);
        this.repaint();
    }

    public void clearMinAlarmModel() {
        if (this.minAlarmModel != null) {
            this.minAlarmDv.reset();
            this.minAlarmModel.removeNumberScalarListener((INumberScalarListener)this);
            this.minAlarmModel = null;
            this.getY1Axis().removeDataView(this.minAlarmDv);
            this.repaint();
        }
    }

    public void setMaxAlarmModel(INumberScalar iNumberScalar) {
        this.clearMaxAlarmModel();
        if (iNumberScalar == null) {
            return;
        }
        this.getY1Axis().addDataView(this.maxAlarmDv);
        this.maxAlarmModel = iNumberScalar;
        this.maxAlarmModel.addNumberScalarListener((INumberScalarListener)this);
        this.repaint();
    }

    public void clearMaxAlarmModel() {
        if (this.maxAlarmModel != null) {
            this.maxAlarmDv.reset();
            this.maxAlarmModel.removeNumberScalarListener((INumberScalarListener)this);
            this.maxAlarmModel = null;
            this.getY1Axis().removeDataView(this.maxAlarmDv);
            this.repaint();
        }
    }

    public String[] clickOnChart(JLChartEvent jLChartEvent) {
        int n;
        String[] stringArray;
        String string = null;
        String string2 = null;
        int n2 = -1;
        if (jLChartEvent.getDataView() != this.dvy) {
            return null;
        }
        if (this.numberModel == null) {
            stringArray = new String[2];
            n2 = 0;
        } else {
            stringArray = new String[3];
            stringArray[0] = this.numberModel.getName();
            n2 = 1;
            if (this.format != null) {
                Object[] objectArray = new Object[]{new Double(jLChartEvent.getTransformedYValue())};
                string = Format.sprintf((String)this.format, (Object[])objectArray) + " " + this.numberModel.getUnit();
            } else {
                string = jLChartEvent.getTransformedYValue() + " " + this.numberModel.getUnit();
            }
        }
        if (this.names != null && (n = jLChartEvent.getDataViewIndex()) >= 0 && n < this.names.length) {
            string2 = this.names[n];
        }
        stringArray[n2] = string2 != null ? "X=" + string2 : "X=" + jLChartEvent.getTransformedXValue();
        stringArray[n2 + 1] = string != null ? "Y=" + string : "Y=" + jLChartEvent.getTransformedYValue();
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spectrumChange(NumberSpectrumEvent numberSpectrumEvent) {
        double[] dArray = numberSpectrumEvent.getValue();
        int n = dArray.length;
        JLDataView jLDataView = this.dvy;
        synchronized (jLDataView) {
            Vector vector = (Vector)this.dvy.getBarFillColors().clone();
            this.dvy.reset();
            for (int i = 0; i < n; ++i) {
                this.dvy.add(this.A0 + this.A1 * (double)i, dArray[i], false);
            }
            this.dvy.updateFilters();
            this.dvy.setBarFillColors(vector);
            this.repaint();
            this.refreshTableSingle(this.dvy);
        }
    }

    public void devStateSpectrumChange(DevStateSpectrumEvent devStateSpectrumEvent) {
        String[] stringArray = devStateSpectrumEvent.getValue();
        if (stringArray == null) {
            return;
        }
        if (this.currentStates == null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.dvy.setBarFillColorAt(i, ATKConstant.getColor4State(stringArray[i]));
            }
            this.currentStates = (String[])devStateSpectrumEvent.getValue().clone();
            this.repaint();
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.currentStates[i].equalsIgnoreCase(stringArray[i])) continue;
            this.dvy.setBarFillColorAt(i, ATKConstant.getColor4State(stringArray[i]));
            this.currentStates[i] = stringArray[i];
        }
        this.repaint();
    }

    public void stringSpectrumChange(StringSpectrumEvent stringSpectrumEvent) {
        if (stringSpectrumEvent.getValue() != null) {
            if (stringSpectrumEvent.getValue().length <= 0) {
                return;
            }
            this.names = stringSpectrumEvent.getValue();
        }
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        if (numberScalarEvent.getSource() == this.minAlarmModel) {
            this.refreshAlarmDv(this.minAlarmDv, numberScalarEvent.getValue());
            return;
        }
        if (numberScalarEvent.getSource() == this.maxAlarmModel) {
            this.refreshAlarmDv(this.maxAlarmDv, numberScalarEvent.getValue());
            return;
        }
    }

    public void refreshAlarmDv(JLDataView jLDataView, double d) {
        if (this.dvy.getDataLength() < 3) {
            return;
        }
        double d2 = this.dvy.getXValueByIndex(0);
        double d3 = this.dvy.getXValueByIndex(this.dvy.getDataLength() - 1);
        jLDataView.reset();
        jLDataView.add(d2, d);
        jLDataView.add(d3, d);
        this.repaint();
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (errorEvent.getSource() == this.numberModel) {
            this.dvy.reset();
            this.repaint();
            this.refreshTableSingle(this.dvy);
            return;
        }
        if (errorEvent.getSource() == this.stateModel) {
            Vector<ColorItem> vector = this.dvy.getBarFillColors();
            vector.clear();
            this.currentStates = null;
            this.repaint();
            return;
        }
        if (errorEvent.getSource() == this.minAlarmModel) {
            this.minAlarmDv.reset();
            this.repaint();
            return;
        }
        if (errorEvent.getSource() == this.maxAlarmModel) {
            this.maxAlarmDv.reset();
            this.repaint();
            return;
        }
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            NumberSpectrumStateBarChartViewer numberSpectrumStateBarChartViewer = new NumberSpectrumStateBarChartViewer();
            numberSpectrumStateBarChartViewer.setDefaultBarChartColor(ATKConstant.getColor4State("UNKNOWN"));
            INumberSpectrum iNumberSpectrum = (INumberSpectrum)attributeList.add("sr/st-v/all/current");
            numberSpectrumStateBarChartViewer.setModel(iNumberSpectrum);
            IDevStateSpectrum iDevStateSpectrum = (IDevStateSpectrum)attributeList.add("sr/st-v/all/SteererStates");
            numberSpectrumStateBarChartViewer.setModel(iDevStateSpectrum);
            IStringSpectrum iStringSpectrum = (IStringSpectrum)attributeList.add("sr/st-v/all/SteererNames");
            numberSpectrumStateBarChartViewer.setModel(iStringSpectrum);
            INumberScalar iNumberScalar = (INumberScalar)attributeList.add("//kidiboo:10000/fp/test/1/double_scalar_w");
            INumberScalar iNumberScalar2 = (INumberScalar)attributeList.add("//kidiboo:10000/fp/test/2/double_scalar_w");
            numberSpectrumStateBarChartViewer.setMinAlarmModel(iNumberScalar);
            numberSpectrumStateBarChartViewer.setMaxAlarmModel(iNumberScalar2);
            numberSpectrumStateBarChartViewer.setBorder(BorderFactory.createLoweredBevelBorder());
            numberSpectrumStateBarChartViewer.setFont(new Font("Dialog", 0, 12));
            numberSpectrumStateBarChartViewer.setPreferredSize(new Dimension(850, 480));
            attributeList.startRefresher();
            JFrame jFrame = new JFrame();
            jFrame.setContentPane(numberSpectrumStateBarChartViewer);
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

