/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.border.EtchedBorder;

public class MultiNumberSpectrumViewer
extends JLChart
implements ISpectrumListener,
IJLChartListener {
    public static final String AXIS_X = "X";
    public static final String AXIS_Y1 = "Y1";
    public static final String AXIS_Y2 = "Y2";
    protected final Color[] defColors = new Color[]{Color.red, Color.blue, Color.magenta, Color.cyan, new Color(50, 120, 0), Color.black, new Color(255, 120, 0), Color.pink, Color.green, Color.yellow};
    protected Map<INumberSpectrum, JLDataView> attMap = new HashMap<INumberSpectrum, JLDataView>();
    protected double affineA0 = 0.0;
    protected double affineA1 = 1.0;
    protected String defaultAxis = new String("Y1");

    public MultiNumberSpectrumViewer() {
        this.setBorder(new EtchedBorder());
        this.setBackground(Color.white);
        this.getY1Axis().setAutoScale(true);
        this.getY2Axis().setAutoScale(true);
        this.getXAxis().setAutoScale(true);
        this.getXAxis().setAnnotation(2);
        this.setJLChartListener(this);
    }

    public void addNumberSpectrumModel(INumberSpectrum iNumberSpectrum) {
        String string = null;
        JLDataView jLDataView = null;
        int n = 0;
        if (iNumberSpectrum == null) {
            return;
        }
        if (this.attMap.containsKey(iNumberSpectrum)) {
            return;
        }
        n = this.attMap.size();
        string = iNumberSpectrum.getFormat();
        jLDataView = new JLDataView();
        jLDataView.setUserFormat(string);
        jLDataView.setUnit(iNumberSpectrum.getUnit());
        jLDataView.setName(iNumberSpectrum.getName());
        jLDataView.setColor(this.defColors[n % this.defColors.length]);
        if (this.defaultAxis.equalsIgnoreCase(AXIS_Y1)) {
            this.getY1Axis().addDataView(jLDataView);
        } else {
            this.getY2Axis().addDataView(jLDataView);
        }
        this.attMap.put(iNumberSpectrum, jLDataView);
        iNumberSpectrum.addSpectrumListener((ISpectrumListener)this);
        iNumberSpectrum.refresh();
    }

    public void addNumberSpectrumModel(INumberSpectrum iNumberSpectrum, String string) {
        String string2 = null;
        JLDataView jLDataView = null;
        int n = 0;
        if (this.defaultAxis.equalsIgnoreCase(string)) {
            this.addNumberSpectrumModel(iNumberSpectrum);
            return;
        }
        if (string.equalsIgnoreCase(AXIS_X)) {
            this.addNumberSpectrumModelToX(iNumberSpectrum);
            return;
        }
        if (iNumberSpectrum == null) {
            return;
        }
        if (this.attMap.containsKey(iNumberSpectrum)) {
            return;
        }
        n = this.attMap.size();
        string2 = iNumberSpectrum.getFormat();
        jLDataView = new JLDataView();
        jLDataView.setUserFormat(string2);
        jLDataView.setUnit(iNumberSpectrum.getUnit());
        jLDataView.setName(iNumberSpectrum.getName());
        jLDataView.setColor(this.defColors[n % this.defColors.length]);
        if (string.equalsIgnoreCase(AXIS_Y1)) {
            this.getY1Axis().addDataView(jLDataView);
        } else {
            this.getY2Axis().addDataView(jLDataView);
        }
        this.attMap.put(iNumberSpectrum, jLDataView);
        iNumberSpectrum.addSpectrumListener((ISpectrumListener)this);
        iNumberSpectrum.refresh();
    }

    protected void addNumberSpectrumModelToX(INumberSpectrum iNumberSpectrum) {
        String string = null;
        JLDataView jLDataView = null;
        boolean bl = false;
        if (iNumberSpectrum == null) {
            return;
        }
        if (this.attMap.containsKey(iNumberSpectrum)) {
            return;
        }
        if (this.getXAxis().getViewNumber() > 0) {
            Set<INumberSpectrum> set;
            JLDataView jLDataView2 = this.getXAxis().getDataView(0);
            if (this.attMap.containsValue(jLDataView2) && (set = this.attMap.keySet()) != null) {
                for (INumberSpectrum iNumberSpectrum2 : set) {
                    JLDataView jLDataView3 = this.attMap.get(iNumberSpectrum2);
                    if (jLDataView3 != jLDataView2) continue;
                    iNumberSpectrum2.removeSpectrumListener((ISpectrumListener)this);
                    this.attMap.remove(iNumberSpectrum2);
                    break;
                }
            }
            this.getXAxis().clearDataView();
        }
        string = iNumberSpectrum.getFormat();
        jLDataView = new JLDataView();
        jLDataView.setUserFormat(string);
        jLDataView.setUnit(iNumberSpectrum.getUnit());
        jLDataView.setName(iNumberSpectrum.getName());
        this.getXAxis().addDataView(jLDataView);
        this.attMap.put(iNumberSpectrum, jLDataView);
        iNumberSpectrum.addSpectrumListener((ISpectrumListener)this);
        iNumberSpectrum.refresh();
    }

    public void removeNumberSpectrumModel(INumberSpectrum iNumberSpectrum) {
        Object var2_2 = null;
        JLDataView jLDataView = null;
        boolean bl = false;
        if (iNumberSpectrum == null) {
            return;
        }
        if (!this.attMap.containsKey(iNumberSpectrum)) {
            return;
        }
        jLDataView = this.attMap.get(iNumberSpectrum);
        iNumberSpectrum.removeSpectrumListener((ISpectrumListener)this);
        this.attMap.remove(iNumberSpectrum);
        if (jLDataView == null) {
            return;
        }
        JLAxis jLAxis = jLDataView.getAxis();
        if (jLAxis == this.getY1Axis()) {
            this.getY1Axis().removeDataView(jLDataView);
        } else if (jLAxis == this.getY2Axis()) {
            this.getY2Axis().removeDataView(jLDataView);
        } else {
            this.getXAxis().removeDataView(jLDataView);
        }
    }

    public void clearModel() {
        Set<INumberSpectrum> set = null;
        JLDataView jLDataView = null;
        INumberSpectrum iNumberSpectrum2 = null;
        boolean bl = false;
        if (this.attMap == null) {
            return;
        }
        set = this.attMap.keySet();
        if (set == null) {
            return;
        }
        for (INumberSpectrum iNumberSpectrum2 : set) {
            jLDataView = this.attMap.get(iNumberSpectrum2);
            iNumberSpectrum2.removeSpectrumListener((ISpectrumListener)this);
            if (jLDataView == null || (bl = this.getY1Axis().checkRemoveDataView(jLDataView))) continue;
            this.getY2Axis().removeDataView(jLDataView);
        }
        this.attMap = new HashMap<INumberSpectrum, JLDataView>();
    }

    public JLDataView getDataView(INumberSpectrum iNumberSpectrum) {
        if (iNumberSpectrum == null) {
            return null;
        }
        if (this.attMap == null) {
            return null;
        }
        if (!this.attMap.containsKey(iNumberSpectrum)) {
            return null;
        }
        JLDataView jLDataView = this.attMap.get(iNumberSpectrum);
        return jLDataView;
    }

    public String getDefaultAxis() {
        return this.defaultAxis;
    }

    public void setDefaultAxis(String string) {
        if (string.equalsIgnoreCase(AXIS_Y1)) {
            this.defaultAxis = AXIS_Y1;
        }
        if (string.equalsIgnoreCase(AXIS_Y2)) {
            this.defaultAxis = AXIS_Y2;
        }
    }

    public void setXAxisAffineTransform(double d, double d2) {
        this.affineA0 = d;
        this.affineA1 = d2;
    }

    public String getSettings() {
        String string = "";
        string = string + this.getConfiguration();
        string = string + "xaxis_transform:" + this.affineA0 + "," + this.affineA1 + "\n";
        string = string + this.getXAxis().getConfiguration("x");
        string = string + this.getY1Axis().getConfiguration("y1");
        string = string + this.getY2Axis().getConfiguration("y2");
        return string;
    }

    public String[] clickOnChart(JLChartEvent jLChartEvent) {
        JLDataView jLDataView = jLChartEvent.getDataView();
        if (jLDataView == null) {
            return null;
        }
        if (!this.attMap.containsValue(jLDataView)) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        string = jLDataView.getExtendedName() + " " + jLDataView.getAxis().getAxeName();
        string2 = "X=" + jLChartEvent.getTransformedXValue();
        string3 = "Y=" + jLDataView.formatValue(jLChartEvent.getTransformedYValue()) + " " + jLDataView.getUnit();
        String[] stringArray = new String[]{string, string2, string3};
        return stringArray;
    }

    public void errorChange(ErrorEvent errorEvent) {
        INumberSpectrum iNumberSpectrum = null;
        JLDataView jLDataView = null;
        iNumberSpectrum = (INumberSpectrum)errorEvent.getSource();
        if (iNumberSpectrum == null) {
            return;
        }
        if (this.attMap == null) {
            return;
        }
        if (!this.attMap.containsKey(iNumberSpectrum)) {
            return;
        }
        jLDataView = this.attMap.get(iNumberSpectrum);
        if (jLDataView == null) {
            return;
        }
        jLDataView.reset();
        this.repaint();
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void spectrumChange(NumberSpectrumEvent numberSpectrumEvent) {
        INumberSpectrum iNumberSpectrum = null;
        JLDataView jLDataView = null;
        double[] dArray = null;
        iNumberSpectrum = (INumberSpectrum)numberSpectrumEvent.getSource();
        if (iNumberSpectrum == null) {
            return;
        }
        if (this.attMap == null) {
            return;
        }
        if (!this.attMap.containsKey(iNumberSpectrum)) {
            return;
        }
        jLDataView = this.attMap.get(iNumberSpectrum);
        if (jLDataView == null) {
            return;
        }
        dArray = numberSpectrumEvent.getValue();
        jLDataView.reset();
        int n = dArray.length;
        if (jLDataView.getAxis() == this.getXAxis()) {
            for (int i = 0; i < n; ++i) {
                jLDataView.add(i, dArray[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                jLDataView.add(this.affineA0 + this.affineA1 * (double)i, dArray[i]);
            }
        }
        this.repaint();
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        JFrame jFrame = new JFrame();
        MultiNumberSpectrumViewer multiNumberSpectrumViewer = new MultiNumberSpectrumViewer();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    INumberSpectrum iNumberSpectrum = (INumberSpectrum)attributeList.add(stringArray[i]);
                    multiNumberSpectrumViewer.addNumberSpectrumModel(iNumberSpectrum);
                    continue;
                }
                catch (ClassCastException classCastException) {
                    System.out.println(stringArray[i] + " is not a valid spectrum");
                    classCastException.printStackTrace();
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Cannot connect to " + stringArray[i]);
                    exception.printStackTrace();
                }
            }
        } else {
            try {
                INumberSpectrum iNumberSpectrum = (INumberSpectrum)attributeList.add("jlp/test/1/att_spectrum");
                multiNumberSpectrumViewer.addNumberSpectrumModel(iNumberSpectrum);
                iNumberSpectrum = (INumberSpectrum)attributeList.add("jlp/test/2/att_spectrum");
                multiNumberSpectrumViewer.addNumberSpectrumModel(iNumberSpectrum);
            }
            catch (Exception exception) {
                System.out.println("Cannot connect to jlp/test/1");
                exception.printStackTrace();
            }
        }
        attributeList.startRefresher();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(multiNumberSpectrumViewer);
        jFrame.setSize(640, 480);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

