/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Multiply
extends PostfixMathCommand {
    public Multiply() {
        this.numberOfParameters = -1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object object = stack.pop();
        for (int i = 1; i < this.curNumberOfParameters; ++i) {
            Object e = stack.pop();
            object = this.mul(e, object);
        }
        stack.push(object);
    }

    public Object mul(Object object, Object object2) throws ParseException {
        if (object instanceof Complex) {
            if (object2 instanceof Complex) {
                return this.mul((Complex)object, (Complex)object2);
            }
            if (object2 instanceof Number) {
                return this.mul((Complex)object, (Number)object2);
            }
            if (object2 instanceof Vector) {
                return this.mul((Vector)object2, (Complex)object);
            }
        } else if (object instanceof Number) {
            if (object2 instanceof Complex) {
                return this.mul((Complex)object2, (Number)object);
            }
            if (object2 instanceof Number) {
                return this.mul((Number)object, (Number)object2);
            }
            if (object2 instanceof Vector) {
                return this.mul((Vector)object2, (Number)object);
            }
        } else if (object instanceof Vector) {
            if (object2 instanceof Complex) {
                return this.mul((Vector)object, (Complex)object2);
            }
            if (object2 instanceof Number) {
                return this.mul((Vector)object, (Number)object2);
            }
        }
        throw new ParseException("Invalid parameter type");
    }

    public Double mul(Number number, Number number2) {
        return new Double(number.doubleValue() * number2.doubleValue());
    }

    public Complex mul(Complex complex, Complex complex2) {
        return complex.mul(complex2);
    }

    public Complex mul(Complex complex, Number number) {
        return complex.mul(number.doubleValue());
    }

    public Vector mul(Vector vector, Number number) {
        Vector<Double> vector2 = new Vector<Double>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(this.mul((Number)vector.elementAt(i), number));
        }
        return vector2;
    }

    public Vector mul(Vector vector, Complex complex) {
        Vector<Complex> vector2 = new Vector<Complex>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(this.mul(complex, (Number)vector.elementAt(i)));
        }
        return vector2;
    }
}

