/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class ByteStatistics
extends ImageStatistics {
    public ByteStatistics(ImageProcessor ip) {
        this(ip, 27, null);
    }

    public ByteStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        float[] cTable;
        int maxThreshold;
        int minThreshold;
        ByteProcessor bp = (ByteProcessor)ip;
        this.histogram = bp.getHistogram();
        this.setup(ip, cal);
        double minT = ip.getMinThreshold();
        if ((mOptions & 0x100) == 0 || minT == -808080.0) {
            minThreshold = 0;
            maxThreshold = 255;
        } else {
            minThreshold = (int)minT;
            maxThreshold = (int)ip.getMaxThreshold();
        }
        float[] fArray = cTable = cal != null ? cal.getCTable() : null;
        if (cTable != null) {
            this.getCalibratedStatistics(minThreshold, maxThreshold, cTable);
        } else {
            this.getRawStatistics(minThreshold, maxThreshold);
        }
        if ((mOptions & 0x10) != 0) {
            if (cTable != null) {
                this.getCalibratedMinAndMax(minThreshold, maxThreshold, cTable);
            } else {
                this.getRawMinAndMax(minThreshold, maxThreshold);
            }
        }
        if ((mOptions & 0x800) != 0) {
            this.fitEllipse(ip);
        } else if ((mOptions & 0x20) != 0) {
            this.getCentroid(ip, minThreshold, maxThreshold);
        }
        if ((mOptions & 0x60040) != 0) {
            this.calculateMoments(ip, minThreshold, maxThreshold, cTable);
        }
        if ((mOptions & 0x10000) != 0) {
            this.calculateMedian(this.histogram, 0, cal);
        }
        if ((mOptions & 0x80000) != 0) {
            this.calculateAreaFraction(ip, this.histogram);
        }
    }

    void getCalibratedStatistics(int minThreshold, int maxThreshold, float[] cTable) {
        double sum = 0.0;
        double sum2 = 0.0;
        int isum = 0;
        for (int i = minThreshold; i <= maxThreshold; ++i) {
            int count = this.histogram[i];
            double value = cTable[i];
            if (count <= 0 || Double.isNaN(value)) continue;
            this.pixelCount += count;
            sum += value * (double)count;
            isum += i * count;
            sum2 += value * value * (double)count;
            if (count <= this.maxCount) continue;
            this.maxCount = count;
            this.mode = i;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.mean = sum / (double)this.pixelCount;
        this.umean = (double)isum / (double)this.pixelCount;
        this.dmode = cTable[this.mode];
        this.calculateStdDev(this.pixelCount, sum, sum2);
        this.histMin = 0.0;
        this.histMax = 255.0;
    }

    void getCentroid(ImageProcessor ip, int minThreshold, int maxThreshold) {
        byte[] pixels = (byte[])ip.getPixels();
        byte[] mask = ip.getMaskArray();
        boolean limit = minThreshold > 0 || maxThreshold < 255;
        int count = 0;
        int xsum = 0;
        int ysum = 0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                if (mask == null || mask[mi++] != 0) {
                    if (limit) {
                        int v = pixels[i] & 0xFF;
                        if (v >= minThreshold && v <= maxThreshold) {
                            ++count;
                            xsum += x;
                            ysum += y;
                        }
                    } else {
                        ++count;
                        xsum += x;
                        ysum += y;
                    }
                }
                ++i;
            }
            ++y;
            ++my;
        }
        this.xCentroid = (double)xsum / (double)count + 0.5;
        this.yCentroid = (double)ysum / (double)count + 0.5;
        if (this.cal != null) {
            this.xCentroid = this.cal.getX(this.xCentroid);
            this.yCentroid = this.cal.getY(this.yCentroid, this.height);
        }
    }

    void calculateMoments(ImageProcessor ip, int minThreshold, int maxThreshold, float[] cTable) {
        byte[] pixels = (byte[])ip.getPixels();
        byte[] mask = ip.getMaskArray();
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double sum4 = 0.0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                int v;
                if ((mask == null || mask[mi++] != 0) && (v = pixels[i] & 0xFF) >= minThreshold && v <= maxThreshold) {
                    double dv = (double)(cTable != null ? cTable[v] : (float)v) + Double.MIN_VALUE;
                    double dv2 = dv * dv;
                    sum1 += dv;
                    sum2 += dv2;
                    sum3 += dv * dv2;
                    sum4 += dv2 * dv2;
                    xsum += (double)x * dv;
                    ysum += (double)y * dv;
                }
                ++i;
            }
            ++y;
            ++my;
        }
        double mean2 = this.mean * this.mean;
        double variance = sum2 / (double)this.pixelCount - mean2;
        double sDeviation = Math.sqrt(variance);
        this.skewness = ((sum3 - 3.0 * this.mean * sum2) / (double)this.pixelCount + 2.0 * this.mean * mean2) / (variance * sDeviation);
        this.kurtosis = ((sum4 - 4.0 * this.mean * sum3 + 6.0 * mean2 * sum2) / (double)this.pixelCount - 3.0 * mean2 * mean2) / (variance * variance) - 3.0;
        this.xCenterOfMass = xsum / sum1 + 0.5;
        this.yCenterOfMass = ysum / sum1 + 0.5;
        if (this.cal != null) {
            this.xCenterOfMass = this.cal.getX(this.xCenterOfMass);
            this.yCenterOfMass = this.cal.getY(this.yCenterOfMass, this.height);
        }
    }

    void getCalibratedMinAndMax(int minThreshold, int maxThreshold, float[] cTable) {
        if (this.pixelCount == 0) {
            this.min = 0.0;
            this.max = 0.0;
            return;
        }
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        double v = 0.0;
        for (int i = minThreshold; i <= maxThreshold; ++i) {
            if (this.histogram[i] <= 0) continue;
            v = cTable[i];
            if (v < this.min) {
                this.min = v;
            }
            if (!(v > this.max)) continue;
            this.max = v;
        }
    }
}

