/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class RGBStackMerge
implements PlugIn {
    private ImagePlus imp;
    private byte[] blank;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        this.mergeStacks();
    }

    public void mergeStacks() {
        int i;
        String none;
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error("No images are open.");
            return;
        }
        String[] titles = new String[wList.length + 1];
        for (int i2 = 0; i2 < wList.length; ++i2) {
            ImagePlus imp = WindowManager.getImage(wList[i2]);
            titles[i2] = imp != null ? imp.getTitle() : "";
        }
        titles[wList.length] = none = "*None*";
        GenericDialog gd = new GenericDialog("RGB Merge");
        gd.addChoice("Red:", titles, titles[0]);
        gd.addChoice("Green:", titles, titles[1]);
        String title3 = titles.length > 2 ? titles[2] : none;
        gd.addChoice("Blue:", titles, title3);
        gd.addCheckbox("Keep source images", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int[] index = new int[]{gd.getNextChoiceIndex(), gd.getNextChoiceIndex(), gd.getNextChoiceIndex()};
        boolean keep = gd.getNextBoolean();
        ImagePlus[] image = new ImagePlus[3];
        int stackSize = 0;
        int width = 0;
        int height = 0;
        for (i = 0; i < 3; ++i) {
            if (index[i] >= wList.length) continue;
            image[i] = WindowManager.getImage(wList[index[i]]);
            width = image[i].getWidth();
            height = image[i].getHeight();
            stackSize = image[i].getStackSize();
        }
        if (width == 0) {
            IJ.error("There must be at least one source image or stack.");
            return;
        }
        for (i = 0; i < 3; ++i) {
            ImagePlus img = image[i];
            if (img == null) continue;
            if (img.getStackSize() != stackSize) {
                IJ.error("The source stacks must all have the same number of slices.");
                return;
            }
            if (img.getWidth() == width && image[i].getHeight() == height) continue;
            IJ.error("The source images or stacks must have the same width and height.");
            return;
        }
        ImageStack red = image[0] != null ? image[0].getStack() : null;
        ImageStack green = image[1] != null ? image[1].getStack() : null;
        ImageStack blue = image[2] != null ? image[2].getStack() : null;
        ImageStack rgb = this.mergeStacks(width, height, stackSize, red, green, blue, keep);
        if (!keep) {
            for (int i3 = 0; i3 < 3; ++i3) {
                if (image[i3] == null) continue;
                image[i3].changes = false;
                image[i3].close();
            }
        }
        ImagePlus imp2 = new ImagePlus("RGB", rgb);
        if (image[0] != null) {
            imp2.setCalibration(image[0].getCalibration());
        }
        imp2.show();
    }

    public ImageStack mergeStacks(int w, int h, int d, ImageStack red, ImageStack green, ImageStack blue, boolean keep) {
        ImageStack rgb = new ImageStack(w, h);
        int inc = d / 10;
        if (inc < 1) {
            inc = 1;
        }
        int slice = 1;
        this.blank = new byte[w * h];
        boolean invertedRed = red != null ? red.getProcessor(1).isInvertedLut() : false;
        boolean invertedGreen = green != null ? green.getProcessor(1).isInvertedLut() : false;
        boolean invertedBlue = blue != null ? blue.getProcessor(1).isInvertedLut() : false;
        try {
            for (int i = 1; i <= d; ++i) {
                ColorProcessor cp = new ColorProcessor(w, h);
                byte[] redPixels = this.getPixels(red, slice, 0);
                byte[] greenPixels = this.getPixels(green, slice, 1);
                byte[] bluePixels = this.getPixels(blue, slice, 2);
                if (invertedRed) {
                    redPixels = this.invert(redPixels);
                }
                if (invertedGreen) {
                    greenPixels = this.invert(greenPixels);
                }
                if (invertedBlue) {
                    bluePixels = this.invert(bluePixels);
                }
                cp.setRGB(redPixels, greenPixels, bluePixels);
                if (keep) {
                    ++slice;
                } else {
                    if (red != null) {
                        red.deleteSlice(1);
                    }
                    if (green != null && green != red) {
                        green.deleteSlice(1);
                    }
                    if (blue != null && blue != red && blue != green) {
                        blue.deleteSlice(1);
                    }
                }
                rgb.addSlice(null, cp);
                if (i % inc != 0) continue;
                IJ.showProgress((double)i / (double)d);
            }
            IJ.showProgress(1.0);
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory("Merge Stacks");
            IJ.showProgress(1.0);
        }
        return rgb;
    }

    byte[] getPixels(ImageStack stack, int slice, int color) {
        if (stack == null) {
            return this.blank;
        }
        Object pixels = stack.getPixels(slice);
        if (!(pixels instanceof int[])) {
            if (pixels instanceof byte[]) {
                return (byte[])pixels;
            }
            ImageProcessor ip = stack.getProcessor(slice);
            ip = ip.convertToByte(true);
            return (byte[])ip.getPixels();
        }
        int size = stack.getWidth() * stack.getHeight();
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b2 = new byte[size];
        ColorProcessor cp = (ColorProcessor)stack.getProcessor(slice);
        cp.getRGB(r, g, b2);
        switch (color) {
            case 0: {
                return r;
            }
            case 1: {
                return g;
            }
            case 2: {
                return b2;
            }
        }
        return null;
    }

    byte[] invert(byte[] pixels) {
        byte[] pixels2 = new byte[pixels.length];
        System.arraycopy(pixels, 0, pixels2, 0, pixels.length);
        for (int i = 0; i < pixels2.length; ++i) {
            pixels2[i] = (byte)(255 - pixels2[i] & 0xFF);
        }
        return pixels2;
    }
}

