/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.IAttributeSpectrumHistory;
import fr.esrf.tangoatk.core.INumberSpectrumHistory;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.NumberSpectrumHistory;

public class DoubleSpectrumHelper
extends ANumberSpectrumHelper {
    public DoubleSpectrumHelper(AAttribute aAttribute) {
        this.init(aAttribute);
    }

    void init(AAttribute aAttribute) {
        super.init(aAttribute);
    }

    void insert(double[] dArray) {
        double d = 1.0;
        d = this.attribute.getDisplayUnitFactor();
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        if (d == 1.0) {
            deviceAttribute.insert(dArray);
        } else {
            double[] dArray2 = new double[dArray.length];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = dArray[i] / d;
            }
            deviceAttribute.insert(dArray2);
        }
    }

    protected INumberSpectrumHistory[] getNumberSpectrumAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        INumberSpectrumHistory[] iNumberSpectrumHistoryArray = new NumberSpectrumHistory[deviceDataHistoryArray.length];
        double d = 1.0;
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        d = this.attribute.getDisplayUnitFactor();
        if (d <= 0.0) {
            d = 1.0;
        }
        for (int i = 0; i < deviceDataHistoryArray.length; ++i) {
            NumberSpectrumHistory numberSpectrumHistory = new NumberSpectrumHistory();
            try {
                numberSpectrumHistory.setTimestamp(deviceDataHistoryArray[i].getTime());
            }
            catch (Exception exception) {
                numberSpectrumHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[i].getAttrQuality();
                if (0 == attrQuality.value()) {
                    numberSpectrumHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    numberSpectrumHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    numberSpectrumHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    numberSpectrumHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    numberSpectrumHistory.setState("CHANGING");
                } else {
                    numberSpectrumHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                numberSpectrumHistory.setState("UNKNOWN");
            }
            try {
                double[] dArray = deviceDataHistoryArray[i].extractDoubleArray();
                double[] dArray2 = new double[dArray.length];
                for (int j = 0; j < dArray.length; ++j) {
                    dArray2[j] = dArray[j] * d;
                }
                numberSpectrumHistory.setValue(dArray2);
            }
            catch (Exception exception) {
                numberSpectrumHistory.setValue(new double[0]);
            }
            iNumberSpectrumHistoryArray[i] = numberSpectrumHistory;
        }
        return iNumberSpectrumHistoryArray;
    }

    protected INumberSpectrumHistory[] getNumberSpectrumDeviceAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        INumberSpectrumHistory[] iNumberSpectrumHistoryArray = new NumberSpectrumHistory[deviceDataHistoryArray.length];
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        for (int i = 0; i < deviceDataHistoryArray.length; ++i) {
            NumberSpectrumHistory numberSpectrumHistory = new NumberSpectrumHistory();
            try {
                numberSpectrumHistory.setTimestamp(deviceDataHistoryArray[i].getTime());
            }
            catch (Exception exception) {
                numberSpectrumHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[i].getAttrQuality();
                if (0 == attrQuality.value()) {
                    numberSpectrumHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    numberSpectrumHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    numberSpectrumHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    numberSpectrumHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    numberSpectrumHistory.setState("CHANGING");
                } else {
                    numberSpectrumHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                numberSpectrumHistory.setState("UNKNOWN");
            }
            try {
                numberSpectrumHistory.setValue(deviceDataHistoryArray[i].extractDoubleArray());
            }
            catch (Exception exception) {
                numberSpectrumHistory.setValue(new double[0]);
            }
            iNumberSpectrumHistoryArray[i] = numberSpectrumHistory;
        }
        return iNumberSpectrumHistoryArray;
    }

    protected IAttributeSpectrumHistory[] getSpectrumDeviceAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getNumberSpectrumDeviceAttHistory(deviceDataHistoryArray);
    }

    protected IAttributeSpectrumHistory[] getSpectrumAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getNumberSpectrumAttHistory(deviceDataHistoryArray);
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Double(d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Double(d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Double(d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Double(d), bl);
    }

    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Double(d), bl);
    }

    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Double(d), bl);
    }

    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Double(d), bl);
    }

    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Double(d), bl);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Double(d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Double(d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Double(d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Double(d));
    }

    void setMinWarning(double d) {
        this.setProperty("min_warning", new Double(d));
    }

    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Double(d));
    }

    void setDeltaT(double d) {
        this.setProperty("delta_t", new Double(d));
    }

    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Double(d));
    }

    double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        double[] dArray = deviceAttribute.extractDoubleArray();
        int n = deviceAttribute.getNbRead();
        if (n == dArray.length) {
            return deviceAttribute.extractDoubleArray();
        }
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    double[] getNumberSpectrumSetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        int n;
        double[] dArray = deviceAttribute.extractDoubleArray();
        int n2 = dArray.length - (n = deviceAttribute.getNbRead());
        if (n2 <= 0) {
            return this.getNumberSpectrumValue(deviceAttribute);
        }
        double[] dArray2 = new double[n2];
        int n3 = 0;
        for (int i = n; i < dArray.length; ++i) {
            dArray2[n3] = dArray[i];
            ++n3;
        }
        return dArray2;
    }

    double[] getNumberSpectrumDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int n = deviceAttribute.getNbRead();
        double d = this.attribute.getDisplayUnitFactor();
        double[] dArray = deviceAttribute.extractDoubleArray();
        if (dArray.length == n && d == 1.0) {
            return deviceAttribute.extractDoubleArray();
        }
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i] * d;
        }
        return dArray2;
    }

    double[] getNumberSpectrumDisplaySetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        double[] dArray = deviceAttribute.extractDoubleArray();
        int n = deviceAttribute.getNbRead();
        int n2 = dArray.length - n;
        double d = this.attribute.getDisplayUnitFactor();
        if (n2 <= 0) {
            return this.getNumberSpectrumDisplayValue(deviceAttribute);
        }
        double[] dArray2 = new double[n2];
        int n3 = 0;
        for (int i = n; i < dArray.length; ++i) {
            dArray2[n3] = dArray[i] * d;
            ++n3;
        }
        return dArray2;
    }

    public String getVersion() {
        return "$Id: DoubleSpectrumHelper.java,v 1.16 2010/09/24 13:11:54 poncet Exp $";
    }
}

