/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanImage;
import fr.esrf.tangoatk.core.IBooleanImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class BooleanImageHelper
implements Serializable {
    AAttribute attribute;
    EventSupport propChanges;
    boolean[][] retval = new boolean[1][1];

    public BooleanImageHelper(AAttribute aAttribute) {
        this.init(aAttribute);
    }

    void init(AAttribute aAttribute) {
        this.setAttribute(aAttribute);
        this.propChanges = aAttribute.getPropChanges();
    }

    public void setAttribute(AAttribute aAttribute) {
        this.attribute = aAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    void fireImageValueChanged(boolean[][] blArray, long l) {
        this.propChanges.fireBooleanImageEvent((IBooleanImage)((Object)this.attribute), blArray, l);
    }

    void insert(boolean[][] blArray) {
        boolean[] blArray2 = this.flatten(blArray);
        this.attribute.getAttribute().insert(blArray2, blArray[0].length, blArray.length);
    }

    boolean[] flatten(boolean[][] blArray) {
        int n = blArray[0].length;
        int n2 = blArray.length * blArray[0].length;
        boolean[] blArray2 = new boolean[n2];
        for (int i = 0; i < blArray.length; ++i) {
            System.arraycopy(blArray[i], 0, blArray2, i * n, n);
        }
        return blArray2;
    }

    boolean[][] getBooleanImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        boolean[] blArray = deviceAttribute.extractBooleanArray();
        int n = this.attribute.getYDimension();
        int n2 = this.attribute.getXDimension();
        if (n != this.retval.length || n2 != this.retval[0].length) {
            this.retval = new boolean[n][n2];
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.retval[i][j] = blArray[n3++];
            }
        }
        return this.retval;
    }

    void addBooleanImageListener(IBooleanImageListener iBooleanImageListener) {
        this.propChanges.addBooleanImageListener(iBooleanImageListener);
    }

    void removeBooleanImageListener(IBooleanImageListener iBooleanImageListener) {
        this.propChanges.removeBooleanImageListener(iBooleanImageListener);
    }

    public String getVersion() {
        return "$Id: BooleanImageHelper.java,v 1.7 2010/09/24 13:11:54 poncet Exp $";
    }
}

