/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.JAWT;
import com.sun.opengl.impl.JAWT_DrawingSurface;
import com.sun.opengl.impl.JAWT_DrawingSurfaceInfo;
import com.sun.opengl.impl.windows.JAWT_Win32DrawingSurfaceInfo;
import com.sun.opengl.impl.windows.WGL;
import com.sun.opengl.impl.windows.WindowsGLDrawable;
import com.sun.opengl.impl.windows.WindowsOnscreenGLContext;
import java.awt.Component;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class WindowsOnscreenGLDrawable
extends WindowsGLDrawable {
    public static final int LOCK_SURFACE_NOT_READY = 1;
    public static final int LOCK_SURFACE_CHANGED = 2;
    public static final int LOCK_SUCCESS = 3;
    protected Component component;
    private JAWT_DrawingSurface ds;
    private JAWT_DrawingSurfaceInfo dsi;
    private JAWT_Win32DrawingSurfaceInfo win32dsi;
    protected boolean realized;
    private static final boolean PROFILING = Debug.debug("WindowsOnscreenGLDrawable.profiling");
    private static final int PROFILING_TICKS = 200;
    private int profilingLockSurfaceTicks;
    private long profilingLockSurfaceTime;
    private int profilingUnlockSurfaceTicks;
    private long profilingUnlockSurfaceTime;
    private int profilingSwapBuffersTicks;
    private long profilingSwapBuffersTime;
    private int setPixelFormatFailCount;
    private static final int MAX_SET_PIXEL_FORMAT_FAIL_COUNT = 5;

    public WindowsOnscreenGLDrawable(Component component, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(gLCapabilities, gLCapabilitiesChooser);
        this.component = component;
    }

    public GLContext createContext(GLContext gLContext) {
        return new WindowsOnscreenGLContext(this, gLContext);
    }

    public void setRealized(boolean bl) {
        this.realized = bl;
        if (!bl) {
            this.setChosenGLCapabilities(null);
            this.pixelFormatChosen = false;
        }
    }

    public void setSize(int n, int n2) {
        this.component.setSize(n, n2);
    }

    public int getWidth() {
        return this.component.getWidth();
    }

    public int getHeight() {
        return this.component.getHeight();
    }

    public void swapBuffers() throws GLException {
        boolean bl = false;
        if (this.hdc == 0L) {
            if (this.lockSurface() == 1) {
                return;
            }
            bl = true;
        }
        long l = 0L;
        if (PROFILING) {
            l = System.currentTimeMillis();
        }
        if (!WGL.SwapBuffers(this.hdc) && WGL.GetLastError() != 0) {
            throw new GLException("Error swapping buffers");
        }
        if (PROFILING) {
            long l2 = System.currentTimeMillis();
            this.profilingSwapBuffersTime += l2 - l;
            int n = 200;
            if (++this.profilingSwapBuffersTicks == n) {
                System.err.println("SwapBuffers calls: " + this.profilingSwapBuffersTime + " ms / " + n + "  calls (" + (float)this.profilingSwapBuffersTime / (float)n + " ms/call)");
                this.profilingSwapBuffersTime = 0L;
                this.profilingSwapBuffersTicks = 0;
            }
        }
        if (bl) {
            this.unlockSurface();
        }
    }

    public int lockSurface() throws GLException {
        if (!this.realized) {
            return 1;
        }
        if (this.hdc != 0L) {
            throw new GLException("Surface already locked");
        }
        long l = 0L;
        if (PROFILING) {
            l = System.currentTimeMillis();
        }
        this.ds = JAWT.getJAWT().GetDrawingSurface(this.component);
        if (this.ds == null) {
            return 1;
        }
        int n = this.ds.Lock();
        if ((n & 1) != 0) {
            throw new GLException("Unable to lock surface");
        }
        int n2 = 3;
        if ((n & 8) != 0) {
            n2 = 2;
        }
        this.dsi = this.ds.GetDrawingSurfaceInfo();
        if (this.dsi == null) {
            this.ds.Unlock();
            JAWT.getJAWT().FreeDrawingSurface(this.ds);
            this.ds = null;
            return 1;
        }
        this.win32dsi = (JAWT_Win32DrawingSurfaceInfo)this.dsi.platformInfo();
        this.hdc = this.win32dsi.hdc();
        if (this.hdc == 0L) {
            this.ds.FreeDrawingSurfaceInfo(this.dsi);
            this.ds.Unlock();
            JAWT.getJAWT().FreeDrawingSurface(this.ds);
            this.ds = null;
            this.dsi = null;
            this.win32dsi = null;
            return 1;
        }
        if (!this.pixelFormatChosen) {
            try {
                this.choosePixelFormat(true);
                this.setPixelFormatFailCount = 0;
            }
            catch (RuntimeException runtimeException) {
                this.unlockSurface();
                if (runtimeException instanceof GLException) {
                    if (++this.setPixelFormatFailCount == 5) {
                        this.setPixelFormatFailCount = 0;
                        throw runtimeException;
                    }
                    return 1;
                }
                throw new GLException((Throwable)runtimeException);
            }
        }
        if (PROFILING) {
            long l2 = System.currentTimeMillis();
            this.profilingLockSurfaceTime += l2 - l;
            int n3 = 200;
            if (++this.profilingLockSurfaceTicks == n3) {
                System.err.println("LockSurface calls: " + this.profilingLockSurfaceTime + " ms / " + n3 + " calls (" + (float)this.profilingLockSurfaceTime / (float)n3 + " ms/call)");
                this.profilingLockSurfaceTime = 0L;
                this.profilingLockSurfaceTicks = 0;
            }
        }
        return n2;
    }

    public void unlockSurface() {
        if (this.hdc == 0L) {
            throw new GLException("Surface already unlocked");
        }
        long l = 0L;
        if (PROFILING) {
            l = System.currentTimeMillis();
        }
        this.ds.FreeDrawingSurfaceInfo(this.dsi);
        this.ds.Unlock();
        JAWT.getJAWT().FreeDrawingSurface(this.ds);
        this.ds = null;
        this.dsi = null;
        this.win32dsi = null;
        this.hdc = 0L;
        if (PROFILING) {
            long l2 = System.currentTimeMillis();
            this.profilingUnlockSurfaceTime += l2 - l;
            int n = 200;
            if (++this.profilingUnlockSurfaceTicks == n) {
                System.err.println("UnlockSurface calls: " + this.profilingUnlockSurfaceTime + " ms / " + n + " calls (" + (float)this.profilingUnlockSurfaceTime / (float)n + " ms/call)");
                this.profilingUnlockSurfaceTime = 0L;
                this.profilingUnlockSurfaceTicks = 0;
            }
        }
    }
}

