/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarHistory;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.StringAttributeHelper;
import fr.esrf.tangoatk.core.attribute.StringScalarHistory;
import java.io.IOException;
import java.io.ObjectInputStream;

public class StringScalar
extends AAttribute
implements IStringScalar {
    StringAttributeHelper stringHelper = new StringAttributeHelper(this);
    String stringValue = null;
    String setPointValue = null;
    String[] possibleValues = null;

    public String getString() {
        return this.getStringValue();
    }

    public void setValue(String string) {
        try {
            this.attribute.insert(string);
            this.writeAtt();
            this.refresh();
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
    }

    public IScalarAttribute getWritableAttribute() {
        return null;
    }

    public IScalarAttribute getReadableAttribute() {
        return null;
    }

    public void setString(String string) {
        this.setValue(string);
    }

    public int getXDimension() {
        return 1;
    }

    public int getMaxXDimension() {
        return 1;
    }

    public void refresh() {
        DeviceAttribute deviceAttribute = null;
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                deviceAttribute = this.readValueFromNetwork();
                if (deviceAttribute == null) {
                    return;
                }
                this.stringValue = deviceAttribute.extractString();
                this.setPointValue = this.stringHelper.getStringScalarSetPoint(deviceAttribute);
                this.fireValueChanged(this.stringValue);
            }
            catch (DevFailed devFailed) {
                this.stringValue = null;
                this.setPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.stringValue = null;
            this.setPointValue = null;
            System.out.println("StringScalar.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("StringScalar.refresh()------------------------------------------------");
        }
    }

    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(String string) {
        this.propChanges.fireStringScalarEvent(this, string, this.timeStamp);
    }

    public void addStringScalarListener(IStringScalarListener iStringScalarListener) {
        this.propChanges.addStringScalarListener(iStringScalarListener);
        this.addStateListener(iStringScalarListener);
    }

    public void removeStringScalarListener(IStringScalarListener iStringScalarListener) {
        this.propChanges.removeStringScalarListener(iStringScalarListener);
        this.removeStateListener(iStringScalarListener);
    }

    public IStringScalarHistory[] getStringScalarHistory() {
        IStringScalarHistory[] iStringScalarHistoryArray = null;
        try {
            iStringScalarHistoryArray = (StringScalarHistory[])this.stringHelper.getScalarAttHistory(this.readAttHistoryFromNetwork());
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            iStringScalarHistoryArray = null;
        }
        catch (Exception exception) {
            this.readAttError(exception.getMessage(), exception);
            iStringScalarHistoryArray = null;
        }
        return iStringScalarHistoryArray;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String getStringDeviceValue() {
        String string = null;
        try {
            this.stringValue = string = this.readValueFromNetwork().extractString();
        }
        catch (DevFailed devFailed) {
            this.stringValue = null;
            this.setPointValue = null;
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
        }
        catch (Exception exception) {
            this.stringValue = null;
            this.setPointValue = null;
            System.out.println("StringScalar.getStringDeviceValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("StringScalar.getStringDeviceValue()------------------------------------------------");
        }
        return this.stringValue;
    }

    public String getStringSetPoint() {
        return this.setPointValue;
    }

    public String getStringDeviceSetPoint() {
        String string;
        try {
            this.setPointValue = string = this.stringHelper.getStringScalarSetPoint(this.readValueFromNetwork());
        }
        catch (DevFailed devFailed) {
            this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            string = "DevFailed";
            this.setPointValue = null;
        }
        catch (Exception exception) {
            this.readAttError(exception.getMessage(), exception);
            string = "Exception";
            this.setPointValue = null;
        }
        return string;
    }

    public void setPossibleValues(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        if (this.possibleValues == null && stringArray.length > 0) {
            this.possibleValues = stringArray;
        }
    }

    public String[] getPossibleValues() {
        return this.possibleValues;
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        block8: {
            ++this.periodicCount;
            DeviceAttribute deviceAttribute = null;
            try {
                deviceAttribute = tangoPeriodicEvent.getValue();
            }
            catch (DevFailed devFailed) {
                if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                    this.stringValue = null;
                    this.setPointValue = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                } else {
                    this.stringValue = null;
                    this.setPointValue = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                }
                return;
            }
            catch (Exception exception) {
                this.stringValue = null;
                this.setPointValue = null;
                System.out.println("StringScalar.periodic.getValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("StringScalar.periodic.getValue()------------------------------------------------");
                return;
            }
            if (deviceAttribute == null) break block8;
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.stringValue = deviceAttribute.extractString();
                this.setPointValue = this.stringHelper.getStringScalarSetPoint(deviceAttribute);
                this.fireValueChanged(this.stringValue);
            }
            catch (DevFailed devFailed) {
                this.stringValue = null;
                this.setPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.stringValue = null;
                this.setPointValue = null;
                System.out.println("StringScalar.periodic.extractString() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("StringScalar.periodic.extractString()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        block8: {
            ++this.changeCount;
            DeviceAttribute deviceAttribute = null;
            try {
                deviceAttribute = tangoChangeEvent.getValue();
            }
            catch (DevFailed devFailed) {
                if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                    this.stringValue = null;
                    this.setPointValue = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                } else {
                    this.stringValue = null;
                    this.setPointValue = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                }
                return;
            }
            catch (Exception exception) {
                this.stringValue = null;
                this.setPointValue = null;
                System.out.println("StringScalar.change.getValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("StringScalar.change.getValue()------------------------------------------------");
                return;
            }
            if (deviceAttribute == null) break block8;
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.stringValue = deviceAttribute.extractString();
                this.setPointValue = this.stringHelper.getStringScalarSetPoint(deviceAttribute);
                this.fireValueChanged(this.stringValue);
            }
            catch (DevFailed devFailed) {
                this.stringValue = null;
                this.setPointValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.stringValue = null;
                this.setPointValue = null;
                System.out.println("StringScalar.change.extractString() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("StringScalar.change.extractString()------------------------------------------------");
            }
        }
    }

    public String getVersion() {
        return "$Id: StringScalar.java,v 1.18 2005/04/28 14:32:25 jlpons Exp $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

