/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.NumberImage;
import java.io.IOException;
import java.io.ObjectInputStream;

public class NumberSpectrum
extends NumberImage
implements INumberSpectrum {
    double[] spectrumValue;
    ANumberSpectrumHelper numberSpectrumHelper;

    public void init(Device device, String string, AttributeInfo attributeInfo) {
        super.init(device, string, attributeInfo);
    }

    public double[][] getStandardValue() throws DevFailed {
        return this.numberSpectrumHelper.getStandardNumberValue();
    }

    public void setNumberHelper(ANumberSpectrumHelper aNumberSpectrumHelper) {
        this.numberHelper = aNumberSpectrumHelper;
        this.numberSpectrumHelper = aNumberSpectrumHelper;
    }

    public void addImageListener(IImageListener iImageListener) {
        this.numberSpectrumHelper.addImageListener(iImageListener);
    }

    public void removeImageListener(IImageListener iImageListener) {
        this.numberSpectrumHelper.removeImageListener(iImageListener);
    }

    public void addSpectrumListener(ISpectrumListener iSpectrumListener) {
        this.propChanges.addSpectrumListener(iSpectrumListener);
    }

    public void removeSpectrumListener(ISpectrumListener iSpectrumListener) {
        this.propChanges.removeSpectrumListener(iSpectrumListener);
    }

    public void setValue(double[][] dArray) {
        this.setValue(dArray[0]);
    }

    public double[][] getValue() {
        double[][] dArrayArray = new double[][]{this.getSpectrumValue()};
        return dArrayArray;
    }

    public void setValue(double[] dArray) {
        try {
            this.insert(dArray);
            this.writeAtt();
            this.numberSpectrumHelper.fireSpectrumValueChanged(dArray, System.currentTimeMillis());
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
    }

    public double[] getStandardSpectrumValue() {
        double[] dArray = this.getSpectrumValue();
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * this.getStandardUnit();
        }
        return dArray;
    }

    protected void checkDimensions(double[] dArray) {
        if (dArray.length > this.getMaxXDimension()) {
            throw new IllegalStateException();
        }
    }

    protected void insert(double[] dArray) {
        this.checkDimensions(dArray);
        this.numberSpectrumHelper.insert(dArray);
    }

    public void refresh() {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                this.spectrumValue = this.numberSpectrumHelper.getNumberSpectrumValue(this.readValueFromNetwork());
                this.numberSpectrumHelper.fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            this.spectrumValue = null;
            System.out.println("NumberSpectrum.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("NumberSpectrum.refresh()------------------------------------------------");
        }
    }

    public double[] getSpectrumValue() {
        return this.spectrumValue;
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        block8: {
            ++this.periodicCount;
            DeviceAttribute deviceAttribute = null;
            try {
                deviceAttribute = tangoPeriodicEvent.getValue();
            }
            catch (DevFailed devFailed) {
                if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                    this.spectrumValue = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                } else {
                    this.spectrumValue = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                }
                return;
            }
            catch (Exception exception) {
                this.spectrumValue = null;
                System.out.println("NumberSpectrum.periodic.getValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberSpectrum.periodic.getValue()------------------------------------------------");
                return;
            }
            if (deviceAttribute == null) break block8;
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = this.numberSpectrumHelper.getNumberSpectrumValue(deviceAttribute);
                this.numberSpectrumHelper.fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.spectrumValue = null;
                System.out.println("NumberSpectrum.periodic.getNumberSpectrumValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberSpectrum.periodic.getNumberSpectrumValue()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        block8: {
            ++this.changeCount;
            DeviceAttribute deviceAttribute = null;
            try {
                deviceAttribute = tangoChangeEvent.getValue();
            }
            catch (DevFailed devFailed) {
                if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                    this.spectrumValue = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                } else {
                    this.spectrumValue = null;
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                }
                return;
            }
            catch (Exception exception) {
                this.spectrumValue = null;
                System.out.println("NumberSpectrum.change.getValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberSpectrum.change.getValue()------------------------------------------------");
                return;
            }
            if (deviceAttribute == null) break block8;
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.spectrumValue = this.numberSpectrumHelper.getNumberSpectrumValue(deviceAttribute);
                this.numberSpectrumHelper.fireSpectrumValueChanged(this.spectrumValue, this.timeStamp);
            }
            catch (DevFailed devFailed) {
                this.spectrumValue = null;
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                this.spectrumValue = null;
                System.out.println("NumberSpectrum.change.getNumberSpectrumValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("NumberSpectrum.change.getNumberSpectrumValue()------------------------------------------------");
            }
        }
    }

    public String getVersion() {
        return "$Id: NumberSpectrum.java,v 1.11 2005/04/28 14:32:25 jlpons Exp $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }

    public int getYDimension() {
        return 1;
    }

    public int getMaxYDimension() {
        return 1;
    }
}

