/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.LongImageHelper;

public class LongSpectrumHelper
extends ANumberSpectrumHelper {
    public LongSpectrumHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        super.init(iAttribute);
        this.imageHelper = new LongImageHelper(iAttribute);
    }

    protected void insert(double[] dArray) {
        int[] nArray = new int[dArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = new Double(dArray[n]).intValue();
            ++n;
        }
        this.deviceAttribute.insert(nArray, this.attribute.getXDimension(), this.attribute.getYDimension());
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Long((long)d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Long((long)d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Long((long)d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Long((long)d));
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Long((long)d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Long((long)d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Long((long)d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Long((long)d), bl);
    }

    double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        int[] nArray = deviceAttribute.extractLongArray();
        double[] dArray = new double[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            dArray[n] = nArray[n];
            ++n;
        }
        return dArray;
    }

    public String getVersion() {
        return "$Id: LongSpectrumHelper.java,v 1.5 2004/12/09 14:56:16 jlpons Exp $";
    }
}

