/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.IBooleanImage;
import fr.esrf.tangoatk.core.IBooleanImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.BooleanImageHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BooleanImage
extends AAttribute
implements IBooleanImage {
    BooleanImageHelper imageHelper = new BooleanImageHelper(this);
    boolean[][] imageValue = null;

    public boolean[][] getValue() {
        return this.imageValue;
    }

    public void setValue(boolean[][] blArray) {
        try {
            this.checkDimensions(blArray);
            this.insert(this.imageHelper.flatten(blArray));
            this.writeAtt();
            this.imageHelper.fireImageValueChanged(blArray, System.currentTimeMillis());
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
        catch (Exception exception) {
            this.setAttError("Couldn't set value", new ATKException(exception));
        }
    }

    void insert(boolean[] blArray) {
        this.imageHelper.insert(blArray);
    }

    public void refresh() {
        DeviceAttribute deviceAttribute = null;
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                deviceAttribute = this.readValueFromNetwork();
                if (deviceAttribute == null) {
                    return;
                }
                this.imageValue = this.imageHelper.getBooleanImageValue(deviceAttribute);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            System.out.println("BooleanImage.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("BooleanImage.refresh()------------------------------------------------");
        }
    }

    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(boolean[][] blArray) {
        this.imageHelper.fireImageValueChanged(blArray, this.timeStamp);
    }

    public void addBooleanImageListener(IBooleanImageListener iBooleanImageListener) {
        this.imageHelper.addBooleanImageListener(iBooleanImageListener);
        this.addStateListener(iBooleanImageListener);
    }

    public void removeBooleanImageListener(IBooleanImageListener iBooleanImageListener) {
        this.imageHelper.removeBooleanImageListener(iBooleanImageListener);
        this.removeStateListener(iBooleanImageListener);
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        block8: {
            ++this.periodicCount;
            DeviceAttribute deviceAttribute = null;
            try {
                deviceAttribute = tangoPeriodicEvent.getValue();
            }
            catch (DevFailed devFailed) {
                if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                } else {
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                }
                return;
            }
            catch (Exception exception) {
                System.out.println("BooleanImage.periodic.getValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("BooleanImage.periodic.getValue()------------------------------------------------");
                return;
            }
            if (deviceAttribute == null) break block8;
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getBooleanImageValue(deviceAttribute);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                System.out.println("BooleanImage.periodic.extractBoolean() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("BooleanImage.periodic.extractBoolean()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        block8: {
            ++this.changeCount;
            DeviceAttribute deviceAttribute = null;
            try {
                deviceAttribute = tangoChangeEvent.getValue();
            }
            catch (DevFailed devFailed) {
                if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                } else {
                    this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
                }
                return;
            }
            catch (Exception exception) {
                System.out.println("BooleanImage.change.getValue() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("BooleanImage.change.getValue()------------------------------------------------");
                return;
            }
            if (deviceAttribute == null) break block8;
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getBooleanImageValue(deviceAttribute);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                System.out.println("BooleanImage.change.extractBoolean() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("BooleanImage.change.extractBoolean()------------------------------------------------");
            }
        }
    }

    public String getVersion() {
        return "$Id: BooleanImage.java,v 1.2 2005/04/28 14:32:24 jlpons Exp $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

