/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRotatable;
import fr.esrf.tangoatk.widget.util.jdraw.JDSpline;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.JLXPath;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;

public class JDPolyline
extends JDObject
implements JDRotatable {
    static final boolean isClosedDefault = true;
    static final int stepDefault = 1;
    boolean isClosed;
    int step;
    int breakId = -1;
    int breakX;
    int breakY;

    JDPolyline() {
    }

    public JDPolyline(String string, Point[] pointArray) {
        this.initDefault();
        this.summit = new Point2D.Double[pointArray.length];
        int n = 0;
        while (n < pointArray.length) {
            this.summit[n] = new Point2D.Double(pointArray[n].x, pointArray[n].y);
            ++n;
        }
        this.name = string;
        this.updateShape();
        Point2D.Double double_ = new Point2D.Double(this.boundRect.x + this.boundRect.width / 2, this.boundRect.y + this.boundRect.height / 2);
        this.setOrigin(double_);
    }

    JDPolyline(JDPolyline jDPolyline, int n, int n2) {
        this.cloneObject(jDPolyline, n, n2);
        this.isClosed = jDPolyline.isClosed;
        this.step = jDPolyline.step;
        this.updateShape();
    }

    JDPolyline(JLXObject jLXObject, JLXPath jLXPath) {
        this.initDefault();
        this.loadObject(jLXObject);
        double d = jLXObject.boundRect.getX();
        double d2 = jLXObject.boundRect.getY();
        double d3 = jLXObject.boundRect.getWidth();
        double d4 = jLXObject.boundRect.getHeight();
        int n = jLXPath.path.size();
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
        this.summit = new Point2D.Double[n];
        this.createSummit();
        int n2 = 0;
        while (n2 < n) {
            double[] dArray = (double[])jLXPath.path.get(n2);
            this.summit[n2].x = this.origin.x + dArray[0];
            this.summit[n2].y = this.origin.y + dArray[1];
            ++n2;
        }
        this.isClosed = jLXPath.closed;
        this.step = 1;
        this.updateShape();
    }

    void initDefault() {
        super.initDefault();
        this.step = 1;
        this.isClosed = true;
    }

    public JDObject copy(int n, int n2) {
        return new JDPolyline(this, n, n2);
    }

    public void paint(JDrawEditor jDrawEditor, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.prepareRendering(graphics2D);
        if (!this.isClosed) {
            if (this.lineWidth > 0) {
                graphics.setColor(this.foreground);
                BasicStroke basicStroke = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
                if (basicStroke != null) {
                    Stroke stroke = graphics2D.getStroke();
                    graphics2D.setStroke(basicStroke);
                    graphics.drawPolyline(this.ptsx, this.ptsy, this.ptsx.length);
                    graphics2D.setStroke(stroke);
                } else {
                    graphics.drawPolyline(this.ptsx, this.ptsy, this.ptsx.length);
                }
            }
        } else {
            Object object;
            if (this.fillStyle != 0) {
                object = GraphicsUtils.createPatternForFilling(this);
                if (object != null) {
                    graphics2D.setPaint((Paint)object);
                }
                graphics.fillPolygon(this.ptsx, this.ptsy, this.ptsx.length);
            }
            if (this.lineWidth > 0) {
                graphics.setColor(this.foreground);
                object = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
                if (object != null) {
                    Stroke stroke = graphics2D.getStroke();
                    graphics2D.setStroke((Stroke)object);
                    graphics.drawPolygon(this.ptsx, this.ptsy, this.ptsx.length);
                    graphics2D.setStroke(stroke);
                } else {
                    graphics.drawPolygon(this.ptsx, this.ptsy, this.ptsx.length);
                }
            }
        }
        this.paintShadows(graphics);
    }

    void paintSelectedSummit(Graphics graphics, int[] nArray, double d) {
        graphics.setColor(Color.MAGENTA);
        graphics.setXORMode(Color.white);
        int n = (int)(d / 2.0 + 1.0);
        int n2 = 0;
        while (n2 < nArray.length) {
            graphics.fillRect((int)(this.summit[nArray[n2]].x + 0.5) - n, (int)(this.summit[nArray[n2]].y + 0.5) - n, 2 * n, 2 * n);
            ++n2;
        }
        graphics.setPaintMode();
    }

    int getSummitMotion(int n) {
        return 3;
    }

    void translateSummits(int[] nArray, double d, double d2) {
        int n = 0;
        while (n < nArray.length) {
            this.summit[nArray[n]].x += d;
            this.summit[nArray[n]].y += d2;
            ++n;
        }
        this.updateShape();
    }

    int[] getSummitsInsideRectangle(Rectangle rectangle) {
        int[] nArray = new int[this.summit.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.summit.length) {
            if (rectangle.contains((int)(this.summit[n2].x + 0.5), (int)(this.summit[n2].y + 0.5))) {
                nArray[n] = n2;
                ++n;
            }
            ++n2;
        }
        int[] nArray2 = new int[n];
        int n3 = 0;
        while (n3 < n) {
            nArray2[n3] = nArray[n3];
            ++n3;
        }
        return nArray2;
    }

    public void moveSummit(int n, double d, double d2) {
        this.summit[n].x = d;
        this.summit[n].y = d2;
        this.updateShape();
    }

    void deleteSummit() {
        if (this.breakId < 0) {
            return;
        }
        Point2D.Double[] doubleArray = new Point2D.Double[this.summit.length - 1];
        int n = 0;
        int n2 = 0;
        while (n < this.summit.length) {
            if (n != this.breakId) {
                doubleArray[n2++] = this.summit[n];
            }
            ++n;
        }
        this.summit = doubleArray;
        this.updateShape();
    }

    boolean canDeleteSummit(int n) {
        if (!this.visible) {
            return false;
        }
        this.breakId = -1;
        if (n < 0 || n >= this.summit.length || this.summit.length <= 2) {
            return false;
        }
        this.breakId = n;
        return true;
    }

    boolean canBreakShape(int n, int n2) {
        if (!this.visible) {
            return false;
        }
        Line2D.Double double_ = new Line2D.Double();
        this.breakId = -1;
        int n3 = 0;
        while (n3 < this.ptsx.length) {
            int n4 = n3 + 1;
            if (n4 >= this.ptsx.length) {
                n4 -= this.ptsx.length;
            }
            double_.setLine(this.ptsx[n3], this.ptsy[n3], this.ptsx[n4], this.ptsy[n4]);
            if (double_.intersects(n - 3, n2 - 3, 6.0, 6.0)) {
                this.breakId = n3;
                this.breakX = n;
                this.breakY = n2;
                return true;
            }
            ++n3;
        }
        return false;
    }

    void breakShape() {
        if (this.breakId < 0) {
            return;
        }
        Point2D.Double[] doubleArray = new Point2D.Double[this.summit.length + 1];
        int n = 0;
        int n2 = 0;
        while (n < this.summit.length) {
            doubleArray[n2++] = this.summit[n];
            if (n == this.breakId) {
                doubleArray[n2++] = new Point2D.Double(this.breakX, this.breakY);
            }
            ++n;
        }
        this.summit = doubleArray;
        this.updateShape();
    }

    /*
     * Unable to fully structure code
     */
    public boolean isInsideObject(int var1_1, int var2_2) {
        block3: {
            if (!super.isInsideObject(var1_1, var2_2)) {
                return false;
            }
            var3_3 = false;
            var4_4 = 0;
            if (this.fillStyle == 0 || !this.isClosed) ** GOTO lbl12
            var5_5 = new Polygon(this.ptsx, this.ptsy, this.ptsx.length);
            var3_3 = var5_5.contains(var1_1, var2_2);
            break block3;
lbl-1000:
            // 1 sources

            {
                var3_3 = this.isPointOnLine(var1_1, var2_2, this.ptsx[var4_4], this.ptsy[var4_4], this.ptsx[var4_4 + 1], this.ptsy[var4_4 + 1]);
                if (var3_3) continue;
                ++var4_4;
lbl12:
                // 3 sources

                ** while (var4_4 < this.ptsx.length - 1 && !var3_3)
            }
lbl13:
            // 1 sources

            if (!var3_3 && this.isClosed) {
                var3_3 = this.isPointOnLine(var1_1, var2_2, this.ptsx[var4_4], this.ptsy[var4_4], this.ptsx[0], this.ptsy[0]);
            }
        }
        return var3_3;
    }

    public void rotate(double d, double d2, double d3) {
        double d4 = Math.sin(d);
        double d5 = Math.cos(d);
        int n = 0;
        while (n < this.summit.length) {
            double d6 = this.summit[n].x - d2;
            double d7 = this.summit[n].y - d3;
            this.summit[n].x = d6 * d5 + d7 * d4 + d2;
            this.summit[n].y = -d6 * d4 + d7 * d5 + d3;
            ++n;
        }
        this.updateShape();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean bl) {
        this.isClosed = bl;
        this.updateShape();
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int n) {
        this.step = 1;
    }

    public void setStartingPoint(int n) {
        Point2D.Double[] doubleArray = new Point2D.Double[this.summit.length];
        int n2 = n %= this.summit.length;
        while (n2 < this.summit.length) {
            doubleArray[n2 - n] = this.summit[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            doubleArray[n3 + this.summit.length - n] = this.summit[n3];
            ++n3;
        }
        this.summit = doubleArray;
        this.updateShape();
    }

    public void connect(JDPolyline jDPolyline) {
        JDPolyline jDPolyline2 = jDPolyline instanceof JDSpline ? ((JDSpline)jDPolyline).convertToPolyline() : jDPolyline;
        Point2D.Double[] doubleArray = new Point2D.Double[this.summit.length + jDPolyline2.getSummitNumber()];
        int n = 0;
        while (n < this.summit.length) {
            doubleArray[n] = this.summit[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < jDPolyline2.getSummitNumber()) {
            doubleArray[n2 + this.summit.length] = new Point2D.Double(jDPolyline2.getSummit((int)n2).x, jDPolyline2.getSummit((int)n2).y);
            ++n2;
        }
        this.summit = doubleArray;
        this.updateShape();
    }

    public void invertSummitOrder() {
        Point2D.Double[] doubleArray = new Point2D.Double[this.summit.length];
        int n = 0;
        while (n < this.summit.length) {
            doubleArray[this.summit.length - n - 1] = this.summit[n];
            ++n;
        }
        this.summit = doubleArray;
        this.updateShape();
    }

    void saveObject(FileWriter fileWriter, int n) throws IOException {
        String string;
        String string2 = this.saveObjectHeader(fileWriter, n);
        if (this.step != 1) {
            string = string2 + "step:" + this.step + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (!this.isClosed) {
            string = string2 + "isClosed:" + this.isClosed + "\n";
            fileWriter.write(string, 0, string.length());
        }
        this.closeObjectHeader(fileWriter, n);
    }

    /*
     * Unable to fully structure code
     */
    JDPolyline(JDFileLoader var1_1) throws IOException {
        super();
        this.initDefault();
        var2_2 = var1_1.getCurrentLine();
        var1_1.startBlock();
        this.summit = var1_1.parseSummitArray();
        if (this.summit.length >= 2) ** GOTO lbl17
        throw new IOException("Invalid summit number for JDPolyline at line " + var2_2);
lbl-1000:
        // 1 sources

        {
            var3_3 = var1_1.parseProperyName();
            if (var3_3.equals("isClosed")) {
                this.isClosed = var1_1.parseBoolean();
                continue;
            }
            if (var3_3.equals("step")) {
                this.step = (int)var1_1.parseDouble();
                continue;
            }
            this.loadDefaultPropery(var1_1, var3_3);
lbl17:
            // 4 sources

            ** while (!var1_1.isEndBlock())
        }
lbl18:
        // 1 sources

        var1_1.endBlock();
        this.updateShape();
    }

    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(5);
        this.fillUndoPattern(undoPattern);
        undoPattern.step = this.step;
        undoPattern.isClosed = this.isClosed;
        return undoPattern;
    }

    JDPolyline(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.step = undoPattern.step;
        this.isClosed = undoPattern.isClosed;
        this.updateShape();
    }

    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[this.summit.length];
        this.ptsy = new int[this.summit.length];
        int n = 0;
        while (n < this.summit.length) {
            this.ptsx[n] = (int)(this.summit[n].x + 0.5);
            this.ptsy[n] = (int)(this.summit[n].y + 0.5);
            ++n;
        }
        if (this.hasShadow()) {
            this.computeShadow(true);
            this.computeShadowColors();
        }
    }
}

