/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDBrowserPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDGradientDialog;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDObjectPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private JTextField nameText;
    private JButton applyNameBtn;
    private JLabel backgroundLabel;
    private JButton backgroundButton;
    private JLabel foregroundLabel;
    private JButton foregroundButton;
    private JLabel lineWidthLabel;
    private JSpinner lineWidthSpinner;
    private JLabel lineDashLabel;
    private JComboBox lineDashCombo;
    private JLabel fillDashLabel;
    private JComboBox fillDashCombo;
    private JButton fillCustomButton;
    private JCheckBox visibleCheckBox;
    private JCheckBox antiAliasCheckBox;
    private JCheckBox shadowCheckBox;
    private JCheckBox invertShadowCheckBox;
    private JLabel shadowWidthLabel;
    private JSpinner shadowWidthSpinner;
    private JDObject[] allObjects = null;
    private JDrawEditor invoker;
    private JDBrowserPanel invoker2;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDObjectPanel() {
        this(null, null, null);
    }

    public JDObjectPanel(JDObject[] jDObjectArray, JDrawEditor jDrawEditor, JDBrowserPanel jDBrowserPanel) {
        this.invoker = jDrawEditor;
        this.invoker2 = jDBrowserPanel;
        this.setForeground(JDUtils.labelColor);
        this.setFont(JDUtils.labelFont);
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel jPanel = new JPanel(null);
        jPanel.setBorder(JDUtils.createTitleBorder("Object name"));
        jPanel.setBounds(5, 5, 370, 55);
        this.nameText = new JTextField();
        this.nameText.setEditable(true);
        this.nameText.setFont(JDUtils.labelFont);
        this.nameText.setBounds(10, 20, 260, 24);
        this.nameText.addActionListener(this);
        jPanel.add(this.nameText);
        this.applyNameBtn = new JButton("Apply");
        this.applyNameBtn.setFont(JDUtils.labelFont);
        this.applyNameBtn.setBounds(270, 20, 90, 24);
        this.applyNameBtn.addActionListener(this);
        jPanel.add(this.applyNameBtn);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setBorder(JDUtils.createTitleBorder("Colors"));
        jPanel2.setBounds(5, 60, 370, 55);
        this.foregroundLabel = JDUtils.createLabel("Foreground");
        this.foregroundLabel.setBounds(10, 20, 100, 24);
        jPanel2.add(this.foregroundLabel);
        this.foregroundButton = new JButton("...");
        this.foregroundButton.setMargin(new Insets(0, 0, 0, 0));
        this.foregroundButton.setForeground(Color.BLACK);
        this.foregroundButton.addActionListener(this);
        this.foregroundButton.setBounds(120, 20, 60, 24);
        jPanel2.add(this.foregroundButton);
        this.add(jPanel2);
        this.backgroundLabel = JDUtils.createLabel("Background");
        this.backgroundLabel.setBounds(190, 20, 100, 24);
        jPanel2.add(this.backgroundLabel);
        this.backgroundButton = new JButton("");
        this.backgroundButton.setMargin(new Insets(0, 0, 0, 0));
        this.backgroundButton.setForeground(Color.BLACK);
        this.backgroundButton.addActionListener(this);
        this.backgroundButton.setBounds(300, 20, 60, 24);
        jPanel2.add(this.backgroundButton);
        JPanel jPanel3 = new JPanel(null);
        jPanel3.setBorder(JDUtils.createTitleBorder("Styles"));
        jPanel3.setBounds(5, 115, 370, 115);
        this.lineDashLabel = JDUtils.createLabel("Line style");
        this.lineDashLabel.setBounds(10, 20, 70, 25);
        jPanel3.add(this.lineDashLabel);
        this.lineDashCombo = new JComboBox();
        this.lineDashCombo.setFont(JDUtils.labelFont);
        this.lineDashCombo.addItem("Solid");
        this.lineDashCombo.addItem("Point dash");
        this.lineDashCombo.addItem("Short dash");
        this.lineDashCombo.addItem("Long dash");
        this.lineDashCombo.addItem("Dot dash");
        this.lineDashCombo.addActionListener(this);
        this.lineDashCombo.setBounds(80, 20, 140, 25);
        jPanel3.add(this.lineDashCombo);
        this.lineWidthLabel = JDUtils.createLabel("Line width");
        this.lineWidthLabel.setHorizontalAlignment(4);
        this.lineWidthLabel.setBounds(220, 20, 90, 25);
        jPanel3.add(this.lineWidthLabel);
        this.lineWidthSpinner = new JSpinner();
        this.lineWidthSpinner.addChangeListener(this);
        this.lineWidthSpinner.setBounds(315, 20, 45, 25);
        jPanel3.add(this.lineWidthSpinner);
        this.add(jPanel3);
        this.fillDashLabel = JDUtils.createLabel("Fill style");
        this.fillDashLabel.setBounds(10, 50, 70, 25);
        jPanel3.add(this.fillDashLabel);
        this.fillDashCombo = new JComboBox();
        this.fillDashCombo.setFont(JDUtils.labelFont);
        this.fillDashCombo.addItem("No fill");
        this.fillDashCombo.addItem("Solid");
        this.fillDashCombo.addItem("Large leff hatch");
        this.fillDashCombo.addItem("Large right hatch");
        this.fillDashCombo.addItem("Large cross hatch");
        this.fillDashCombo.addItem("Small leff hatch");
        this.fillDashCombo.addItem("Small right hatch");
        this.fillDashCombo.addItem("Small cross hatch");
        this.fillDashCombo.addItem("Dot pattern 1");
        this.fillDashCombo.addItem("Dot pattern 2");
        this.fillDashCombo.addItem("Dot pattern 3");
        this.fillDashCombo.addItem("Gradient fill");
        this.fillDashCombo.addActionListener(this);
        this.fillDashCombo.setBounds(80, 50, 140, 25);
        jPanel3.add(this.fillDashCombo);
        this.fillCustomButton = new JButton("Gradient settings");
        this.fillCustomButton.setFont(JDUtils.labelFont);
        this.fillCustomButton.setMargin(new Insets(0, 0, 0, 0));
        this.fillCustomButton.setForeground(Color.BLACK);
        this.fillCustomButton.addActionListener(this);
        this.fillCustomButton.setBounds(230, 50, 130, 25);
        jPanel3.add(this.fillCustomButton);
        this.visibleCheckBox = new JCheckBox("Visible");
        this.visibleCheckBox.setFont(JDUtils.labelFont);
        this.visibleCheckBox.setForeground(JDUtils.labelColor);
        this.visibleCheckBox.setBounds(5, 80, 90, 25);
        this.visibleCheckBox.addActionListener(this);
        jPanel3.add(this.visibleCheckBox);
        this.antiAliasCheckBox = new JCheckBox("Anti alias");
        this.antiAliasCheckBox.setFont(JDUtils.labelFont);
        this.antiAliasCheckBox.setForeground(JDUtils.labelColor);
        this.antiAliasCheckBox.setBounds(110, 80, 90, 25);
        this.antiAliasCheckBox.addActionListener(this);
        jPanel3.add(this.antiAliasCheckBox);
        JPanel jPanel4 = new JPanel(null);
        jPanel4.setBorder(JDUtils.createTitleBorder("Shadows"));
        jPanel4.setBounds(5, 230, 370, 55);
        this.shadowCheckBox = new JCheckBox("Shadow");
        this.shadowCheckBox.setFont(JDUtils.labelFont);
        this.shadowCheckBox.setForeground(JDUtils.labelColor);
        this.shadowCheckBox.setBounds(5, 20, 90, 25);
        this.shadowCheckBox.addActionListener(this);
        jPanel4.add(this.shadowCheckBox);
        this.invertShadowCheckBox = new JCheckBox("Invert");
        this.invertShadowCheckBox.setFont(JDUtils.labelFont);
        this.invertShadowCheckBox.setForeground(JDUtils.labelColor);
        this.invertShadowCheckBox.setBounds(110, 20, 90, 25);
        this.invertShadowCheckBox.addActionListener(this);
        jPanel4.add(this.invertShadowCheckBox);
        this.shadowWidthLabel = JDUtils.createLabel("Thickness");
        this.shadowWidthLabel.setHorizontalAlignment(4);
        this.shadowWidthLabel.setBounds(200, 20, 90, 25);
        jPanel4.add(this.shadowWidthLabel);
        this.shadowWidthSpinner = new JSpinner();
        this.shadowWidthSpinner.addChangeListener(this);
        this.shadowWidthSpinner.setBounds(295, 20, 65, 25);
        jPanel4.add(this.shadowWidthSpinner);
        this.add(jPanel4);
        this.updatePanel(jDObjectArray);
    }

    public void updatePanel(JDObject[] jDObjectArray) {
        this.allObjects = jDObjectArray;
        this.isUpdating = true;
        if (jDObjectArray == null || jDObjectArray.length <= 0) {
            this.nameText.setText("");
            this.foregroundButton.setBackground(Color.LIGHT_GRAY);
            this.backgroundButton.setBackground(Color.LIGHT_GRAY);
            this.lineDashCombo.setSelectedIndex(-1);
            this.lineWidthSpinner.setModel(new SpinnerNumberModel(0, 0, 0, 0));
            this.shadowWidthSpinner.setModel(new SpinnerNumberModel(0, 0, 0, 0));
            this.fillDashCombo.setSelectedIndex(-1);
            this.fillCustomButton.setEnabled(false);
            this.visibleCheckBox.setSelected(false);
            this.antiAliasCheckBox.setSelected(false);
            this.shadowCheckBox.setSelected(false);
            this.invertShadowCheckBox.setSelected(false);
        } else {
            JDObject jDObject = jDObjectArray[0];
            this.nameText.setText(jDObject.getName());
            this.foregroundButton.setBackground(jDObject.getForeground());
            this.backgroundButton.setBackground(jDObject.getBackground());
            this.lineDashCombo.setSelectedIndex(jDObject.getLineStyle());
            Integer n = new Integer(jDObject.getLineWidth());
            Integer n2 = new Integer(0);
            Integer n3 = new Integer(10);
            Integer n4 = new Integer(1);
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
            this.lineWidthSpinner.setModel(spinnerNumberModel);
            n2 = new Integer(1);
            n3 = new Integer(20);
            n4 = new Integer(1);
            n = new Integer(jDObject.getShadowWidth());
            SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(n, n2, n3, n4);
            this.shadowWidthSpinner.setModel(spinnerNumberModel2);
            this.fillDashCombo.setSelectedIndex(jDObject.getFillStyle());
            this.fillCustomButton.setEnabled(jDObject.getFillStyle() == 11);
            this.visibleCheckBox.setSelected(jDObject.isVisible());
            this.antiAliasCheckBox.setSelected(jDObject.isAntiAliased());
            this.shadowCheckBox.setSelected(jDObject.hasShadow());
            this.invertShadowCheckBox.setSelected(jDObject.hasInverseShadow());
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        int n = 1;
        while (n < this.allObjects.length) {
            this.oldRect = this.oldRect.union(this.allObjects[n].getRepaintRect());
            ++n;
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle rectangle = this.allObjects[0].getRepaintRect();
        int n = 1;
        while (n < this.allObjects.length) {
            rectangle = rectangle.union(this.allObjects[n].getRepaintRect());
            ++n;
        }
        this.invoker.repaint(rectangle.union(this.oldRect));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        Object object = actionEvent.getSource();
        this.initRepaint();
        if (object == this.backgroundButton) {
            Color color = JColorChooser.showDialog(this, "Choose background color", this.allObjects[0].getBackground());
            if (color != null) {
                int n = 0;
                while (n < this.allObjects.length) {
                    this.allObjects[n].setBackground(color);
                    ++n;
                }
                this.backgroundButton.setBackground(color);
                this.invoker.setNeedToSave(true, "Change background");
            }
        } else if (object == this.foregroundButton) {
            Color color = JColorChooser.showDialog(this, "Choose foreground color", this.allObjects[0].getForeground());
            if (color != null) {
                int n = 0;
                while (n < this.allObjects.length) {
                    this.allObjects[n].setForeground(color);
                    ++n;
                }
                this.foregroundButton.setBackground(color);
                this.invoker.setNeedToSave(true, "Change foreground");
            }
        } else if (object == this.lineDashCombo) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].setLineStyle(this.lineDashCombo.getSelectedIndex());
                ++n;
            }
            this.invoker.setNeedToSave(true, "Change line style");
        } else if (object == this.fillDashCombo) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].setFillStyle(this.fillDashCombo.getSelectedIndex());
                ++n;
            }
            this.fillCustomButton.setEnabled(this.fillDashCombo.getSelectedIndex() == 11);
            this.invoker.setNeedToSave(true, "Change fill style");
        } else if (object == this.shadowCheckBox) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].setShadow(this.shadowCheckBox.isSelected());
                ++n;
            }
            this.invoker.setNeedToSave(true, "Change shadow");
        } else if (object == this.invertShadowCheckBox) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].setInverseShadow(this.invertShadowCheckBox.isSelected());
                ++n;
            }
            this.invoker.setNeedToSave(true, "Change invert shadow");
        } else if (object == this.nameText || object == this.applyNameBtn) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].setName(this.nameText.getText());
                ++n;
            }
            this.invoker.setNeedToSave(true, "Change name");
            if (this.invoker2 != null) {
                this.invoker2.updateNode();
            }
            this.nameText.setCaretPosition(0);
        } else if (object == this.visibleCheckBox) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].setVisible(this.visibleCheckBox.isSelected());
                ++n;
            }
            this.invoker.setNeedToSave(true, "Change visible");
        } else if (object == this.fillCustomButton) {
            JDialog jDialog = (JDialog)this.getRootPane().getRootPane().getParent();
            JDGradientDialog jDGradientDialog = new JDGradientDialog(jDialog, this.allObjects, (JComponent)this.invoker);
            if (jDGradientDialog.editGradient()) {
                this.invoker.setNeedToSave(true, "Change gradient fill");
            }
        } else if (object == this.antiAliasCheckBox) {
            int n = 0;
            while (n < this.allObjects.length) {
                this.allObjects[n].setAntiAlias(this.antiAliasCheckBox.isSelected());
                ++n;
            }
            this.invoker.setNeedToSave(true, "Change anti alias");
        }
        this.repaintObjects();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        Object object = changeEvent.getSource();
        this.initRepaint();
        if (object == this.lineWidthSpinner) {
            Integer n = (Integer)this.lineWidthSpinner.getValue();
            int n2 = 0;
            while (n2 < this.allObjects.length) {
                this.allObjects[n2].setLineWidth(n);
                ++n2;
            }
            this.invoker.setNeedToSave(true, "Change line width");
        } else if (object == this.shadowWidthSpinner) {
            Integer n = (Integer)this.shadowWidthSpinner.getValue();
            int n3 = 0;
            while (n3 < this.allObjects.length) {
                this.allObjects[n3].setShadowWidth(n);
                ++n3;
            }
            this.invoker.setNeedToSave(true, "Change shadow width");
        }
        this.repaintObjects();
    }
}

