/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDMouseEvent;
import fr.esrf.tangoatk.widget.util.jdraw.JDMouseListener;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueListener;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueProgram;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public abstract class JDObject {
    public static final int LINE_STYLE_SOLID = 0;
    public static final int LINE_STYLE_DOT = 1;
    public static final int LINE_STYLE_DASH = 2;
    public static final int LINE_STYLE_LONG_DASH = 3;
    public static final int LINE_STYLE_DASH_DOT = 4;
    public static final int FILL_STYLE_NONE = 0;
    public static final int FILL_STYLE_SOLID = 1;
    public static final int FILL_STYLE_LARGE_RIGHT_HATCH = 2;
    public static final int FILL_STYLE_LARGE_LEFT_HATCH = 3;
    public static final int FILL_STYLE_LARGE_CROSS_HATCH = 4;
    public static final int FILL_STYLE_SMALL_RIGHT_HATCH = 5;
    public static final int FILL_STYLE_SMALL_LEFT_HATCH = 6;
    public static final int FILL_STYLE_SMALL_CROSS_HATCH = 7;
    public static final int FILL_STYLE_DOT_PATTERN_1 = 8;
    public static final int FILL_STYLE_DOT_PATTERN_2 = 9;
    public static final int FILL_STYLE_DOT_PATTERN_3 = 10;
    public static final int FILL_STYLE_GRADIENT = 11;
    public static final int VALUE_INC_ON_CLICK = 0;
    public static final int VALUE_INC_ON_PRESSRELEASE = 1;
    public static final int VALUE_CHANGE_ON_XDRAG_LEFT = 2;
    public static final int VALUE_CHANGE_ON_XDRAG_RIGHT = 3;
    public static final int VALUE_CHANGE_ON_YDRAG_TOP = 4;
    public static final int VALUE_CHANGE_ON_YDRAG_BOTTOM = 5;
    static final int NONE_SM = 0;
    static final int HORIZONTAL_SM = 1;
    static final int VERTICAL_SM = 2;
    static final int BOTH_SM = 3;
    static final int MPRESSED = 1;
    static final int MRELEASED = 2;
    static final int MDRAGGED = 3;
    private static final Color foregroundDefault = Color.black;
    private static final Color backgroundDefault = Color.white;
    private static final int fillStyleDefault = 0;
    private static final int lineWidthDefault = 1;
    private static final int lineStyleDefault = 0;
    private static final boolean isShadowedDefault = false;
    private static final boolean invertShadowDefault = false;
    private static final int shadowThicknessDefault = 5;
    private static final boolean visibleDefault = true;
    private static final String nameDefault = "JDObject";
    private static final int minValueDefault = 0;
    private static final int maxValueDefault = 1;
    private static final int initValueDefault = 0;
    private static final boolean userValueDefault = false;
    private static final int valueChangeModeDefault = 0;
    private static final float gradientX1default = 0.0f;
    private static final float gradientY1default = 0.0f;
    private static final float gradientX2default = 70.7f;
    private static final float gradientY2default = 70.7f;
    private static final Color gradientC1default = Color.BLACK;
    private static final Color gradientC2default = Color.WHITE;
    private static final boolean gradientCyclicdefault = false;
    private static final boolean antiAliasDefault = false;
    Rectangle boundRect = new Rectangle(0, 0, 0, 0);
    Point2D.Double origin = new Point2D.Double(0.0, 0.0);
    Point2D.Double[] summit;
    Color foreground;
    int lineStyle;
    int lineWidth;
    Color background;
    int fillStyle;
    boolean visible;
    String name;
    boolean userValue;
    int valueChangeMode;
    boolean antiAlias;
    private int value;
    int minValue;
    int maxValue;
    int initValue;
    private boolean hasMapper;
    JDValueProgram backgroundMapper;
    JDValueProgram foregroundMapper;
    JDValueProgram visibilityMapper;
    JDValueProgram invertShadowMapper;
    JDValueProgram hTranslationMapper;
    JDValueProgram vTranslationMapper;
    private Vector valueListener = null;
    private Vector mouseListener = null;
    private JDrawEditor parent = null;
    int[] ptsx;
    int[] ptsy;
    double[] normes;
    Polygon[] shadows;
    Color[] shadowColors;
    int shadowThickness;
    Rectangle sBoundRect;
    boolean isShadowed;
    boolean invertShadow;
    double lightx = 1.0;
    double lighty = 1.0;
    private double[] sSummit = null;
    private double sXOrg;
    private double sYOrg;
    private Rectangle preRefreshRect = null;
    float gradientX1;
    float gradientX2;
    float gradientY1;
    float gradientY2;
    float sGradientX1;
    float sGradientX2;
    float sGradientY1;
    float sGradientY2;
    Color gradientC1;
    Color gradientC2;
    boolean gradientCyclic;
    String[] extParamValue = null;
    String[] extParamName = null;

    void initDefault() {
        double d = Math.sqrt(this.lightx * this.lightx + this.lighty * this.lighty);
        this.lightx /= d;
        this.lighty /= d;
        this.sBoundRect = new Rectangle();
        this.foreground = foregroundDefault;
        this.background = backgroundDefault;
        this.fillStyle = 0;
        this.lineWidth = 1;
        this.lineStyle = 0;
        this.isShadowed = false;
        this.invertShadow = false;
        this.shadowThickness = 5;
        this.visible = true;
        this.name = nameDefault;
        this.antiAlias = false;
        this.minValue = 0;
        this.maxValue = 1;
        this.initValue = 0;
        this.userValue = false;
        this.valueChangeMode = 0;
        this.initDefaultMapper();
        this.gradientX1 = 0.0f;
        this.gradientX2 = 70.7f;
        this.gradientY1 = 0.0f;
        this.gradientY2 = 70.7f;
        this.gradientC1 = gradientC1default;
        this.gradientC2 = gradientC2default;
        this.gradientCyclic = false;
    }

    void initDefaultMapper() {
        this.backgroundMapper = null;
        this.foregroundMapper = null;
        this.visibilityMapper = null;
        this.invertShadowMapper = null;
        this.hTranslationMapper = null;
        this.vTranslationMapper = null;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.restoreTransform();
        this.setVal(n, this);
    }

    void setVal(int n, JDObject jDObject) {
        this.value = n;
        this.manageMappers(jDObject);
    }

    void initValue() {
        this.initVal(this);
    }

    void initVal(JDObject jDObject) {
        this.hasMapper = this.hasValueProgram();
        this.value = this.initValue;
        this.manageMappers(jDObject);
    }

    void incValue() {
        if (this.value + 1 > this.maxValue) {
            this.setValue(this.minValue);
            this.fireValueExceed();
        } else {
            this.setValue(this.value + 1);
        }
    }

    boolean hasValueProgram() {
        return this.backgroundMapper != null || this.foregroundMapper != null || this.visibilityMapper != null || this.invertShadowMapper != null || this.hTranslationMapper != null || this.vTranslationMapper != null;
    }

    int saturateValue(int n) {
        if (n > this.getMaxValue()) {
            n = this.getMaxValue();
        }
        if (n < this.getMinValue()) {
            n = this.getMinValue();
        }
        return n;
    }

    void processValue(int n, int n2, int n3) {
        int n4 = this.value;
        switch (this.getValueChangeMode()) {
            case 0: {
                if (n != 1) break;
                this.incValue();
                this.fireValueChange();
                break;
            }
            case 1: {
                if (n != 1 && n != 2) break;
                this.incValue();
                this.fireValueChange();
                break;
            }
            case 2: {
                Rectangle rectangle = this.getBoundRect();
                double d = this.getMaxValue() + 1 - this.getMinValue();
                int n5 = this.getMinValue() + (int)((double)(n2 - rectangle.x) / (double)rectangle.width * d);
                this.setValue(this.saturateValue(n5));
                if (this.value == n4) break;
                this.fireValueChange();
                break;
            }
            case 3: {
                Rectangle rectangle = this.getBoundRect();
                double d = this.getMaxValue() + 1 - this.getMinValue();
                int n6 = this.getMinValue() + (int)((double)(rectangle.width + rectangle.x - n2) / (double)rectangle.width * d);
                this.setValue(this.saturateValue(n6));
                if (this.value == n4) break;
                this.fireValueChange();
                break;
            }
            case 4: {
                Rectangle rectangle = this.getBoundRect();
                double d = this.getMaxValue() + 1 - this.getMinValue();
                int n7 = this.getMinValue() + (int)((double)(n3 - rectangle.y) / (double)rectangle.height * d);
                this.setValue(this.saturateValue(n7));
                if (this.value == n4) break;
                this.fireValueChange();
                break;
            }
            case 5: {
                Rectangle rectangle = this.getBoundRect();
                double d = this.getMaxValue() + 1 - this.getMinValue();
                int n8 = this.getMinValue() + (int)((double)(rectangle.height + rectangle.y - n3) / (double)rectangle.height * d);
                this.setValue(this.saturateValue(n8));
                if (this.value == n4) break;
                this.fireValueChange();
            }
        }
    }

    void findObjectsAt(int n, int n2, Vector vector) {
        boolean bl = this.visible;
        this.visible = true;
        if (this.isInteractive() && this.isInsideObject(n, n2)) {
            vector.add(this);
        }
        this.visible = bl;
    }

    void getUserValueList(Vector vector) {
        if (this.isInteractive()) {
            vector.add(this);
        }
    }

    private void manageMappers(JDObject jDObject) {
        if (this.hasMapper) {
            this.manageBackgroundMapper();
            this.manageForegroundMapper();
            this.manageVisibilityMapper();
            this.manageInvertShadowMapper();
            this.manageTranslationMapper(jDObject);
        }
    }

    private void manageBackgroundMapper() {
        if (this.backgroundMapper != null) {
            Color color = this.backgroundMapper.getColorMappingFor(this);
            this.setBackground(color);
        }
    }

    private void manageForegroundMapper() {
        if (this.foregroundMapper != null) {
            Color color = this.foregroundMapper.getColorMappingFor(this);
            this.setForeground(color);
        }
    }

    private void manageInvertShadowMapper() {
        if (this.invertShadowMapper != null) {
            boolean bl = this.invertShadowMapper.getBooleanMappingFor(this);
            this.setInverseShadow(bl);
        }
    }

    private void manageVisibilityMapper() {
        if (this.visibilityMapper != null) {
            boolean bl = this.visibilityMapper.getBooleanMappingFor(this);
            this.setVisible(bl);
        }
    }

    private void manageTranslationMapper(JDObject jDObject) {
        int n = 0;
        int n2 = 0;
        if (this.hTranslationMapper != null) {
            n = this.hTranslationMapper.getIntegerMappingFor(this, jDObject);
        }
        if (this.vTranslationMapper != null) {
            n2 = this.vTranslationMapper.getIntegerMappingFor(this, jDObject);
        }
        this.translate(n, n2);
    }

    public void addValueListener(JDValueListener jDValueListener) {
        if (this.valueListener == null) {
            this.valueListener = new Vector();
        }
        this.valueListener.add(jDValueListener);
    }

    public void addMouseListener(JDMouseListener jDMouseListener) {
        if (this.mouseListener == null) {
            this.mouseListener = new Vector();
        }
        this.mouseListener.add(jDMouseListener);
    }

    public void removeValueListener(JDValueListener jDValueListener) {
        if (this.valueListener != null) {
            this.valueListener.remove(jDValueListener);
        }
    }

    public void removeMouseListener(JDMouseListener jDMouseListener) {
        if (this.mouseListener != null) {
            this.mouseListener.remove(jDMouseListener);
        }
    }

    public void clearValueListener() {
        if (this.valueListener != null) {
            this.valueListener.clear();
        }
        this.valueListener = null;
    }

    public void clearMouseListener() {
        if (this.mouseListener != null) {
            this.mouseListener.clear();
        }
        this.mouseListener = null;
    }

    boolean hasMouseListener() {
        if (this.mouseListener != null) {
            return this.mouseListener.size() > 0;
        }
        return false;
    }

    void fireValueChange() {
        if (this.valueListener != null) {
            int n = 0;
            while (n < this.valueListener.size()) {
                ((JDValueListener)this.valueListener.get(n)).valueChanged(this);
                ++n;
            }
        }
    }

    void fireValueExceed() {
        if (this.valueListener != null) {
            int n = 0;
            while (n < this.valueListener.size()) {
                ((JDValueListener)this.valueListener.get(n)).valueExceedBounds(this);
                ++n;
            }
        }
    }

    void fireMouseEvent(int n, MouseEvent mouseEvent) {
        if (this.mouseListener != null) {
            JDMouseEvent jDMouseEvent = new JDMouseEvent(this, mouseEvent);
            switch (n) {
                case 501: {
                    int n2 = 0;
                    while (n2 < this.mouseListener.size()) {
                        ((JDMouseListener)this.mouseListener.get(n2)).mousePressed(jDMouseEvent);
                        ++n2;
                    }
                    break;
                }
                case 502: {
                    int n3 = 0;
                    while (n3 < this.mouseListener.size()) {
                        ((JDMouseListener)this.mouseListener.get(n3)).mouseReleased(jDMouseEvent);
                        ++n3;
                    }
                    break;
                }
                case 500: {
                    int n4 = 0;
                    while (n4 < this.mouseListener.size()) {
                        ((JDMouseListener)this.mouseListener.get(n4)).mouseClicked(jDMouseEvent);
                        ++n4;
                    }
                    break;
                }
                case 504: {
                    int n5 = 0;
                    while (n5 < this.mouseListener.size()) {
                        ((JDMouseListener)this.mouseListener.get(n5)).mouseEntered(jDMouseEvent);
                        ++n5;
                    }
                    break;
                }
                case 505: {
                    int n6 = 0;
                    while (n6 < this.mouseListener.size()) {
                        ((JDMouseListener)this.mouseListener.get(n6)).mouseExited(jDMouseEvent);
                        ++n6;
                    }
                    break;
                }
            }
        }
    }

    public abstract void paint(JDrawEditor var1, Graphics var2);

    void getObjectsByClassList(Vector vector, Class clazz) {
        if (this.getClass() == clazz) {
            vector.add(this);
        }
    }

    public void getObjectsByName(Vector vector, String string, boolean bl) {
        if (this.getName().equals(string)) {
            vector.add(this);
        }
    }

    Rectangle getRepaintRect() {
        int n = this.lineWidth + 1;
        if (!this.hasShadow()) {
            return new Rectangle(this.boundRect.x - n, this.boundRect.y - n, this.boundRect.width + n * 2, this.boundRect.height + n * 2);
        }
        Rectangle rectangle = this.getShadowBoundRect();
        return new Rectangle(rectangle.x - n, rectangle.y - n, rectangle.width + n * 2, rectangle.height + n * 2);
    }

    public Rectangle getBoundRect() {
        return this.boundRect;
    }

    void paintShadows(Graphics graphics) {
        if (this.hasShadow()) {
            int n = 0;
            while (n < this.shadows.length) {
                graphics.setColor(this.shadowColors[n]);
                graphics.fillPolygon(this.shadows[n]);
                ++n;
            }
        }
    }

    void createSummit() {
        int n = 0;
        while (n < this.summit.length) {
            this.summit[n] = new Point2D.Double(0.0, 0.0);
            ++n;
        }
    }

    public boolean isInsideObject(int n, int n2) {
        if (!this.visible) {
            return false;
        }
        int n3 = (this.lineWidth + 1) * 2;
        Rectangle rectangle = new Rectangle(this.boundRect.x - n3 / 2, this.boundRect.y - n3 / 2, this.boundRect.width + n3, this.boundRect.height + n3);
        return rectangle.contains(n, n2);
    }

    public int getSummitNumber() {
        return this.summit.length;
    }

    int getSummit(int n, int n2, double d) {
        int n3 = 0;
        boolean bl = false;
        int n4 = (int)(d / 2.0 + 1.0);
        while (n3 < this.summit.length && !bl) {
            boolean bl2 = bl = (double)n >= this.summit[n3].x - (double)n4 && (double)n <= this.summit[n3].x + (double)n4 && (double)n2 >= this.summit[n3].y - (double)n4 && (double)n2 <= this.summit[n3].y + (double)n4;
            if (bl) continue;
            ++n3;
        }
        if (bl) {
            return n3;
        }
        return -1;
    }

    public Point2D.Double getSummit(int n) {
        return this.summit[n];
    }

    void computeBoundRect() {
        double d = -65536.0;
        double d2 = -65536.0;
        double d3 = 65536.0;
        double d4 = 65536.0;
        int n = 0;
        while (n < this.summit.length) {
            if (this.summit[n].x < d3) {
                d3 = this.summit[n].x;
            }
            if (this.summit[n].x > d) {
                d = this.summit[n].x;
            }
            if (this.summit[n].y < d4) {
                d4 = this.summit[n].y;
            }
            if (this.summit[n].y > d2) {
                d2 = this.summit[n].y;
            }
            ++n;
        }
        this.boundRect = new Rectangle((int)d3, (int)d4, (int)(d - d3) + 1, (int)(d2 - d4) + 1);
    }

    void paintSummit(Graphics graphics, double d) {
        graphics.setColor(Color.black);
        graphics.setXORMode(Color.white);
        int n = (int)(d / 2.0 + 1.0);
        int n2 = 0;
        while (n2 < this.summit.length) {
            graphics.fillRect((int)(this.summit[n2].x + 0.5) - n, (int)(this.summit[n2].y + 0.5) - n, 2 * n, 2 * n);
            ++n2;
        }
        graphics.setPaintMode();
    }

    void paintOrigin(Graphics graphics) {
        graphics.setColor(Color.RED);
        graphics.drawLine((int)(this.origin.x - 10.0), (int)this.origin.y, (int)(this.origin.x + 10.0), (int)this.origin.y);
        graphics.drawLine((int)this.origin.x, (int)(this.origin.y - 10.0), (int)this.origin.x, (int)(this.origin.y + 10.0));
    }

    public abstract void moveSummit(int var1, double var2, double var4);

    public void moveSummitH(int n, double d) {
        double d2 = this.summit[n].y;
        this.moveSummit(n, d, d2);
    }

    public void moveSummitV(int n, double d) {
        double d2 = this.summit[n].x;
        this.moveSummit(n, d2, d);
    }

    abstract int getSummitMotion(int var1);

    boolean isPointOnLine(int n, int n2, int n3, int n4, int n5, int n6) {
        Line2D.Double double_ = new Line2D.Double(n3, n4, n5, n6);
        return double_.intersects(n - 2, n2 - 2, 4.0, 4.0);
    }

    public abstract JDObject copy(int var1, int var2);

    JDPolyline buildDefaultPolyline() {
        this.updateShape();
        Point[] pointArray = new Point[this.ptsx.length];
        int n = 0;
        while (n < pointArray.length) {
            pointArray[n] = new Point(this.ptsx[n], this.ptsy[n]);
            ++n;
        }
        JDPolyline jDPolyline = new JDPolyline(this.name, pointArray);
        jDPolyline.copyObjectProperty(this);
        return jDPolyline;
    }

    void copyObjectProperty(JDObject jDObject) {
        this.foreground = new Color(jDObject.getForeground().getRGB());
        this.background = new Color(jDObject.getBackground().getRGB());
        this.fillStyle = jDObject.fillStyle;
        this.lineWidth = jDObject.lineWidth;
        this.lineStyle = jDObject.lineStyle;
        this.antiAlias = jDObject.antiAlias;
        this.isShadowed = jDObject.isShadowed;
        this.invertShadow = jDObject.invertShadow;
        this.shadowThickness = jDObject.shadowThickness;
        this.name = new String(jDObject.name);
        this.visible = jDObject.visible;
        this.sBoundRect = new Rectangle();
        this.minValue = jDObject.minValue;
        this.maxValue = jDObject.maxValue;
        this.initValue = jDObject.initValue;
        this.userValue = jDObject.userValue;
        this.valueChangeMode = jDObject.valueChangeMode;
        this.initDefaultMapper();
        if (jDObject.backgroundMapper != null) {
            this.backgroundMapper = jDObject.backgroundMapper.copy();
        }
        if (jDObject.foregroundMapper != null) {
            this.foregroundMapper = jDObject.foregroundMapper.copy();
        }
        if (jDObject.visibilityMapper != null) {
            this.visibilityMapper = jDObject.visibilityMapper.copy();
        }
        if (jDObject.invertShadowMapper != null) {
            this.invertShadowMapper = jDObject.invertShadowMapper.copy();
        }
        if (jDObject.hTranslationMapper != null) {
            this.hTranslationMapper = jDObject.hTranslationMapper.copy();
        }
        if (jDObject.vTranslationMapper != null) {
            this.vTranslationMapper = jDObject.vTranslationMapper.copy();
        }
        this.gradientX1 = jDObject.gradientX1;
        this.gradientX2 = jDObject.gradientX2;
        this.gradientY1 = jDObject.gradientY1;
        this.gradientY2 = jDObject.gradientY2;
        this.gradientC1 = jDObject.gradientC1;
        this.gradientC2 = jDObject.gradientC2;
        this.gradientCyclic = jDObject.gradientCyclic;
        if (jDObject.extParamName != null) {
            this.extParamName = jDObject.extParamName;
            this.extParamValue = new String[jDObject.extParamValue.length];
            int n = 0;
            while (n < jDObject.extParamValue.length) {
                this.extParamValue[n] = new String(jDObject.extParamValue[n]);
                ++n;
            }
        } else {
            this.extParamValue = null;
        }
    }

    void cloneObject(JDObject jDObject, int n, int n2) {
        this.summit = new Point2D.Double[jDObject.summit.length];
        int n3 = 0;
        while (n3 < jDObject.summit.length) {
            this.summit[n3] = new Point2D.Double(jDObject.summit[n3].x + (double)n, jDObject.summit[n3].y + (double)n2);
            ++n3;
        }
        this.origin = new Point2D.Double(jDObject.origin.x + (double)n, jDObject.origin.y + (double)n2);
        this.copyObjectProperty(jDObject);
    }

    public void translate(double d, double d2) {
        int n = 0;
        while (n < this.summit.length) {
            this.summit[n].x += d;
            this.summit[n].y += d2;
            ++n;
        }
        this.origin.x += d;
        this.origin.y += d2;
        this.updateShape();
    }

    public void scaleTranslate(double d, double d2, double d3, double d4, double d5, double d6) {
        int n = 0;
        while (n < this.summit.length) {
            this.summit[n].x = d + d3 * (this.summit[n].x - d);
            this.summit[n].y = d2 + d4 * (this.summit[n].y - d2);
            ++n;
        }
        this.origin.x = d + d3 * (this.origin.x - d);
        this.origin.y = d2 + d4 * (this.origin.y - d2);
        int n2 = 0;
        while (n2 < this.summit.length) {
            this.summit[n2].x += d5;
            this.summit[n2].y += d6;
            ++n2;
        }
        this.origin.x += d5;
        this.origin.y += d6;
        this.updateShape();
    }

    public void scale(double d, double d2, double d3, double d4) {
        int n = 0;
        while (n < this.summit.length) {
            this.summit[n].x = d + d3 * (this.summit[n].x - d);
            this.summit[n].y = d2 + d4 * (this.summit[n].y - d2);
            ++n;
        }
        this.origin.x = d + d3 * (this.origin.x - d);
        this.origin.y = d2 + d4 * (this.origin.y - d2);
        this.updateShape();
    }

    public void rotate90(double d, double d2) {
        double d3;
        double d4;
        int n = this.summit.length;
        int n2 = 0;
        while (n2 < n) {
            d4 = this.summit[n2].x;
            d3 = this.summit[n2].y;
            this.summit[n2].x = d + (d3 - d2);
            this.summit[n2].y = d2 - (d4 - d);
            ++n2;
        }
        d4 = this.origin.x;
        d3 = this.origin.y;
        this.origin.x = d + (d3 - d2);
        this.origin.y = d2 - (d4 - d);
        d4 = this.gradientX1;
        d3 = this.gradientY1;
        this.gradientX1 = (float)d3;
        this.gradientY1 = (float)(-d4);
        d4 = this.gradientX2;
        d3 = this.gradientY2;
        this.gradientX2 = (float)d3;
        this.gradientY2 = (float)(-d4);
        this.updateShape();
    }

    abstract void saveObject(FileWriter var1, int var2) throws IOException;

    void loadDefaultPropery(JDFileLoader jDFileLoader, String string) throws IOException {
        if (string.equals("origin")) {
            this.origin = jDFileLoader.parsePoint();
        } else if (string.equals("foreground")) {
            this.foreground = jDFileLoader.parseColor();
        } else if (string.equals("background")) {
            this.background = jDFileLoader.parseColor();
        } else if (string.equals("fillStyle")) {
            this.fillStyle = (int)jDFileLoader.parseDouble();
        } else if (string.equals("lineWidth")) {
            this.lineWidth = (int)jDFileLoader.parseDouble();
        } else if (string.equals("lineStyle")) {
            this.lineStyle = (int)jDFileLoader.parseDouble();
        } else if (string.equals("antiAlias")) {
            this.antiAlias = jDFileLoader.parseBoolean();
        } else if (string.equals("isShadowed")) {
            this.isShadowed = jDFileLoader.parseBoolean();
        } else if (string.equals("invertShadow")) {
            this.invertShadow = jDFileLoader.parseBoolean();
        } else if (string.equals("name")) {
            this.name = jDFileLoader.parseString();
        } else if (string.equals("shadowThickness")) {
            this.shadowThickness = (int)jDFileLoader.parseDouble();
        } else if (string.equals("visible")) {
            this.visible = jDFileLoader.parseBoolean();
        } else if (string.equals("minvalue")) {
            this.minValue = (int)jDFileLoader.parseDouble();
        } else if (string.equals("maxvalue")) {
            this.maxValue = (int)jDFileLoader.parseDouble();
        } else if (string.equals("initvalue")) {
            this.initValue = (int)jDFileLoader.parseDouble();
        } else if (string.equals("uservalue")) {
            this.userValue = jDFileLoader.parseBoolean();
        } else if (string.equals("valuechangemode")) {
            this.valueChangeMode = (int)jDFileLoader.parseDouble();
        } else if (string.equals("gradX1")) {
            this.gradientX1 = (int)jDFileLoader.parseDouble();
        } else if (string.equals("gradY1")) {
            this.gradientY1 = (int)jDFileLoader.parseDouble();
        } else if (string.equals("gradX2")) {
            this.gradientX2 = (int)jDFileLoader.parseDouble();
        } else if (string.equals("gradY2")) {
            this.gradientY2 = (int)jDFileLoader.parseDouble();
        } else if (string.equals("gradCyclic")) {
            this.gradientCyclic = jDFileLoader.parseBoolean();
        } else if (string.equals("gradC1")) {
            this.gradientC1 = jDFileLoader.parseColor();
        } else if (string.equals("gradC2")) {
            this.gradientC2 = jDFileLoader.parseColor();
        } else if (string.equals("backgroundmapper")) {
            this.backgroundMapper = new JDValueProgram(jDFileLoader);
        } else if (string.equals("foregroundmapper")) {
            this.foregroundMapper = new JDValueProgram(jDFileLoader);
        } else if (string.equals("visibilitymapper")) {
            this.visibilityMapper = new JDValueProgram(jDFileLoader);
        } else if (string.equals("htranslationmapper")) {
            this.hTranslationMapper = new JDValueProgram(jDFileLoader);
        } else if (string.equals("vtranslationmapper")) {
            this.vTranslationMapper = new JDValueProgram(jDFileLoader);
        } else if (string.equals("invertshadowmapper")) {
            this.invertShadowMapper = new JDValueProgram(jDFileLoader);
        } else if (string.equals("extensions")) {
            this.loadObjectExtension(jDFileLoader);
        } else {
            System.out.println("Unknown property found:" + string);
            jDFileLoader.jumpPropertyValue();
        }
    }

    private void loadObjectExtension(JDFileLoader jDFileLoader) throws IOException {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        jDFileLoader.startBlock();
        while (!jDFileLoader.isEndBlock()) {
            vector.add(jDFileLoader.parseProperyName());
            vector2.add(jDFileLoader.parseParamString());
        }
        jDFileLoader.endBlock();
        int n = vector.size();
        if (n > 0) {
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = (String)vector.get(n2);
                ++n2;
            }
            this.setExtensionList(stringArray);
            n2 = 0;
            while (n2 < n) {
                this.setExtendedParam(n2, (String)vector2.get(n2));
                ++n2;
            }
        }
    }

    void loadObject(JDFileLoader jDFileLoader) throws IOException {
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseSummitArray();
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
    }

    void loadObject(JLXObject jLXObject) {
        this.foreground = jLXObject.style.lineColor;
        this.background = jLXObject.style.fillColor;
        this.fillStyle = jLXObject.style.fillStyle;
        this.lineWidth = jLXObject.style.lineWidth;
        this.lineStyle = jLXObject.style.lineStyle;
        this.isShadowed = jLXObject.shadowWidth != 0;
        this.invertShadow = jLXObject.shadowWidth < 0;
        this.name = jLXObject.name;
        int n = this.shadowThickness = jLXObject.shadowWidth < 0 ? -jLXObject.shadowWidth : jLXObject.shadowWidth;
        if (this.shadowThickness == 0) {
            this.shadowThickness = 1;
        }
        this.visible = jLXObject.visible;
        this.gradientX1 = jLXObject.style.gradientX1;
        this.gradientY1 = jLXObject.style.gradientY1;
        this.gradientX2 = jLXObject.style.gradientX2;
        this.gradientY2 = jLXObject.style.gradientY2;
        this.gradientC1 = jLXObject.style.gradientC1;
        this.gradientC2 = jLXObject.style.gradientC2;
        this.gradientCyclic = jLXObject.style.gradientCyclic;
    }

    String roundDouble(double d) {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        if (d < 0.0) {
            d = -d;
            bl2 = true;
        }
        int n = (int)(d * 10000.0 + 0.5);
        int n2 = n / 10000;
        int n3 = n % 10000;
        if (n3 == 0) {
            string = Integer.toString(n2);
        } else if (n3 > 0 && n3 < 10) {
            string = Integer.toString(n2) + ".000" + Integer.toString(n3);
        } else if (n3 >= 10 && n3 < 100) {
            bl = true;
            string = Integer.toString(n2) + ".00" + Integer.toString(n3);
        } else if (n3 >= 100 && n3 < 1000) {
            bl = true;
            string = Integer.toString(n2) + ".0" + Integer.toString(n3);
        } else {
            bl = true;
            string = Integer.toString(n2) + "." + Integer.toString(n3);
        }
        if (bl) {
            n = string.length() - 1;
            while (bl && n >= 0) {
                boolean bl3 = bl = string.charAt(n) == '0';
                if (!bl) continue;
                --n;
            }
            string = string.substring(0, n + 1);
        }
        if (bl2) {
            string = "-" + string;
        }
        return string;
    }

    private void saveMapper(FileWriter fileWriter, String string, JDValueProgram jDValueProgram, String string2) throws IOException {
        String string3 = string2 + string + ":{\n";
        fileWriter.write(string3);
        jDValueProgram.saveObject(fileWriter, string2 + "  ");
        string3 = string2 + "}\n";
        fileWriter.write(string3);
    }

    private void saveExtensions(FileWriter fileWriter, String string) throws IOException {
        int n = this.getExtendedParamNumber();
        if (n > 0) {
            String string2 = string + "extensions:{\n";
            fileWriter.write(string2);
            int n2 = 0;
            while (n2 < n) {
                string2 = this.extParamName[n2].indexOf(32) > 0 ? string + "  \"" + this.extParamName[n2] + "\":" : string + "  " + this.extParamName[n2] + ":";
                String string3 = "";
                String[] stringArray = JDUtils.makeStringArray(this.extParamValue[n2]);
                int n3 = 0;
                while (n3 < string2.length()) {
                    string3 = string3 + " ";
                    ++n3;
                }
                n3 = 0;
                while (n3 < stringArray.length) {
                    if (n3 > 0) {
                        string2 = string3;
                    }
                    string2 = string2 + "\"";
                    string2 = string2 + stringArray[n3];
                    string2 = string2 + "\"";
                    if (n3 < stringArray.length - 1) {
                        string2 = string2 + ",";
                    }
                    string2 = string2 + "\n";
                    fileWriter.write(string2);
                    ++n3;
                }
                ++n2;
            }
            string2 = string + "}\n";
            fileWriter.write(string2);
        }
    }

    void saveSummit(FileWriter fileWriter, String string) throws IOException {
        String string2 = string + "summit:";
        int n = 0;
        while (n < this.summit.length) {
            string2 = n != this.summit.length - 1 ? string2 + this.roundDouble(this.summit[n].x) + "," + this.roundDouble(this.summit[n].y) + "," : string2 + this.roundDouble(this.summit[n].x) + "," + this.roundDouble(this.summit[n].y) + "\n";
            ++n;
        }
        fileWriter.write(string2, 0, string2.length());
    }

    String saveObjectHeader(FileWriter fileWriter, int n) throws IOException {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + "  ";
            ++n2;
        }
        String string2 = string + this.toString() + " {\n";
        fileWriter.write(string2, 0, string2.length());
        string = string + "  ";
        this.saveSummit(fileWriter, string);
        string2 = string + "origin:" + this.roundDouble(this.origin.x) + "," + this.roundDouble(this.origin.y) + "\n";
        fileWriter.write(string2, 0, string2.length());
        if (this.foreground.getRGB() != foregroundDefault.getRGB()) {
            string2 = string + "foreground:" + this.foreground.getRed() + "," + this.foreground.getGreen() + "," + this.foreground.getBlue() + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.background.getRGB() != backgroundDefault.getRGB()) {
            string2 = string + "background:" + this.background.getRed() + "," + this.background.getGreen() + "," + this.background.getBlue() + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.fillStyle != 0) {
            string2 = string + "fillStyle:" + this.fillStyle + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.lineWidth != 1) {
            string2 = string + "lineWidth:" + this.lineWidth + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.antiAlias) {
            string2 = string + "antiAlias:" + this.antiAlias + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.lineStyle != 0) {
            string2 = string + "lineStyle:" + this.lineStyle + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.isShadowed) {
            string2 = string + "isShadowed:" + this.isShadowed + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.invertShadow) {
            string2 = string + "invertShadow:" + this.invertShadow + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.shadowThickness != 5) {
            string2 = string + "shadowThickness:" + this.shadowThickness + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (!this.visible) {
            string2 = string + "visible:" + this.visible + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.minValue != 0) {
            string2 = string + "minvalue:" + this.minValue + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.maxValue != 1) {
            string2 = string + "maxvalue:" + this.maxValue + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.initValue != 0) {
            string2 = string + "initvalue:" + this.initValue + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.userValue) {
            string2 = string + "uservalue:" + this.userValue + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.valueChangeMode != 0) {
            string2 = string + "valuechangemode:" + this.valueChangeMode + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (!this.name.equals(nameDefault)) {
            string2 = string + "name:\"" + this.name + "\"\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.gradientX1 != 0.0f) {
            string2 = string + "gradX1:" + this.gradientX1 + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.gradientX2 != 70.7f) {
            string2 = string + "gradX2:" + this.gradientX2 + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.gradientY1 != 0.0f) {
            string2 = string + "gradY1:" + this.gradientY1 + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.gradientY2 != 70.7f) {
            string2 = string + "gradY2:" + this.gradientY2 + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.gradientCyclic) {
            string2 = string + "gradCyclic:" + this.gradientCyclic + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.gradientC1.getRGB() != gradientC1default.getRGB()) {
            string2 = string + "gradC1:" + this.gradientC1.getRed() + "," + this.gradientC1.getGreen() + "," + this.gradientC1.getBlue() + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.gradientC2.getRGB() != gradientC2default.getRGB()) {
            string2 = string + "gradC2:" + this.gradientC2.getRed() + "," + this.gradientC2.getGreen() + "," + this.gradientC2.getBlue() + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        this.saveExtensions(fileWriter, string);
        if (this.hasBackgroundMapper()) {
            this.saveMapper(fileWriter, "backgroundmapper", this.backgroundMapper, string);
        }
        if (this.hasForegroundMapper()) {
            this.saveMapper(fileWriter, "foregroundmapper", this.foregroundMapper, string);
        }
        if (this.hasVisibilityMapper()) {
            this.saveMapper(fileWriter, "visibilitymapper", this.visibilityMapper, string);
        }
        if (this.hasInvertShadowMapper()) {
            this.saveMapper(fileWriter, "invertshadowmapper", this.invertShadowMapper, string);
        }
        if (this.hasHTranslationMapper()) {
            this.saveMapper(fileWriter, "htranslationmapper", this.hTranslationMapper, string);
        }
        if (this.hasVTranslationMapper()) {
            this.saveMapper(fileWriter, "vtranslationmapper", this.vTranslationMapper, string);
        }
        return string;
    }

    void closeObjectHeader(FileWriter fileWriter, int n) throws IOException {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + "  ";
            ++n2;
        }
        String string2 = string + "}\n";
        fileWriter.write(string2, 0, string2.length());
    }

    abstract UndoPattern getUndoPattern();

    void fillUndoPattern(UndoPattern undoPattern) {
        undoPattern.xOrigin = this.origin.x;
        undoPattern.yOrigin = this.origin.y;
        undoPattern.summit = new double[this.summit.length * 2];
        int n = 0;
        while (n < this.summit.length) {
            undoPattern.summit[2 * n + 0] = this.summit[n].x;
            undoPattern.summit[2 * n + 1] = this.summit[n].y;
            ++n;
        }
        undoPattern.rgbForeground = this.foreground.getRGB();
        undoPattern.rgbBackground = this.background.getRGB();
        undoPattern.fillStyle = this.fillStyle;
        undoPattern.lineWidth = this.lineWidth;
        undoPattern.lineStyle = this.lineStyle;
        undoPattern.antiAlias = this.antiAlias;
        undoPattern.isShadowed = this.isShadowed;
        undoPattern.invertShadow = this.invertShadow;
        undoPattern.name = new String(this.name);
        undoPattern.shadowThickness = this.shadowThickness;
        undoPattern.visible = this.visible;
        undoPattern.minValue = this.minValue;
        undoPattern.maxValue = this.maxValue;
        undoPattern.initValue = this.initValue;
        undoPattern.userValue = this.userValue;
        undoPattern.valueChangeMode = this.valueChangeMode;
        if (this.hasBackgroundMapper()) {
            undoPattern.backgroundMapper = this.backgroundMapper.copy();
        }
        if (this.hasForegroundMapper()) {
            undoPattern.foregroundMapper = this.foregroundMapper.copy();
        }
        if (this.hasVisibilityMapper()) {
            undoPattern.visibilityMapper = this.visibilityMapper.copy();
        }
        if (this.hasInvertShadowMapper()) {
            undoPattern.invertShadowMapper = this.invertShadowMapper.copy();
        }
        if (this.hasHTranslationMapper()) {
            undoPattern.hTranslationMapper = this.hTranslationMapper.copy();
        }
        if (this.hasVTranslationMapper()) {
            undoPattern.vTranslationMapper = this.vTranslationMapper.copy();
        }
        undoPattern.gradientX1 = this.gradientX1;
        undoPattern.gradientX2 = this.gradientX2;
        undoPattern.gradientY1 = this.gradientY1;
        undoPattern.gradientY2 = this.gradientY2;
        undoPattern.gradientC1 = this.gradientC1;
        undoPattern.gradientC2 = this.gradientC2;
        undoPattern.gradientCyclic = this.gradientCyclic;
        undoPattern.extsN = this.extParamName;
        if (undoPattern.extsN != null) {
            undoPattern.extsV = new String[undoPattern.extsN.length];
            int n2 = 0;
            while (n2 < undoPattern.extsN.length) {
                undoPattern.extsV[n2] = new String(this.extParamValue[n2]);
                ++n2;
            }
        }
    }

    void applyUndoPattern(UndoPattern undoPattern) {
        int n = undoPattern.summit.length / 2;
        this.origin = new Point2D.Double(undoPattern.xOrigin, undoPattern.yOrigin);
        this.summit = new Point2D.Double[n];
        int n2 = 0;
        while (n2 < n) {
            this.summit[n2] = new Point2D.Double(undoPattern.summit[2 * n2], undoPattern.summit[2 * n2 + 1]);
            ++n2;
        }
        this.foreground = new Color(undoPattern.rgbForeground);
        this.background = new Color(undoPattern.rgbBackground);
        this.fillStyle = undoPattern.fillStyle;
        this.lineWidth = undoPattern.lineWidth;
        this.lineStyle = undoPattern.lineStyle;
        this.antiAlias = undoPattern.antiAlias;
        this.isShadowed = undoPattern.isShadowed;
        this.invertShadow = undoPattern.invertShadow;
        this.name = undoPattern.name;
        this.shadowThickness = undoPattern.shadowThickness;
        this.visible = undoPattern.visible;
        this.minValue = undoPattern.minValue;
        this.maxValue = undoPattern.maxValue;
        this.initValue = undoPattern.initValue;
        this.userValue = undoPattern.userValue;
        this.valueChangeMode = undoPattern.valueChangeMode;
        if (undoPattern.backgroundMapper != null) {
            this.backgroundMapper = undoPattern.backgroundMapper.copy();
        }
        if (undoPattern.foregroundMapper != null) {
            this.foregroundMapper = undoPattern.foregroundMapper.copy();
        }
        if (undoPattern.visibilityMapper != null) {
            this.visibilityMapper = undoPattern.visibilityMapper.copy();
        }
        if (undoPattern.invertShadowMapper != null) {
            this.invertShadowMapper = undoPattern.invertShadowMapper.copy();
        }
        if (undoPattern.hTranslationMapper != null) {
            this.hTranslationMapper = undoPattern.hTranslationMapper.copy();
        }
        if (undoPattern.vTranslationMapper != null) {
            this.vTranslationMapper = undoPattern.vTranslationMapper.copy();
        }
        this.gradientX1 = undoPattern.gradientX1;
        this.gradientX2 = undoPattern.gradientX2;
        this.gradientY1 = undoPattern.gradientY1;
        this.gradientY2 = undoPattern.gradientY2;
        this.gradientC1 = undoPattern.gradientC1;
        this.gradientC2 = undoPattern.gradientC2;
        this.gradientCyclic = undoPattern.gradientCyclic;
        this.extParamName = undoPattern.extsN;
        if (undoPattern.extsN != null) {
            this.extParamValue = new String[undoPattern.extsN.length];
            int n3 = 0;
            while (n3 < undoPattern.extsN.length) {
                this.extParamValue[n3] = new String(undoPattern.extsV[n3]);
                ++n3;
            }
        }
    }

    public void restoreTransform() {
        this.origin.x = this.sXOrg;
        this.origin.y = this.sYOrg;
        int n = 0;
        while (n < this.sSummit.length / 2) {
            this.summit[n].x = this.sSummit[2 * n];
            this.summit[n].y = this.sSummit[2 * n + 1];
            ++n;
        }
        this.gradientX1 = this.sGradientX1;
        this.gradientX2 = this.sGradientX2;
        this.gradientY1 = this.sGradientY1;
        this.gradientY2 = this.sGradientY2;
        this.updateShape();
    }

    public void saveTransform() {
        this.sSummit = new double[this.summit.length * 2];
        int n = 0;
        while (n < this.summit.length) {
            this.sSummit[2 * n] = this.summit[n].x;
            this.sSummit[2 * n + 1] = this.summit[n].y;
            ++n;
        }
        this.sXOrg = this.origin.x;
        this.sYOrg = this.origin.y;
        this.sGradientX1 = this.gradientX1;
        this.sGradientX2 = this.gradientX2;
        this.sGradientY1 = this.gradientY1;
        this.sGradientY2 = this.gradientY2;
    }

    abstract void updateShape();

    Rectangle getShadowBoundRect() {
        return this.sBoundRect;
    }

    void getMinMax(int[] nArray, int[] nArray2) {
        int n = 65536;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] <= n) {
                n = nArray[n3];
            }
            if (nArray[n3] >= n2) {
                n2 = nArray[n3];
            }
            ++n3;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 > 65536) {
            n2 = 65536;
        }
        nArray2[0] = n;
        nArray2[1] = n2;
    }

    void computeNextShadowSegment(int n, Polygon polygon, double[] dArray) {
        double d;
        double d2;
        int n2;
        int n3 = n + 2;
        int n4 = this.ptsx.length;
        if (n3 >= n4) {
            n3 -= n4;
        }
        if ((n2 = n + 1) >= n4) {
            n2 -= n4;
        }
        if (this.normes[n] < 1.0 || this.normes[n2] < 1.0) {
            d2 = 0.0;
            d = 0.0;
        } else {
            double d3 = (double)(this.ptsx[n3] - this.ptsx[n2]) / this.normes[n2];
            double d4 = (double)(this.ptsx[n] - this.ptsx[n2]) / this.normes[n];
            d2 = d3 + d4;
            double d5 = (double)(this.ptsy[n3] - this.ptsy[n2]) / this.normes[n2];
            double d6 = (double)(this.ptsy[n] - this.ptsy[n2]) / this.normes[n];
            d = d5 + d6;
            double d7 = Math.sqrt(d2 * d2 + d * d);
            if (d7 <= 1.0E-5) {
                d2 = -(this.ptsy[n2] - this.ptsy[n]);
                d = this.ptsx[n2] - this.ptsx[n];
                d7 = Math.sqrt(d2 * d2 + d * d);
                if (d7 < 1.0) {
                    d2 = 0.0;
                    d = 0.0;
                } else {
                    d2 /= d7;
                    d /= d7;
                }
            } else {
                double d8 = (d2 /= d7) * d3 + (d /= d7) * d5;
                d8 = Math.sqrt(1.0 - d8 * d8);
                d2 /= d8;
                d /= d8;
            }
            if (!polygon.contains(this.ptsx[n2] + (int)(d2 * 4.0), this.ptsy[n2] + (int)(d * 4.0))) {
                d2 = -d2;
                d = -d;
            }
        }
        dArray[0] = d2;
        dArray[1] = d;
    }

    Color computeShadowColor(int n, int n2, Polygon polygon, double[] dArray) {
        double d;
        double d2;
        double d3;
        double d4 = -(this.ptsy[n2] - this.ptsy[n]);
        double d5 = this.ptsx[n2] - this.ptsx[n];
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        if (d6 < 1.0) {
            d4 = 0.0;
            d5 = 0.0;
        } else {
            d4 /= d6;
            d5 /= d6;
        }
        int n3 = (int)(d4 * 4.0);
        int n4 = (int)(d5 * 4.0);
        if (!polygon.contains((this.ptsx[n2] + this.ptsx[n]) / 2 + n3, (this.ptsy[n2] + this.ptsy[n]) / 2 + n4)) {
            d4 = -d4;
            d5 = -d5;
        }
        if ((d3 = (d2 = !this.invertShadow ? this.lightx * d4 + this.lighty * d5 : this.lightx * -d4 + this.lighty * -d5) * 128.0) > 0.0 && d3 < 80.0) {
            d3 = 80.0;
        }
        if (d3 <= 0.0 && d3 > -20.0) {
            d3 = -20.0;
        }
        if ((d = dArray[0] + d3) < 0.0) {
            d = 0.0;
        }
        if (d > 255.0) {
            d = 255.0;
        }
        return this.createColorFromYUV(d, dArray[1], dArray[2]);
    }

    void RGBtoYUV(Color color, double[] dArray) {
        double d = color.getRed();
        double d2 = color.getGreen();
        double d3 = color.getBlue();
        dArray[0] = 0.299 * d + 0.587 * d2 + 0.114 * d3;
        dArray[1] = -0.169 * d - 0.331 * d2 + 0.5 * d3 + 128.0;
        dArray[2] = 0.5 * d - 0.419 * d2 - 0.081 * d3 + 128.0;
    }

    Color createColorFromYUV(double d, double d2, double d3) {
        int n = (int)(d + 1.4075 * (d3 - 128.0));
        int n2 = (int)(d - 0.7169 * (d3 - 128.0) - 0.3455 * (d2 - 128.0));
        int n3 = (int)(d + 1.779 * (d2 - 128.0));
        if (n > 255) {
            n = 255;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return new Color(n, n2, n3);
    }

    void computeShadow(boolean bl) {
        double d;
        double d2;
        int n = 65536;
        int n2 = 65536;
        int n3 = 0;
        int n4 = 0;
        int n5 = bl ? this.ptsx.length : this.ptsx.length - 1;
        Polygon polygon = new Polygon(this.ptsx, this.ptsy, this.ptsx.length);
        double[] dArray = new double[2];
        this.normes = new double[this.ptsx.length];
        Polygon[] polygonArray = new Polygon[n5];
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        double d3 = this.shadowThickness;
        int[] nArray3 = new int[2];
        int n6 = 0;
        while (n6 < this.ptsx.length - 1) {
            d2 = (this.ptsx[n6 + 1] - this.ptsx[n6]) * (this.ptsx[n6 + 1] - this.ptsx[n6]);
            d = (this.ptsy[n6 + 1] - this.ptsy[n6]) * (this.ptsy[n6 + 1] - this.ptsy[n6]);
            this.normes[n6] = Math.sqrt(d2 + d);
            ++n6;
        }
        d2 = (this.ptsx[0] - this.ptsx[n6]) * (this.ptsx[0] - this.ptsx[n6]);
        d = (this.ptsy[0] - this.ptsy[n6]) * (this.ptsy[0] - this.ptsy[n6]);
        this.normes[n6] = Math.sqrt(d2 + d);
        this.computeNextShadowSegment(this.ptsx.length - 1, polygon, dArray);
        n6 = 0;
        while (n6 < n5) {
            nArray[0] = this.ptsx[n6];
            nArray2[0] = this.ptsy[n6];
            nArray[1] = this.ptsx[n6] + (int)Math.round(d3 * dArray[0]);
            nArray2[1] = this.ptsy[n6] + (int)Math.round(d3 * dArray[1]);
            this.computeNextShadowSegment(n6, polygon, dArray);
            int n7 = n6 + 1;
            if (n7 >= this.ptsx.length) {
                n7 = 0;
            }
            nArray[2] = this.ptsx[n7] + (int)Math.round(d3 * dArray[0]);
            nArray2[2] = this.ptsy[n7] + (int)Math.round(d3 * dArray[1]);
            nArray[3] = this.ptsx[n7];
            nArray2[3] = this.ptsy[n7];
            this.getMinMax(nArray, nArray3);
            if (nArray3[0] <= n) {
                n = nArray3[0];
            }
            if (nArray3[1] >= n3) {
                n3 = nArray3[1];
            }
            this.getMinMax(nArray2, nArray3);
            if (nArray3[0] <= n2) {
                n2 = nArray3[0];
            }
            if (nArray3[1] >= n4) {
                n4 = nArray3[1];
            }
            polygonArray[n6] = new Polygon(nArray, nArray2, 4);
            ++n6;
        }
        this.shadows = polygonArray;
        this.sBoundRect.setBounds(n, n2, n3 - n + 1, n4 - n2 + 1);
        this.sBoundRect = this.sBoundRect.union(this.boundRect);
    }

    void computeShadowColors() {
        int n = this.ptsx.length;
        double[] dArray = new double[3];
        if (this.foreground != null) {
            this.RGBtoYUV(this.foreground, dArray);
        } else {
            dArray[0] = 0.0;
            dArray[1] = 128.0;
            dArray[2] = 128.0;
        }
        Polygon polygon = new Polygon(this.ptsx, this.ptsy, n);
        this.shadowColors = new Color[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            if (n3 >= n) {
                n3 = 0;
            }
            this.shadowColors[n2] = this.computeShadowColor(n2, n3, polygon, dArray);
            ++n2;
        }
    }

    String getNodeName() {
        String string;
        String string2 = this.getClass().toString();
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        String string3 = string = this.name.length() >= 0 ? this.name : string2;
        if (this.isInteractive()) {
            string = string + "*";
        }
        return string;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setForeground(Color color) {
        this.foreground = color;
        if (this.hasShadow()) {
            this.computeShadowColors();
        }
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setOrigin(Point2D.Double double_) {
        this.origin = double_;
    }

    public void centerOrigin() {
        this.origin.x = this.boundRect.x + this.boundRect.width / 2;
        this.origin.y = this.boundRect.y + this.boundRect.height / 2;
    }

    public Point2D.Double getOrigin() {
        return this.origin;
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public void setFillStyle(int n) {
        this.fillStyle = n;
    }

    public int getFillStyle() {
        return this.fillStyle;
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
    }

    public boolean isAntiAliased() {
        return this.antiAlias;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public boolean hasShadow() {
        return this.isShadowed;
    }

    public void setShadow(boolean bl) {
        this.isShadowed = bl;
        this.updateShape();
    }

    public void setShadowWidth(int n) {
        this.shadowThickness = n;
        this.updateShape();
    }

    public int getShadowWidth() {
        return this.shadowThickness;
    }

    public boolean hasInverseShadow() {
        return this.invertShadow;
    }

    public void setInverseShadow(boolean bl) {
        this.invertShadow = bl;
        if (this.hasShadow()) {
            this.computeShadowColors();
        }
    }

    public void setMinValue(int n) {
        this.minValue = n;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(int n) {
        this.maxValue = n;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setInitValue(int n) {
        this.initValue = n;
    }

    public int getInitValue() {
        return this.initValue;
    }

    public boolean isInteractive() {
        return this.userValue;
    }

    public void setInteractive(boolean bl) {
        this.userValue = bl;
    }

    public int getValueChangeMode() {
        return this.valueChangeMode;
    }

    public void setValueChangeMode(int n) {
        this.valueChangeMode = n;
    }

    public boolean hasBackgroundMapper() {
        return this.backgroundMapper != null;
    }

    public void setBackgroundMapper(JDValueProgram jDValueProgram) {
        this.backgroundMapper = jDValueProgram;
    }

    public JDValueProgram getBackgroundMapper() {
        return this.backgroundMapper;
    }

    public boolean hasForegroundMapper() {
        return this.foregroundMapper != null;
    }

    public void setForegroundMapper(JDValueProgram jDValueProgram) {
        this.foregroundMapper = jDValueProgram;
    }

    public JDValueProgram getForegroundMapper() {
        return this.foregroundMapper;
    }

    public boolean hasVisibilityMapper() {
        return this.visibilityMapper != null;
    }

    public void setVisibilityMapper(JDValueProgram jDValueProgram) {
        this.visibilityMapper = jDValueProgram;
    }

    public JDValueProgram getVisibilityMapper() {
        return this.visibilityMapper;
    }

    public boolean hasInvertShadowMapper() {
        return this.invertShadowMapper != null;
    }

    public void setInvertShadowMapper(JDValueProgram jDValueProgram) {
        this.invertShadowMapper = jDValueProgram;
    }

    public JDValueProgram getInvertShadowMapper() {
        return this.invertShadowMapper;
    }

    public boolean hasHTranslationMapper() {
        return this.hTranslationMapper != null;
    }

    public void setHTranslationMapper(JDValueProgram jDValueProgram) {
        this.hTranslationMapper = jDValueProgram;
    }

    public JDValueProgram getHTranslationMapper() {
        return this.hTranslationMapper;
    }

    public boolean hasVTranslationMapper() {
        return this.vTranslationMapper != null;
    }

    public void setVTranslationMapper(JDValueProgram jDValueProgram) {
        this.vTranslationMapper = jDValueProgram;
    }

    public JDValueProgram getVTranslationMapper() {
        return this.vTranslationMapper;
    }

    void prepareRendering(Graphics2D graphics2D) {
        if (this.antiAlias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public void setGradientFillParam(float f, float f2, Color color, float f3, float f4, Color color2, boolean bl) {
        this.gradientX1 = f;
        this.gradientX2 = f3;
        this.gradientY1 = f2;
        this.gradientY2 = f4;
        this.gradientC1 = color;
        this.gradientC2 = color2;
        this.gradientCyclic = bl;
    }

    void setParent(JDrawEditor jDrawEditor) {
        this.parent = jDrawEditor;
    }

    JDrawEditor getParent() {
        return this.parent;
    }

    public boolean isProgrammed() {
        return this.hasValueProgram();
    }

    public void refresh() {
        if (this.parent != null) {
            if (this.preRefreshRect != null) {
                this.parent.repaint(this.preRefreshRect.union(this.getRepaintRect()));
            } else {
                this.parent.repaint(this.getRepaintRect());
            }
        }
        this.preRefreshRect = null;
    }

    public void preRefresh() {
        this.preRefreshRect = this.getRepaintRect();
    }

    public void setExtensionList(String[] stringArray) {
        this.extParamName = stringArray;
        this.extParamValue = new String[stringArray.length];
        int n = 0;
        while (n < this.extParamValue.length) {
            this.extParamValue[n] = "";
            ++n;
        }
    }

    public void addExtension(String string) {
        int n = this.getExtendedParamIndex(string);
        if (n != -1) {
            return;
        }
        int n2 = this.getExtendedParamNumber();
        String[] stringArray = new String[n2 + 1];
        String[] stringArray2 = new String[n2 + 1];
        n = 0;
        while (n < n2) {
            stringArray[n] = this.extParamName[n];
            stringArray2[n] = this.extParamValue[n];
            ++n;
        }
        stringArray[n] = string;
        stringArray2[n] = "";
        this.extParamName = stringArray;
        this.extParamValue = stringArray2;
    }

    public void setExtendedParam(String string, String string2) {
        int n = this.getExtendedParamIndex(string);
        if (n != -1) {
            this.extParamValue[n] = string2;
        } else {
            System.out.println("JDObject.setExtendedParam() : " + string + " does not exist for " + this.getName() + ".");
        }
    }

    public void removeExtension(int n) {
        int n2 = this.getExtendedParamNumber();
        if (n >= n2 || n < 0) {
            System.out.println("JDObject.removeExtension() : " + n + " index out of bounds.");
            return;
        }
        String[] stringArray = new String[n2 - 1];
        String[] stringArray2 = new String[n2 - 1];
        int n3 = 0;
        while (n3 < n) {
            stringArray[n3] = this.extParamName[n3];
            stringArray2[n3] = this.extParamValue[n3];
            ++n3;
        }
        n3 = n + 1;
        while (n3 < n2) {
            stringArray[n3 - 1] = this.extParamName[n3];
            stringArray2[n3 - 1] = this.extParamValue[n3];
            ++n3;
        }
        this.extParamName = stringArray;
        this.extParamValue = stringArray2;
    }

    public void setExtendedParam(int n, String string) {
        int n2 = this.getExtendedParamNumber();
        if (n < 0 || n >= n2) {
            System.out.println("JDObject.setExtendedParam() : index of of bounds.");
            return;
        }
        this.extParamValue[n] = string;
    }

    public String getExtendedParam(String string) {
        int n = this.getExtendedParamIndex(string);
        if (n != -1) {
            return this.extParamValue[n];
        }
        System.out.println("JDObject.getExtendedParam() : " + string + " does not exist.");
        return "";
    }

    public String getExtendedParam(int n) {
        int n2 = this.getExtendedParamNumber();
        if (n < 0 || n >= n2) {
            System.out.println("JDObject.getExtendedParam() : index of of bounds.");
            return "";
        }
        return this.extParamValue[n];
    }

    public String getExtendedParamName(int n) {
        int n2 = this.getExtendedParamNumber();
        if (n < 0 || n >= n2) {
            System.out.println("JDObject.getExtendedParamName() : index of of bounds.");
            return "";
        }
        return this.extParamName[n];
    }

    public String getExtendedParamDesc(String string) {
        return "";
    }

    public int getExtendedParamNumber() {
        if (this.extParamValue == null) {
            return 0;
        }
        return this.extParamValue.length;
    }

    public int getExtendedParamIndex(String string) {
        if (this.extParamName == null) {
            return -1;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.extParamName.length && !bl) {
            bl = string.equalsIgnoreCase(this.extParamName[n]);
            if (bl) continue;
            ++n;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    public boolean hasExtendedParam(String string) {
        return this.getExtendedParamIndex(string) >= 0;
    }

    public boolean isFixedExtendedParam(String string) {
        return false;
    }
}

