/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.chart.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JLDataViewOption
extends JDialog
implements ActionListener,
MouseListener,
ChangeListener,
KeyListener {
    private JLDataView dataView;
    private JLChart chart;
    private JLabel nameLabel;
    private JTabbedPane tabPane;
    private JButton closeBtn;
    private JPanel linePanel;
    private JLabel viewTypeLabel;
    private JComboBox viewTypeCombo;
    private JLabel lineColorView;
    private JButton lineColorBtn;
    private JLabel lineColorLabel;
    private JLabel fillColorView;
    private JButton fillColorBtn;
    private JLabel fillColorLabel;
    private JLabel fillStyleLabel;
    private JComboBox fillStyleCombo;
    private JLabel lineWidthLabel;
    private JSpinner lineWidthSpinner;
    private JLabel lineDashLabel;
    private JComboBox lineDashCombo;
    private JPanel barPanel;
    private JLabel barWidthLabel;
    private JSpinner barWidthSpinner;
    private JLabel fillMethodLabel;
    private JComboBox fillMethodCombo;
    private JPanel markerPanel;
    private JLabel markerColorView;
    private JButton markerColorBtn;
    private JLabel markerColorLabel;
    private JLabel markerSizeLabel;
    private JSpinner markerSizeSpinner;
    private JLabel markerStyleLabel;
    private JComboBox markerStyleCombo;
    private JCheckBox labelVisibleCheck;
    private JPanel transformPanel;
    private JTextArea transformHelpLabel;
    private JLabel transformA0Label;
    private JTextField transformA0Text;
    private JLabel transformA1Label;
    private JTextField transformA1Text;
    private JLabel transformA2Label;
    private JTextField transformA2Text;

    public JLDataViewOption(JDialog jDialog, JLChart jLChart, JLDataView jLDataView) {
        super((Dialog)jDialog, true);
        this.dataView = jLDataView;
        this.chart = jLChart;
        this.initComponents();
    }

    public JLDataViewOption(JFrame jFrame, JLChart jLChart, JLDataView jLDataView) {
        super((Frame)jFrame, true);
        this.dataView = jLDataView;
        this.chart = jLChart;
        this.initComponents();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JLDataViewOption.this.hide();
                JLDataViewOption.this.dispose();
            }
        });
        this.setTitle("Data view options");
        this.tabPane = new JTabbedPane();
        this.linePanel = new JPanel();
        this.linePanel.setLayout(null);
        this.viewTypeLabel = new JLabel("View type");
        this.viewTypeLabel.setFont(GraphicsUtils.labelFont);
        this.viewTypeLabel.setForeground(GraphicsUtils.fColor);
        this.viewTypeCombo = new JComboBox();
        this.viewTypeCombo.setFont(GraphicsUtils.labelFont);
        this.viewTypeCombo.addItem("Line");
        this.viewTypeCombo.addItem("Bar graph");
        this.viewTypeCombo.setSelectedIndex(this.dataView.getViewType());
        this.viewTypeCombo.addActionListener(this);
        this.lineColorView = new JLabel("");
        this.lineColorView.setBackground(this.dataView.getColor());
        this.lineColorView.setOpaque(true);
        this.lineColorView.setBorder(BorderFactory.createLineBorder(Color.black));
        this.lineColorBtn = new JButton("...");
        this.lineColorBtn.addMouseListener(this);
        this.lineColorLabel = new JLabel("Line Color");
        this.lineColorLabel.setFont(GraphicsUtils.labelFont);
        this.lineColorLabel.setForeground(GraphicsUtils.fColor);
        this.fillColorView = new JLabel("");
        this.fillColorView.setBackground(this.dataView.getFillColor());
        this.fillColorView.setOpaque(true);
        this.fillColorView.setBorder(BorderFactory.createLineBorder(Color.black));
        this.fillColorBtn = new JButton("...");
        this.fillColorBtn.addMouseListener(this);
        this.fillColorLabel = new JLabel("Fill Color");
        this.fillColorLabel.setFont(GraphicsUtils.labelFont);
        this.fillColorLabel.setForeground(GraphicsUtils.fColor);
        this.lineWidthLabel = new JLabel("Line Width");
        this.lineWidthLabel.setFont(GraphicsUtils.labelFont);
        this.lineWidthLabel.setForeground(GraphicsUtils.fColor);
        this.lineWidthSpinner = new JSpinner();
        Integer n = new Integer(this.dataView.getLineWidth());
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(10);
        Integer n4 = new Integer(1);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
        this.lineWidthSpinner.setModel(spinnerNumberModel);
        this.lineWidthSpinner.addChangeListener(this);
        this.lineDashLabel = new JLabel("Line style");
        this.lineDashLabel.setFont(GraphicsUtils.labelFont);
        this.lineDashLabel.setForeground(GraphicsUtils.fColor);
        this.lineDashCombo = new JComboBox();
        this.lineDashCombo.setFont(GraphicsUtils.labelFont);
        this.lineDashCombo.addItem("Solid");
        this.lineDashCombo.addItem("Point dash");
        this.lineDashCombo.addItem("Short dash");
        this.lineDashCombo.addItem("Long dash");
        this.lineDashCombo.addItem("Dot dash");
        this.lineDashCombo.setSelectedIndex(this.dataView.getStyle());
        this.lineDashCombo.addActionListener(this);
        this.fillStyleLabel = new JLabel("Fill style");
        this.fillStyleLabel.setFont(GraphicsUtils.labelFont);
        this.fillStyleLabel.setForeground(GraphicsUtils.fColor);
        this.fillStyleCombo = new JComboBox();
        this.fillStyleCombo.setFont(GraphicsUtils.labelFont);
        this.fillStyleCombo.addItem("No fill");
        this.fillStyleCombo.addItem("Solid");
        this.fillStyleCombo.addItem("Large leff hatch");
        this.fillStyleCombo.addItem("Large right hatch");
        this.fillStyleCombo.addItem("Large cross hatch");
        this.fillStyleCombo.addItem("Small leff hatch");
        this.fillStyleCombo.addItem("Small right hatch");
        this.fillStyleCombo.addItem("Small cross hatch");
        this.fillStyleCombo.addItem("Dot pattern 1");
        this.fillStyleCombo.addItem("Dot pattern 2");
        this.fillStyleCombo.addItem("Dot pattern 3");
        this.fillStyleCombo.setSelectedIndex(this.dataView.getFillStyle());
        this.fillStyleCombo.addActionListener(this);
        this.linePanel.add(this.viewTypeLabel);
        this.linePanel.add(this.viewTypeCombo);
        this.linePanel.add(this.lineColorLabel);
        this.linePanel.add(this.lineColorView);
        this.linePanel.add(this.lineColorBtn);
        this.linePanel.add(this.fillColorLabel);
        this.linePanel.add(this.fillColorView);
        this.linePanel.add(this.fillColorBtn);
        this.linePanel.add(this.lineWidthLabel);
        this.linePanel.add(this.lineWidthSpinner);
        this.linePanel.add(this.lineDashLabel);
        this.linePanel.add(this.lineDashCombo);
        this.linePanel.add(this.fillStyleLabel);
        this.linePanel.add(this.fillStyleCombo);
        this.viewTypeLabel.setBounds(10, 10, 100, 25);
        this.viewTypeCombo.setBounds(115, 10, 125, 25);
        this.lineColorLabel.setBounds(10, 40, 100, 25);
        this.lineColorView.setBounds(115, 40, 80, 25);
        this.lineColorBtn.setBounds(200, 40, 40, 27);
        this.fillColorLabel.setBounds(10, 70, 100, 25);
        this.fillColorView.setBounds(115, 70, 80, 25);
        this.fillColorBtn.setBounds(200, 70, 40, 27);
        this.fillStyleLabel.setBounds(10, 100, 100, 25);
        this.fillStyleCombo.setBounds(115, 100, 125, 25);
        this.lineWidthLabel.setBounds(10, 130, 100, 25);
        this.lineWidthSpinner.setBounds(115, 130, 125, 25);
        this.lineDashLabel.setBounds(10, 160, 100, 25);
        this.lineDashCombo.setBounds(115, 160, 125, 25);
        this.barPanel = new JPanel();
        this.barPanel.setLayout(null);
        this.barWidthLabel = new JLabel("Bar Width");
        this.barWidthLabel.setFont(GraphicsUtils.labelFont);
        this.barWidthLabel.setForeground(GraphicsUtils.fColor);
        this.barWidthSpinner = new JSpinner();
        n = new Integer(this.dataView.getBarWidth());
        n2 = new Integer(0);
        n3 = new Integer(100);
        n4 = new Integer(1);
        spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
        this.barWidthSpinner.setModel(spinnerNumberModel);
        this.barWidthSpinner.addChangeListener(this);
        this.fillMethodLabel = new JLabel("Filling method");
        this.fillMethodLabel.setFont(GraphicsUtils.labelFont);
        this.fillMethodLabel.setForeground(GraphicsUtils.fColor);
        this.fillMethodCombo = new JComboBox();
        this.fillMethodCombo.setFont(GraphicsUtils.labelFont);
        this.fillMethodCombo.addItem("From Up");
        this.fillMethodCombo.addItem("From Zero");
        this.fillMethodCombo.addItem("From Bottom");
        this.fillMethodCombo.setSelectedIndex(this.dataView.getFillMethod());
        this.fillMethodCombo.addActionListener(this);
        this.barPanel.add(this.barWidthLabel);
        this.barPanel.add(this.barWidthSpinner);
        this.barPanel.add(this.fillMethodLabel);
        this.barPanel.add(this.fillMethodCombo);
        this.barWidthLabel.setBounds(10, 10, 100, 25);
        this.barWidthSpinner.setBounds(115, 10, 125, 25);
        this.fillMethodLabel.setBounds(10, 40, 100, 25);
        this.fillMethodCombo.setBounds(115, 40, 125, 25);
        this.markerPanel = new JPanel();
        this.markerPanel.setLayout(null);
        this.markerColorView = new JLabel("");
        this.markerColorView.setBackground(this.dataView.getMarkerColor());
        this.markerColorView.setOpaque(true);
        this.markerColorView.setBorder(BorderFactory.createLineBorder(Color.black));
        this.markerColorBtn = new JButton("...");
        this.markerColorBtn.addMouseListener(this);
        this.markerColorLabel = new JLabel("Color");
        this.markerColorLabel.setFont(GraphicsUtils.labelFont);
        this.markerColorLabel.setForeground(GraphicsUtils.fColor);
        this.markerSizeLabel = new JLabel("Size");
        this.markerSizeLabel.setFont(GraphicsUtils.labelFont);
        this.markerSizeLabel.setForeground(GraphicsUtils.fColor);
        this.markerSizeSpinner = new JSpinner();
        n = new Integer(this.dataView.getMarkerSize());
        spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
        this.markerSizeSpinner.setModel(spinnerNumberModel);
        this.markerSizeSpinner.addChangeListener(this);
        this.markerStyleLabel = new JLabel("Marker style");
        this.markerStyleLabel.setFont(GraphicsUtils.labelFont);
        this.markerStyleLabel.setForeground(GraphicsUtils.fColor);
        this.markerStyleCombo = new JComboBox();
        this.markerStyleCombo.addItem("None");
        this.markerStyleCombo.addItem("Dot");
        this.markerStyleCombo.addItem("Box");
        this.markerStyleCombo.addItem("triangle");
        this.markerStyleCombo.addItem("Diamond");
        this.markerStyleCombo.addItem("Star");
        this.markerStyleCombo.addItem("Vert. line");
        this.markerStyleCombo.addItem("Horz. line");
        this.markerStyleCombo.addItem("Cross");
        this.markerStyleCombo.addItem("Circle");
        this.markerStyleCombo.addItem("Sqaure");
        this.markerStyleCombo.setSelectedIndex(this.dataView.getMarker());
        this.markerStyleCombo.addActionListener(this);
        this.labelVisibleCheck = new JCheckBox();
        this.labelVisibleCheck.setFont(GraphicsUtils.labelFont);
        this.labelVisibleCheck.setForeground(GraphicsUtils.fColor);
        this.labelVisibleCheck.setText("Legend visible");
        this.labelVisibleCheck.setSelected(this.dataView.isLabelVisible());
        this.labelVisibleCheck.addActionListener(this);
        this.markerPanel.add(this.markerColorLabel);
        this.markerPanel.add(this.markerColorView);
        this.markerPanel.add(this.markerColorBtn);
        this.markerPanel.add(this.markerSizeLabel);
        this.markerPanel.add(this.markerSizeSpinner);
        this.markerPanel.add(this.markerStyleLabel);
        this.markerPanel.add(this.markerStyleCombo);
        this.markerPanel.add(this.labelVisibleCheck);
        this.markerColorLabel.setBounds(10, 10, 100, 25);
        this.markerColorView.setBounds(115, 10, 80, 25);
        this.markerColorBtn.setBounds(200, 10, 40, 27);
        this.markerSizeLabel.setBounds(10, 40, 100, 25);
        this.markerSizeSpinner.setBounds(115, 40, 125, 25);
        this.markerStyleLabel.setBounds(10, 70, 100, 25);
        this.markerStyleCombo.setBounds(115, 70, 125, 25);
        this.labelVisibleCheck.setBounds(10, 100, 225, 25);
        this.transformPanel = new JPanel();
        this.transformPanel.setLayout(null);
        this.transformHelpLabel = new JTextArea("This apply a polynomial transform\nto the data view:\n y' = A0 + A1*y + A2*y^2");
        this.transformHelpLabel.setFont(GraphicsUtils.labelFont);
        this.transformHelpLabel.setForeground(GraphicsUtils.fColor);
        this.transformHelpLabel.setFont(this.markerStyleLabel.getFont());
        this.transformHelpLabel.setEditable(false);
        this.transformHelpLabel.setBackground(this.markerStyleLabel.getBackground());
        this.transformA0Label = new JLabel("A0");
        this.transformA0Label.setFont(GraphicsUtils.labelFont);
        this.transformA0Label.setForeground(GraphicsUtils.fColor);
        this.transformA0Text = new JTextField();
        this.transformA0Text.setEditable(true);
        this.transformA0Text.setText(Double.toString(this.dataView.getA0()));
        this.transformA0Text.addKeyListener(this);
        this.transformA1Label = new JLabel("A1");
        this.transformA1Label.setFont(GraphicsUtils.labelFont);
        this.transformA1Label.setForeground(GraphicsUtils.fColor);
        this.transformA1Text = new JTextField();
        this.transformA1Text.setEditable(true);
        this.transformA1Text.setText(Double.toString(this.dataView.getA1()));
        this.transformA1Text.addKeyListener(this);
        this.transformA2Label = new JLabel("A2");
        this.transformA2Label.setFont(GraphicsUtils.labelFont);
        this.transformA2Label.setForeground(GraphicsUtils.fColor);
        this.transformA2Text = new JTextField();
        this.transformA2Text.setEditable(true);
        this.transformA2Text.setText(Double.toString(this.dataView.getA2()));
        this.transformA2Text.addKeyListener(this);
        this.transformPanel.add(this.transformHelpLabel);
        this.transformPanel.add(this.transformA0Label);
        this.transformPanel.add(this.transformA0Text);
        this.transformPanel.add(this.transformA1Label);
        this.transformPanel.add(this.transformA1Text);
        this.transformPanel.add(this.transformA2Label);
        this.transformPanel.add(this.transformA2Text);
        this.transformHelpLabel.setBounds(10, 100, 240, 100);
        this.transformA0Label.setBounds(60, 10, 30, 25);
        this.transformA0Text.setBounds(95, 10, 100, 25);
        this.transformA1Label.setBounds(60, 40, 30, 25);
        this.transformA1Text.setBounds(95, 40, 100, 25);
        this.transformA2Label.setBounds(60, 70, 30, 25);
        this.transformA2Text.setBounds(95, 70, 100, 25);
        this.nameLabel = new JLabel();
        this.nameLabel.setText(this.dataView.getName());
        this.tabPane.add("Curve", this.linePanel);
        this.tabPane.add("Bar", this.barPanel);
        this.tabPane.add("Marker", this.markerPanel);
        this.tabPane.add("Transform", this.transformPanel);
        jPanel.add(this.tabPane);
        jPanel.add(this.nameLabel);
        this.closeBtn = new JButton();
        this.closeBtn.setText("Close");
        jPanel.add(this.closeBtn);
        this.tabPane.setBounds(5, 5, 260, 220);
        this.closeBtn.setBounds(185, 230, 80, 25);
        this.nameLabel.setBounds(10, 230, 170, 25);
        this.closeBtn.addMouseListener(this);
        jPanel.setPreferredSize(new Dimension(270, 265));
        this.setContentPane(jPanel);
        this.setResizable(false);
    }

    public void Commit() {
        if (this.chart != null) {
            this.chart.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Color color;
        if (mouseEvent.getSource() == this.closeBtn) {
            this.hide();
            this.dispose();
        } else if (mouseEvent.getSource() == this.lineColorBtn) {
            Color color2 = JColorChooser.showDialog(this, "Choose Line Color", this.dataView.getColor());
            if (color2 != null) {
                this.dataView.setColor(color2);
                this.lineColorView.setBackground(color2);
                this.Commit();
            }
        } else if (mouseEvent.getSource() == this.fillColorBtn) {
            Color color3 = JColorChooser.showDialog(this, "Choose Fill Color", this.dataView.getFillColor());
            if (color3 != null) {
                this.dataView.setFillColor(color3);
                this.fillColorView.setBackground(color3);
                this.Commit();
            }
        } else if (mouseEvent.getSource() == this.markerColorBtn && (color = JColorChooser.showDialog(this, "Choose marker Color", this.dataView.getMarkerColor())) != null) {
            this.dataView.setMarkerColor(color);
            this.markerColorView.setBackground(color);
            this.Commit();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.lineDashCombo) {
            this.dataView.setStyle(this.lineDashCombo.getSelectedIndex());
            this.Commit();
        } else if (actionEvent.getSource() == this.fillStyleCombo) {
            this.dataView.setFillStyle(this.fillStyleCombo.getSelectedIndex());
            this.Commit();
        } else if (actionEvent.getSource() == this.fillMethodCombo) {
            this.dataView.setFillMethod(this.fillMethodCombo.getSelectedIndex());
            this.Commit();
        } else if (actionEvent.getSource() == this.viewTypeCombo) {
            this.dataView.setViewType(this.viewTypeCombo.getSelectedIndex());
            this.Commit();
        } else if (actionEvent.getSource() == this.markerStyleCombo) {
            this.dataView.setMarker(this.markerStyleCombo.getSelectedIndex());
            this.Commit();
        } else if (actionEvent.getSource() == this.labelVisibleCheck) {
            this.dataView.setLabelVisible(this.labelVisibleCheck.isSelected());
            this.Commit();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.lineWidthSpinner) {
            Integer n = (Integer)this.lineWidthSpinner.getValue();
            this.dataView.setLineWidth(n);
            this.Commit();
        } else if (changeEvent.getSource() == this.barWidthSpinner) {
            Integer n = (Integer)this.barWidthSpinner.getValue();
            this.dataView.setBarWidth(n);
            this.Commit();
        } else if (changeEvent.getSource() == this.markerSizeSpinner) {
            Integer n = (Integer)this.markerSizeSpinner.getValue();
            this.dataView.setMarkerSize(n);
            this.Commit();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.transformA0Text) {
            if (keyEvent.getKeyCode() == 10) {
                String string = this.transformA0Text.getText();
                try {
                    double d = Double.parseDouble(string);
                    this.dataView.setA0(d);
                    this.Commit();
                }
                catch (NumberFormatException numberFormatException) {
                    this.transformA0Text.setText(Double.toString(this.dataView.getA0()));
                }
            }
            if (keyEvent.getKeyCode() == 27) {
                this.transformA0Text.setText(Double.toString(this.dataView.getA0()));
            }
        } else if (keyEvent.getSource() == this.transformA1Text) {
            if (keyEvent.getKeyCode() == 10) {
                String string = this.transformA1Text.getText();
                try {
                    double d = Double.parseDouble(string);
                    this.dataView.setA1(d);
                    this.Commit();
                }
                catch (NumberFormatException numberFormatException) {
                    this.transformA1Text.setText(Double.toString(this.dataView.getA1()));
                }
            }
            if (keyEvent.getKeyCode() == 27) {
                this.transformA1Text.setText(Double.toString(this.dataView.getA1()));
            }
        } else if (keyEvent.getSource() == this.transformA2Text) {
            if (keyEvent.getKeyCode() == 10) {
                String string = this.transformA2Text.getText();
                try {
                    double d = Double.parseDouble(string);
                    this.dataView.setA2(d);
                    this.Commit();
                }
                catch (NumberFormatException numberFormatException) {
                    this.transformA2Text.setText(Double.toString(this.dataView.getA2()));
                }
            }
            if (keyEvent.getKeyCode() == 27) {
                this.transformA2Text.setText(Double.toString(this.dataView.getA2()));
            }
        }
    }
}

