/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.IWheelSwitchListener;
import fr.esrf.tangoatk.widget.util.JArrowButton;
import fr.esrf.tangoatk.widget.util.WheelSwitchEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;

public class WheelSwitch
extends JComponent {
    private static Font defaultFont = new Font("Lucida Bright", 0, 16);
    private static Color defaultBackground = new Color(200, 200, 200);
    private static Color defaultSelectionColor = new Color(156, 154, 206);
    private int off_x;
    private int off_y;
    private int intNumber;
    private int fracNumber;
    private double value;
    private double maxValue;
    private Dimension dz;
    private boolean editMode;
    private String editValue;
    private EventListenerList listenerList;
    private JArrowButton[] buttons_up;
    private JArrowButton[] buttons_down;
    private int nbButton = 0;
    private int selButton = 0;
    private Color buttonBackground;
    private Color selectionColor;
    static /* synthetic */ Class class$fr$esrf$tangoatk$widget$util$IWheelSwitchListener;

    public WheelSwitch() {
        this.setLayout(null);
        this.setForeground(Color.black);
        this.setBackground(defaultBackground);
        this.setBorder(null);
        this.setFont(defaultFont);
        this.buttonBackground = this.getBackground();
        this.selectionColor = defaultSelectionColor;
        this.setOpaque(true);
        this.setPrecision(3, 2);
        this.value = 0.0;
        this.editMode = false;
        this.editValue = "";
        this.listenerList = new EventListenerList();
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                WheelSwitch.this.placeComponents();
            }

            public void componentShown(ComponentEvent componentEvent) {
                WheelSwitch.this.placeComponents();
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                WheelSwitch.this.processKey(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                WheelSwitch.this.grabFocus();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                WheelSwitch.this.updateButtonFocus();
                WheelSwitch.this.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                WheelSwitch.this.updateButtonFocus();
                WheelSwitch.this.repaint();
            }
        });
    }

    public Dimension getPreferredSize() {
        Insets insets = this.hasBorder() ? this.getInsets() : new Insets(1, 1, 1, 1);
        this.computeDigitSize();
        int n = this.fracNumber > 0 ? this.dz.width * (this.intNumber + this.fracNumber + 2) : this.dz.width * (this.intNumber + this.fracNumber + 1);
        int n2 = this.dz.width * 2 + this.dz.height;
        return new Dimension(n + insets.right + insets.left, n2 + insets.top + insets.bottom);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setValue(double d) {
        this.value = this.near(d);
        this.repaint();
    }

    public double getValue() {
        return this.value;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.dz = null;
        this.computeDigitSize();
        this.placeComponents();
    }

    public Dimension getDigitSize() {
        return this.dz;
    }

    public void setButtonColor(Color color) {
        this.buttonBackground = color;
        int n = 0;
        while (n < this.nbButton) {
            this.buttons_up[n].setBackground(this.buttonBackground);
            this.buttons_down[n].setBackground(this.buttonBackground);
            ++n;
        }
    }

    public Color getButtonColor() {
        return this.buttonBackground;
    }

    public void setSelButtonColor(Color color) {
        this.selectionColor = color;
    }

    public Color getSelButtonColor() {
        return this.selectionColor;
    }

    public void setFormat(String string) {
        if (string.length() <= 2) {
            System.out.println("WheelSwitch: Invalid format use %x.yf or %xd");
            return;
        }
        String string2 = string.replace('.', '_');
        string2 = string2.replace('%', '0');
        string2 = string2.substring(0, string2.length() - 1);
        String[] stringArray = string2.split("_");
        try {
            if (stringArray.length == 2) {
                int n;
                int n2 = Integer.parseInt(stringArray[0]);
                if (n2 <= (n = Integer.parseInt(stringArray[1]))) {
                    System.out.println("WheelSwitch: Invalid format a<b in %a.bf");
                } else {
                    this.setPrecision(n2 - n, n);
                }
            } else if (stringArray.length == 1) {
                int n = Integer.parseInt(stringArray[0]);
                this.setPrecision(n, 0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("WheelSwitch: Invalid format use %x.yf or %xd");
        }
    }

    public synchronized void setPrecision(int n, int n2) {
        int n3 = this.nbButton;
        this.nbButton = 0;
        int n4 = 0;
        while (n4 < n3) {
            this.remove(this.buttons_up[n4]);
            this.remove(this.buttons_down[n4]);
            this.buttons_up[n4] = null;
            this.buttons_down[n4] = null;
            ++n4;
        }
        this.intNumber = n;
        if (this.intNumber < 1) {
            this.intNumber = 1;
        }
        this.fracNumber = n2;
        if (this.fracNumber < 0) {
            this.fracNumber = 0;
        }
        n3 = this.intNumber + this.fracNumber;
        this.buttons_up = new JArrowButton[n3];
        this.buttons_down = new JArrowButton[n3];
        this.maxValue = Math.pow(10.0, this.intNumber);
        n4 = 0;
        while (n4 < n3) {
            this.buttons_up[n4] = new JArrowButton();
            this.add(this.buttons_up[n4]);
            this.buttons_up[n4].addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    WheelSwitch.this.clickUp(mouseEvent);
                }
            });
            this.buttons_down[n4] = new JArrowButton();
            this.add(this.buttons_down[n4]);
            this.buttons_down[n4].setOrientation(JArrowButton.DOWN);
            this.buttons_down[n4].addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    WheelSwitch.this.clickDown(mouseEvent);
                }
            });
            ++n4;
        }
        this.value = this.near(this.value);
        this.nbButton = n3;
        this.selButton = n3 - 1;
        this.placeComponents();
        this.updateButtonFocus();
        this.repaint();
    }

    private boolean hasBorder() {
        return this.getBorder() != null;
    }

    /*
     * Unable to fully structure code
     */
    private void clickUp(MouseEvent var1_1) {
        var2_2 = 0;
        var3_3 = false;
        this.grabFocus();
        if (!Double.isNaN(this.value)) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            v0 = var3_3 = var1_1.getSource() == this.buttons_up[var2_2];
            if (var3_3) continue;
            ++var2_2;
lbl9:
            // 3 sources

            ** while (var2_2 < this.nbButton && !var3_3)
        }
lbl10:
        // 1 sources

        if (!this.editMode && var3_3) {
            this.increaseValue(var2_2);
            this.selButton = var2_2;
            this.updateButtonFocus();
            this.repaint();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void clickDown(MouseEvent var1_1) {
        var2_2 = 0;
        var3_3 = false;
        this.grabFocus();
        if (!Double.isNaN(this.value)) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            v0 = var3_3 = var1_1.getSource() == this.buttons_down[var2_2];
            if (var3_3) continue;
            ++var2_2;
lbl9:
            // 3 sources

            ** while (var2_2 < this.nbButton && !var3_3)
        }
lbl10:
        // 1 sources

        if (!this.editMode && var3_3) {
            this.decreaseValue(var2_2);
            this.selButton = var2_2;
            this.updateButtonFocus();
            this.repaint();
        }
    }

    private void computeDigitSize() {
        int n = 0;
        int n2 = 0;
        if (this.dz == null) {
            String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
            int n3 = 0;
            while (n3 < stringArray.length) {
                Dimension dimension = ATKGraphicsUtils.measureString(stringArray[n3], this.getFont());
                int n4 = dimension.width + 1;
                if (n4 > n) {
                    n = n4;
                }
                ++n3;
            }
            n2 = (int)ATKGraphicsUtils.getLineMetrics("0123456789", this.getFont()).getAscent() + 1;
            this.dz = new Dimension(n, n2);
        }
    }

    private double near(double d) {
        double d2 = Math.pow(10.0, this.fracNumber);
        return Math.rint(d * d2) / d2;
    }

    private String getDigit(int n) {
        int n2;
        if (Double.isNaN(this.value)) {
            return "X";
        }
        double d = this.value;
        if (d < 0.0) {
            d = -d;
        }
        if (n >= 0) {
            d /= Math.pow(10.0, n);
        } else {
            n2 = (int)(d += 0.5 / Math.pow(10.0, this.fracNumber));
            d -= (double)n2;
            d *= Math.pow(10.0, -n);
        }
        if (d > 1.0E9) {
            n2 = (int)(d / 1.0E7);
            d -= (double)n2 * 1.0E7;
        }
        Integer n3 = new Integer((int)d % 10);
        return n3.toString();
    }

    protected void paintComponent(Graphics graphics) {
        Serializable serializable;
        int n = this.getWidth();
        int n2 = this.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics.setPaintMode();
        this.computeDigitSize();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        if (this.editMode) {
            serializable = this.getFontMetrics(this.getFont());
            Rectangle2D rectangle2D = serializable.getStringBounds(this.editValue, graphics);
            int n3 = (n - (int)rectangle2D.getWidth()) / 2;
            graphics.drawString(this.editValue, n3, this.off_y + this.dz.width + this.dz.height - 2);
        } else {
            if (this.value < 0.0) {
                graphics.drawString("-", this.off_x, this.off_y + this.dz.width + this.dz.height - 2);
            }
            if (this.fracNumber > 0) {
                graphics.drawString(".", this.off_x + (this.intNumber + 1) * this.dz.width + 2, this.off_y + this.dz.width + this.dz.height - 2);
            }
            int n4 = 0;
            while (n4 < this.nbButton) {
                int n5 = n4 < this.intNumber ? this.off_x + (n4 + 1) * this.dz.width : this.off_x + (n4 + 2) * this.dz.width;
                graphics.drawString(this.getDigit(this.intNumber - n4 - 1), n5, this.off_y + this.dz.width + this.dz.height - 2);
                ++n4;
            }
        }
        if (this.hasFocus()) {
            serializable = this.hasBorder() ? this.getInsets() : new Insets(1, 1, 1, 1);
            graphics.setColor(defaultSelectionColor);
            graphics.drawLine(((Insets)serializable).left + 1, ((Insets)serializable).top + 1, n - ((Insets)serializable).right - 1, ((Insets)serializable).top + 1);
            graphics.drawLine(n - ((Insets)serializable).right - 1, ((Insets)serializable).top + 1, n - ((Insets)serializable).right - 1, n2 - ((Insets)serializable).bottom - 1);
            graphics.drawLine(n - ((Insets)serializable).right - 1, n2 - ((Insets)serializable).bottom - 1, ((Insets)serializable).left + 1, n2 - ((Insets)serializable).bottom - 1);
            graphics.drawLine(((Insets)serializable).left + 1, n2 - ((Insets)serializable).bottom - 1, ((Insets)serializable).left + 1, ((Insets)serializable).top + 1);
        }
    }

    public void addWheelSwitchListener(IWheelSwitchListener iWheelSwitchListener) {
        this.listenerList.add(class$fr$esrf$tangoatk$widget$util$IWheelSwitchListener == null ? (class$fr$esrf$tangoatk$widget$util$IWheelSwitchListener = WheelSwitch.class$("fr.esrf.tangoatk.widget.util.IWheelSwitchListener")) : class$fr$esrf$tangoatk$widget$util$IWheelSwitchListener, iWheelSwitchListener);
    }

    public void removeWheelSwitchListener(IWheelSwitchListener iWheelSwitchListener) {
        this.listenerList.remove(class$fr$esrf$tangoatk$widget$util$IWheelSwitchListener == null ? (class$fr$esrf$tangoatk$widget$util$IWheelSwitchListener = WheelSwitch.class$("fr.esrf.tangoatk.widget.util.IWheelSwitchListener")) : class$fr$esrf$tangoatk$widget$util$IWheelSwitchListener, iWheelSwitchListener);
    }

    private void fireValueChange() {
        IWheelSwitchListener[] iWheelSwitchListenerArray = (IWheelSwitchListener[])this.listenerList.getListeners(class$fr$esrf$tangoatk$widget$util$IWheelSwitchListener == null ? (class$fr$esrf$tangoatk$widget$util$IWheelSwitchListener = WheelSwitch.class$("fr.esrf.tangoatk.widget.util.IWheelSwitchListener")) : class$fr$esrf$tangoatk$widget$util$IWheelSwitchListener);
        WheelSwitchEvent wheelSwitchEvent = new WheelSwitchEvent(this, this.value);
        int n = 0;
        while (n < iWheelSwitchListenerArray.length) {
            iWheelSwitchListenerArray[n].valueChange(wheelSwitchEvent);
            ++n;
        }
    }

    private void updateButtonFocus() {
        int n = 0;
        while (n < this.nbButton) {
            if (n == this.selButton && this.hasFocus()) {
                this.buttons_up[n].setBackground(this.selectionColor);
                this.buttons_down[n].setBackground(this.selectionColor);
            } else {
                this.buttons_up[n].setBackground(this.buttonBackground);
                this.buttons_down[n].setBackground(this.buttonBackground);
            }
            ++n;
        }
    }

    private void increaseValue(int n) {
        if (!Double.isNaN(this.value)) {
            double d = this.near(this.value + Math.pow(10.0, this.intNumber - n - 1));
            if (Math.abs(d) < this.maxValue) {
                this.value = d;
            }
            this.fireValueChange();
        }
    }

    private void decreaseValue(int n) {
        if (!Double.isNaN(this.value)) {
            double d = this.near(this.value - Math.pow(10.0, this.intNumber - n - 1));
            if (Math.abs(d) < this.maxValue) {
                this.value = d;
            }
            this.fireValueChange();
        }
    }

    private void processKey(KeyEvent keyEvent) {
        block17: {
            char c = keyEvent.getKeyChar();
            int n = keyEvent.getKeyCode();
            if (!this.editMode && this.nbButton > 0) {
                switch (n) {
                    case 39: {
                        ++this.selButton;
                        if (this.selButton >= this.nbButton) {
                            this.selButton = this.nbButton - 1;
                        }
                        this.updateButtonFocus();
                        this.repaint();
                        break;
                    }
                    case 37: {
                        --this.selButton;
                        if (this.selButton < 0) {
                            this.selButton = 0;
                        }
                        this.updateButtonFocus();
                        this.repaint();
                        break;
                    }
                    case 38: {
                        this.increaseValue(this.selButton);
                        this.repaint();
                        break;
                    }
                    case 40: {
                        this.decreaseValue(this.selButton);
                        this.repaint();
                    }
                }
            }
            if (c >= '0' && c <= '9' || c == '.' || c == '-') {
                this.editValue = this.editValue + c;
                this.editMode = true;
                this.repaint();
            }
            if (n == 12 || n == 3 || n == 27) {
                this.editValue = "";
                this.editMode = false;
                this.repaint();
            }
            if (this.editMode && this.editValue.length() > 0 && (n == 8 || n == 127)) {
                this.editValue = this.editValue.substring(0, this.editValue.length() - 1);
                this.repaint();
            }
            if (!this.editMode || n != 10) break block17;
            try {
                double d = this.near(Double.parseDouble(this.editValue));
                if (Math.abs(d) < this.maxValue) {
                    this.value = d;
                    this.fireValueChange();
                    this.editValue = "";
                    this.editMode = false;
                    this.repaint();
                } else {
                    int n2 = JOptionPane.showConfirmDialog(this, "Warning: value out of range allowed by the format.\nCancel editing ?", "[WheelSwitch error]", 0);
                    if (n2 == 0) {
                        this.editValue = "";
                        this.editMode = false;
                        this.repaint();
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private synchronized void placeComponents() {
        this.computeDigitSize();
        Dimension dimension = this.getSize();
        int n = this.fracNumber > 0 ? this.dz.width * (this.nbButton + 2) : this.dz.width * (this.nbButton + 1);
        int n2 = this.dz.height + 2 * this.dz.width;
        this.off_x = (dimension.width - n) / 2;
        this.off_y = (dimension.height - n2) / 2;
        int n3 = 0;
        while (n3 < this.nbButton) {
            int n4 = n3 < this.intNumber ? this.off_x + (n3 + 1) * this.dz.width + 1 : this.off_x + (n3 + 2) * this.dz.width + 1;
            this.buttons_up[n3].setBounds(n4, this.off_y + 2, this.dz.width - 2, this.dz.width - 2);
            int n5 = this.dz.width + this.dz.height + this.off_y;
            this.buttons_down[n3].setBounds(n4, n5, this.dz.width - 2, this.dz.width - 2);
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        WheelSwitch wheelSwitch = new WheelSwitch();
        WheelSwitch wheelSwitch2 = new WheelSwitch();
        WheelSwitch wheelSwitch3 = new WheelSwitch();
        WheelSwitch wheelSwitch4 = new WheelSwitch();
        WheelSwitch wheelSwitch5 = new WheelSwitch();
        wheelSwitch.setFormat("%4.3e");
        wheelSwitch.setValue(-42.9995);
        wheelSwitch.addWheelSwitchListener(new IWheelSwitchListener(){

            public void valueChange(WheelSwitchEvent wheelSwitchEvent) {
                System.out.println("Value changed ws1:" + wheelSwitchEvent.getValue());
            }
        });
        wheelSwitch2.setFormat("%6.3f");
        wheelSwitch2.setValue(-12.5);
        wheelSwitch2.setFont(new Font("Dialog", 1, 50));
        wheelSwitch2.addWheelSwitchListener(new IWheelSwitchListener(){

            public void valueChange(WheelSwitchEvent wheelSwitchEvent) {
                System.out.println("Value changed ws2:" + wheelSwitchEvent.getValue());
            }
        });
        wheelSwitch3.setFormat("%6.0f");
        wheelSwitch3.setButtonColor(new Color(100, 200, 160));
        wheelSwitch3.setValue(48.0);
        wheelSwitch3.setFont(new Font("Lucida Bright", 1, 30));
        wheelSwitch3.setBorder(BorderFactory.createEtchedBorder());
        wheelSwitch3.addWheelSwitchListener(new IWheelSwitchListener(){

            public void valueChange(WheelSwitchEvent wheelSwitchEvent) {
                System.out.println("Value changed ws3:" + wheelSwitchEvent.getValue());
            }
        });
        wheelSwitch4.setFormat("%5.2f");
        wheelSwitch4.setButtonColor(new Color(0, 255, 0));
        wheelSwitch4.setValue(28.1);
        wheelSwitch4.setFont(new Font("Lucida Bright", 1, 12));
        wheelSwitch4.setBorder(BorderFactory.createEtchedBorder());
        wheelSwitch4.addWheelSwitchListener(new IWheelSwitchListener(){

            public void valueChange(WheelSwitchEvent wheelSwitchEvent) {
                System.out.println("Value changed ws4:" + wheelSwitchEvent.getValue());
            }
        });
        wheelSwitch5.setFormat("%5.2f");
        wheelSwitch5.setButtonColor(new Color(255, 0, 0));
        wheelSwitch5.setValue(28.1);
        wheelSwitch5.setFont(new Font("Dialog", 0, 16));
        wheelSwitch5.addWheelSwitchListener(new IWheelSwitchListener(){

            public void valueChange(WheelSwitchEvent wheelSwitchEvent) {
                System.out.println("Value changed ws5:" + wheelSwitchEvent.getValue());
            }
        });
        JButton jButton = new JButton("OK");
        jButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().setBackground(Color.white);
        jFrame.getContentPane().setLayout(new FlowLayout());
        jFrame.getContentPane().add(wheelSwitch);
        jFrame.getContentPane().add(wheelSwitch2);
        jFrame.getContentPane().add(wheelSwitch3);
        jFrame.getContentPane().add(wheelSwitch4);
        jFrame.getContentPane().add(wheelSwitch5);
        jFrame.getContentPane().add(jButton);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

