/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.Marker;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JComponent;

public class JImage
extends JComponent
implements MouseMotionListener,
MouseListener {
    private static final int MARKER_CROSS = 1;
    private static final int MARKER_RECT = 2;
    private BufferedImage theImage = null;
    private Insets margin;
    private int xOrg;
    private int yOrg;
    private boolean selectionEnabled;
    private int mode;
    private boolean isDragging;
    private int dragCorner;
    private int cornerWidth = 10;
    private int x1 = -1;
    private int y1 = -1;
    private int x2 = -1;
    private int y2 = -1;
    private boolean snapToGrid;
    private int grid = 16;
    Vector markers = null;
    double markerScaleFactor = 1.0;

    public JImage() {
        this.setLayout(null);
        this.setBorder(null);
        this.setBackground(new Color(180, 180, 200));
        this.setOpaque(true);
        this.margin = new Insets(5, 5, 5, 5);
        this.xOrg = 5;
        this.yOrg = 5;
        this.mode = 1;
        this.isDragging = false;
        this.selectionEnabled = true;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.snapToGrid = false;
    }

    public void setSelectionEnabled(boolean bl) {
        this.selectionEnabled = bl;
        this.repaint();
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public Rectangle getSelectionRect() {
        if (this.hasSelection()) {
            return this.buildSelectionRect();
        }
        return null;
    }

    public Point[] getSelectionPoint() {
        if (this.hasSelection()) {
            Point[] pointArray = new Point[]{new Point(this.x1, this.y1), new Point(this.x2, this.y2)};
            return pointArray;
        }
        return null;
    }

    public void setSelectionMode(int n) {
        this.mode = n;
        this.clipSelection();
        this.repaint();
    }

    public int getSelectionMode() {
        return this.mode;
    }

    public boolean hasSelection() {
        return this.selectionEnabled && this.x1 >= 0 && this.x2 >= 0 && this.y1 >= 0 && this.y2 >= 0;
    }

    public void setSelection(int n, int n2, int n3, int n4) {
        if (this.selectionEnabled) {
            this.x1 = n;
            this.y1 = n2;
            this.x2 = n3;
            this.y2 = n4;
            this.clipSelection();
            this.isDragging = false;
            this.repaint();
        }
    }

    public void clearSelection() {
        this.x1 = -1;
        this.y1 = -1;
        this.x2 = -1;
        this.y2 = -1;
        this.isDragging = false;
        this.repaint();
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public int getXOrigin() {
        return this.xOrg;
    }

    public int getYOrigin() {
        return this.yOrg;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.theImage = bufferedImage;
        this.clearSelection();
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.theImage;
    }

    public Dimension getImageSize() {
        if (this.theImage != null) {
            return new Dimension(this.theImage.getWidth(), this.theImage.getHeight());
        }
        return new Dimension(0, 0);
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean bl) {
        this.snapToGrid = bl;
    }

    public int getSnapGrid() {
        return this.grid;
    }

    public void setSnapGrid(int n) {
        this.grid = n;
    }

    public int addCrossMarker(int n, int n2, Color color) {
        if (this.markers == null) {
            this.markers = new Vector();
        }
        this.markers.add(new Marker(1, n, n2, color));
        this.repaint();
        return this.markers.size() - 1;
    }

    public int addRectangleMarker(int n, int n2, int n3, int n4, Color color) {
        if (this.markers == null) {
            this.markers = new Vector();
        }
        this.markers.add(new Marker(2, new Rectangle(n, n2, n3, n4), color));
        this.repaint();
        return this.markers.size() - 1;
    }

    public void setMarkerPos(int n, int n2, int n3, int n4, int n5) {
        if (this.markers != null) {
            if (n >= 0 && n < this.markers.size()) {
                Marker marker = (Marker)this.markers.get(n);
                marker.markerRect.setBounds(n2, n3, n4, n5);
            }
            this.repaint();
        }
    }

    public void clearMarkers() {
        if (this.markers != null) {
            this.markers.clear();
            this.markers = null;
            this.repaint();
        }
    }

    public int getMarkerNumber() {
        if (this.markers == null) {
            return 0;
        }
        return this.markers.size();
    }

    public void setMarkerScale(double d) {
        this.markerScaleFactor = d;
    }

    private void paintSelection(Graphics graphics) {
        if (this.hasSelection()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(Color.red);
            Stroke stroke = graphics2D.getStroke();
            BasicStroke basicStroke = new BasicStroke(2.0f);
            if (basicStroke != null) {
                graphics2D.setStroke(basicStroke);
            }
            Rectangle rectangle = this.buildSelectionRect();
            Rectangle rectangle2 = new Rectangle(0, 0, this.cornerWidth, this.cornerWidth);
            switch (this.mode) {
                case 0: {
                    graphics2D.drawLine(this.x1, this.y1, this.x2, this.y2);
                    graphics2D.setStroke(stroke);
                    int n = (this.x1 + this.x2) / 2;
                    int n2 = (this.y1 + this.y2) / 2;
                    double d = this.y2 - this.y1;
                    double d2 = -(this.x2 - this.x1);
                    double d3 = Math.sqrt(d * d + d2 * d2);
                    int n3 = (int)(8.0 * (d / d3));
                    int n4 = (int)(8.0 * (d2 / d3));
                    d = this.x2 - this.x1;
                    d2 = this.y2 - this.y1;
                    d3 = Math.sqrt(d * d + d2 * d2);
                    int n5 = (int)(10.0 * (d / d3));
                    int n6 = (int)(10.0 * (d2 / d3));
                    graphics2D.drawLine(n - n3, n2 - n4, n + n3, n2 + n4);
                    graphics2D.drawLine(n + n3, n2 + n4, n + n5, n2 + n6);
                    graphics2D.drawLine(n + n5, n2 + n6, n - n3, n2 - n4);
                    rectangle2.translate(this.x1 - this.cornerWidth / 2, this.y1 - this.cornerWidth / 2);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle2.translate(this.x2 - this.x1, this.y2 - this.y1);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    break;
                }
                case 1: {
                    graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics2D.setStroke(stroke);
                    rectangle2.translate(rectangle.x - this.cornerWidth / 2, rectangle.y - this.cornerWidth / 2);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle2.translate(rectangle.width, 0);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle2.translate(0, rectangle.height);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle2.translate(-rectangle.width, 0);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle2.translate(rectangle.width / 2, -rectangle.height / 2);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
            }
            graphics2D.setPaintMode();
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (this.theImage != null) {
            this.xOrg = (dimension.width - this.theImage.getWidth()) / 2;
            this.yOrg = (dimension.height - this.theImage.getHeight()) / 2;
            graphics.translate(this.xOrg, this.yOrg);
            graphics.drawImage(this.theImage, 0, 0, null);
            this.paintSelection(graphics);
        }
        if (this.markers != null) {
            int n = 0;
            while (n < this.markers.size()) {
                Marker marker = (Marker)this.markers.get(n);
                graphics.setColor(marker.markerColor);
                int n2 = (int)((double)marker.markerRect.x * this.markerScaleFactor);
                int n3 = (int)((double)marker.markerRect.y * this.markerScaleFactor);
                int n4 = (int)((double)marker.markerRect.width * this.markerScaleFactor);
                int n5 = (int)((double)marker.markerRect.height * this.markerScaleFactor);
                Rectangle rectangle = new Rectangle(0, 0, this.theImage.getWidth() + 1, this.theImage.getHeight() + 1);
                Rectangle rectangle2 = n4 == 0 ? new Rectangle(n2, n3, 1, 1) : new Rectangle(n2, n3, n4, n5);
                if (rectangle.contains(rectangle2)) {
                    switch (marker.type) {
                        case 1: {
                            graphics.drawLine(n2, 0, n2, this.theImage.getHeight());
                            graphics.drawLine(0, n3, this.theImage.getWidth(), n3);
                            graphics.drawRect(n2 - 2, n3 - 2, 5, 5);
                            break;
                        }
                        case 2: {
                            graphics.drawRect(n2, n3, n4, n5);
                        }
                    }
                }
                ++n;
            }
        }
    }

    public Dimension getMinimumSize() {
        if (this.theImage == null) {
            return new Dimension(320, 200);
        }
        return new Dimension(this.theImage.getWidth() + this.margin.right + this.margin.left, this.theImage.getHeight() + this.margin.top + this.margin.bottom);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private boolean cornerMatch(int n, int n2, int n3, int n4) {
        int n5 = this.cornerWidth / 2;
        return n >= n3 - n5 && n <= n3 + n5 && n2 >= n4 - n5 && n2 <= n4 + n5;
    }

    private int findCorner(int n, int n2) {
        if (this.hasSelection()) {
            int n3 = (this.x2 + this.x1) / 2;
            int n4 = (this.y2 + this.y1) / 2;
            if (this.cornerMatch(n, n2, this.x1, this.y1)) {
                return 1;
            }
            if (this.cornerMatch(n, n2, this.x2, this.y1) && this.mode == 1) {
                return 2;
            }
            if (this.cornerMatch(n, n2, this.x2, this.y2)) {
                return 3;
            }
            if (this.cornerMatch(n, n2, this.x1, this.y2) && this.mode == 1) {
                return 4;
            }
            if (this.cornerMatch(n, n2, n3, n4)) {
                return 5;
            }
        }
        return 0;
    }

    private Rectangle buildSelectionRect() {
        Rectangle rectangle = new Rectangle();
        if (this.x1 < this.x2) {
            if (this.y1 < this.y2) {
                rectangle.setRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
            } else {
                rectangle.setRect(this.x1, this.y2, this.x2 - this.x1, this.y1 - this.y2);
            }
        } else if (this.y1 < this.y2) {
            rectangle.setRect(this.x2, this.y1, this.x1 - this.x2, this.y2 - this.y1);
        } else {
            rectangle.setRect(this.x2, this.y2, this.x1 - this.x2, this.y1 - this.y2);
        }
        return rectangle;
    }

    private void repaintBoundingRect(Rectangle rectangle) {
        Rectangle rectangle2 = this.buildSelectionRect();
        if (!rectangle2.equals(rectangle)) {
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = rectangle.x + rectangle.width;
            int n4 = rectangle.y + rectangle.height;
            if (rectangle2.x < n) {
                n = rectangle2.x;
            }
            if (rectangle2.y < n2) {
                n2 = rectangle2.y;
            }
            if (rectangle2.width + rectangle2.x > n3) {
                n3 = rectangle2.width + rectangle2.x;
            }
            if (rectangle2.height + rectangle2.y > n4) {
                n4 = rectangle2.height + rectangle2.y;
            }
            int n5 = this.cornerWidth / 2;
            if (this.mode == 0) {
                this.repaint(0L, n - n5 + this.xOrg - 4, n2 - n5 + this.yOrg - 4, n3 - n + this.cornerWidth + 8, n4 - n2 + this.cornerWidth + 8);
            } else {
                this.repaint(0L, n - n5 + this.xOrg, n2 - n5 + this.yOrg, n3 - n + this.cornerWidth + 1, n4 - n2 + this.cornerWidth + 1);
            }
        }
    }

    private void clipSelection() {
        if (this.hasSelection()) {
            Dimension dimension = this.getImageSize();
            if (this.mode == 0) {
                if (this.x1 >= dimension.width) {
                    this.x1 = dimension.width - 1;
                }
                if (this.y1 >= dimension.height) {
                    this.y1 = dimension.height - 1;
                }
                if (this.x2 >= dimension.width) {
                    this.x2 = dimension.width - 1;
                }
                if (this.y2 >= dimension.height) {
                    this.y2 = dimension.height - 1;
                }
                if (this.x1 < 0) {
                    this.x1 = 0;
                }
                if (this.y1 < 0) {
                    this.y1 = 0;
                }
                if (this.x2 < 0) {
                    this.x2 = 0;
                }
                if (this.y2 < 0) {
                    this.y2 = 0;
                }
            } else {
                if (this.x1 == this.x2) {
                    this.x2 += this.grid;
                }
                if (this.y1 == this.y2) {
                    this.y2 += this.grid;
                }
                if (dimension.width > 1) {
                    if (this.x1 >= dimension.width - 1) {
                        this.x1 = dimension.width;
                    }
                    if (this.x2 >= dimension.width - 1) {
                        this.x2 = dimension.width;
                    }
                } else {
                    this.x1 = 0;
                    this.x2 = 1;
                }
                if (dimension.height > 1) {
                    if (this.y1 >= dimension.height - 1) {
                        this.y1 = dimension.height;
                    }
                    if (this.y2 >= dimension.height - 1) {
                        this.y2 = dimension.height;
                    }
                } else {
                    this.y1 = 0;
                    this.y2 = 1;
                }
                if (this.x1 < 0) {
                    this.x1 = 0;
                }
                if (this.y1 < 0) {
                    this.y1 = 0;
                }
                if (this.x2 < 0) {
                    this.x2 = 0;
                }
                if (this.y2 < 0) {
                    this.y2 = 0;
                }
            }
        }
    }

    private void alignSelection() {
        if (this.snapToGrid && this.hasSelection()) {
            if (this.mode == 1) {
                this.x1 = this.x1 / this.grid * this.grid;
                this.x2 = this.x2 / this.grid * this.grid;
                this.y1 = this.y1 / this.grid * this.grid;
                this.y2 = this.y2 / this.grid * this.grid;
            } else {
                Dimension dimension = this.getImageSize();
                this.x1 = this.x1 >= dimension.width - 1 ? dimension.width - 1 : this.x1 / this.grid * this.grid;
                this.x2 = this.x2 >= dimension.width - 1 ? dimension.width - 1 : this.x2 / this.grid * this.grid;
                this.y1 = this.y1 >= dimension.height - 1 ? dimension.height - 1 : this.y1 / this.grid * this.grid;
                this.y2 = this.y2 >= dimension.height - 1 ? dimension.height - 1 : this.y2 / this.grid * this.grid;
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isDragging) {
            Rectangle rectangle = this.buildSelectionRect();
            int n = mouseEvent.getX() - this.xOrg;
            int n2 = mouseEvent.getY() - this.yOrg;
            Dimension dimension = this.getImageSize();
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (this.mode == 0) {
                if (n >= dimension.width) {
                    n = dimension.width - 1;
                }
                if (n2 >= dimension.height) {
                    n2 = dimension.height - 1;
                }
            } else {
                if (n >= dimension.width) {
                    n = dimension.width;
                }
                if (n2 >= dimension.height) {
                    n2 = dimension.height;
                }
            }
            switch (this.dragCorner) {
                case 1: {
                    this.x1 = n;
                    this.y1 = n2;
                    break;
                }
                case 2: {
                    this.x2 = n;
                    this.y1 = n2;
                    break;
                }
                case 3: {
                    this.x2 = n;
                    this.y2 = n2;
                    break;
                }
                case 4: {
                    this.x1 = n;
                    this.y2 = n2;
                    break;
                }
                case 5: {
                    Rectangle rectangle2 = this.buildSelectionRect();
                    int n3 = rectangle2.x + rectangle2.width / 2;
                    int n4 = rectangle2.y + rectangle2.height / 2;
                    int n5 = n - n3;
                    int n6 = n2 - n4;
                    if (this.x1 + n5 < 0) {
                        n5 = -this.x1;
                    }
                    if (this.x2 + n5 < 0) {
                        n5 = -this.x2;
                    }
                    if (this.y1 + n6 < 0) {
                        n6 = -this.y1;
                    }
                    if (this.y2 + n6 < 0) {
                        n6 = -this.y2;
                    }
                    if (this.mode == 0) {
                        if (this.x1 + n5 >= dimension.width) {
                            n5 = dimension.width - 1 - this.x1;
                        }
                        if (this.x2 + n5 >= dimension.width) {
                            n5 = dimension.width - 1 - this.x2;
                        }
                        if (this.y1 + n6 >= dimension.height) {
                            n6 = dimension.height - 1 - this.y1;
                        }
                        if (this.y2 + n6 >= dimension.height) {
                            n6 = dimension.height - 1 - this.y2;
                        }
                    } else {
                        if (this.x1 + n5 >= dimension.width) {
                            n5 = dimension.width - this.x1;
                        }
                        if (this.x2 + n5 >= dimension.width) {
                            n5 = dimension.width - this.x2;
                        }
                        if (this.y1 + n6 >= dimension.height) {
                            n6 = dimension.height - this.y1;
                        }
                        if (this.y2 + n6 >= dimension.height) {
                            n6 = dimension.height - this.y2;
                        }
                    }
                    this.x1 += n5;
                    this.x2 += n5;
                    this.y1 += n6;
                    this.y2 += n6;
                }
            }
            this.alignSelection();
            this.repaintBoundingRect(rectangle);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.isDragging = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            int n = mouseEvent.getX() - this.xOrg;
            int n2 = mouseEvent.getY() - this.yOrg;
            if (this.selectionEnabled) {
                Cloneable cloneable;
                this.dragCorner = this.findCorner(n, n2);
                if (this.dragCorner == 0 && !this.hasSelection()) {
                    cloneable = this.getImageSize();
                    if (n > ((Dimension)cloneable).width || n2 > ((Dimension)cloneable).height) {
                        return;
                    }
                    if (n < 0) {
                        n = 0;
                    }
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    this.x1 = this.x2 = n;
                    this.y1 = this.y2 = n2;
                    this.dragCorner = 3;
                    this.repaint(0L, this.x1 - this.cornerWidth, this.y1 - this.cornerWidth, this.x1 + this.cornerWidth, this.y1 + this.cornerWidth);
                }
                cloneable = this.buildSelectionRect();
                this.alignSelection();
                this.repaintBoundingRect((Rectangle)cloneable);
                this.isDragging = true;
            }
        }
    }
}

