/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorAdapter;
import fr.esrf.tangoatk.widget.util.ErrorTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;

class ErrorPanel
extends JPanel
implements IErrorListener,
ISetErrorListener {
    private ErrorAdapter errorAdapter = new ErrorAdapter();
    private JPopupMenu popupMenu;
    private JMenuItem showItem;
    private JMenuItem stackItem;
    private JMenuItem stopItem;
    private JMenuItem startItem;
    private JPanel filterPanel;
    private JToggleButton stopButton;
    private JButton clearButton;
    private JCheckBox panicBox;
    private JCheckBox errorBox;
    private JCheckBox warningBox;
    private JComboBox sourceCombo;
    private JComboBox sortCombo;
    private JSplitPane errorSplitPane;
    private JScrollPane tableView;
    private JTable errorTable;
    private JScrollPane errorView;
    private ErrorTree errorTree;
    private JFrame stackFrame;
    private JTextArea stackText;
    private int selectedRow = -1;
    private String selectedSource = null;
    private boolean sourceComboUpdate = false;
    private boolean stopped = false;

    public ErrorPanel() {
        this.initComponents();
        this.errorAdapter.setErrorPanel(this);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.popupMenu = new JPopupMenu();
        this.showItem = new JMenuItem();
        this.showItem.setText("Show Error");
        this.showItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorPanel.this.showItemActionPerformed();
            }
        });
        this.popupMenu.add(this.showItem);
        this.stackItem = new JMenuItem();
        this.stackItem.setText("Show Java stack");
        this.stackItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorPanel.this.showJavaStackActionPerformed();
            }
        });
        this.popupMenu.add(this.stackItem);
        this.stopItem = new JMenuItem();
        this.stopItem.setText("Stop");
        this.stopItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorPanel.this.stopItemActionPerformed();
            }
        });
        this.popupMenu.add(this.stopItem);
        this.startItem = new JMenuItem();
        this.startItem.setText("Start");
        this.startItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorPanel.this.startItemActionPerformed();
            }
        });
        this.popupMenu.add(this.startItem);
        this.filterPanel = new JPanel();
        FlowLayout flowLayout = new FlowLayout(0);
        this.filterPanel.setLayout(flowLayout);
        this.filterPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Filters", 1, 0, ATKConstant.labelFont, Color.BLACK));
        this.stopButton = new JToggleButton();
        this.stopButton.setText("Stop");
        this.stopButton.setToolTipText("Stops updating");
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorPanel.this.stopButtonActionPerformed();
            }
        });
        this.filterPanel.add(this.stopButton);
        this.clearButton = new JButton();
        this.clearButton.setText("Clear");
        this.clearButton.setToolTipText("Clear errors");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorPanel.this.clearButtonActionPerformed();
            }
        });
        this.filterPanel.add(this.clearButton);
        this.panicBox = new JCheckBox();
        this.panicBox.setFont(ATKConstant.labelFont);
        this.panicBox.setSelected(true);
        this.panicBox.setText("View panic");
        this.panicBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorPanel.this.panicBoxActionPerformed();
            }
        });
        this.filterPanel.add(this.panicBox);
        this.errorBox = new JCheckBox();
        this.errorBox.setFont(ATKConstant.labelFont);
        this.errorBox.setSelected(true);
        this.errorBox.setText("View error");
        this.errorBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorPanel.this.errorBoxActionPerformed();
            }
        });
        this.filterPanel.add(this.errorBox);
        this.warningBox = new JCheckBox();
        this.warningBox.setFont(ATKConstant.labelFont);
        this.warningBox.setSelected(true);
        this.warningBox.setText("View warning");
        this.warningBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorPanel.this.warningBoxActionPerformed();
            }
        });
        this.filterPanel.add(this.warningBox);
        JLabel jLabel = new JLabel("  View source");
        jLabel.setFont(ATKConstant.labelFont);
        this.filterPanel.add(jLabel);
        this.sourceCombo = new JComboBox();
        this.sourceCombo.setFont(ATKConstant.labelFont);
        this.sourceCombo.addItem("All");
        this.filterPanel.add(this.sourceCombo);
        this.sourceCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorPanel.this.sourceComboActionPerformed();
            }
        });
        jLabel = new JLabel("  Sort by");
        jLabel.setFont(ATKConstant.labelFont);
        this.filterPanel.add(jLabel);
        this.sortCombo = new JComboBox();
        this.sortCombo.setFont(ATKConstant.labelFont);
        this.sortCombo.addItem("No sort");
        this.sortCombo.addItem("Time");
        this.sortCombo.addItem("Severity");
        this.sortCombo.addItem("Source");
        this.sortCombo.addItem("Description");
        this.filterPanel.add(this.sortCombo);
        this.sortCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorPanel.this.sortComboActionPerformed();
            }
        });
        this.add((Component)this.filterPanel, "South");
        this.errorTable = new JTable(this.errorAdapter);
        this.errorTable.setPreferredScrollableViewportSize(new Dimension(600, 300));
        this.errorTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ErrorPanel.this.errorTableMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ErrorPanel.this.errorTableMouseReleased(mouseEvent);
            }
        });
        this.errorTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                ErrorPanel.this.errorTableColumnClicked(tableColumnModelEvent.getFromIndex());
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        this.tableView = new JScrollPane(this.errorTable);
        this.tableView.setVerticalScrollBarPolicy(22);
        this.errorTree = new ErrorTree();
        this.errorView = new JScrollPane(this.errorTree);
        this.errorView.setPreferredSize(new Dimension(230, 300));
        this.errorSplitPane = new JSplitPane(1);
        this.errorSplitPane.add(this.tableView);
        this.errorSplitPane.add(this.errorView);
        this.errorSplitPane.setDividerSize(4);
        this.add((Component)this.errorSplitPane, "Center");
        this.stackText = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.stackText);
        this.stackFrame = new JFrame("Java Stack View");
        this.stackFrame.setContentPane(jScrollPane);
        this.sizeColumns();
    }

    private void sortComboActionPerformed() {
        int n = this.sortCombo.getSelectedIndex();
        this.errorAdapter.setSortedColumn(n - 1);
    }

    private void sourceComboActionPerformed() {
        if (!this.sourceComboUpdate) {
            int n = this.sourceCombo.getSelectedIndex();
            this.selectedSource = n >= 1 ? this.sourceCombo.getSelectedItem().toString() : null;
            this.errorAdapter.setSourceFilter(this.selectedSource);
        }
    }

    private void panicBoxActionPerformed() {
        this.errorAdapter.showPanic(this.panicBox.isSelected());
    }

    private void errorBoxActionPerformed() {
        this.errorAdapter.showError(this.errorBox.isSelected());
    }

    private void warningBoxActionPerformed() {
        this.errorAdapter.showWarning(this.warningBox.isSelected());
    }

    private void clearButtonActionPerformed() {
        this.errorAdapter.clearError();
    }

    private void stopButtonActionPerformed() {
        this.stopped = this.stopButton.getText().equals("Stop");
        if (this.stopped) {
            this.stopButton.setText("Resume");
            this.stopButton.setToolTipText("Restarts updating");
        } else {
            this.stopButton.setText("Stop");
            this.stopButton.setToolTipText("Stops updating");
        }
    }

    private void showItemActionPerformed() {
        this.errorTree.addErrors(this.errorAdapter.getErrorNumber(this.selectedRow));
        this.selectedRow = -1;
    }

    private void showJavaStackActionPerformed() {
        Throwable throwable = this.errorAdapter.getErrorAt(this.selectedRow);
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(throwable.getClass() + "\n at\n");
        int n = 0;
        while (n < stackTraceElementArray.length) {
            stringBuffer.append(stackTraceElementArray[n]);
            stringBuffer.append('\n');
            ++n;
        }
        this.stackText.setText(stringBuffer.toString());
        ATKGraphicsUtils.centerFrameOnScreen(this.stackFrame);
        this.stackFrame.setVisible(true);
    }

    private void stopItemActionPerformed() {
        this.stopped = true;
        this.stopButton.setText("Resume");
        this.stopButton.setToolTipText("Restarts updating");
    }

    private void startItemActionPerformed() {
        this.stopped = false;
        this.stopButton.setText("Stop");
        this.stopButton.setToolTipText("Stops updating");
    }

    private void errorTableColumnClicked(int n) {
        this.sortCombo.setSelectedIndex(n + 1);
    }

    private void errorTableMouseClicked(MouseEvent mouseEvent) {
        this.selectedRow = this.errorTable.getSelectedRow();
        if (this.selectedRow != -1 && mouseEvent.isPopupTrigger()) {
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void errorTableMouseReleased(MouseEvent mouseEvent) {
        this.errorTableMouseClicked(mouseEvent);
    }

    private void errorTableMousePressed(MouseEvent mouseEvent) {
        this.errorTableMouseClicked(mouseEvent);
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (this.stopped) {
            return;
        }
        this.errorAdapter.addError(errorEvent);
    }

    public void setErrorOccured(ErrorEvent errorEvent) {
        if (this.stopped) {
            return;
        }
        this.errorAdapter.addError(errorEvent);
    }

    public void sourceChange() {
        int n = -1;
        this.sourceComboUpdate = true;
        Vector vector = this.errorAdapter.getAllSource();
        this.sourceCombo.removeAllItems();
        this.sourceCombo.addItem("All");
        int n2 = 0;
        while (n2 < vector.size()) {
            if (this.selectedSource != null && this.selectedSource.equalsIgnoreCase((String)vector.get(n2))) {
                n = n2;
            }
            this.sourceCombo.addItem(vector.get(n2));
            ++n2;
        }
        if (n == -1) {
            this.selectedSource = null;
            this.errorAdapter.setSourceFilter(this.selectedSource);
        }
        this.sourceCombo.setSelectedIndex(n + 1);
        this.sourceComboUpdate = false;
    }

    private void sizeColumns() {
        this.errorTable.getColumnModel().getColumn(0).setMaxWidth(70);
        this.errorTable.getColumnModel().getColumn(1).setMaxWidth(60);
        this.errorTable.getColumnModel().getColumn(2).setMinWidth(150);
        this.errorTable.getColumnModel().getColumn(3).setMinWidth(300);
    }
}

