/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.command.StringVoidCommand;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OptionComboCommandViewer
extends JPanel
implements ActionListener,
IErrorListener {
    private JComboBox jComboBox;
    private JLabel jLabel;
    private DefaultComboBoxModel comboModel = null;
    private String defActionCmd = "userActionCmd";
    private Font theFont;
    private ICommand model = null;
    private String[] optionList = new String[]{"None"};
    private String title = null;

    public OptionComboCommandViewer() {
        if (this.title == null) {
            this.title = new String("no title");
        }
        this.theFont = new Font("Dialog", 0, 14);
        this.initComponents();
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.jComboBox.setModel(this.comboModel);
        this.jComboBox.setActionCommand(this.defActionCmd);
    }

    public OptionComboCommandViewer(String string) {
        this.title = string;
        if (this.title == null) {
            this.title = new String("no title");
        }
        this.theFont = new Font("Dialog", 0, 14);
        this.initComponents();
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.jComboBox.setModel(this.comboModel);
        this.jComboBox.setActionCommand(this.defActionCmd);
    }

    private void initComponents() {
        this.jLabel = new JLabel();
        this.jComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.jLabel.setText(this.title);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 2);
        this.add((Component)this.jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.jComboBox, gridBagConstraints);
        this.jComboBox.addActionListener(this);
    }

    public void enableExecution() {
        this.jComboBox.setActionCommand(this.defActionCmd);
    }

    public void disableExecution() {
        this.jComboBox.setActionCommand("dummy");
    }

    public Font getTheFont() {
        return this.theFont;
    }

    public void setTheFont(Font font) {
        if (font != null) {
            this.theFont = font;
            this.jLabel.setFont(this.theFont);
            this.jComboBox.setFont(this.theFont);
        }
    }

    public ICommand getModel() {
        return this.model;
    }

    public void setModel(ICommand iCommand) {
        if (this.model != null) {
            this.model.removeErrorListener((IErrorListener)this);
            this.model = null;
        }
        if (iCommand != null && iCommand instanceof StringVoidCommand) {
            this.model = iCommand;
            this.model.addErrorListener((IErrorListener)this);
        }
    }

    public void clearModel() {
        this.setModel(null);
    }

    public String[] getOptionList() {
        return this.optionList;
    }

    public void setOptionList(String[] stringArray) {
        DefaultComboBoxModel<String> defaultComboBoxModel = null;
        if (stringArray == null) {
            String[] stringArray2 = new String[]{"None"};
            this.optionList = stringArray2;
        } else {
            this.optionList = stringArray;
        }
        defaultComboBoxModel = new DefaultComboBoxModel<String>(this.optionList);
        this.jComboBox.setModel(defaultComboBoxModel);
        this.comboModel = defaultComboBoxModel;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string == null ? new String("no title") : string;
        this.jLabel.setText(this.title);
    }

    public int getSelectedIndex() {
        return this.jComboBox.getSelectedIndex();
    }

    public void setSelectedIndex(int n) throws IllegalArgumentException {
        this.jComboBox.setSelectedIndex(n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = null;
        String string = null;
        Vector<String> vector = new Vector<String>();
        jComboBox = (JComboBox)actionEvent.getSource();
        string = (String)jComboBox.getSelectedItem();
        if (!actionEvent.getActionCommand().equals(this.defActionCmd)) {
            this.jComboBox.setActionCommand(this.defActionCmd);
            return;
        }
        if (string == null) {
            return;
        }
        if (this.model == null) {
            return;
        }
        vector.add(0, string);
        this.model.execute(vector);
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (errorEvent.getSource() == this.model) {
            JOptionPane.showMessageDialog(this, "Failed to execute command:\n" + errorEvent.getError().getMessage());
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"ext", "imm", "bus"};
        CommandList commandList = new CommandList();
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        OptionComboCommandViewer optionComboCommandViewer = new OptionComboCommandViewer();
        optionComboCommandViewer.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(optionComboCommandViewer);
        try {
            IEntity iEntity = commandList.add("sr/Agilent_4395a/1/SetTriggerSource");
            if (iEntity instanceof StringVoidCommand) {
                System.out.println("Oui c'est un stringVoid command");
            } else {
                System.out.println("Desolee ce n'est pas un stringVoid command");
            }
            if (iEntity instanceof ICommand) {
                ICommand iCommand = (ICommand)iEntity;
                optionComboCommandViewer.setModel(iCommand);
                optionComboCommandViewer.setOptionList(stringArray2);
                optionComboCommandViewer.setTitle(iCommand.getNameSansDevice());
            }
        }
        catch (Exception exception) {
            System.out.println("Cannot connect to sr/agilent/1/SetTriggerSource");
        }
        jFrame.setContentPane(jPanel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

