/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import com.braju.format.Format;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.attribute.NumberScalar;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JProgressBar;

public class NumberScalarProgressBar
extends JProgressBar
implements INumberScalarListener {
    protected INumberScalar nsModel = null;
    protected int min = -1;
    protected int max = -1;
    protected boolean printVal = true;
    protected String nsDispFormat = null;

    public NumberScalarProgressBar() {
        this.setStringPainted(true);
        this.setIndeterminate(true);
    }

    public INumberScalar getNsModel() {
        return this.nsModel;
    }

    public void setNsModel(INumberScalar iNumberScalar) {
        if (this.nsModel != null) {
            this.nsModel.removeNumberScalarListener((INumberScalarListener)this);
            this.nsModel = null;
        }
        this.progressString = null;
        this.setIndeterminate(true);
        this.nsDispFormat = null;
        this.min = -1;
        this.max = -1;
        if (iNumberScalar == null) {
            return;
        }
        this.nsModel = iNumberScalar;
        if (this.nsModel instanceof NumberScalar) {
            NumberScalar numberScalar = (NumberScalar)this.nsModel;
            double d = numberScalar.getMinValue();
            double d2 = numberScalar.getMaxValue();
            double d3 = numberScalar.getNumberScalarValue();
            this.min = (int)d;
            this.max = (int)d2;
            if (this.min == this.max && this.min < 0) {
                this.min = -1;
                this.max = -1;
            } else {
                this.setMinimum(this.min);
                this.setMaximum(this.max);
            }
            this.nsDispFormat = this.nsModel.getProperty("format").getPresentation();
            int n = (int)d3;
            this.setValue(n);
            this.setIndeterminate(false);
            if (this.printVal) {
                this.progressString = this.getDisplayString(d3);
            }
        }
        this.nsModel.addNumberScalarListener((INumberScalarListener)this);
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int n) {
        this.min = n;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int n) {
        this.max = n;
    }

    public boolean getPrintVal() {
        return this.printVal;
    }

    public void setPrintVal(boolean bl) {
        this.printVal = bl;
        if (!this.printVal) {
            this.progressString = null;
        }
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        double d = numberScalarEvent.getValue();
        int n = (int)d;
        this.setValue(n);
        if (this.printVal) {
            this.progressString = this.getDisplayString(d);
        }
    }

    protected String getDisplayString(double d) {
        Double d2 = new Double(d);
        Object[] objectArray = new Object[]{d2};
        try {
            if (this.nsDispFormat == null) {
                String string = Format.sprintf((String)"%3.0f", (Object[])objectArray);
                return string;
            }
            if (this.nsDispFormat.equalsIgnoreCase("Not Specified")) {
                String string = Format.sprintf((String)"%3.0f", (Object[])objectArray);
                return string;
            }
            if (this.nsDispFormat.indexOf(37) < 0) {
                String string = Format.sprintf((String)"%3.0f", (Object[])objectArray);
                return string;
            }
            String string = Format.sprintf((String)this.nsDispFormat, (Object[])objectArray);
            return string;
        }
        catch (Exception exception) {
            return "Exception while formating";
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public static void main(String[] stringArray) {
        Object object;
        AttributeList attributeList = new AttributeList();
        NumberScalarProgressBar numberScalarProgressBar = new NumberScalarProgressBar();
        try {
            object = (INumberScalar)attributeList.add("elin/gun/aux/Temporization");
            numberScalarProgressBar.setNsModel((INumberScalar)object);
            numberScalarProgressBar.setPrintVal(true);
            attributeList.startRefresher();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        object = new JFrame();
        ((JFrame)object).getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        ((JFrame)object).getContentPane().add((Component)numberScalarProgressBar, gridBagConstraints);
        ((Window)object).pack();
        ((Window)object).show();
    }

    public String toString() {
        return "{NumberScalarProgressBar}";
    }
}

