/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import com.braju.format.Format;
import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.NumberImageEvent;
import fr.esrf.tangoatk.widget.attribute.IRoiListener;
import fr.esrf.tangoatk.widget.attribute.RoiEvent;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.image.LineProfilerViewer;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.JGradientEditor;
import fr.esrf.tangoatk.widget.util.JImage;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import fr.esrf.tangoatk.widget.util.JTableRow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;

public class NumberImageViewer
extends JPanel
implements IImageListener,
MouseMotionListener,
MouseListener,
ActionListener,
KeyListener {
    INumberImage model;
    private double[][] doubleValues = null;
    private Rectangle oldSelection = null;
    private int profileMode;
    private boolean showingMenu;
    private boolean snapToGrid;
    private boolean sigHistogram;
    private boolean isNegative;
    private int startHisto;
    private Gradient gColor;
    private int[] gColormap;
    private int iSz;
    private EventListenerList listenerList;
    private Insets noMargin = new Insets(0, 0, 0, 0);
    private boolean autoZoom = false;
    private boolean firstRefresh = false;
    private boolean isBestFit;
    private boolean autoBestFit;
    private double bfMin = 0.0;
    private double bfMax = 65536.0;
    private double autoBfMin;
    private double autoBfMax;
    private double bfa0;
    private double bfa1;
    private double curSelMin;
    private double curSelMax;
    private JImage imagePanel;
    private JScrollPane imageView;
    private JPanel buttonPanel;
    private JButton selectButton;
    private JButton selectMaxButton;
    private JButton fileButton;
    private JButton zoomButton;
    private JButton tableButton;
    private JButton profileButton;
    private JButton histoButton;
    private JButton settingsButton;
    private Font panelFont;
    private JPanel cfgPanel;
    private JLabel statusLabel;
    private JLabel minMaxLabel;
    private JLabel selLabel;
    private JTextField selText;
    private JPopupMenu imgMenu;
    private JMenuItem infoMenuItem;
    private JCheckBoxMenuItem bestFitMenuItem;
    private JCheckBoxMenuItem snapToGridMenuItem;
    private JCheckBoxMenuItem negativeMenuItem;
    private JCheckBoxMenuItem toolbarMenuItem;
    private JCheckBoxMenuItem statusLineMenuItem;
    private JMenuItem selectionMenuItem;
    private JMenuItem selectionMaxMenuItem;
    private JMenuItem fileMenuItem;
    private JMenuItem zoomMenuItem;
    private JMenuItem tableMenuItem;
    private JMenuItem lineProfileMenuItem;
    private JMenuItem histogramMenuItem;
    private JMenuItem settingsMenuItem;
    private LineProfilerViewer lineProfiler = null;
    private JFrame zoomDialog = null;
    private JPanel zoomPanel;
    private JScrollPane zoomView;
    private JImage zoomImage;
    private JPanel zoomCfgPanel;
    private JComboBox zoomCombo;
    private int zoomFactor;
    private int zoomXOrg;
    private int zoomYOrg;
    private JLabel zoomText;
    private JDialog settingsDialog = null;
    private JPanel settingsPanel;
    private LabelViewer attNameLabel;
    private JButton propButton;
    private JCheckBox sigHistogramCheck;
    private JCheckBox bestFitCheck;
    private JCheckBox autoBestFitCheck;
    private JLabel minBestFitLabel;
    private JTextField minBestFitText;
    private JLabel maxBestFitLabel;
    private JTextField maxBestFitText;
    private JCheckBox snapToGridCheck;
    private JLabel snapToGridLabel;
    private JTextField snapToGridText;
    private JCheckBox negativeCheck;
    private JComboBox imageSizeCombo;
    private JLabel imageSizeLabel;
    private JGradientEditor gradViewer;
    private JButton gradButton;
    private JLabel gradLabel;
    private JButton okButton;
    private JButton cancelButton;
    private JFrame tableDialog = null;
    private JTableRow tablePanel;
    SimplePropertyFrame propDialog = null;
    static /* synthetic */ Class class$fr$esrf$tangoatk$widget$attribute$IRoiListener;

    public NumberImageViewer() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.imagePanel = new JImage();
        this.imagePanel.setBorder(null);
        this.imagePanel.setSnapGrid(8);
        this.imageView = new JScrollPane(this.imagePanel);
        this.add((Component)this.imageView, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(null);
        this.buttonPanel.setPreferredSize(new Dimension(40, 0));
        this.add((Component)this.buttonPanel, "West");
        this.selectButton = new JButton();
        this.selectButton.setMargin(null);
        this.selectButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_select.gif")));
        this.selectButton.setBounds(2, 5, 36, 36);
        this.selectButton.setToolTipText("Free selection");
        this.selectButton.addActionListener(this);
        this.buttonPanel.add(this.selectButton);
        this.selectMaxButton = new JButton();
        this.selectMaxButton.setMargin(null);
        this.selectMaxButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_selectmax.gif")));
        this.selectMaxButton.setBounds(2, 45, 36, 36);
        this.selectMaxButton.setToolTipText("Select whole image");
        this.selectMaxButton.addActionListener(this);
        this.buttonPanel.add(this.selectMaxButton);
        this.fileButton = new JButton();
        this.fileButton.setMargin(null);
        this.fileButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_snapshot.gif")));
        this.fileButton.setBounds(2, 85, 36, 36);
        this.fileButton.setToolTipText("Save snapshot");
        this.fileButton.addActionListener(this);
        this.buttonPanel.add(this.fileButton);
        this.zoomButton = new JButton();
        this.zoomButton.setMargin(null);
        this.zoomButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_zoom.gif")));
        this.zoomButton.setBounds(2, 125, 36, 36);
        this.zoomButton.setToolTipText("Zoom selection");
        this.zoomButton.addActionListener(this);
        this.buttonPanel.add(this.zoomButton);
        this.tableButton = new JButton();
        this.tableButton.setMargin(null);
        this.tableButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_table.gif")));
        this.tableButton.setBounds(2, 165, 36, 36);
        this.tableButton.setToolTipText("Selection to table");
        this.tableButton.addActionListener(this);
        this.buttonPanel.add(this.tableButton);
        this.profileButton = new JButton();
        this.profileButton.setMargin(null);
        this.profileButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_profile.gif")));
        this.profileButton.setBounds(2, 210, 36, 36);
        this.profileButton.setToolTipText("Line profile");
        this.profileButton.addActionListener(this);
        this.buttonPanel.add(this.profileButton);
        this.histoButton = new JButton();
        this.histoButton.setMargin(null);
        this.histoButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_histo.gif")));
        this.histoButton.setBounds(2, 245, 36, 36);
        this.histoButton.setToolTipText("Histogram");
        this.histoButton.addActionListener(this);
        this.buttonPanel.add(this.histoButton);
        this.settingsButton = new JButton();
        this.settingsButton.setMargin(null);
        this.settingsButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_option.gif")));
        this.settingsButton.setBounds(2, 290, 36, 36);
        this.settingsButton.setToolTipText("Image viewer settings");
        this.settingsButton.addActionListener(this);
        this.buttonPanel.add(this.settingsButton);
        this.cfgPanel = new JPanel();
        this.cfgPanel.setLayout(null);
        this.cfgPanel.setPreferredSize(new Dimension(0, 25));
        this.add((Component)this.cfgPanel, "South");
        this.panelFont = new Font("Dialog", 0, 11);
        this.statusLabel = new JLabel("");
        this.statusLabel.setFont(this.panelFont);
        this.statusLabel.setBounds(5, 3, 220, 20);
        this.cfgPanel.add(this.statusLabel);
        this.minMaxLabel = new JLabel("");
        this.minMaxLabel.setFont(this.panelFont);
        this.minMaxLabel.setBounds(230, 3, 160, 20);
        this.cfgPanel.add(this.minMaxLabel);
        this.selLabel = new JLabel("Selection");
        this.selLabel.setFont(this.panelFont);
        this.selLabel.setBounds(390, 3, 55, 20);
        this.cfgPanel.add(this.selLabel);
        this.selText = new JTextField("None");
        this.selText.setMargin(this.noMargin);
        this.selText.setFont(this.panelFont);
        this.selText.setBounds(450, 3, 160, 20);
        this.selText.addKeyListener(this);
        this.cfgPanel.add(this.selText);
        this.imgMenu = new JPopupMenu();
        this.infoMenuItem = new JMenuItem("Image Viewer");
        this.infoMenuItem.setEnabled(false);
        this.bestFitMenuItem = new JCheckBoxMenuItem("Best fit");
        this.bestFitMenuItem.addActionListener(this);
        this.snapToGridMenuItem = new JCheckBoxMenuItem("Align to grid");
        this.snapToGridMenuItem.addActionListener(this);
        this.negativeMenuItem = new JCheckBoxMenuItem("Negative image");
        this.negativeMenuItem.addActionListener(this);
        this.toolbarMenuItem = new JCheckBoxMenuItem("Show toolbar");
        this.toolbarMenuItem.addActionListener(this);
        this.statusLineMenuItem = new JCheckBoxMenuItem("Show status line");
        this.statusLineMenuItem.addActionListener(this);
        this.selectionMenuItem = new JMenuItem("Free selection");
        this.selectionMenuItem.addActionListener(this);
        this.selectionMaxMenuItem = new JMenuItem("Select all");
        this.selectionMaxMenuItem.addActionListener(this);
        this.lineProfileMenuItem = new JMenuItem("Line profile");
        this.lineProfileMenuItem.addActionListener(this);
        this.histogramMenuItem = new JMenuItem("Histogram");
        this.histogramMenuItem.addActionListener(this);
        this.fileMenuItem = new JMenuItem("Save selection");
        this.fileMenuItem.addActionListener(this);
        this.zoomMenuItem = new JMenuItem("Zoom selection");
        this.zoomMenuItem.addActionListener(this);
        this.settingsMenuItem = new JMenuItem("Settings");
        this.settingsMenuItem.addActionListener(this);
        this.tableMenuItem = new JMenuItem("Selection to table");
        this.tableMenuItem.addActionListener(this);
        this.imgMenu.add(this.infoMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.bestFitMenuItem);
        this.imgMenu.add(this.negativeMenuItem);
        this.imgMenu.add(this.snapToGridMenuItem);
        this.imgMenu.add(this.toolbarMenuItem);
        this.imgMenu.add(this.statusLineMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.selectionMenuItem);
        this.imgMenu.add(this.selectionMaxMenuItem);
        this.imgMenu.add(this.fileMenuItem);
        this.imgMenu.add(this.zoomMenuItem);
        this.imgMenu.add(this.tableMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.lineProfileMenuItem);
        this.imgMenu.add(this.histogramMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.settingsMenuItem);
        this.imagePanel.addMouseMotionListener(this);
        this.imagePanel.addMouseListener(this);
        this.isBestFit = false;
        this.setAlignToGrid(true);
        this.autoBestFit = true;
        this.sigHistogram = false;
        this.isNegative = false;
        this.showingMenu = true;
        this.curSelMin = 65536.0;
        this.curSelMax = 0.0;
        this.startHisto = 0;
        this.zoomFactor = 0;
        this.gColor = new Gradient();
        this.gColormap = this.gColor.buildColorMap(65536);
        this.iSz = 1;
        this.listenerList = new EventListenerList();
    }

    public void addRoiListener(IRoiListener iRoiListener) {
        this.listenerList.add(class$fr$esrf$tangoatk$widget$attribute$IRoiListener == null ? (class$fr$esrf$tangoatk$widget$attribute$IRoiListener = NumberImageViewer.class$("fr.esrf.tangoatk.widget.attribute.IRoiListener")) : class$fr$esrf$tangoatk$widget$attribute$IRoiListener, iRoiListener);
    }

    public void removeRoiListener(IRoiListener iRoiListener) {
        this.listenerList.remove(class$fr$esrf$tangoatk$widget$attribute$IRoiListener == null ? (class$fr$esrf$tangoatk$widget$attribute$IRoiListener = NumberImageViewer.class$("fr.esrf.tangoatk.widget.attribute.IRoiListener")) : class$fr$esrf$tangoatk$widget$attribute$IRoiListener, iRoiListener);
    }

    public void fireRoiChange() {
        IRoiListener[] iRoiListenerArray = (IRoiListener[])this.listenerList.getListeners(class$fr$esrf$tangoatk$widget$attribute$IRoiListener == null ? (class$fr$esrf$tangoatk$widget$attribute$IRoiListener = NumberImageViewer.class$("fr.esrf.tangoatk.widget.attribute.IRoiListener")) : class$fr$esrf$tangoatk$widget$attribute$IRoiListener);
        RoiEvent roiEvent = new RoiEvent(this, this.getSelection());
        int n = 0;
        while (n < iRoiListenerArray.length) {
            iRoiListenerArray[n].roiChange(roiEvent);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBestFit(boolean bl) {
        this.isBestFit = bl;
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isBestFit() {
        return this.isBestFit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoBestFit(boolean bl) {
        this.autoBestFit = bl;
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isAutoBestFit() {
        return this.autoBestFit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBestFitMinMax(double d, double d2) {
        if (d < d2) {
            this.bfMin = d;
            this.bfMax = d2;
        }
        if (!this.autoBestFit) {
            NumberImageViewer numberImageViewer = this;
            synchronized (numberImageViewer) {
                this.convertImage();
                if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                    this.buildZoom();
                }
            }
        }
    }

    public double getBestFitMin() {
        return this.bfMin;
    }

    public double getBestFitMax() {
        return this.bfMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGradient(Gradient gradient) {
        this.gColor = gradient;
        this.gColormap = gradient.buildColorMap(65536);
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public Gradient getGradient() {
        return this.gColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNegative(boolean bl) {
        this.isNegative = bl;
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public void setAlignToGrid(boolean bl) {
        this.snapToGrid = bl;
        this.imagePanel.setSnapToGrid(bl);
    }

    public boolean isAlignToGrid() {
        return this.snapToGrid;
    }

    public void setToolbarVisible(boolean bl) {
        this.buttonPanel.setVisible(bl);
    }

    public boolean isToolbarVisible() {
        return this.buttonPanel.isVisible();
    }

    public void setStatusLineVisible(boolean bl) {
        this.cfgPanel.setVisible(bl);
    }

    public boolean isStatusLineVisible() {
        return this.cfgPanel.isVisible();
    }

    public void setShowingMenu(boolean bl) {
        this.showingMenu = bl;
    }

    public void setZoom(int n) {
        switch (n) {
            case 0: {
                this.iSz = -4;
                break;
            }
            case 1: {
                this.iSz = -2;
                break;
            }
            case 2: {
                this.iSz = 1;
                break;
            }
            case 3: {
                this.iSz = 2;
                break;
            }
            case 4: {
                this.iSz = 4;
                break;
            }
            case 5: {
                this.iSz = 8;
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this, "NumberImageViewer.setZoom():\nInvalid zoom index value. [0..5]", "Error", 0);
                this.iSz = 1;
                n = 2;
            }
        }
        if (this.iSz < 0) {
            this.imagePanel.setMarkerScale(-this.iSz);
        } else {
            this.imagePanel.setMarkerScale(1.0 / (double)this.iSz);
        }
    }

    public int getZoom() {
        int n = 0;
        switch (this.iSz) {
            case -4: {
                n = 0;
                break;
            }
            case -2: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 8: {
                n = 5;
            }
        }
        return n;
    }

    public void setAutoZoom(boolean bl) {
        this.autoZoom = bl;
    }

    public boolean getAutoZoom() {
        return this.autoZoom;
    }

    public boolean isShowingMenu() {
        return this.showingMenu;
    }

    public Insets getImageMargin() {
        return this.imagePanel.getMargin();
    }

    public void setImageMargin(Insets insets) {
        this.imagePanel.setMargin(insets);
    }

    public Dimension getCurrentImageSize() {
        if (this.doubleValues == null) {
            return new Dimension(0, 0);
        }
        int n = this.doubleValues.length;
        if (n == 0) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.doubleValues[0].length, n);
    }

    public void setSelectionEnabled(boolean bl) {
        this.imagePanel.setSelectionEnabled(bl);
    }

    public boolean isSelectionEnabled() {
        return this.imagePanel.isSelectionEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(Rectangle rectangle) {
        this.divRect(rectangle);
        this.imagePanel.setSelection(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.refreshComponents();
        }
    }

    public Rectangle getSelection() {
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle != null) {
            this.mulRect(rectangle);
        }
        return rectangle;
    }

    public int getSelectionMode() {
        return this.imagePanel.getSelectionMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectionMode(int n) {
        this.imagePanel.clearSelection();
        this.imagePanel.setSelectionMode(n);
        this.freePopup();
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.refreshStatusLine();
            this.refreshSelectionMinMax();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(double[][] dArray) {
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.doubleValues = dArray;
            this.computeAutoZoom();
            this.convertImage();
            this.refreshComponents();
        }
        if (this.doubleValues == null) {
            this.imagePanel.setImage(null);
            this.freePopup();
            this.imageView.revalidate();
        }
    }

    public void loadImage(String string) throws IOException {
        File file = new File(string);
        BufferedImage bufferedImage = ImageIO.read(file);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n];
        double[][] dArray = new double[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            bufferedImage.getRGB(0, n3, n, 1, nArray, 0, n);
            int n4 = 0;
            while (n4 < n) {
                dArray[n3][n4] = (nArray[n4] & 0xFF00) >> 8;
                ++n4;
            }
            ++n3;
        }
        this.setData(dArray);
    }

    public int addCrossMarker(int n, int n2, Color color) {
        return this.imagePanel.addCrossMarker(n, n2, color);
    }

    public int addRectangleMarker(int n, int n2, int n3, int n4, Color color) {
        return this.imagePanel.addRectangleMarker(n, n2, n3, n4, color);
    }

    public void setMarkerPos(int n, int n2, int n3, int n4, int n5) {
        this.imagePanel.setMarkerPos(n, n2, n3, n4, n5);
    }

    public void clearMarkers() {
        this.imagePanel.clearMarkers();
    }

    public boolean hasMarker() {
        return this.imagePanel.getMarkerNumber() > 0;
    }

    private void mulRect(Rectangle rectangle) {
        if (this.iSz < 0) {
            rectangle.x /= -this.iSz;
            rectangle.y /= -this.iSz;
            rectangle.width /= -this.iSz;
            rectangle.height /= -this.iSz;
        } else {
            rectangle.x *= this.iSz;
            rectangle.y *= this.iSz;
            rectangle.width *= this.iSz;
            rectangle.height *= this.iSz;
        }
    }

    private void divRect(Rectangle rectangle) {
        if (this.iSz < 0) {
            rectangle.x *= -this.iSz;
            rectangle.y *= -this.iSz;
            rectangle.width *= -this.iSz;
            rectangle.height *= -this.iSz;
        } else {
            rectangle.x /= this.iSz;
            rectangle.y /= this.iSz;
            rectangle.width /= this.iSz;
            rectangle.height /= this.iSz;
        }
    }

    private void mulPoint(Point point) {
        boolean bl = false;
        boolean bl2 = false;
        Dimension dimension = this.getCurrentImageSize();
        if (this.iSz < 0) {
            point.x /= -this.iSz;
            point.y /= -this.iSz;
        } else {
            if (point.x == dimension.width / this.iSz - 1) {
                point.x = dimension.width - 1;
                bl = true;
            }
            if (point.y == dimension.height / this.iSz - 1) {
                point.y = dimension.height - 1;
                bl2 = true;
            }
            if (!bl) {
                point.x *= this.iSz;
            }
            if (!bl2) {
                point.y *= this.iSz;
            }
        }
    }

    private void freePopup() {
        if (this.lineProfiler != null) {
            this.lineProfiler.setData(null);
        }
        if (this.zoomDialog != null) {
            this.zoomImage.setImage(null);
        }
        if (this.tableDialog != null) {
            this.tablePanel.clearData();
        }
    }

    private double[] buildProfileData() {
        Dimension dimension = this.getCurrentImageSize();
        Point[] pointArray = this.imagePanel.getSelectionPoint();
        if (pointArray != null) {
            double[] dArray;
            this.mulPoint(pointArray[0]);
            this.mulPoint(pointArray[1]);
            int n = pointArray[1].x - pointArray[0].x;
            int n2 = pointArray[1].y - pointArray[0].y;
            int n3 = Math.abs(n);
            int n4 = Math.abs(n2);
            if (n3 > n4) {
                double d = (double)n2 / (double)n3;
                dArray = new double[n3 + 1];
                int n5 = pointArray[0].x;
                int n6 = 0;
                while (n6 <= n3) {
                    int n7 = pointArray[0].y + (int)(d * (double)n6);
                    dArray[n6] = n5 >= 0 && n5 < dimension.width && n7 >= 0 && n7 < dimension.height ? this.doubleValues[n7][n5] : Double.NaN;
                    n5 = n < 0 ? --n5 : ++n5;
                    ++n6;
                }
            } else {
                double d = (double)n / (double)n4;
                dArray = new double[n4 + 1];
                int n8 = pointArray[0].y;
                int n9 = 0;
                while (n9 <= n4) {
                    int n10 = pointArray[0].x + (int)(d * (double)n9);
                    dArray[n9] = n10 >= 0 && n10 < dimension.width && n8 >= 0 && n8 < dimension.height ? this.doubleValues[n8][n10] : Double.NaN;
                    n8 = n2 < 0 ? --n8 : ++n8;
                    ++n9;
                }
            }
            return dArray;
        }
        return null;
    }

    private double[] buildHistogramData() {
        if (this.doubleValues == null) {
            return null;
        }
        double[] dArray = new double[65536];
        this.startHisto = 0;
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle != null) {
            int n;
            this.mulRect(rectangle);
            int n2 = 0;
            while (n2 < 65536) {
                dArray[n2] = 0.0;
                ++n2;
            }
            try {
                n2 = rectangle.x;
                while (n2 < rectangle.x + rectangle.width) {
                    n = rectangle.y;
                    while (n < rectangle.y + rectangle.height) {
                        int n3 = (int)this.doubleValues[n][n2];
                        dArray[n3] = dArray[n3] + 1.0;
                        ++n;
                    }
                    ++n2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("NumberImageViewer.buildHistogramData() : Cannot build histogram. One or more value exceed the range [0..65535].");
                return null;
            }
            if (!this.sigHistogram) {
                return dArray;
            }
            n = 0;
            int n4 = 65535;
            boolean bl = false;
            while (n < 65536 && !bl) {
                boolean bl2 = bl = dArray[n] > 0.0;
                if (bl) continue;
                ++n;
            }
            bl = false;
            while (n4 >= 0 && !bl) {
                boolean bl3 = bl = dArray[n4] > 0.0;
                if (bl) continue;
                --n4;
            }
            int n5 = n4 - n + 1;
            double[] dArray2 = new double[n5];
            n2 = 0;
            while (n2 < n5) {
                dArray2[n2] = dArray[n + n2];
                ++n2;
            }
            dArray = null;
            this.startHisto = n;
            return dArray2;
        }
        return null;
    }

    private void refreshLineProfile() {
        if (this.lineProfiler != null && this.lineProfiler.isVisible() && this.profileMode > 0) {
            switch (this.profileMode) {
                case 1: {
                    this.lineProfiler.setData(this.buildProfileData());
                    break;
                }
                case 2: {
                    double[] dArray = this.buildHistogramData();
                    if (dArray != null) {
                        this.lineProfiler.setData(dArray, this.startHisto);
                        break;
                    }
                    this.lineProfiler.setData(null);
                }
            }
        }
    }

    private void refreshSelectionMinMax() {
        if (this.doubleValues == null) {
            this.minMaxLabel.setText("");
            return;
        }
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle == null || this.imagePanel.getSelectionMode() != 1) {
            this.minMaxLabel.setText("");
            return;
        }
        this.mulRect(rectangle);
        this.curSelMin = 65536.0;
        this.curSelMax = 0.0;
        int n = rectangle.y;
        while (n < rectangle.y + rectangle.height) {
            int n2 = rectangle.x;
            while (n2 < rectangle.x + rectangle.width) {
                double d = this.doubleValues[n][n2];
                if (d > this.curSelMax) {
                    this.curSelMax = d;
                }
                if (d < this.curSelMin) {
                    this.curSelMin = d;
                }
                ++n2;
            }
            ++n;
        }
        if (this.curSelMin <= this.curSelMax) {
            this.minMaxLabel.setText("Range[" + Double.toString(this.curSelMin) + "," + Double.toString(this.curSelMax) + "]");
        } else {
            this.minMaxLabel.setText("");
        }
    }

    private void refreshComponents() {
        this.refreshStatusLine();
        this.refreshSelectionMinMax();
        this.refreshLineProfile();
        if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
            this.buildZoom();
            this.zoomView.revalidate();
            this.zoomPanel.repaint();
        }
        if (this.tableDialog != null && this.tableDialog.isVisible()) {
            this.buildTable();
            this.tablePanel.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectionChanged() {
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.refreshComponents();
        }
        this.fireRoiChange();
    }

    private void refreshStatusLine() {
        int n = this.imagePanel.getSelectionMode();
        String string = "None";
        switch (n) {
            case 0: {
                Point[] pointArray = this.imagePanel.getSelectionPoint();
                if (pointArray == null) break;
                this.mulPoint(pointArray[0]);
                this.mulPoint(pointArray[1]);
                string = "Line (" + pointArray[0].x + "," + pointArray[0].y + ") - (" + pointArray[1].x + "," + pointArray[1].y + ")";
                break;
            }
            case 1: {
                Rectangle rectangle = this.imagePanel.getSelectionRect();
                if (rectangle == null) break;
                this.mulRect(rectangle);
                string = "Rect (" + rectangle.x + "," + rectangle.y + ") - [" + rectangle.width + "," + rectangle.height + "]";
            }
        }
        this.selText.setText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showZoom() {
        this.constructZoomPanel();
        if (this.zoomDialog.isVisible()) {
            this.zoomDialog.show();
            return;
        }
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            if (!this.buildZoom()) {
                return;
            }
        }
        this.zoomCombo.setSelectedIndex(this.zoomFactor);
        this.zoomText.setText("");
        this.zoomDialog.setTitle("[zoom] ImageViewer");
        this.zoomDialog.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = this.zoomDialog.getPreferredSize();
        this.zoomDialog.setBounds((dimension.width - dimension2.height) / 2, (dimension.height - dimension2.height) / 2, dimension2.width, dimension2.height);
        this.zoomDialog.show();
    }

    private void applySettings() {
        String string = this.minBestFitText.getText();
        String string2 = this.maxBestFitText.getText();
        String string3 = this.snapToGridText.getText();
        this.isBestFit = this.bestFitCheck.isSelected();
        this.autoBestFit = this.autoBestFitCheck.isSelected();
        this.snapToGrid = this.snapToGridCheck.isSelected();
        this.isNegative = this.negativeCheck.isSelected();
        this.sigHistogram = this.sigHistogramCheck.isSelected();
        this.setZoom(this.imageSizeCombo.getSelectedIndex());
        this.setAlignToGrid(this.snapToGrid);
        try {
            int n = Integer.parseInt(string3);
            this.imagePanel.setSnapGrid(n);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Invalid syntax for grid value", "Error", 0);
        }
        if (!this.autoBestFit) {
            try {
                this.bfMin = Double.parseDouble(string);
                this.bfMax = Double.parseDouble(string2);
                if (this.bfMin >= this.bfMax) {
                    JOptionPane.showMessageDialog(null, "maximum  best fit value is lower or equal than minimum!", "Error", 0);
                    this.autoBestFit = true;
                    this.bfMin = 0.0;
                    this.bfMax = 65536.0;
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Invalid syntax for maximum or minimum best fit value", "Error", 0);
                this.autoBestFit = true;
                this.bfMin = 0.0;
                this.bfMax = 65536.0;
            }
        }
        this.settingsDialog.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showSettings() {
        this.constructSettingsPanel();
        this.minBestFitText.setText(Double.toString(this.bfMin));
        this.maxBestFitText.setText(Double.toString(this.bfMax));
        this.minBestFitLabel.setEnabled(!this.autoBestFit);
        this.minBestFitText.setEnabled(!this.autoBestFit);
        this.maxBestFitLabel.setEnabled(!this.autoBestFit);
        this.maxBestFitText.setEnabled(!this.autoBestFit);
        this.bestFitCheck.setSelected(this.isBestFit);
        this.autoBestFitCheck.setSelected(this.autoBestFit);
        this.sigHistogramCheck.setSelected(this.sigHistogram);
        this.snapToGridCheck.setSelected(this.snapToGrid);
        this.negativeCheck.setSelected(this.isNegative);
        this.imageSizeCombo.setSelectedIndex(this.getZoom());
        this.snapToGridText.setText(Integer.toString(this.imagePanel.getSnapGrid()));
        this.settingsDialog.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = this.settingsDialog.getPreferredSize();
        this.settingsDialog.setBounds((dimension.width - dimension2.height) / 2, (dimension.height - dimension2.height) / 2, dimension2.width, dimension2.height);
        this.settingsDialog.setVisible(true);
        this.settingsDialog.dispose();
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            this.refreshComponents();
        }
    }

    private boolean buildTable() {
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle == null) {
            return false;
        }
        this.mulRect(rectangle);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return false;
        }
        String string = null;
        if (this.model != null) {
            string = this.model.getFormat();
        }
        if (string != null && string.length() > 0) {
            if (string.indexOf(37) == -1) {
                Object[][] objectArray = new String[rectangle.height][rectangle.width];
                int n = 0;
                while (n < rectangle.height) {
                    int n2 = 0;
                    while (n2 < rectangle.width) {
                        objectArray[n][n2] = AttrManip.format((String)string, (double)this.doubleValues[rectangle.y + n][rectangle.x + n2]);
                        ++n2;
                    }
                    ++n;
                }
                this.tablePanel.setData(objectArray, rectangle.x, rectangle.y);
            } else {
                Object[] objectArray = new Double[1];
                Object[][] objectArray2 = new String[rectangle.height][rectangle.width];
                int n = 0;
                while (n < rectangle.height) {
                    int n3 = 0;
                    while (n3 < rectangle.width) {
                        objectArray[0] = new Double(this.doubleValues[rectangle.y + n][rectangle.x + n3]);
                        objectArray2[n][n3] = Format.sprintf((String)string, (Object[])objectArray);
                        ++n3;
                    }
                    ++n;
                }
                this.tablePanel.setData(objectArray2, rectangle.x, rectangle.y);
            }
        } else {
            Object[][] objectArray = new Double[rectangle.height][rectangle.width];
            int n = 0;
            while (n < rectangle.height) {
                int n4 = 0;
                while (n4 < rectangle.width) {
                    objectArray[n][n4] = new Double(this.doubleValues[rectangle.y + n][rectangle.x + n4]);
                    ++n4;
                }
                ++n;
            }
            this.tablePanel.setData(objectArray, rectangle.x, rectangle.y);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTable() {
        this.constructTablePanel();
        if (this.tableDialog.isVisible()) {
            this.tableDialog.setVisible(true);
            return;
        }
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            if (!this.buildTable()) {
                return;
            }
        }
        ATKGraphicsUtils.centerFrameOnScreen(this.tableDialog);
        this.tableDialog.setVisible(true);
    }

    private void showPropertyFrame() {
        if (this.model != null) {
            if (this.propDialog == null) {
                this.propDialog = new SimplePropertyFrame(this.settingsDialog, true);
            }
            this.propDialog.setModel((IAttribute)this.model);
            this.propDialog.setVisible(true);
        }
    }

    private void showGradientEditor() {
        Gradient gradient = JGradientEditor.showDialog(this.settingsDialog, this.gColor);
        if (gradient != null) {
            this.gColor = gradient;
            this.gColormap = gradient.buildColorMap(65536);
            this.gradViewer.setGradient(this.gColor);
            this.gradViewer.repaint();
        }
    }

    private void constructLineProfiler() {
        if (this.lineProfiler == null) {
            this.lineProfiler = new LineProfilerViewer();
            this.lineProfiler.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    NumberImageViewer.this.lineProfiler.setData(null);
                    NumberImageViewer.this.lineProfiler.dispose();
                }
            });
        }
    }

    private void constructTablePanel() {
        if (this.tableDialog == null) {
            this.tablePanel = new JTableRow();
            this.tableDialog = new JFrame();
            this.tableDialog.setContentPane(this.tablePanel);
            this.tableDialog.setTitle("[table] ImageViewer");
            this.tableDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    NumberImageViewer.this.tablePanel.clearData();
                    NumberImageViewer.this.tableDialog.dispose();
                }
            });
        }
    }

    private void constructZoomPanel() {
        if (this.zoomDialog == null) {
            this.zoomPanel = new JPanel(new BorderLayout());
            this.zoomImage = new JImage();
            this.zoomImage.setSelectionEnabled(false);
            this.zoomImage.setMargin(new Insets(2, 2, 2, 2));
            this.zoomImage.setImage(null);
            this.zoomView = new JScrollPane(this.zoomImage);
            this.zoomPanel.add((Component)this.zoomView, "Center");
            this.zoomCfgPanel = new JPanel();
            this.zoomCfgPanel.setLayout(null);
            this.zoomCfgPanel.setPreferredSize(new Dimension(0, 25));
            this.zoomCombo = new JComboBox();
            this.zoomCombo.setFont(this.panelFont);
            this.zoomCombo.addItem("Zoom 100%");
            this.zoomCombo.addItem("Zoom 200%");
            this.zoomCombo.addItem("Zoom 300%");
            this.zoomCombo.addItem("Zoom 400%");
            this.zoomCombo.addItem("Zoom 500%");
            this.zoomCombo.addItem("Zoom 600%");
            this.zoomCombo.addItem("Zoom 700%");
            this.zoomCombo.addItem("Zoom 800%");
            this.zoomCombo.setEditable(false);
            this.zoomCombo.setBounds(5, 3, 120, 20);
            this.zoomCombo.addActionListener(this);
            this.zoomCfgPanel.add(this.zoomCombo);
            this.zoomText = new JLabel("");
            this.zoomText.setFont(this.panelFont);
            this.zoomText.setBounds(130, 3, 500, 20);
            this.zoomCfgPanel.add(this.zoomText);
            this.zoomPanel.add((Component)this.zoomCfgPanel, "South");
            this.zoomDialog = new JFrame();
            this.zoomDialog.setContentPane(this.zoomPanel);
            this.zoomDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    NumberImageViewer.this.zoomImage.setImage(null);
                    NumberImageViewer.this.zoomDialog.dispose();
                }
            });
            this.zoomImage.addMouseMotionListener(this);
        }
    }

    private void constructSettingsPanel() {
        if (this.settingsDialog == null) {
            this.settingsPanel = new JPanel();
            this.settingsPanel.setLayout(null);
            this.settingsPanel.setMinimumSize(new Dimension(290, 245));
            this.settingsPanel.setPreferredSize(new Dimension(290, 245));
            this.attNameLabel = new LabelViewer();
            this.attNameLabel.setOpaque(false);
            this.attNameLabel.setFont(new Font("Dialog", 1, 16));
            this.attNameLabel.setBounds(5, 5, 200, 30);
            this.attNameLabel.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
            this.settingsPanel.add(this.attNameLabel);
            this.attNameLabel.setModel((IAttribute)this.model);
            this.propButton = new JButton();
            this.propButton.setText("?");
            this.propButton.setToolTipText("Edit attribute properties");
            this.propButton.setFont(this.panelFont);
            this.propButton.setMargin(new Insets(0, 0, 0, 0));
            this.propButton.setBounds(250, 5, 30, 30);
            this.propButton.addActionListener(this);
            this.settingsPanel.add(this.propButton);
            JSeparator jSeparator = new JSeparator();
            jSeparator.setBounds(0, 40, 500, 10);
            this.settingsPanel.add(jSeparator);
            this.autoBestFitCheck = new JCheckBox("Best fit");
            this.autoBestFitCheck.setSelected(true);
            this.autoBestFitCheck.setFont(this.panelFont);
            this.autoBestFitCheck.setBounds(5, 50, 100, 20);
            this.autoBestFitCheck.setToolTipText("Generate the best fit display using maximum and minimum value of the image");
            this.autoBestFitCheck.addActionListener(this);
            this.settingsPanel.add(this.autoBestFitCheck);
            this.bestFitCheck = new JCheckBox("Enable fitting");
            this.bestFitCheck.setSelected(false);
            this.bestFitCheck.setFont(this.panelFont);
            this.bestFitCheck.setBounds(120, 50, 105, 20);
            this.bestFitCheck.setToolTipText("Display the image using the whole color range");
            this.settingsPanel.add(this.bestFitCheck);
            this.minBestFitLabel = new JLabel("Fit Min");
            this.minBestFitLabel.setFont(this.panelFont);
            this.minBestFitLabel.setBounds(5, 75, 80, 20);
            this.settingsPanel.add(this.minBestFitLabel);
            this.minBestFitText = new JTextField("");
            this.minBestFitText.setMargin(this.noMargin);
            this.minBestFitText.setFont(this.panelFont);
            this.minBestFitText.setBounds(90, 75, 50, 20);
            this.settingsPanel.add(this.minBestFitText);
            this.maxBestFitLabel = new JLabel("Fit Max");
            this.maxBestFitLabel.setFont(this.panelFont);
            this.maxBestFitLabel.setBounds(145, 75, 80, 20);
            this.maxBestFitLabel.setHorizontalAlignment(0);
            this.settingsPanel.add(this.maxBestFitLabel);
            this.maxBestFitText = new JTextField("");
            this.maxBestFitText.setMargin(this.noMargin);
            this.maxBestFitText.setFont(this.panelFont);
            this.maxBestFitText.setBounds(230, 75, 50, 20);
            this.settingsPanel.add(this.maxBestFitText);
            this.gradLabel = new JLabel("Colormap");
            this.gradLabel.setFont(this.panelFont);
            this.gradLabel.setBounds(5, 100, 70, 20);
            this.settingsPanel.add(this.gradLabel);
            this.gradViewer = new JGradientEditor();
            this.gradViewer.setGradient(this.gColor);
            this.gradViewer.setEditable(false);
            this.gradViewer.setToolTipText("Display the image using this colormap");
            this.gradViewer.setBounds(80, 100, 180, 20);
            this.settingsPanel.add(this.gradViewer);
            this.gradButton = new JButton();
            this.gradButton.setText("...");
            this.gradButton.setToolTipText("Edit colormap");
            this.gradButton.setFont(this.panelFont);
            this.gradButton.setMargin(new Insets(0, 0, 0, 0));
            this.gradButton.setBounds(260, 100, 20, 20);
            this.gradButton.addActionListener(this);
            this.settingsPanel.add(this.gradButton);
            this.negativeCheck = new JCheckBox("Negative image");
            this.negativeCheck.setSelected(false);
            this.negativeCheck.setFont(this.panelFont);
            this.negativeCheck.setBounds(5, 125, 110, 20);
            this.negativeCheck.setToolTipText("Display the negative image");
            this.settingsPanel.add(this.negativeCheck);
            this.imageSizeLabel = new JLabel("Image size");
            this.imageSizeLabel.setFont(this.panelFont);
            this.imageSizeLabel.setBounds(115, 125, 85, 20);
            this.imageSizeLabel.setHorizontalAlignment(0);
            this.settingsPanel.add(this.imageSizeLabel);
            this.imageSizeCombo = new JComboBox();
            this.imageSizeCombo.setFont(this.panelFont);
            this.imageSizeCombo.addItem("400  %");
            this.imageSizeCombo.addItem("200  %");
            this.imageSizeCombo.addItem("100  %");
            this.imageSizeCombo.addItem("50   %");
            this.imageSizeCombo.addItem("25   %");
            this.imageSizeCombo.addItem("12.5 %");
            this.imageSizeCombo.setBounds(200, 125, 80, 22);
            this.settingsPanel.add(this.imageSizeCombo);
            JSeparator jSeparator2 = new JSeparator();
            jSeparator2.setBounds(0, 153, 500, 10);
            this.settingsPanel.add(jSeparator2);
            this.snapToGridCheck = new JCheckBox("Align to grid");
            this.snapToGridCheck.setSelected(false);
            this.snapToGridCheck.setFont(this.panelFont);
            this.snapToGridCheck.setBounds(5, 160, 100, 20);
            this.snapToGridCheck.setToolTipText("Align the selection to the grid");
            this.settingsPanel.add(this.snapToGridCheck);
            this.snapToGridLabel = new JLabel("Grid spacing");
            this.snapToGridLabel.setFont(this.panelFont);
            this.snapToGridLabel.setBounds(110, 160, 90, 20);
            this.settingsPanel.add(this.snapToGridLabel);
            this.snapToGridText = new JTextField("");
            this.snapToGridText.setMargin(this.noMargin);
            this.snapToGridText.setFont(this.panelFont);
            this.snapToGridText.setBounds(205, 160, 50, 20);
            this.settingsPanel.add(this.snapToGridText);
            this.sigHistogramCheck = new JCheckBox("Display significative data for histogram");
            this.sigHistogramCheck.setSelected(false);
            this.sigHistogramCheck.setFont(this.panelFont);
            this.sigHistogramCheck.setBounds(5, 185, 280, 20);
            this.sigHistogramCheck.setToolTipText("Clip the histogram to significative data");
            this.settingsPanel.add(this.sigHistogramCheck);
            this.okButton = new JButton();
            this.okButton.setText("Apply");
            this.okButton.setFont(this.panelFont);
            this.okButton.setBounds(5, 215, 80, 25);
            this.okButton.addActionListener(this);
            this.settingsPanel.add(this.okButton);
            this.cancelButton = new JButton();
            this.cancelButton.setText("Dismiss");
            this.cancelButton.setFont(this.panelFont);
            this.cancelButton.setBounds(205, 215, 80, 25);
            this.cancelButton.addActionListener(this);
            this.settingsPanel.add(this.cancelButton);
            this.settingsDialog = new JDialog((Frame)null, true);
            this.settingsDialog.setResizable(false);
            this.settingsDialog.setContentPane(this.settingsPanel);
            this.settingsDialog.setTitle("Image viewer settings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.selectButton || actionEvent.getSource() == this.selectionMenuItem) {
            this.imagePanel.clearSelection();
            this.imagePanel.setSelectionMode(1);
            this.profileMode = 0;
            this.freePopup();
            NumberImageViewer numberImageViewer = this;
            synchronized (numberImageViewer) {
                this.refreshStatusLine();
                this.refreshSelectionMinMax();
            }
        }
        if (actionEvent.getSource() == this.selectMaxButton || actionEvent.getSource() == this.selectionMaxMenuItem) {
            Dimension dimension = this.imagePanel.getImageSize();
            this.imagePanel.setSelection(0, 0, dimension.width, dimension.height);
            this.selectionChanged();
        } else if (actionEvent.getSource() == this.fileButton) {
            File file;
            int n = 0;
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.setDialogTitle("Save EDF 16Bits snapshot");
            int n2 = jFileChooser.showSaveDialog(this);
            if (n2 == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                if (file.exists()) {
                    n = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
                }
                if (n == 0) {
                    this.saveEdf(file.getAbsolutePath());
                }
            }
        } else {
            if (actionEvent.getSource() == this.profileButton || actionEvent.getSource() == this.lineProfileMenuItem) {
                this.imagePanel.setSelectionMode(0);
                this.constructLineProfiler();
                this.lineProfiler.setLineProfileMode();
                this.lineProfiler.setVisible(true);
                this.profileMode = 1;
                NumberImageViewer numberImageViewer = this;
                synchronized (numberImageViewer) {
                    this.refreshStatusLine();
                    this.refreshLineProfile();
                }
            }
            if (actionEvent.getSource() == this.histoButton || actionEvent.getSource() == this.histogramMenuItem) {
                this.imagePanel.setSelectionMode(1);
                this.constructLineProfiler();
                this.lineProfiler.setHistogramMode();
                this.lineProfiler.setVisible(true);
                this.profileMode = 2;
                NumberImageViewer numberImageViewer = this;
                synchronized (numberImageViewer) {
                    this.refreshStatusLine();
                    this.refreshLineProfile();
                }
            }
            if (actionEvent.getSource() == this.bestFitMenuItem) {
                this.setBestFit(!this.isBestFit());
            } else if (actionEvent.getSource() == this.negativeMenuItem) {
                this.setNegative(!this.isNegative());
            } else if (actionEvent.getSource() == this.snapToGridMenuItem) {
                this.setAlignToGrid(!this.isAlignToGrid());
            } else if (actionEvent.getSource() == this.toolbarMenuItem) {
                this.setToolbarVisible(!this.isToolbarVisible());
            } else if (actionEvent.getSource() == this.statusLineMenuItem) {
                this.setStatusLineVisible(!this.isStatusLineVisible());
            } else if (actionEvent.getSource() == this.zoomButton || actionEvent.getSource() == this.zoomMenuItem) {
                this.showZoom();
            } else if (actionEvent.getSource() == this.zoomCombo) {
                this.zoomFactor = this.zoomCombo.getSelectedIndex();
                NumberImageViewer numberImageViewer = this;
                synchronized (numberImageViewer) {
                    this.buildZoom();
                }
                this.zoomDialog.pack();
            } else if (actionEvent.getSource() == this.settingsButton || actionEvent.getSource() == this.settingsMenuItem) {
                this.showSettings();
            } else if (actionEvent.getSource() == this.autoBestFitCheck) {
                this.autoBestFit = !this.autoBestFit;
                this.minBestFitLabel.setEnabled(!this.autoBestFit);
                this.minBestFitText.setEnabled(!this.autoBestFit);
                this.maxBestFitLabel.setEnabled(!this.autoBestFit);
                this.maxBestFitText.setEnabled(!this.autoBestFit);
            } else if (actionEvent.getSource() == this.cancelButton) {
                this.settingsDialog.setVisible(false);
            } else if (actionEvent.getSource() == this.okButton) {
                this.applySettings();
            } else if (actionEvent.getSource() == this.tableButton || actionEvent.getSource() == this.tableMenuItem) {
                this.showTable();
            } else if (actionEvent.getSource() == this.propButton) {
                this.showPropertyFrame();
            } else if (actionEvent.getSource() == this.gradButton) {
                this.showGradientEditor();
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public synchronized void mouseMoved(MouseEvent mouseEvent) {
        Dimension dimension = this.getCurrentImageSize();
        if (this.doubleValues != null) {
            if (mouseEvent.getSource() == this.imagePanel) {
                int n;
                int n2;
                if (this.iSz < 0) {
                    n2 = (mouseEvent.getX() - this.imagePanel.getXOrigin()) / -this.iSz;
                    n = (mouseEvent.getY() - this.imagePanel.getYOrigin()) / -this.iSz;
                } else {
                    n2 = (mouseEvent.getX() - this.imagePanel.getXOrigin()) * this.iSz;
                    n = (mouseEvent.getY() - this.imagePanel.getYOrigin()) * this.iSz;
                }
                if (n2 >= dimension.width || n >= dimension.height || n < 0 || n2 < 0) {
                    this.statusLabel.setText(this.getLabelInfoString());
                } else {
                    this.statusLabel.setText(this.getLabelInfoString() + " (" + n2 + "," + n + ")=" + Double.toString(this.doubleValues[n][n2]));
                }
                this.refreshStatusLine();
            } else if (mouseEvent.getSource() == this.zoomImage) {
                int n = (mouseEvent.getX() - this.zoomImage.getXOrigin()) / (this.zoomFactor + 1) + this.zoomXOrg;
                int n3 = (mouseEvent.getY() - this.zoomImage.getYOrigin()) / (this.zoomFactor + 1) + this.zoomYOrg;
                if (n >= dimension.width || n3 >= dimension.height || n3 < 0 || n < 0) {
                    this.zoomText.setText("");
                } else {
                    this.zoomText.setText("(" + n + "," + n3 + ") " + Double.toString(this.doubleValues[n3][n]));
                }
            }
        } else {
            this.statusLabel.setText("");
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle != null) {
            if (this.oldSelection == null) {
                this.selectionChanged();
            } else if (!rectangle.equals(this.oldSelection)) {
                this.selectionChanged();
            }
        }
        this.oldSelection = rectangle;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3 && this.showingMenu) {
            this.bestFitMenuItem.setSelected(this.isBestFit());
            this.snapToGridMenuItem.setSelected(this.isAlignToGrid());
            this.negativeMenuItem.setSelected(this.isNegative());
            this.toolbarMenuItem.setSelected(this.isToolbarVisible());
            this.statusLineMenuItem.setSelected(this.isStatusLineVisible());
            this.imgMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.selText && keyEvent.getKeyCode() == 10) {
            Object object;
            String string = this.selText.getText();
            try {
                int n;
                int n2;
                int n3;
                int n4;
                String string2;
                String string3;
                string = string.substring(string.indexOf(40) + 1);
                object = string.substring(0, string.indexOf(44));
                string = string.substring(string.indexOf(44) + 1);
                String string4 = string.substring(0, string.indexOf(41));
                if (this.imagePanel.getSelectionMode() == 0) {
                    string = string.substring(string.indexOf(40) + 1);
                    string3 = string.substring(0, string.indexOf(44));
                    string = string.substring(string.indexOf(44) + 1);
                    string2 = string.substring(0, string.indexOf(41));
                } else {
                    string = string.substring(string.indexOf(91) + 1);
                    string3 = string.substring(0, string.indexOf(44));
                    string = string.substring(string.indexOf(44) + 1);
                    string2 = string.substring(0, string.indexOf(93));
                }
                if (this.iSz < 0) {
                    n4 = Integer.parseInt((String)object) * -this.iSz;
                    n3 = Integer.parseInt(string4) * -this.iSz;
                    n2 = Integer.parseInt(string3) * -this.iSz;
                    n = Integer.parseInt(string2) * -this.iSz;
                } else {
                    n4 = Integer.parseInt((String)object) / this.iSz;
                    n3 = Integer.parseInt(string4) / this.iSz;
                    n2 = Integer.parseInt(string3) / this.iSz;
                    n = Integer.parseInt(string2) / this.iSz;
                }
                if (this.imagePanel.getSelectionMode() == 0) {
                    this.imagePanel.setSelection(n4, n3, n2, n);
                } else {
                    this.imagePanel.setSelection(n4, n3, n4 + n2, n3 + n);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Invalid syntax for selection", "Error", 0);
            }
            object = this.imagePanel.getSelectionRect();
            if (object != null) {
                if (this.oldSelection == null) {
                    this.selectionChanged();
                } else if (!((Rectangle)object).equals(this.oldSelection)) {
                    this.selectionChanged();
                }
            }
            this.oldSelection = object;
            this.refreshStatusLine();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void imageChange(NumberImageEvent numberImageEvent) {
        this.setData(numberImageEvent.getValue());
    }

    private void saveEdf(String string) {
        if (this.doubleValues == null) {
            JOptionPane.showMessageDialog(this, "No data to save.");
            return;
        }
        Dimension dimension = this.getCurrentImageSize();
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        } else {
            this.mulRect(rectangle);
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            JOptionPane.showMessageDialog(this, "No area selected.");
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(string);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{\n");
            stringBuffer.append("HeaderID       = EH:000001:000000:000000 ;\n");
            stringBuffer.append("Image          = 1 ;\n");
            stringBuffer.append("ByteOrder      = LowByteFirst ;\n");
            stringBuffer.append("DataType       = UnsignedShort ;\n");
            stringBuffer.append("Dim_1          = " + rectangle.width + " ;\n");
            stringBuffer.append("Dim_2          = " + rectangle.height + " ;\n");
            stringBuffer.append("Size           = " + rectangle.width * rectangle.height * 2 + " ;\n");
            stringBuffer.append("count_time     = 0 ;\n");
            stringBuffer.append("point_no       = 0 ;\n");
            stringBuffer.append("preset         = 1.0 ;\n");
            stringBuffer.append("col_end        = " + (rectangle.width - 1) + " ;\n");
            stringBuffer.append("row_end        = " + (rectangle.height - 1) + " ;\n");
            stringBuffer.append("dir            = . ;\n");
            stringBuffer.append("suffix         = edf ;\n");
            stringBuffer.append("prefix         = ;\n");
            stringBuffer.append("run            = 1 ;\n");
            stringBuffer.append("description    = ;\n");
            stringBuffer.append("title          = snapshot ;\n");
            int n = stringBuffer.length();
            while (n < 1022) {
                stringBuffer.append(' ');
                ++n;
            }
            stringBuffer.append("}\n");
            fileWriter.write(stringBuffer.toString());
            char[] cArray = new char[2];
            int n2 = rectangle.y;
            while (n2 < rectangle.y + rectangle.height) {
                int n3 = rectangle.x;
                while (n3 < rectangle.x + rectangle.width) {
                    int n4 = (int)this.doubleValues[n2][n3];
                    cArray[0] = (char)(n4 & 0xFF);
                    cArray[1] = (char)(n4 >> 8 & 0xFF);
                    fileWriter.write(cArray);
                    ++n3;
                }
                ++n2;
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error during saving file.\n" + exception.getMessage());
        }
    }

    private String getLabelInfoString() {
        Dimension dimension = this.getCurrentImageSize();
        int n = this.iSz < 0 ? (int)(100.0 * (double)(-this.iSz)) : (int)(100.0 / (double)this.iSz);
        return n + "% [" + dimension.width + "," + dimension.height + "]";
    }

    /*
     * Unable to fully structure code
     */
    private void computeAutoZoom() {
        block5: {
            block6: {
                if (this.doubleValues == null) {
                    return;
                }
                if (!this.firstRefresh && !this.autoZoom || this.doubleValues.length <= 0 || (var1_1 = this.doubleValues.length) <= 0) break block5;
                var2_2 = this.doubleValues[0].length;
                var3_3 = 1;
                if (var2_2 <= 800 && var1_1 <= 600) ** GOTO lbl17
                while ((var2_2 > 800 || var1_1 > 600) && var3_3 < 8 && var2_2 % 2 == 0 && var1_1 % 2 == 0) {
                    var2_2 /= 2;
                    var1_1 /= 2;
                    var3_3 *= 2;
                }
                this.iSz = var3_3;
                break block6;
lbl-1000:
                // 1 sources

                {
                    var2_2 *= 2;
                    var1_1 *= 2;
                    var3_3 *= 2;
lbl17:
                    // 2 sources

                    ** while (var2_2 < 600 && var1_1 < 400 && var3_3 < 4)
                }
lbl18:
                // 1 sources

                this.iSz = var3_3 != 1 ? -var3_3 : 1;
            }
            if (this.iSz < 0) {
                this.imagePanel.setMarkerScale(-this.iSz);
            } else {
                this.imagePanel.setMarkerScale(1.0 / (double)this.iSz);
            }
            this.firstRefresh = false;
        }
    }

    private void preComputeBestFit() {
        if (!this.isBestFit) {
            return;
        }
        if (this.doubleValues == null) {
            return;
        }
        if (this.autoBestFit) {
            this.autoBfMin = 65536.0;
            this.autoBfMax = 0.0;
            int n = 0;
            while (n < this.doubleValues.length) {
                int n2 = 0;
                while (n2 < this.doubleValues[n].length) {
                    double d = this.doubleValues[n][n2];
                    if (d > this.autoBfMax) {
                        this.autoBfMax = d;
                    }
                    if (d < this.autoBfMin) {
                        this.autoBfMin = d;
                    }
                    ++n2;
                }
                ++n;
            }
            this.bfa0 = -this.autoBfMin;
            this.bfa1 = this.autoBfMax - this.autoBfMin < 1.0 ? 0.0 : 65536.0 / (this.autoBfMax - this.autoBfMin);
        } else {
            this.bfa0 = -this.bfMin;
            this.bfa1 = this.bfMax - this.bfMin < 1.0 ? 0.0 : 65536.0 / (this.bfMax - this.bfMin);
        }
    }

    private int bestFit(double d) {
        int n = (int)((this.bfa0 + d) * this.bfa1);
        if (n < 0) {
            return 0;
        }
        if (n > 65535) {
            return 65535;
        }
        return n;
    }

    private boolean buildZoom() {
        if (this.doubleValues == null) {
            return false;
        }
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle == null) {
            return false;
        }
        this.mulRect(rectangle);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return false;
        }
        this.zoomXOrg = rectangle.x;
        this.zoomYOrg = rectangle.y;
        int n = this.zoomFactor + 1;
        BufferedImage bufferedImage = new BufferedImage(rectangle.width * n, rectangle.height * n, 1);
        this.zoomImage.setImage(bufferedImage);
        int[] nArray = new int[rectangle.width * n];
        this.preComputeBestFit();
        int n2 = rectangle.y;
        while (n2 < rectangle.y + rectangle.height) {
            int n3;
            int n4 = rectangle.x;
            while (n4 < rectangle.x + rectangle.width) {
                int n5;
                if (this.isNegative) {
                    if (this.isBestFit) {
                        n3 = this.gColormap[~this.bestFit(this.doubleValues[n2][n4]) & 0xFFFF];
                        n5 = 0;
                        while (n5 < n) {
                            nArray[(n4 - rectangle.x) * n + n5] = n3;
                            ++n5;
                        }
                    } else {
                        n3 = this.gColormap[~((int)this.doubleValues[n2][n4]) & 0xFFFF];
                        n5 = 0;
                        while (n5 < n) {
                            nArray[(n4 - rectangle.x) * n + n5] = n3;
                            ++n5;
                        }
                    }
                } else if (this.isBestFit) {
                    n3 = this.gColormap[this.bestFit(this.doubleValues[n2][n4])];
                    n5 = 0;
                    while (n5 < n) {
                        nArray[(n4 - rectangle.x) * n + n5] = n3;
                        ++n5;
                    }
                } else {
                    n3 = this.gColormap[(int)this.doubleValues[n2][n4] & 0xFFFF];
                    n5 = 0;
                    while (n5 < n) {
                        nArray[(n4 - rectangle.x) * n + n5] = n3;
                        ++n5;
                    }
                }
                ++n4;
            }
            n3 = 0;
            while (n3 < n) {
                bufferedImage.setRGB(0, (n2 - rectangle.y) * n + n3, rectangle.width * n, 1, nArray, 0, rectangle.width * n);
                ++n3;
            }
            ++n2;
        }
        return true;
    }

    private void convertImage() {
        if (this.doubleValues == null) {
            return;
        }
        if (this.doubleValues.length > 0) {
            int n = this.doubleValues.length;
            if (n > 0) {
                int n2;
                int n3;
                int n4 = this.doubleValues[0].length;
                BufferedImage bufferedImage = this.imagePanel.getImage();
                if (this.iSz < 0) {
                    n3 = n4 * -this.iSz;
                    n2 = n * -this.iSz;
                } else {
                    n3 = n4 / this.iSz;
                    n2 = n / this.iSz;
                }
                if (bufferedImage == null || bufferedImage.getHeight() != n2 || bufferedImage.getWidth() != n3) {
                    bufferedImage = new BufferedImage(n3, n2, 1);
                    this.imagePanel.setImage(bufferedImage);
                    this.freePopup();
                    this.statusLabel.setText(this.getLabelInfoString());
                    this.refreshComponents();
                }
                int[] nArray = new int[n3];
                this.preComputeBestFit();
                if (this.iSz < 0) {
                    int n5 = -this.iSz;
                    int n6 = 0;
                    while (n6 < n) {
                        int n7;
                        int n8;
                        int n9;
                        if (this.isBestFit) {
                            if (this.isNegative) {
                                n9 = 0;
                                while (n9 < n4) {
                                    n8 = this.gColormap[~this.bestFit(this.doubleValues[n6][n9]) & 0xFFFF];
                                    n7 = 0;
                                    while (n7 < n5) {
                                        nArray[n9 * n5 + n7] = n8;
                                        ++n7;
                                    }
                                    ++n9;
                                }
                            } else {
                                n9 = 0;
                                while (n9 < n4) {
                                    n8 = this.gColormap[this.bestFit(this.doubleValues[n6][n9])];
                                    n7 = 0;
                                    while (n7 < n5) {
                                        nArray[n9 * n5 + n7] = n8;
                                        ++n7;
                                    }
                                    ++n9;
                                }
                            }
                        } else if (this.isNegative) {
                            n9 = 0;
                            while (n9 < n4) {
                                n8 = this.gColormap[~((int)this.doubleValues[n6][n9]) & 0xFFFF];
                                n7 = 0;
                                while (n7 < n5) {
                                    nArray[n9 * n5 + n7] = n8;
                                    ++n7;
                                }
                                ++n9;
                            }
                        } else {
                            n9 = 0;
                            while (n9 < n4) {
                                n8 = this.gColormap[(int)this.doubleValues[n6][n9] & 0xFFFF];
                                n7 = 0;
                                while (n7 < n5) {
                                    nArray[n9 * n5 + n7] = n8;
                                    ++n7;
                                }
                                ++n9;
                            }
                        }
                        n9 = 0;
                        while (n9 < n5) {
                            bufferedImage.setRGB(0, n6 * n5 + n9, n3, 1, nArray, 0, n3);
                            ++n9;
                        }
                        ++n6;
                    }
                } else {
                    int n10 = 0;
                    int n11 = 0;
                    while (n11 < n2) {
                        int n12;
                        int n13;
                        if (this.isBestFit) {
                            if (this.isNegative) {
                                n13 = 0;
                                n12 = 0;
                                while (n12 < n3) {
                                    nArray[n12] = this.gColormap[~this.bestFit(this.doubleValues[n10][n13]) & 0xFFFF];
                                    n13 += this.iSz;
                                    ++n12;
                                }
                            } else {
                                n13 = 0;
                                n12 = 0;
                                while (n12 < n3) {
                                    nArray[n12] = this.gColormap[this.bestFit(this.doubleValues[n10][n13])];
                                    n13 += this.iSz;
                                    ++n12;
                                }
                            }
                        } else if (this.isNegative) {
                            n13 = 0;
                            n12 = 0;
                            while (n12 < n3) {
                                nArray[n12] = this.gColormap[~((int)this.doubleValues[n10][n13]) & 0xFFFF];
                                n13 += this.iSz;
                                ++n12;
                            }
                        } else {
                            n13 = 0;
                            n12 = 0;
                            while (n12 < n3) {
                                nArray[n12] = this.gColormap[(int)this.doubleValues[n10][n13] & 0xFFFF];
                                n13 += this.iSz;
                                ++n12;
                            }
                        }
                        bufferedImage.setRGB(0, n11, n3, 1, nArray, 0, n3);
                        n10 += this.iSz;
                        ++n11;
                    }
                }
                this.imagePanel.repaint();
                this.imageView.revalidate();
                return;
            }
            this.doubleValues = null;
        } else {
            this.doubleValues = null;
        }
    }

    public void setModel(INumberImage iNumberImage) {
        if (this.settingsDialog != null) {
            this.attNameLabel.setModel((IAttribute)iNumberImage);
        }
        if (this.model != null) {
            this.model.removeImageListener((IImageListener)this);
            this.model = null;
        }
        if (iNumberImage != null) {
            this.setZoom(1);
            this.imagePanel.setImage(null);
            this.firstRefresh = true;
            this.freePopup();
            this.model = iNumberImage;
            this.model.addImageListener((IImageListener)this);
            this.model.refresh();
        }
    }

    public void clearModel() {
        this.setModel(null);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        NumberImageViewer numberImageViewer = new NumberImageViewer();
        try {
            AttributeList attributeList = new AttributeList();
            INumberImage iNumberImage = (INumberImage)attributeList.add("jlp/test/1/att_image");
            numberImageViewer.setModel(iNumberImage);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)numberImageViewer, "Center");
            jFrame.setDefaultCloseOperation(3);
            jFrame.setTitle("ImageViewer");
            jFrame.pack();
            jFrame.setVisible(true);
            attributeList.setRefreshInterval(1000);
            attributeList.startRefresher();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

