/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.conf.Default;
import org.jacorb.notification.engine.AbstractRetryStrategy;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.PushTaskExecutor;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.engine.RetryStrategy;
import org.jacorb.notification.engine.RetryStrategyFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.IProxyPushSupplier;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.ORB;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.PortableServer.POA;
import org.picocontainer.defaults.DefaultPicoContainer;

public abstract class AbstractProxyPushSupplier
extends AbstractProxySupplier
implements IProxyPushSupplier {
    private final RetryStrategyFactory retryStrategyFactory_;
    private final SynchronizedBoolean enabled_ = new SynchronizedBoolean(true);
    private final PushTaskExecutor pushTaskExecutor_;
    private final PushTaskExecutor.PushTask pushTask_ = new PushTaskExecutor.PushTask(){

        public void doPush() {
            AbstractProxyPushSupplier.this.pushPendingData();
        }

        public void cancel() {
        }
    };
    static /* synthetic */ Class class$org$jacorb$notification$engine$TaskProcessor;
    static /* synthetic */ Class class$org$jacorb$notification$engine$RetryStrategyFactory;

    public AbstractProxyPushSupplier(IAdmin iAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, PushTaskExecutorFactory pushTaskExecutorFactory, OfferManager offerManager, SubscriptionManager subscriptionManager, ConsumerAdmin consumerAdmin) throws ConfigurationException {
        super(iAdmin, oRB, pOA, configuration, taskProcessor, offerManager, subscriptionManager, consumerAdmin);
        this.pushTaskExecutor_ = pushTaskExecutorFactory.newExecutor(this);
        this.retryStrategyFactory_ = this.newRetryStrategyFactory(configuration, taskProcessor);
    }

    protected void handleFailedPushOperation(PushOperation pushOperation, Throwable throwable) {
        if (AbstractRetryStrategy.isFatalException(throwable)) {
            if (this.logger_.isErrorEnabled()) {
                this.logger_.error("push raised " + throwable + ": will destroy ProxySupplier, " + "disconnect Consumer", throwable);
            }
            pushOperation.dispose();
            this.destroy();
            return;
        }
        if (!this.isDisposed()) {
            RetryStrategy retryStrategy = this.newRetryStrategy(this, pushOperation);
            try {
                retryStrategy.retry();
            }
            catch (RetryException retryException) {
                this.logger_.error("retry failed", retryException);
                retryStrategy.dispose();
                this.destroy();
            }
        }
    }

    private RetryStrategy newRetryStrategy(IProxyPushSupplier iProxyPushSupplier, PushOperation pushOperation) {
        return this.retryStrategyFactory_.newRetryStrategy(iProxyPushSupplier, pushOperation);
    }

    private RetryStrategyFactory newRetryStrategyFactory(Configuration configuration, TaskProcessor taskProcessor) throws ConfigurationException {
        String string = configuration.getAttribute("jacorb.notification.proxysupplier.retrystrategy_factory", Default.DEFAULT_RETRY_STRATEGY_FACTORY);
        try {
            Class clazz = ObjectUtil.classForName(string);
            DefaultPicoContainer defaultPicoContainer = new DefaultPicoContainer();
            defaultPicoContainer.registerComponentInstance((Object)(class$org$jacorb$notification$engine$TaskProcessor == null ? (class$org$jacorb$notification$engine$TaskProcessor = AbstractProxyPushSupplier.class$("org.jacorb.notification.engine.TaskProcessor")) : class$org$jacorb$notification$engine$TaskProcessor), (Object)taskProcessor);
            defaultPicoContainer.registerComponentImplementation((Object)(class$org$jacorb$notification$engine$RetryStrategyFactory == null ? (class$org$jacorb$notification$engine$RetryStrategyFactory = AbstractProxyPushSupplier.class$("org.jacorb.notification.engine.RetryStrategyFactory")) : class$org$jacorb$notification$engine$RetryStrategyFactory), clazz);
            defaultPicoContainer.registerComponentInstance((Object)configuration);
            return (RetryStrategyFactory)defaultPicoContainer.getComponentInstance((Object)(class$org$jacorb$notification$engine$RetryStrategyFactory == null ? (class$org$jacorb$notification$engine$RetryStrategyFactory = AbstractProxyPushSupplier.class$("org.jacorb.notification.engine.RetryStrategyFactory")) : class$org$jacorb$notification$engine$RetryStrategyFactory));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException("jacorb.notification.proxysupplier.retrystrategy_factory", classNotFoundException);
        }
    }

    public final void schedulePush() {
        if (!this.isDisposed() && !this.isSuspended() && this.isEnabled()) {
            this.schedulePush(this.pushTask_);
        }
    }

    public final void schedulePush(PushTaskExecutor.PushTask pushTask) {
        this.pushTaskExecutor_.executePush(pushTask);
    }

    public final void messageDelivered() {
        if (this.isEnabled()) {
            this.schedulePush();
        }
    }

    public void resetErrorCounter() {
        super.resetErrorCounter();
        this.enableDelivery();
    }

    public void disableDelivery() {
        this.logger_.debug("Disable Delivery to ProxySupplier");
        this.enabled_.set(false);
    }

    protected boolean isEnabled() {
        return this.enabled_.get();
    }

    private void enableDelivery() {
        this.logger_.debug("Enable Delivery to ProxySupplier");
        this.enabled_.set(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

