/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.DirectExecutor;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.util.DisposableManager;

public class DefaultTaskExecutor
implements TaskExecutor {
    private static final DefaultTaskExecutor DIRECT_EXECUTOR = new DefaultTaskExecutor("Direct", 0);
    private final Executor executor_;
    private final DisposableManager disposeHooks_ = new DisposableManager();
    private LinkedQueue channel_;

    public static TaskExecutor getDefaultExecutor() {
        return DIRECT_EXECUTOR;
    }

    public DefaultTaskExecutor(String string, int n) {
        this(string, n, false);
    }

    public DefaultTaskExecutor(String string, int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.executor_ = new DirectExecutor();
        } else {
            DefaultThreadFactory defaultThreadFactory = new DefaultThreadFactory(string);
            this.channel_ = new LinkedQueue();
            PooledExecutor pooledExecutor = new PooledExecutor((Channel)this.channel_);
            pooledExecutor.setThreadFactory((ThreadFactory)defaultThreadFactory);
            if (!bl) {
                pooledExecutor.setKeepAliveTime(-1L);
            }
            pooledExecutor.createThreads(n);
            this.executor_ = pooledExecutor;
        }
    }

    public boolean isTaskQueued() {
        if (this.channel_ != null) {
            return !this.channel_.isEmpty();
        }
        return false;
    }

    public void dispose() {
        if (this.executor_ instanceof PooledExecutor) {
            ((PooledExecutor)this.executor_).shutdownNow();
            ((PooledExecutor)this.executor_).interruptAll();
        }
        this.disposeHooks_.dispose();
    }

    public void addDisposeHook(Disposable disposable) {
        this.disposeHooks_.addDisposable(disposable);
    }

    public void execute(Runnable runnable) throws InterruptedException {
        this.executor_.execute(runnable);
    }

    private static final class DefaultThreadFactory
    implements ThreadFactory {
        private int counter_ = 0;
        private final String name;

        private DefaultThreadFactory(String string) {
            this.name = string;
        }

        public synchronized Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName(this.name + "#" + this.counter_++);
            return thread;
        }
    }
}

