/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.PollRing;
import org.omg.CORBA.Any;

public class PollObj {
    protected DeviceImpl dev;
    protected int type;
    protected String name;
    protected TimeVal upd;
    protected TimeVal needed_time;
    protected double max_delta_t;
    protected PollRing ring;

    public PollObj(DeviceImpl deviceImpl, int n, String string, int n2) {
        this.dev = deviceImpl;
        this.type = n;
        this.name = string;
        this.ring = new PollRing(deviceImpl.get_poll_ring_depth());
        this.needed_time = new TimeVal(0, 0, 0);
        this.upd = new TimeVal();
        if (n2 < 1000) {
            this.upd.tv_usec = n2 * 1000;
            this.upd.tv_sec = 0;
        } else {
            this.upd.tv_sec = n2 / 1000;
            this.upd.tv_usec = (n2 - this.upd.tv_sec * 1000) * 1000;
        }
        this.max_delta_t = (double)n2 / 1000.0 * (double)this.dev.get_poll_old_factor();
    }

    synchronized void insert_data(Any any, TimeVal timeVal, TimeVal timeVal2) {
        this.ring.insert_data(any, timeVal);
        this.needed_time = timeVal2;
    }

    synchronized void insert_data(AttributeValue attributeValue, TimeVal timeVal, TimeVal timeVal2) {
        this.ring.insert_data(attributeValue, timeVal);
        this.needed_time = timeVal2;
    }

    synchronized void insert_except(DevFailed devFailed, TimeVal timeVal, TimeVal timeVal2) {
        this.ring.insert_except(devFailed, timeVal);
        this.needed_time = timeVal2;
    }

    synchronized Any get_last_cmd_result() throws DevFailed {
        return this.ring.get_last_cmd_result();
    }

    void update_upd(long l) {
        if (l < 1000L) {
            this.upd.tv_usec = (int)(l * 1000L);
            this.upd.tv_sec = 0;
        } else {
            this.upd.tv_sec = (int)(l / 1000L);
            this.upd.tv_usec = (int)((l - (long)(this.upd.tv_sec * 1000)) * 1000L);
        }
        this.max_delta_t = (int)((double)l / 1000.0) * this.dev.get_poll_old_factor();
    }

    synchronized DevCmdHistory[] get_cmd_history(int n) {
        return this.ring.get_cmd_history(n);
    }

    synchronized DevAttrHistory[] get_attr_history(int n, int n2) {
        return this.ring.get_attr_history(n, n2);
    }

    double get_authorized_delta() {
        return this.max_delta_t;
    }

    synchronized boolean is_ring_empty() {
        return this.is_ring_empty_i();
    }

    boolean is_ring_empty_i() {
        return this.ring.is_empty();
    }

    synchronized int get_upd() {
        return this.get_upd_i();
    }

    int get_upd_i() {
        return this.upd.tv_sec * 1000 + this.upd.tv_usec / 1000;
    }

    synchronized String get_name() {
        return this.get_name_i();
    }

    String get_name_i() {
        return this.name;
    }

    synchronized int get_needed_time() {
        return this.get_needed_time_i();
    }

    int get_needed_time_i() {
        return (int)((double)(this.needed_time.tv_sec * 1000) + (double)this.needed_time.tv_usec / 1000.0);
    }

    synchronized int get_type() {
        return this.get_type_i();
    }

    int get_type_i() {
        return this.type;
    }

    synchronized double get_last_insert_date() {
        return this.get_last_insert_date_i();
    }

    double get_last_insert_date_i() {
        TimeVal timeVal = this.ring.get_last_insert_date();
        double d = (double)timeVal.tv_sec + (double)timeVal.tv_usec / 1000000.0;
        return d;
    }

    synchronized boolean is_last_an_error() {
        return this.is_last_an_error_i();
    }

    boolean is_last_an_error_i() {
        return this.ring.is_last_an_error();
    }

    DevFailed synchronizedget_last_except() {
        return this.get_last_except_i();
    }

    DevFailed get_last_except_i() {
        return this.ring.get_last_except();
    }

    synchronized double[] get_delta_t(int n) throws DevFailed {
        return this.get_delta_t_i(n);
    }

    double[] get_delta_t_i(int n) throws DevFailed {
        return this.ring.get_delta_t(n);
    }

    synchronized int get_elt_nb_in_buffer() {
        return this.get_elt_nb_in_buffer_i();
    }

    int get_elt_nb_in_buffer_i() {
        return this.ring.size();
    }

    AttributeValue get_last_attr_value() throws DevFailed {
        return this.ring.get_last_attr_value();
    }
}

