/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevCmdInfo_2;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.Tango.DevInfo_3;
import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.Device;
import fr.esrf.Tango.DeviceHelper;
import fr.esrf.Tango.Device_2;
import fr.esrf.Tango.Device_2Helper;
import fr.esrf.Tango.Device_3;
import fr.esrf.Tango.Device_3Helper;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbRedundancy;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.TacoTangoDevice;
import fr.esrf.TangoApi.TangoUrl;
import fr.esrf.TangoDs.Except;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;

public class Connection
implements ApiDefs {
    protected int idl_version = 1;
    protected Device device = null;
    protected Device_2 device_2 = null;
    protected Device_3 device_3 = null;
    protected TacoTangoDevice taco_device = null;
    private Object obj = null;
    private int dev_timeout = 0;
    protected String devname = null;
    private boolean already_connected = false;
    private boolean device_is_dbase;
    protected String ior = null;
    protected TangoUrl url;
    protected DevSource dev_src = DevSource.CACHE_DEV;
    protected boolean transparent_reconnection = false;
    private DevFailed prev_failed = null;
    private long prev_failed_t0 = 0L;

    public Device get_device() {
        return this.device;
    }

    private String buildUrlName(String string, String string2) {
        return new String("tango://" + string + ":" + string2);
    }

    private String buildUrlName(String string, String string2, String string3) {
        return new String("tango://" + string + ":" + string2 + "/" + string3);
    }

    protected Connection() throws DevFailed {
        this.url = new TangoUrl();
        this.device_is_dbase = true;
        this.transparent_reconnection = true;
        ApiUtil.get_orb();
        this.connect_to_dbase();
        this.devname = this.device.name();
        this.already_connected = true;
    }

    protected Connection(String string, String string2) throws DevFailed {
        this.url = new TangoUrl(this.buildUrlName(string, string2));
        this.device_is_dbase = true;
        this.transparent_reconnection = true;
        ApiUtil.get_orb();
        this.connect_to_dbase();
        this.devname = this.device.name();
        this.already_connected = true;
    }

    protected Connection(String string, String string2, boolean bl) throws DevFailed {
        this.url = new TangoUrl(this.buildUrlName(string, string2));
        this.device_is_dbase = true;
        this.transparent_reconnection = bl;
        ApiUtil.get_orb();
        this.connect_to_dbase();
        this.devname = this.device.name();
        this.already_connected = true;
    }

    protected Connection(String string) throws DevFailed {
        this.url = new TangoUrl(string);
        this.device_is_dbase = false;
        this.devname = this.url.devname;
        if (this.url.protocol == 0 && this.url.use_db) {
            this.ior = this.get_exported_ior();
        }
    }

    protected Connection(String string, String string2, int n) throws DevFailed {
        this.devname = string;
        this.device_is_dbase = false;
        if (n == 1) {
            this.ior = string2;
            this.url = new TangoUrl();
            this.url.protocol = 0;
        } else {
            String string3 = "TangoApi_INVALID_ARGS";
            String string4 = new String("Invalid argument");
            String string5 = new String("Connection.Connemction()");
            Except.throw_wrong_syntax_exception(string3, string4, string5);
        }
    }

    protected Connection(String string, String string2, String string3) throws DevFailed {
        this.url = new TangoUrl(this.buildUrlName(string2, string3, string));
        this.devname = this.url.devname;
        this.device_is_dbase = false;
        if (this.url.protocol == 0) {
            this.ior = this.get_exported_ior();
        }
    }

    protected synchronized void build_connection() throws DevFailed {
        long l = System.currentTimeMillis();
        long l2 = l - this.prev_failed_t0;
        boolean bl = true;
        if (this.device_is_dbase) {
            this.connect_to_dbase();
        } else {
            try {
                if (this.url.protocol == 0) {
                    if (this.prev_failed != null && l2 < (long)ApiUtil.getReconnectionDelay()) {
                        bl = false;
                        throw this.prev_failed;
                    }
                    this.prev_failed_t0 = l;
                    if (this.url.use_db) {
                        this.dev_import();
                    } else {
                        this.dev_import_without_dbase();
                    }
                    this.prev_failed = null;
                } else if (this.url.protocol == 1 && this.taco_device == null) {
                    this.taco_device = new TacoTangoDevice(this.devname);
                }
            }
            catch (DevFailed devFailed) {
                if (bl) {
                    this.prev_failed_t0 = l;
                    this.prev_failed = devFailed;
                }
                this.ior = null;
                String string = "TangoApi_CANNOT_IMPORT_DEVICE";
                String string2 = new String("Cannot import " + this.devname);
                String string3 = new String("Connection.build_connection(" + this.devname + ")");
                Except.throw_communication_failed(devFailed, string, string2, string3);
            }
        }
    }

    private void createDevice(String string) throws DevFailed {
        java.lang.Object object;
        try {
            object = ApiUtil.get_orb();
            this.obj = ((ORB)object).string_to_object(string);
        }
        catch (RuntimeException runtimeException) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_VALID", runtimeException.toString().substring(runtimeException.toString().indexOf(":") + 2), "Connection.createDevice()");
        }
        object = System.getProperty("TANGO_TIMEOUT");
        if (object == null) {
            object = "3000";
        }
        try {
            this.dev_timeout = Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.set_obj_timeout(this.dev_timeout);
        if (this.obj._is_a("IDL:Tango/Device_3:1.0")) {
            this.device_3 = Device_3Helper.narrow(this.obj);
            this.device_2 = this.device_3;
            this.device = this.device_3;
            this.idl_version = 3;
        } else if (this.obj._is_a("IDL:Tango/Device_2:1.0")) {
            this.device_2 = Device_2Helper.narrow(this.obj);
            this.device = this.device_2;
            this.idl_version = 2;
        } else if (this.obj._is_a("IDL:Tango/Device:1.0")) {
            this.device = DeviceHelper.narrow(this.obj);
            this.idl_version = 1;
        } else {
            Except.throw_non_supported_exception("TangoApi_DEVICE_IDL_UNKNOWN", this.devname + " has an IDL revision not suported !", "Connection.createDevice(" + this.devname + ")");
        }
        this.obj._is_a("Dummy");
    }

    public String get_ior() throws DevFailed {
        Database database = this.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(this.url.host, this.url.strport);
        DbDevImportInfo dbDevImportInfo = database.import_device(this.devname);
        return dbDevImportInfo.ior;
    }

    private String get_exported_ior() throws DevFailed {
        Database database = this.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(this.url.host, this.url.strport);
        DbDevImportInfo dbDevImportInfo = database.import_device(this.devname);
        String string = null;
        if (dbDevImportInfo.exported) {
            string = dbDevImportInfo.ior;
        }
        if (dbDevImportInfo.is_taco) {
            this.url.protocol = 1;
        }
        return string;
    }

    protected void dev_import() throws DevFailed {
        String string = null;
        Database database = this.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(this.url.host, this.url.strport);
        if (this.ior == null) {
            DbDevImportInfo dbDevImportInfo = database.import_device(this.devname);
            if (!dbDevImportInfo.exported) {
                Except.throw_connection_failed("TangoApi_DEVICE_NOT_EXPORTED", this.devname + " Not Exported !", "Connection(" + this.devname + ")");
            }
            string = dbDevImportInfo.ior;
        } else {
            string = this.ior;
        }
        try {
            this.createDevice(string);
            this.already_connected = true;
        }
        catch (DevFailed devFailed) {
            this.device = null;
            this.ior = null;
            throw devFailed;
        }
        catch (Exception exception) {
            this.device = null;
            this.ior = null;
            String string2 = "TangoApi_CANNOT_IMPORT_DEVICE";
            String string3 = this.already_connected ? "Re-" : "";
            String string4 = new String("Cannot " + string3 + "import " + this.devname + " :\n\t" + exception.toString());
            String string5 = new String("Connection.dev_import(" + this.devname + ")");
            Except.throw_connection_failed(string2, string4, string5);
        }
    }

    private void connect_to_dbase() throws DevFailed {
        if (this.device == null) {
            try {
                String string = new String("corbaloc:iiop:" + this.url.host + ":" + this.url.strport + "/database");
                this.createDevice(string);
                System.out.println("Connected to " + string);
            }
            catch (SystemException systemException) {
                if (this.transparent_reconnection) {
                    try {
                        DbRedundancy dbRedundancy = DbRedundancy.get_instance();
                        String string = dbRedundancy.get(this.url.host + ":" + this.url.port);
                        String string2 = new String("corbaloc:iiop:" + string + "/database");
                        this.createDevice(string2);
                        System.out.println("Connected to " + string2);
                    }
                    catch (SystemException systemException2) {
                        this.device = null;
                        this.ior = null;
                        Except.throw_connection_failed("TangoApi_DATABASE_CONNECTION_FAILED", "Connection to database failed  !\n" + systemException2, "connect_to_dbase(" + this.url.host + "," + this.url.strport + ")");
                    }
                }
                this.device = null;
                this.ior = null;
                Except.throw_connection_failed("TangoApi_DATABASE_CONNECTION_FAILED", "Connection to database failed  !\n" + systemException, "connect_to_dbase(" + this.url.host + "," + this.url.strport + ")");
            }
        }
    }

    private void dev_import_without_dbase() throws DevFailed {
        if (this.device == null) {
            try {
                String string = new String("corbaloc:iiop:" + this.url.host + ":" + this.url.strport + "/" + this.devname.toLowerCase());
                this.createDevice(string);
            }
            catch (SystemException systemException) {
                this.device = null;
                this.ior = null;
                systemException.printStackTrace();
                Except.throw_connection_failed("TangoApi_DEVICE_CONNECTION_FAILED", "Connection to device without database failed  !\n" + systemException, "Connection.dev_import_without_dbase(" + this.url.host + "," + this.url.strport + ")");
            }
        }
    }

    private void set_obj_timeout(int n) {
        RelativeRoundtripTimeoutPolicy relativeRoundtripTimeoutPolicy = new RelativeRoundtripTimeoutPolicy(10000 * n);
        this.obj._set_policy_override(new Policy[]{relativeRoundtripTimeoutPolicy}, SetOverrideType.ADD_OVERRIDE);
        this.dev_timeout = n;
    }

    public void set_timeout_millis(int n) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 1) {
            this.taco_device.set_rpc_timeout(n);
            return;
        }
        this.set_obj_timeout(n);
    }

    public int get_timeout() {
        return this.dev_timeout;
    }

    public int get_timeout_millis() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 1) {
            return this.taco_device.get_rpc_timeout();
        }
        return this.dev_timeout;
    }

    protected void throw_dev_failed(Exception exception, String string, boolean bl) throws DevFailed {
        String string2;
        if (exception instanceof DevFailed) {
            throw (DevFailed)exception;
        }
        String string3 = string2 = bl ? new String(this.devname + ".command_inout(" + string + ")") : new String(this.devname + "." + string + ")");
        if (exception.toString().indexOf("org.omg.CORBA.NO_RESPONSE") >= 0 || exception.toString().indexOf("org.omg.CORBA.TIMEOUT") >= 0 || exception.toString().indexOf("org.omg.CORBA.IMP_LIMIT") >= 0) {
            String string4 = new String("Device (" + this.devname + ") timed out (>" + this.dev_timeout + " ms)!");
            Except.throw_communication_failed(new String(exception.toString()), string4, string2);
        } else if (exception.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 || exception.toString().indexOf("org.omg.CORBA.UNKNOWN") >= 0 || exception.toString().indexOf("org.omg.CORBA.COMM_FAILURE") >= 0 || exception.toString().indexOf("org.omg.CORBA.OBJECT_NOT_EXIST") >= 0) {
            String string5 = new String("Lost Connection during command : " + string);
            this.device = null;
            this.ior = null;
            Except.throw_connection_failed(new String(exception.toString()), string5, string2);
        } else if (exception.toString().startsWith("java.lang.RuntimeException")) {
            String string6 = new String("API has catched a RuntimeException" + string);
            this.device = null;
            this.ior = null;
            Except.throw_connection_failed(new String(exception.toString()), string6, string2);
        } else {
            System.out.println("API has catched an exception for " + string2 + " : \n" + exception);
            String string7 = new String(exception.getMessage());
            exception.printStackTrace();
            Except.throw_communication_failed(new String(exception.toString()), string7, string2);
        }
    }

    public DeviceData command_inout(String string, DeviceData deviceData) throws DevFailed {
        Any any = null;
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 1) {
            return this.taco_device.command_inout(string, deviceData);
        }
        boolean bl = false;
        int n = this.transparent_reconnection ? 2 : 1;
        for (int i = 0; i < n && !bl; ++i) {
            try {
                any = this.device_2 != null ? this.device_2.command_inout_2(string, deviceData.extractAny(), this.dev_src) : this.device.command_inout(string, deviceData.extractAny());
                bl = true;
                continue;
            }
            catch (DevFailed devFailed) {
                String string2 = "TangoApi_CANNOT_EXECUTE_COMMAND";
                String string3 = new String("Cannot execute command " + string + " on " + this.devname);
                String string4 = new String("Connection.command_inout()");
                if (devFailed.errors[0].reason.equals("DB_DeviceNotDefined")) {
                    String string5 = devFailed.errors[0].desc;
                    int n2 = string5.lastIndexOf("!");
                    devFailed.errors[0].desc = string5 = string5.substring(0, n2) + "  " + this.url.host + ":" + this.url.port + " !";
                }
                Except.throw_connection_failed(devFailed, string2, string3, string4);
                continue;
            }
            catch (Exception exception) {
                if (exception.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 && i == 0) {
                    this.device = null;
                    this.ior = null;
                    this.build_connection();
                    if (i != n - 1) continue;
                    this.throw_dev_failed(exception, string, true);
                    continue;
                }
                this.throw_dev_failed(exception, string, true);
            }
        }
        return new DeviceData(any);
    }

    public DeviceData command_inout(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        return this.command_inout(string, deviceData);
    }

    public long ping() throws DevFailed {
        this.checkIfTango("ping");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        long l = System.currentTimeMillis();
        try {
            this.device.ping();
        }
        catch (DevFailed devFailed) {
            String string = "TangoApi_CANNOT_PING_DEVICE";
            String string2 = new String("Cannot ping " + this.devname);
            String string3 = new String("Connection.ping()");
            Except.throw_connection_failed(devFailed, string, string2, string3);
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "ping", false);
        }
        long l2 = System.currentTimeMillis();
        return (int)(l2 - l) * 1000;
    }

    public String[] black_box(int n) throws DevFailed {
        this.checkIfTango("black_box");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            String[] stringArray = this.device.black_box(n);
            return stringArray;
        }
        catch (DevFailed devFailed) {
            String string = "TangoApi_CANNOT_READ_BLACK BOX";
            String string2 = new String("Cannot read black box on " + this.devname);
            String string3 = new String("Connection.black_box()");
            Except.throw_connection_failed(devFailed, string, string2, string3);
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "black_box", false);
        }
        return null;
    }

    public DevInfo_3 info_3() throws DevFailed {
        this.checkIfTango("info");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            DevInfo_3 devInfo_3;
            if (this.device_3 != null) {
                devInfo_3 = this.device_3.info_3();
            } else {
                DevInfo devInfo = this.device.info();
                devInfo_3 = new DevInfo_3(devInfo.dev_class, devInfo.server_id, devInfo.server_host, devInfo.server_version, devInfo.doc_url, "");
            }
            return devInfo_3;
        }
        catch (DevFailed devFailed) {
            String string = "TangoApi_CANNOT_READ _DEVICE_INFO";
            String string2 = new String("Cannot read device info on " + this.devname);
            String string3 = new String("Connection.info()");
            Except.throw_connection_failed(devFailed, string, string2, string3);
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "info", false);
        }
        return null;
    }

    public DevInfo info() throws DevFailed {
        this.checkIfTango("info");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            DevInfo devInfo = this.device.info();
            return devInfo;
        }
        catch (DevFailed devFailed) {
            String string = "TangoApi_CANNOT_READ _DEVICE_INFO";
            String string2 = new String("Cannot read device info on " + this.devname);
            String string3 = new String("Connection.info()");
            Except.throw_connection_failed(devFailed, string, string2, string3);
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "info", false);
        }
        return null;
    }

    public CommandInfo[] command_list_query() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            CommandInfo[] commandInfoArray;
            if (this.url.protocol == 1) {
                commandInfoArray = this.taco_device.commandListQuery();
            } else if (this.device_2 != null) {
                DevCmdInfo_2[] devCmdInfo_2Array = this.device_2.command_list_query_2();
                commandInfoArray = new CommandInfo[devCmdInfo_2Array.length];
                for (int i = 0; i < devCmdInfo_2Array.length; ++i) {
                    commandInfoArray[i] = new CommandInfo(devCmdInfo_2Array[i]);
                }
            } else {
                DevCmdInfo[] devCmdInfoArray = this.device.command_list_query();
                commandInfoArray = new CommandInfo[devCmdInfoArray.length];
                for (int i = 0; i < devCmdInfoArray.length; ++i) {
                    commandInfoArray[i] = new CommandInfo(devCmdInfoArray[i]);
                }
            }
            return commandInfoArray;
        }
        catch (DevFailed devFailed) {
            String string = "TangoApi_CANNOT__READ_CMD_LIST";
            String string2 = new String("Cannot read command list for " + this.devname);
            String string3 = new String("Connection.command_list_query()");
            Except.throw_connection_failed(devFailed, string, string2, string3);
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "command_list_query", false);
        }
        return null;
    }

    public int get_idl_version() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        return this.idl_version;
    }

    public DevSource get_source() throws DevFailed {
        if (this.is_taco()) {
            if (this.taco_device == null) {
                this.taco_device = new TacoTangoDevice(this.devname);
            }
            return this.taco_device.get_source();
        }
        return this.dev_src;
    }

    public void set_source(DevSource devSource) throws DevFailed {
        if (this.is_taco()) {
            if (this.taco_device == null) {
                this.taco_device = new TacoTangoDevice(this.devname);
            }
            this.taco_device.set_source(devSource);
        } else {
            this.dev_src = devSource;
        }
    }

    public String get_name() {
        return this.devname;
    }

    public String description() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        return this.device.description();
    }

    public String adm_name() throws DevFailed {
        this.checkIfTango("adm_name");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        String string = null;
        try {
            string = this.device.adm_name();
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "adm_name", false);
        }
        if (!this.url.use_db) {
            string = "tango://" + this.url.host + ":" + this.url.port + "/" + string + "#dbase=no";
        }
        return string;
    }

    public String get_tango_host() throws DevFailed {
        this.checkIfTango("get_tango_host");
        return new String(this.url.host + ":" + this.url.strport);
    }

    public boolean is_taco() {
        return this.url.protocol == 1;
    }

    protected void checkIfTaco(String string) throws DevFailed {
        if (!this.is_taco()) {
            Except.throw_non_supported_exception("TangoApi_NOT_TANGO_CMD", new String(string + " is NOT a TANGO command."), new String(string + "()"));
        }
    }

    protected void checkIfTango(String string) throws DevFailed {
        if (this.is_taco()) {
            Except.throw_non_supported_exception("TangoApi_NOT_TACO_CMD", new String(string + " is NOT a TACO command."), new String(string + "()"));
        }
    }

    public boolean get_transparency_reconnection() {
        return this.transparent_reconnection;
    }

    public void set_transparency_reconnection(boolean bl) {
        this.transparent_reconnection = bl;
    }
}

