// ============================================================================
//
// = CONTEXT
//   Tango Generic Client for Matlab
//
// = FILENAME
//   MexArgs.i
//
// = AUTHOR
//   Nicolas Leclercq - SOLEIL
//
// ============================================================================


//=============================================================================
// MexArgs::set
//=============================================================================
MEX_INLINE void 
MexArgs::set (int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
  this->nlhs_ = nlhs;
  this->plhs_ = plhs;
  this->nrhs_ = nrhs;
  this->prhs_ = prhs;
}

//=============================================================================
// MexArgs::nlhs
//=============================================================================
MEX_INLINE int MexArgs::nlhs (void) const
{
  return this->nlhs_;
}

//=============================================================================
// MexArgs::plhs
//=============================================================================
MEX_INLINE mxArray** MexArgs::plhs (void) const
{
  return this->plhs_;
}

//=============================================================================
// MexArgs::nrhs
//=============================================================================
MEX_INLINE int MexArgs::nrhs (void) const
{
  return this->nrhs_;
}

//=============================================================================
// MexArgs::prhs
//=============================================================================
MEX_INLINE const mxArray** MexArgs::prhs (void) const
{
  return this->prhs_; 
}
