/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SelectableChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import zmq.Address;
import zmq.Clock;
import zmq.Command;
import zmq.Config;
import zmq.Ctx;
import zmq.Dealer;
import zmq.IOThread;
import zmq.IPollEvents;
import zmq.IpcListener;
import zmq.Mailbox;
import zmq.Msg;
import zmq.MultiMap;
import zmq.Own;
import zmq.Pair;
import zmq.Pipe;
import zmq.Poller;
import zmq.Pub;
import zmq.Pull;
import zmq.Push;
import zmq.Rep;
import zmq.Req;
import zmq.Router;
import zmq.SessionBase;
import zmq.Sub;
import zmq.TcpListener;
import zmq.ValueReference;
import zmq.XPub;
import zmq.XSub;
import zmq.ZError;
import zmq.ZMQ;
import zmq.ZObject;

public abstract class SocketBase
extends Own
implements IPollEvents,
Pipe.IPipeEvents {
    private final Map<String, Own> endpoints;
    private final Map<String, Pipe> inprocs;
    private int tag = -1159861073;
    private boolean ctx_terminated = false;
    private boolean destroyed = false;
    private final Mailbox mailbox;
    private final List<Pipe> pipes;
    private Poller poller;
    private SelectableChannel handle;
    private long last_tsc = 0L;
    private int ticks = 0;
    private boolean rcvmore = false;
    private SocketBase monitor_socket = null;
    private int monitor_events = 0;
    protected ValueReference<Integer> errno;

    protected SocketBase(Ctx parent_, int tid_, int sid_) {
        super(parent_, tid_);
        this.options.socket_id = sid_;
        this.endpoints = new MultiMap<String, Own>();
        this.inprocs = new MultiMap<String, Pipe>();
        this.pipes = new ArrayList<Pipe>();
        this.mailbox = new Mailbox("socket-" + sid_);
        this.errno = new ValueReference<Integer>(0);
    }

    protected abstract void xattach_pipe(Pipe var1, boolean var2);

    protected abstract void xterminated(Pipe var1);

    public boolean check_tag() {
        return this.tag == -1159861073;
    }

    public static SocketBase create(int type_, Ctx parent_, int tid_, int sid_) {
        SocketBase s = null;
        switch (type_) {
            case 0: {
                s = new Pair(parent_, tid_, sid_);
                break;
            }
            case 1: {
                s = new Pub(parent_, tid_, sid_);
                break;
            }
            case 2: {
                s = new Sub(parent_, tid_, sid_);
                break;
            }
            case 3: {
                s = new Req(parent_, tid_, sid_);
                break;
            }
            case 4: {
                s = new Rep(parent_, tid_, sid_);
                break;
            }
            case 5: {
                s = new Dealer(parent_, tid_, sid_);
                break;
            }
            case 6: {
                s = new Router(parent_, tid_, sid_);
                break;
            }
            case 7: {
                s = new Pull(parent_, tid_, sid_);
                break;
            }
            case 8: {
                s = new Push(parent_, tid_, sid_);
                break;
            }
            case 9: {
                s = new XPub(parent_, tid_, sid_);
                break;
            }
            case 10: {
                s = new XSub(parent_, tid_, sid_);
                break;
            }
            default: {
                throw new IllegalArgumentException("type=" + type_);
            }
        }
        return s;
    }

    @Override
    public void destroy() {
        this.stop_monitor();
        assert (this.destroyed);
    }

    public Mailbox get_mailbox() {
        return this.mailbox;
    }

    public void stop() {
        this.send_stop();
    }

    private void check_protocol(String protocol_) {
        if (!(protocol_.equals("inproc") || protocol_.equals("ipc") || protocol_.equals("tcp"))) {
            throw new UnsupportedOperationException(protocol_);
        }
        if ((protocol_.equals("pgm") || protocol_.equals("epgm")) && this.options.type != 1 && this.options.type != 2 && this.options.type != 9 && this.options.type != 10) {
            throw new UnsupportedOperationException(protocol_ + ",type=" + this.options.type);
        }
    }

    private void attach_pipe(Pipe pipe_) {
        this.attach_pipe(pipe_, false);
    }

    private void attach_pipe(Pipe pipe_, boolean icanhasall_) {
        pipe_.set_event_sink(this);
        this.pipes.add(pipe_);
        this.xattach_pipe(pipe_, icanhasall_);
        if (this.is_terminating()) {
            this.register_term_acks(1);
            pipe_.terminate(false);
        }
    }

    public void setsockopt(int option_, Object optval_) {
        if (this.ctx_terminated) {
            throw new ZError.CtxTerminatedException();
        }
        if (this.xsetsockopt(option_, optval_)) {
            return;
        }
        this.options.setsockopt(option_, optval_);
    }

    public int getsockopt(int option_) {
        if (option_ != 15 && this.ctx_terminated) {
            throw new ZError.CtxTerminatedException();
        }
        if (option_ == 13) {
            return this.rcvmore ? 1 : 0;
        }
        if (option_ == 15) {
            boolean rc = this.process_commands(0, false);
            if (!rc && this.errno.get() == 156384765) {
                return -1;
            }
            assert (rc);
            int val = 0;
            if (this.has_out()) {
                val |= 2;
            }
            if (this.has_in()) {
                val |= 1;
            }
            return val;
        }
        return (Integer)this.getsockoptx(option_);
    }

    public Object getsockoptx(int option_) {
        if (this.ctx_terminated) {
            throw new ZError.CtxTerminatedException();
        }
        if (option_ == 13) {
            return this.rcvmore ? 1 : 0;
        }
        if (option_ == 14) {
            return this.mailbox.get_fd();
        }
        if (option_ == 15) {
            boolean rc = this.process_commands(0, false);
            if (!rc && this.errno.get() == 156384765) {
                return -1;
            }
            assert (rc);
            int val = 0;
            if (this.has_out()) {
                val |= 2;
            }
            if (this.has_in()) {
                val |= 1;
            }
            return val;
        }
        return this.options.getsockopt(option_);
    }

    public boolean bind(String addr) {
        URI uri;
        if (this.ctx_terminated) {
            throw new ZError.CtxTerminatedException();
        }
        boolean brc = this.process_commands(0, false);
        if (!brc) {
            return false;
        }
        try {
            uri = new URI(addr);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String protocol = uri.getScheme();
        String address = uri.getAuthority();
        String path = uri.getPath();
        if (address == null) {
            address = path;
        }
        this.check_protocol(protocol);
        if (protocol.equals("inproc")) {
            Ctx.Endpoint endpoint = new Ctx.Endpoint(this, this.options);
            boolean rc = this.register_endpoint(addr, endpoint);
            if (rc) {
                this.options.last_endpoint = addr;
                this.errno.set(48);
            }
            return rc;
        }
        if (protocol.equals("pgm") || protocol.equals("epgm")) {
            return this.connect(addr);
        }
        IOThread io_thread = this.choose_io_thread(this.options.affinity);
        if (io_thread == null) {
            throw new IllegalStateException("EMTHREAD");
        }
        if (protocol.equals("tcp")) {
            TcpListener listener = new TcpListener(io_thread, this, this.options);
            int rc = listener.set_address(address);
            if (rc != 0) {
                listener.destroy();
                this.event_bind_failed(address, rc);
                this.errno.set(rc);
                return false;
            }
            this.options.last_endpoint = listener.get_address();
            this.add_endpoint(this.options.last_endpoint, listener);
            return true;
        }
        if (protocol.equals("ipc")) {
            IpcListener listener = new IpcListener(io_thread, this, this.options);
            int rc = listener.set_address(address);
            if (rc != 0) {
                listener.destroy();
                this.event_bind_failed(address, rc);
                this.errno.set(rc);
                return false;
            }
            this.options.last_endpoint = listener.get_address();
            this.add_endpoint(addr, listener);
            return true;
        }
        throw new IllegalArgumentException(addr);
    }

    public boolean connect(String addr_) {
        URI uri;
        if (this.ctx_terminated) {
            throw new ZError.CtxTerminatedException();
        }
        boolean brc = this.process_commands(0, false);
        if (!brc) {
            return false;
        }
        try {
            uri = new URI(addr_);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String protocol = uri.getScheme();
        String address = uri.getAuthority();
        String path = uri.getPath();
        if (address == null) {
            address = path;
        }
        this.check_protocol(protocol);
        if (protocol.equals("inproc")) {
            boolean written;
            Msg id;
            Ctx.Endpoint peer = this.find_endpoint(addr_);
            if (peer.socket == null) {
                return false;
            }
            int sndhwm = 0;
            if (this.options.sndhwm != 0 && peer.options.rcvhwm != 0) {
                sndhwm = this.options.sndhwm + peer.options.rcvhwm;
            }
            int rcvhwm = 0;
            if (this.options.rcvhwm != 0 && peer.options.sndhwm != 0) {
                rcvhwm = this.options.rcvhwm + peer.options.sndhwm;
            }
            ZObject[] parents = new ZObject[]{this, peer.socket};
            Pipe[] pipes = new Pipe[]{null, null};
            int[] hwms = new int[]{sndhwm, rcvhwm};
            boolean[] delays = new boolean[]{this.options.delay_on_disconnect, this.options.delay_on_close};
            Pipe.pipepair(parents, pipes, hwms, delays);
            this.attach_pipe(pipes[0]);
            if (peer.options.recv_identity) {
                id = new Msg(this.options.identity_size);
                id.put(this.options.identity, 0, this.options.identity_size);
                id.setFlags(64);
                written = pipes[0].write(id);
                assert (written);
                pipes[0].flush();
            }
            if (this.options.recv_identity) {
                id = new Msg(peer.options.identity_size);
                id.put(peer.options.identity, 0, peer.options.identity_size);
                id.setFlags(64);
                written = pipes[1].write(id);
                assert (written);
                pipes[1].flush();
            }
            this.send_bind(peer.socket, pipes[1], false);
            this.options.last_endpoint = addr_;
            this.inprocs.put(addr_, pipes[0]);
            return true;
        }
        IOThread io_thread = this.choose_io_thread(this.options.affinity);
        if (io_thread == null) {
            throw new IllegalStateException("Empty IO Thread");
        }
        boolean ipv4only = this.options.ipv4only != 0;
        Address paddr = new Address(protocol, address, ipv4only);
        paddr.resolve();
        SessionBase session = SessionBase.create(io_thread, true, this, this.options, paddr);
        assert (session != null);
        boolean icanhasall = false;
        if (protocol.equals("pgm") || protocol.equals("epgm")) {
            icanhasall = true;
        }
        if (this.options.delay_attach_on_connect != 1 || icanhasall) {
            ZObject[] parents = new ZObject[]{this, session};
            Pipe[] pipes = new Pipe[]{null, null};
            int[] hwms = new int[]{this.options.sndhwm, this.options.rcvhwm};
            boolean[] delays = new boolean[]{this.options.delay_on_disconnect, this.options.delay_on_close};
            Pipe.pipepair(parents, pipes, hwms, delays);
            this.attach_pipe(pipes[0], icanhasall);
            session.attach_pipe(pipes[1]);
        }
        this.options.last_endpoint = paddr.toString();
        this.add_endpoint(addr_, session);
        return true;
    }

    private void add_endpoint(String addr_, Own endpoint_) {
        this.launch_child(endpoint_);
        this.endpoints.put(addr_, endpoint_);
    }

    public boolean term_endpoint(String addr_) {
        URI uri;
        if (this.ctx_terminated) {
            throw new ZError.CtxTerminatedException();
        }
        if (addr_ == null) {
            throw new IllegalArgumentException();
        }
        boolean rc = this.process_commands(0, false);
        if (!rc) {
            return rc;
        }
        try {
            uri = new URI(addr_);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String protocol = uri.getScheme();
        if (protocol.equals("inproc")) {
            if (!this.inprocs.containsKey(addr_)) {
                return false;
            }
            Iterator<Map.Entry<String, Pipe>> it = this.inprocs.entrySet().iterator();
            while (it.hasNext()) {
                it.next().getValue().terminate(true);
                it.remove();
            }
            return true;
        }
        if (!this.endpoints.containsKey(addr_)) {
            return false;
        }
        Iterator<Map.Entry<String, Own>> it = this.endpoints.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Own> e = it.next();
            if (!e.getKey().equals(addr_)) continue;
            this.term_child(e.getValue());
            it.remove();
        }
        return true;
    }

    public boolean send(Msg msg_, int flags_) {
        block9: {
            long end;
            boolean rc;
            if (this.ctx_terminated) {
                this.errno.set(156384765);
                return false;
            }
            if (msg_ == null) {
                throw new IllegalArgumentException();
            }
            boolean brc = this.process_commands(0, true);
            if (!brc) {
                return false;
            }
            msg_.resetFlags(1);
            if ((flags_ & 2) > 0) {
                msg_.setFlags(1);
            }
            if (rc = this.xsend(msg_)) {
                return true;
            }
            if (this.errno.get() != 35) {
                return false;
            }
            if ((flags_ & 1) > 0 || this.options.sndtimeo == 0) {
                return false;
            }
            int timeout = this.options.sndtimeo;
            long l = end = timeout < 0 ? 0L : Clock.now_ms() + (long)timeout;
            do {
                if (!this.process_commands(timeout, false)) {
                    return false;
                }
                rc = this.xsend(msg_);
                if (rc) break block9;
                if (this.errno.get() == 35) continue;
                return false;
            } while (timeout <= 0 || (timeout = (int)(end - Clock.now_ms())) > 0);
            this.errno.set(35);
            return false;
        }
        return true;
    }

    public Msg recv(int flags_) {
        Msg msg_;
        block11: {
            if (this.ctx_terminated) {
                this.errno.set(156384765);
                return null;
            }
            if (++this.ticks == Config.INBOUND_POLL_RATE.getValue()) {
                if (!this.process_commands(0, false)) {
                    return null;
                }
                this.ticks = 0;
            }
            if ((msg_ = this.xrecv()) == null && this.errno.get() != 35) {
                return null;
            }
            if (msg_ != null) {
                this.extract_flags(msg_);
                return msg_;
            }
            if ((flags_ & 1) > 0 || this.options.rcvtimeo == 0) {
                if (!this.process_commands(0, false)) {
                    return null;
                }
                this.ticks = 0;
                msg_ = this.xrecv();
                if (msg_ == null) {
                    return null;
                }
                this.extract_flags(msg_);
                return msg_;
            }
            int timeout = this.options.rcvtimeo;
            long end = timeout < 0 ? 0L : Clock.now_ms() + (long)timeout;
            boolean block = this.ticks != 0;
            do {
                if (!this.process_commands(block ? timeout : 0, false)) {
                    return null;
                }
                msg_ = this.xrecv();
                if (msg_ != null) break block11;
                if (this.errno.get() != 35) {
                    return null;
                }
                block = true;
            } while (timeout <= 0 || (timeout = (int)(end - Clock.now_ms())) > 0);
            this.errno.set(35);
            return null;
        }
        this.ticks = 0;
        this.extract_flags(msg_);
        return msg_;
    }

    public void close() {
        this.tag = -559038737;
        this.send_reap(this);
    }

    public boolean has_in() {
        return this.xhas_in();
    }

    public boolean has_out() {
        return this.xhas_out();
    }

    public void start_reaping(Poller poller_) {
        this.poller = poller_;
        this.handle = this.mailbox.get_fd();
        this.poller.add_fd(this.handle, this);
        this.poller.set_pollin(this.handle);
        this.terminate();
        this.check_destroy();
    }

    private boolean process_commands(int timeout_, boolean throttle_) {
        Command cmd;
        boolean ret = true;
        if (timeout_ != 0) {
            cmd = this.mailbox.recv(timeout_);
        } else {
            long tsc = 0L;
            if (tsc != 0L && throttle_) {
                if (tsc >= this.last_tsc && tsc - this.last_tsc <= (long)Config.MAX_COMMAND_DELAY.getValue()) {
                    return true;
                }
                this.last_tsc = tsc;
            }
            cmd = this.mailbox.recv(0L);
        }
        while (cmd != null) {
            cmd.destination().process_command(cmd);
            cmd = this.mailbox.recv(0L);
        }
        if (this.ctx_terminated) {
            this.errno.set(156384765);
            return false;
        }
        return ret;
    }

    @Override
    protected void process_stop() {
        this.stop_monitor();
        this.ctx_terminated = true;
    }

    @Override
    protected void process_bind(Pipe pipe_) {
        this.attach_pipe(pipe_);
    }

    @Override
    protected void process_term(int linger_) {
        this.unregister_endpoints(this);
        for (int i = 0; i != this.pipes.size(); ++i) {
            this.pipes.get(i).terminate(false);
        }
        this.register_term_acks(this.pipes.size());
        super.process_term(linger_);
    }

    @Override
    protected void process_destroy() {
        this.destroyed = true;
    }

    protected boolean xsetsockopt(int option_, Object optval_) {
        return false;
    }

    protected boolean xhas_out() {
        return false;
    }

    protected boolean xsend(Msg msg_) {
        throw new UnsupportedOperationException("Must Override");
    }

    protected boolean xhas_in() {
        return false;
    }

    protected Msg xrecv() {
        throw new UnsupportedOperationException("Must Override");
    }

    protected void xread_activated(Pipe pipe_) {
        throw new UnsupportedOperationException("Must Override");
    }

    protected void xwrite_activated(Pipe pipe_) {
        throw new UnsupportedOperationException("Must Override");
    }

    protected void xhiccuped(Pipe pipe_) {
        throw new UnsupportedOperationException("Must override");
    }

    @Override
    public void in_event() {
        try {
            this.process_commands(0, false);
        }
        catch (ZError.CtxTerminatedException ctxTerminatedException) {
            // empty catch block
        }
        this.check_destroy();
    }

    @Override
    public void out_event() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connect_event() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept_event() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void timer_event(int id_) {
        throw new UnsupportedOperationException();
    }

    private void check_destroy() {
        if (this.destroyed) {
            this.poller.rm_fd(this.handle);
            this.destroy_socket(this);
            this.send_reaped();
            super.process_destroy();
        }
    }

    @Override
    public void read_activated(Pipe pipe_) {
        this.xread_activated(pipe_);
    }

    @Override
    public void write_activated(Pipe pipe_) {
        this.xwrite_activated(pipe_);
    }

    @Override
    public void hiccuped(Pipe pipe_) {
        if (this.options.delay_attach_on_connect == 1) {
            pipe_.terminate(false);
        } else {
            this.xhiccuped(pipe_);
        }
    }

    @Override
    public void terminated(Pipe pipe_) {
        this.xterminated(pipe_);
        Iterator<Map.Entry<String, Pipe>> it = this.inprocs.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next().getValue() != pipe_) continue;
            it.remove();
            break;
        }
        this.pipes.remove(pipe_);
        if (this.is_terminating()) {
            this.unregister_term_ack();
        }
    }

    private void extract_flags(Msg msg_) {
        if ((msg_.flags() & 0x40) > 0) assert (this.options.recv_identity);
        this.rcvmore = msg_.hasMore();
    }

    public boolean monitor(String addr_, int events_) {
        URI uri;
        if (this.ctx_terminated) {
            throw new ZError.CtxTerminatedException();
        }
        if (addr_ == null) {
            this.stop_monitor();
            return true;
        }
        try {
            uri = new URI(addr_);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String protocol = uri.getScheme();
        String address = uri.getAuthority();
        String path = uri.getPath();
        if (address == null) {
            address = path;
        }
        this.check_protocol(protocol);
        if (!protocol.equals("inproc")) {
            this.stop_monitor();
            throw new IllegalArgumentException("inproc socket required");
        }
        this.monitor_events = events_;
        this.monitor_socket = this.get_ctx().create_socket(0);
        if (this.monitor_socket == null) {
            return false;
        }
        int linger = 0;
        try {
            this.monitor_socket.setsockopt(17, linger);
        }
        catch (IllegalArgumentException e) {
            this.stop_monitor();
            throw e;
        }
        boolean rc = this.monitor_socket.bind(addr_);
        if (!rc) {
            this.stop_monitor();
        }
        return rc;
    }

    public void event_connected(String addr, SelectableChannel ch) {
        if ((this.monitor_events & 1) == 0) {
            return;
        }
        this.monitor_event(new ZMQ.Event(1, addr, ch));
    }

    public void event_connect_delayed(String addr, int errno) {
        if ((this.monitor_events & 2) == 0) {
            return;
        }
        this.monitor_event(new ZMQ.Event(2, addr, errno));
    }

    public void event_connect_retried(String addr, int interval) {
        if ((this.monitor_events & 4) == 0) {
            return;
        }
        this.monitor_event(new ZMQ.Event(4, addr, interval));
    }

    public void event_listening(String addr, SelectableChannel ch) {
        if ((this.monitor_events & 8) == 0) {
            return;
        }
        this.monitor_event(new ZMQ.Event(8, addr, ch));
    }

    public void event_bind_failed(String addr, int errno) {
        if ((this.monitor_events & 0x10) == 0) {
            return;
        }
        this.monitor_event(new ZMQ.Event(16, addr, errno));
    }

    public void event_accepted(String addr, SelectableChannel ch) {
        if ((this.monitor_events & 0x20) == 0) {
            return;
        }
        this.monitor_event(new ZMQ.Event(32, addr, ch));
    }

    public void event_accept_failed(String addr, int errno) {
        if ((this.monitor_events & 0x40) == 0) {
            return;
        }
        this.monitor_event(new ZMQ.Event(64, addr, errno));
    }

    public void event_closed(String addr, SelectableChannel ch) {
        if ((this.monitor_events & 0x80) == 0) {
            return;
        }
        this.monitor_event(new ZMQ.Event(128, addr, ch));
    }

    public void event_close_failed(String addr, int errno) {
        if ((this.monitor_events & 0x100) == 0) {
            return;
        }
        this.monitor_event(new ZMQ.Event(256, addr, errno));
    }

    public void event_disconnected(String addr, SelectableChannel ch) {
        if ((this.monitor_events & 0x200) == 0) {
            return;
        }
        this.monitor_event(new ZMQ.Event(512, addr, ch));
    }

    protected void monitor_event(ZMQ.Event event) {
        if (this.monitor_socket == null) {
            return;
        }
        event.write(this.monitor_socket);
    }

    protected void stop_monitor() {
        if (this.monitor_socket != null) {
            if ((this.monitor_events & 0x400) != 0) {
                this.monitor_event(new ZMQ.Event(1024, "", 0));
            }
            this.monitor_socket.close();
            this.monitor_socket = null;
            this.monitor_events = 0;
        }
    }

    public String toString() {
        return super.toString() + "[" + this.options.socket_id + "]";
    }

    public SelectableChannel get_fd() {
        return this.mailbox.get_fd();
    }

    public String typeString() {
        switch (this.options.type) {
            case 0: {
                return "PAIR";
            }
            case 1: {
                return "PUB";
            }
            case 2: {
                return "SUB";
            }
            case 3: {
                return "REQ";
            }
            case 4: {
                return "REP";
            }
            case 5: {
                return "DEALER";
            }
            case 6: {
                return "ROUTER";
            }
            case 7: {
                return "PULL";
            }
            case 8: {
                return "PUSH";
            }
        }
        return "UNKOWN";
    }

    public int errno() {
        return this.errno.get();
    }
}

