/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Blob;
import zmq.Config;
import zmq.Msg;
import zmq.YPipe;
import zmq.ZObject;

public class Pipe
extends ZObject {
    private YPipe<Msg> inpipe;
    private YPipe<Msg> outpipe;
    private boolean in_active;
    private boolean out_active;
    private int hwm;
    private int lwm;
    private long msgs_read;
    private long msgs_written;
    private long peers_msgs_read;
    private Pipe peer;
    private IPipeEvents sink;
    private State state;
    private boolean delay;
    private Blob identity;
    private ZObject parent;

    private Pipe(ZObject parent_, YPipe<Msg> inpipe_, YPipe<Msg> outpipe_, int inhwm_, int outhwm_, boolean delay_) {
        super(parent_);
        this.inpipe = inpipe_;
        this.outpipe = outpipe_;
        this.in_active = true;
        this.out_active = true;
        this.hwm = outhwm_;
        this.lwm = Pipe.compute_lwm(inhwm_);
        this.msgs_read = 0L;
        this.msgs_written = 0L;
        this.peers_msgs_read = 0L;
        this.peer = null;
        this.sink = null;
        this.state = State.ACTIVE;
        this.delay = delay_;
        this.parent = parent_;
    }

    public static void pipepair(ZObject[] parents_, Pipe[] pipes_, int[] hwms_, boolean[] delays_) {
        YPipe<Msg> upipe1 = new YPipe<Msg>(Config.MESSAGE_PIPE_GRANULARITY.getValue());
        YPipe<Msg> upipe2 = new YPipe<Msg>(Config.MESSAGE_PIPE_GRANULARITY.getValue());
        pipes_[0] = new Pipe(parents_[0], upipe1, upipe2, hwms_[1], hwms_[0], delays_[0]);
        pipes_[1] = new Pipe(parents_[1], upipe2, upipe1, hwms_[0], hwms_[1], delays_[1]);
        pipes_[0].set_peer(pipes_[1]);
        pipes_[1].set_peer(pipes_[0]);
    }

    private void set_peer(Pipe peer_) {
        assert (peer_ != null);
        this.peer = peer_;
    }

    public void set_event_sink(IPipeEvents sink_) {
        assert (this.sink == null);
        this.sink = sink_;
    }

    public void set_identity(Blob identity_) {
        this.identity = identity_;
    }

    public Blob get_identity() {
        return this.identity;
    }

    public boolean check_read() {
        if (!this.in_active || this.state != State.ACTIVE && this.state != State.PENDING) {
            return false;
        }
        if (!this.inpipe.check_read()) {
            this.in_active = false;
            return false;
        }
        if (Pipe.is_delimiter(this.inpipe.probe())) {
            Msg msg = this.inpipe.read();
            assert (msg != null);
            this.delimit();
            return false;
        }
        return true;
    }

    public Msg read() {
        if (!this.in_active || this.state != State.ACTIVE && this.state != State.PENDING) {
            return null;
        }
        Msg msg_ = this.inpipe.read();
        if (msg_ == null) {
            this.in_active = false;
            return null;
        }
        if (msg_.isDelimiter()) {
            this.delimit();
            return null;
        }
        if (!msg_.hasMore()) {
            ++this.msgs_read;
        }
        if (this.lwm > 0 && this.msgs_read % (long)this.lwm == 0L) {
            this.send_activate_write(this.peer, this.msgs_read);
        }
        return msg_;
    }

    public boolean check_write() {
        boolean full;
        if (!this.out_active || this.state != State.ACTIVE) {
            return false;
        }
        boolean bl = full = this.hwm > 0 && this.msgs_written - this.peers_msgs_read == (long)this.hwm;
        if (full) {
            this.out_active = false;
            return false;
        }
        return true;
    }

    public boolean write(Msg msg_) {
        if (!this.check_write()) {
            return false;
        }
        boolean more = msg_.hasMore();
        this.outpipe.write(msg_, more);
        if (!more) {
            ++this.msgs_written;
        }
        return true;
    }

    public void rollback() {
        if (this.outpipe != null) {
            Msg msg;
            while ((msg = this.outpipe.unwrite()) != null) {
                assert ((msg.flags() & 1) > 0);
            }
        }
    }

    public void flush() {
        if (this.state == State.TERMINATING) {
            return;
        }
        if (this.outpipe != null && !this.outpipe.flush()) {
            this.send_activate_read(this.peer);
        }
    }

    @Override
    protected void process_activate_read() {
        if (!(this.in_active || this.state != State.ACTIVE && this.state != State.PENDING)) {
            this.in_active = true;
            this.sink.read_activated(this);
        }
    }

    @Override
    protected void process_activate_write(long msgs_read_) {
        this.peers_msgs_read = msgs_read_;
        if (!this.out_active && this.state == State.ACTIVE) {
            this.out_active = true;
            this.sink.write_activated(this);
        }
    }

    @Override
    protected void process_hiccup(Object pipe_) {
        assert (this.outpipe != null);
        this.outpipe.flush();
        while (this.outpipe.read() != null) {
        }
        assert (pipe_ != null);
        this.outpipe = (YPipe)pipe_;
        this.out_active = true;
        if (this.state == State.ACTIVE) {
            this.sink.hiccuped(this);
        }
    }

    @Override
    protected void process_pipe_term() {
        if (this.state == State.ACTIVE) {
            if (!this.delay) {
                this.state = State.TERMINATING;
                this.outpipe = null;
                this.send_pipe_term_ack(this.peer);
            } else {
                this.state = State.PENDING;
            }
            return;
        }
        if (this.state == State.DELIMITED) {
            this.state = State.TERMINATING;
            this.outpipe = null;
            this.send_pipe_term_ack(this.peer);
            return;
        }
        if (this.state == State.TERMINATED) {
            this.state = State.DOUBLE_TERMINATED;
            this.outpipe = null;
            this.send_pipe_term_ack(this.peer);
            return;
        }
        assert (false);
    }

    @Override
    protected void process_pipe_term_ack() {
        assert (this.sink != null);
        this.sink.terminated(this);
        if (this.state == State.TERMINATED) {
            this.outpipe = null;
            this.send_pipe_term_ack(this.peer);
        } else assert (this.state == State.TERMINATING || this.state == State.DOUBLE_TERMINATED);
        while (this.inpipe.read() != null) {
        }
        this.inpipe = null;
    }

    public void terminate(boolean delay_) {
        this.delay = delay_;
        if (this.state == State.TERMINATED || this.state == State.DOUBLE_TERMINATED) {
            return;
        }
        if (this.state == State.TERMINATING) {
            return;
        }
        if (this.state == State.ACTIVE) {
            this.send_pipe_term(this.peer);
            this.state = State.TERMINATED;
        } else if (this.state == State.PENDING && !this.delay) {
            this.outpipe = null;
            this.send_pipe_term_ack(this.peer);
            this.state = State.TERMINATING;
        } else if (this.state != State.PENDING) {
            if (this.state == State.DELIMITED) {
                this.send_pipe_term(this.peer);
                this.state = State.TERMINATED;
            } else assert (false);
        }
        this.out_active = false;
        if (this.outpipe != null) {
            this.rollback();
            Msg msg = new Msg();
            msg.initDelimiter();
            this.outpipe.write(msg, false);
            this.flush();
        }
    }

    private static boolean is_delimiter(Msg msg_) {
        return msg_.isDelimiter();
    }

    private static int compute_lwm(int hwm_) {
        int result = hwm_ > Config.MAX_WM_DELTA.getValue() * 2 ? hwm_ - Config.MAX_WM_DELTA.getValue() : (hwm_ + 1) / 2;
        return result;
    }

    private void delimit() {
        if (this.state == State.ACTIVE) {
            this.state = State.DELIMITED;
            return;
        }
        if (this.state == State.PENDING) {
            this.outpipe = null;
            this.send_pipe_term_ack(this.peer);
            this.state = State.TERMINATING;
            return;
        }
        assert (false);
    }

    public void hiccup() {
        if (this.state != State.ACTIVE) {
            return;
        }
        this.inpipe = null;
        this.inpipe = new YPipe(Config.MESSAGE_PIPE_GRANULARITY.getValue());
        this.in_active = true;
        this.send_hiccup(this.peer, this.inpipe);
    }

    public String toString() {
        return super.toString() + "[" + this.parent + "]";
    }

    static enum State {
        ACTIVE,
        DELIMITED,
        PENDING,
        TERMINATING,
        TERMINATED,
        DOUBLE_TERMINATED;

    }

    public static interface IPipeEvents {
        public void read_activated(Pipe var1);

        public void write_activated(Pipe var1);

        public void hiccuped(Pipe var1);

        public void terminated(Pipe var1);
    }
}

