/*
 * Decompiled with CFR 0.152.
 */
package org.tango.utils;

import fr.esrf.Tango.DevFailed;
import org.tango.utils.CircuitBreakerCommand;

public class SimpleCircuitBreaker {
    private final CircuitBreakerCommand command;
    private static final int RETRIES_BEFORE_OPEN_CIRCUIT_BREAKER = 3;
    private static final int WAIT_CIRCUIT_BREAKER_OPEN = 30000;
    private static final int WAIT_CIRCUIT_BREAKER_CLOSE = 3000;
    private int retryNr = 0;

    public SimpleCircuitBreaker(CircuitBreakerCommand command) {
        this.command = command;
    }

    public void execute(int retriesBeforeOpen, int waitCircuitOpen, int waitCircuitClose) throws DevFailed {
        boolean ok = false;
        this.retryNr = 0;
        while (!ok) {
            try {
                this.command.execute();
                ok = true;
            }
            catch (DevFailed e) {
                ok = false;
                this.command.notifyError(e);
                this.getFallback(retriesBeforeOpen, waitCircuitOpen, waitCircuitClose);
            }
        }
    }

    private void getFallback(int retriesBeforeOpen, int waitCircuitOpen, int waitCircuitClose) throws DevFailed {
        this.command.getFallback();
        ++this.retryNr;
        if (this.retryNr == retriesBeforeOpen) {
            this.retryNr = 0;
            try {
                Thread.sleep(waitCircuitOpen);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
        } else {
            try {
                Thread.sleep(waitCircuitClose);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void execute() throws DevFailed {
        this.execute(3, 30000, 3000);
    }
}

