/*
 * Decompiled with CFR 0.152.
 */
package org.tango.utils;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DevFailedUtils {
    private static final String TANGO_ERROR = "TANGO_ERROR";
    private static final Logger LOGGER = LoggerFactory.getLogger(DevFailedUtils.class);
    public static final String TANGO_BUILD_FAILED = "TANGO_BUILD_FAILED";

    private DevFailedUtils() {
    }

    public static DevFailed newDevFailed(String reason, String desc) {
        LOGGER.error("{}, {}", (Object)reason, (Object)desc);
        DevFailed ex = new DevFailed(reason, DevFailedUtils.buildDevError(reason, desc, 3));
        LOGGER.error("", ex);
        return ex;
    }

    public static DevFailed newDevFailed(String msg) {
        LOGGER.error(msg);
        DevFailed ex = new DevFailed(msg, DevFailedUtils.buildDevError(TANGO_ERROR, msg, 3));
        LOGGER.error("", ex);
        return ex;
    }

    @Deprecated
    public static void throwDevFailed(String msg) throws DevFailed {
        DevFailed e = new DevFailed(msg, DevFailedUtils.buildDevError(TANGO_ERROR, msg, 3));
        LOGGER.error(msg);
        LOGGER.error("", e);
        throw e;
    }

    @Deprecated
    public static void throwDevFailed(String reason, String desc) throws DevFailed {
        DevFailed e = new DevFailed(reason, DevFailedUtils.buildDevError(reason, desc, 3));
        LOGGER.error("{}, {}", (Object)reason, (Object)desc);
        LOGGER.error("", e);
        throw e;
    }

    public static DevError[] buildDevError(String reason, String desc, int stackLevel) {
        DevError[] err = new DevError[]{new DevError()};
        err[0].desc = desc;
        err[0].severity = ErrSeverity.ERR;
        err[0].reason = reason;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        err[0].origin = stackTrace[stackLevel].toString();
        return err;
    }

    public static DevFailed newDevFailed(Throwable origin) {
        DevError[] err = new DevError[]{new DevError()};
        err[0].desc = origin.getClass().getCanonicalName();
        err[0].severity = ErrSeverity.PANIC;
        err[0].reason = "NA";
        StringWriter sw = new StringWriter();
        origin.printStackTrace(new PrintWriter(sw));
        err[0].origin = sw.toString();
        DevFailed e = new DevFailed(origin.getLocalizedMessage(), err);
        return e;
    }

    public static void throwDevFailed(Throwable origin) throws DevFailed {
        DevFailed e = DevFailedUtils.newDevFailed(origin);
        LOGGER.error("throwing DevFailed from ", origin);
        throw e;
    }

    public static String toString(DevFailed e) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("exception message is: ").append(e.getLocalizedMessage());
        if (e.errors != null) {
            for (int i = 0; i < e.errors.length; ++i) {
                buffer.append("\nError Level ").append(i).append(":\n");
                buffer.append("\t - desc: ").append(e.errors[i].desc).append("\n");
                buffer.append("\t - origin: ").append(e.errors[i].origin).append("\n");
                buffer.append("\t - reason: ").append(e.errors[i].reason).append("\n");
                String sev = "";
                if (e.errors[i].severity.value() == ErrSeverity.ERR.value()) {
                    sev = "ERROR";
                } else if (e.errors[i].severity.value() == ErrSeverity.PANIC.value()) {
                    sev = "PANIC";
                } else if (e.errors[i].severity.value() == ErrSeverity.WARN.value()) {
                    sev = "WARN";
                }
                buffer.append("\t - severity: ").append(sev).append("\n");
            }
        } else {
            buffer.append("EMPTY DevFailed");
        }
        return buffer.toString();
    }

    public static void logDevFailed(DevFailed e, Logger logger) {
        if (e.errors != null) {
            for (int i = 0; i < e.errors.length; ++i) {
                logger.error("Error Level {} :", (Object)i);
                logger.error("\t - desc: {}", (Object)e.errors[i].desc);
                logger.error("\t - origin: {}", (Object)e.errors[i].origin);
                logger.error("\t - reason: {}", (Object)e.errors[i].reason);
                String sev = "";
                if (e.errors[i].severity.value() == ErrSeverity.ERR.value()) {
                    sev = "ERROR";
                } else if (e.errors[i].severity.value() == ErrSeverity.PANIC.value()) {
                    sev = "PANIC";
                } else if (e.errors[i].severity.value() == ErrSeverity.WARN.value()) {
                    sev = "WARN";
                }
                logger.error("\t - severity: {}", (Object)sev);
            }
        } else {
            logger.error("EMPTY DevFailed");
        }
    }

    public static void printDevFailed(DevFailed e) {
        System.err.println(DevFailedUtils.toString(e));
    }
}

