/*
 * Decompiled with CFR 0.152.
 */
package org.tango.utils;

import fr.esrf.Tango.ClntIdent;
import fr.esrf.Tango.JavaClntIdent;
import fr.esrf.Tango.LockerLanguage;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPLoopbackConnection;
import org.omg.ETF.Connection;

public final class ClientIDUtil {
    private ClientIDUtil() {
    }

    public static ClntIdent copyClntIdent(ClntIdent clt) {
        ClntIdent copy = new ClntIdent();
        if (clt != null) {
            if (clt.discriminator().equals(LockerLanguage.CPP)) {
                copy.cpp_clnt(clt.cpp_clnt());
            } else {
                JavaClntIdent copyJava = new JavaClntIdent();
                copyJava.uuid = Arrays.copyOf(clt.java_clnt().uuid, clt.java_clnt().uuid.length);
                copyJava.MainClass = clt.java_clnt().MainClass;
                copy.java_clnt(copyJava);
            }
        }
        return copy;
    }

    public static boolean clientIdentEqual(ClntIdent ident1, ClntIdent ident2) {
        boolean areEqual = true;
        if (ident1 == null || ident2 == null || ident1.discriminator() == null || ident2.discriminator() == null) {
            areEqual = false;
        } else if (ident1.discriminator().value() != ident2.discriminator().value()) {
            areEqual = false;
        } else if (ident1.discriminator().equals(LockerLanguage.CPP) && ident1.cpp_clnt() != ident2.cpp_clnt()) {
            areEqual = false;
        } else if (ident1.discriminator().equals(LockerLanguage.JAVA) && ident1.java_clnt().MainClass.equalsIgnoreCase(ident2.java_clnt().MainClass)) {
            areEqual = false;
        } else if (ident1.discriminator().equals(LockerLanguage.JAVA) && !Arrays.equals(ident1.java_clnt().uuid, ident2.java_clnt().uuid)) {
            areEqual = false;
        }
        return areEqual;
    }

    public static String toString(ClntIdent ident) {
        StringBuilder sb = new StringBuilder();
        if (ident == null || ident.discriminator() == null) {
            sb.append("empty ClntIdent");
        } else if (ident.discriminator().equals(LockerLanguage.CPP)) {
            sb.append("CPP client with PID ").append(ident.cpp_clnt());
        } else {
            sb.append("Java client with Main class ").append(ident.java_clnt().MainClass);
        }
        return sb.toString();
    }

    public static String hostNameFrom(Connection connection) {
        if (connection instanceof IIOPConnection) {
            IIOPConnection iiopConnection = (IIOPConnection)connection;
            return iiopConnection.getSocket().getInetAddress().getHostName();
        }
        if (connection instanceof IIOPLoopbackConnection) {
            try {
                return InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                return "localhost";
            }
        }
        throw new IllegalStateException("Unknown connection type: " + connection.getClass());
    }
}

