/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.schedule;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.annotation.Schedule;
import org.tango.server.properties.PropertiesUtils;
import org.tango.server.schedule.DeviceJob;
import org.tango.utils.DevFailedUtils;

public final class DeviceScheduler {
    private static final String JOB_PARAM_DEVICE = "device";
    private static final String JOB_PARAM_METHOD = "method";
    private static final String SCHEDULE_PROP = "schedule";
    private final Logger logger = LoggerFactory.getLogger(DeviceScheduler.class);
    private final Set<Method> methodList;
    private final Object businessObject;
    private Scheduler quartz;
    private final String deviceName;
    private final String className;
    private static int poolSize = Math.min(10, Runtime.getRuntime().availableProcessors());

    public DeviceScheduler(Object businessObject, Set<Method> methodList, String deviceName, String className) {
        this.businessObject = businessObject;
        this.methodList = methodList;
        this.deviceName = deviceName;
        this.className = className;
    }

    public void triggerJob() throws DevFailed {
        for (Method method : this.methodList) {
            Schedule config = method.getAnnotation(Schedule.class);
            String[] activationProps = PropertiesUtils.getDeviceProperty(this.deviceName, this.className, config.activationProperty());
            boolean active = false;
            if (activationProps.length > 0 && (activationProps[0].equalsIgnoreCase("true") || activationProps[0].equalsIgnoreCase("1"))) {
                active = true;
            }
            if (!active) continue;
            try {
                if (this.quartz == null) {
                    StdSchedulerFactory fact = new StdSchedulerFactory();
                    Properties props = new Properties();
                    this.logger.debug("setting pool size to  {}", (Object)poolSize);
                    props.put("org.quartz.threadPool.threadCount", Integer.toString(poolSize));
                    fact.initialize(props);
                    this.quartz = fact.getScheduler();
                    this.quartz.start();
                }
            }
            catch (SchedulerException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            String devicePropName = method.getName() + SCHEDULE_PROP;
            String[] deviceProps = PropertiesUtils.getDeviceProperty(this.deviceName, this.className, devicePropName);
            String cronExpression = "";
            if (deviceProps.length > 0) {
                cronExpression = deviceProps[0];
            }
            if (cronExpression.isEmpty()) {
                cronExpression = config.cronExpression();
            }
            CronTrigger trigger = null;
            try {
                trigger = !config.timezone().isEmpty() ? TriggerBuilder.newTrigger().withSchedule(CronScheduleBuilder.cronSchedule(cronExpression).inTimeZone(TimeZone.getTimeZone(config.timezone()))).build() : TriggerBuilder.newTrigger().withSchedule(CronScheduleBuilder.cronSchedule(cronExpression)).build();
            }
            catch (RuntimeException e) {
                throw DevFailedUtils.newDevFailed("unable to start device scheduler for " + method + " - error is: " + e.getMessage());
            }
            try {
                if (this.quartz == null) {
                    StdSchedulerFactory fact = new StdSchedulerFactory();
                    Properties props = new Properties();
                    this.logger.debug("setting pool size to  {}", (Object)poolSize);
                    props.put("org.quartz.threadPool.threadCount", Integer.toString(poolSize));
                    fact.initialize(props);
                    this.quartz = fact.getScheduler();
                    this.quartz.start();
                }
                JobDetail job = JobBuilder.newJob(DeviceJob.class).withIdentity(method.getName(), this.deviceName).build();
                job.getJobDataMap().put(JOB_PARAM_DEVICE, this.businessObject);
                job.getJobDataMap().put(JOB_PARAM_METHOD, (Object)method);
                this.quartz.scheduleJob(job, trigger);
                this.logger.debug("start job on {} started with {}", (Object)method, (Object)cronExpression);
            }
            catch (SchedulerException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
        }
    }

    public static void setThreadPoolSize(int poolSize) {
        DeviceScheduler.poolSize = poolSize;
    }

    public void stop() throws DevFailed {
        try {
            if (this.quartz != null) {
                for (Method method : this.methodList) {
                    this.logger.debug("delete job for {}", (Object)method.getName());
                    this.quartz.deleteJob(new JobKey(method.getName(), this.deviceName));
                }
            }
        }
        catch (SchedulerException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
    }
}

