/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.properties;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.DefaultConverters;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.Transmorph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.client.database.DatabaseFactory;
import org.tango.utils.DevFailedUtils;

public final class PropertiesUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesUtils.class);
    private static Map<String, Map<String, String[]>> devicePropertiesCache = new HashMap<String, Map<String, String[]>>();
    private static Map<String, Map<String, String[]>> classPropertiesCache = new HashMap<String, Map<String, String[]>>();
    private static Map<String, Map<String, String[]>> devicePipePropertiesCache = new HashMap<String, Map<String, String[]>>();
    private static Map<String, Map<String, String[]>> classPipePropertiesCache = new HashMap<String, Map<String, String[]>>();

    private PropertiesUtils() {
    }

    public static void clearDeviceCache(String deviceName) {
        devicePropertiesCache.remove(deviceName);
        for (Map.Entry<String, Map<String, String[]>> entry : devicePipePropertiesCache.entrySet()) {
            if (!entry.getKey().startsWith(deviceName)) continue;
            devicePipePropertiesCache.remove(entry.getKey());
        }
    }

    public static void clearClassCache(String className) {
        classPropertiesCache.remove(className);
        for (Map.Entry<String, Map<String, String[]>> entry : devicePipePropertiesCache.entrySet()) {
            if (!entry.getKey().startsWith(className)) continue;
            classPipePropertiesCache.remove(className);
        }
    }

    public static void clearCache() {
        devicePropertiesCache.clear();
        classPropertiesCache.clear();
        devicePipePropertiesCache.clear();
        classPipePropertiesCache.clear();
    }

    public static Map<String, String[]> getDevicePipeProperties(String deviceName, String pipeName) throws DevFailed {
        Map<String, String[]> properties;
        String fullPipeName = deviceName + pipeName;
        if (devicePipePropertiesCache.containsKey(fullPipeName)) {
            properties = devicePipePropertiesCache.get(fullPipeName);
        } else {
            properties = DatabaseFactory.getDatabase().getDevicePipeProperties(deviceName, pipeName);
            devicePipePropertiesCache.put(fullPipeName, properties);
        }
        return properties;
    }

    public static Map<String, String[]> getDeviceProperties(String deviceName) throws DevFailed {
        Map<String, String[]> properties;
        if (devicePropertiesCache.containsKey(deviceName)) {
            properties = devicePropertiesCache.get(deviceName);
        } else {
            properties = DatabaseFactory.getDatabase().getDeviceProperties(deviceName, new String[0]);
            devicePropertiesCache.put(deviceName, properties);
        }
        return properties;
    }

    static Map<String, String[]> getClassProperties(String className) throws DevFailed {
        Map<String, String[]> properties;
        if (classPropertiesCache.containsKey(className)) {
            properties = classPropertiesCache.get(className);
        } else {
            properties = DatabaseFactory.getDatabase().getClassProperties(className, new String[0]);
            classPropertiesCache.put(className, properties);
        }
        return properties;
    }

    static Map<String, String[]> getClassPipeProperties(String className, String pipeName) throws DevFailed {
        Map<String, String[]> properties;
        String fullPipeName = className + pipeName;
        if (classPipePropertiesCache.containsKey(fullPipeName)) {
            properties = classPipePropertiesCache.get(fullPipeName);
        } else {
            properties = DatabaseFactory.getDatabase().getClassProperties(className, pipeName);
            classPipePropertiesCache.put(fullPipeName, properties);
        }
        return properties;
    }

    static String[] getProp(Map<String, String[]> prop, String propertyName) {
        String[] result = null;
        if (prop != null) {
            for (Map.Entry<String, String[]> entry : prop.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(propertyName)) continue;
                result = entry.getValue();
            }
        }
        return result;
    }

    public static String[] getDeviceProperty(String deviceName, String className, String propertyName) throws DevFailed {
        Object[] property = new String[]{};
        Map<String, String[]> prop = PropertiesUtils.getDeviceProperties(deviceName);
        String[] temp = PropertiesUtils.getProp(prop, propertyName);
        if (temp != null) {
            property = temp;
            LOGGER.debug("{} device property is {}", (Object)propertyName, (Object)Arrays.toString(property));
        } else {
            Map<String, String[]> propClass = PropertiesUtils.getClassProperties(className);
            String[] tempClass = PropertiesUtils.getProp(propClass, propertyName);
            if (tempClass != null) {
                property = tempClass;
                LOGGER.debug("{} class property is {}", (Object)propertyName, (Object)Arrays.toString(property));
            } else {
                LOGGER.debug("{} property value not found in tango db", (Object)propertyName);
            }
        }
        return property;
    }

    public static String[] getDevicePipeProperty(String deviceName, String className, String pipeName, String propertyName) throws DevFailed {
        Object[] property = new String[]{};
        Map<String, String[]> prop = PropertiesUtils.getDevicePipeProperties(deviceName, pipeName);
        String[] temp = PropertiesUtils.getProp(prop, propertyName);
        if (temp != null) {
            property = temp;
            LOGGER.debug("{} device pipe property is {}", (Object)propertyName, (Object)Arrays.toString(property));
        } else {
            Map<String, String[]> propClass = PropertiesUtils.getClassPipeProperties(className, pipeName);
            if (propClass.get(propertyName) != null) {
                property = propClass.get(propertyName);
                LOGGER.debug("{} class pipe property is {}", (Object)propertyName, (Object)Arrays.toString(property));
            } else {
                LOGGER.debug("{} pipe property {} value not found in tango db", (Object)pipeName, (Object)propertyName);
            }
        }
        return property;
    }

    static void injectProperty(String propertyName, Method propMethod, String[] property, Object businessObject, String[] defaultValue) throws DevFailed {
        Transmorph transmorph = new Transmorph((IConverter)new DefaultConverters());
        Class<?> paramType = propMethod.getParameterTypes()[0];
        if (paramType.isArray()) {
            PropertiesUtils.injectArray(propertyName, propMethod, property, businessObject, transmorph, paramType, defaultValue);
        } else {
            PropertiesUtils.injectValue(propertyName, propMethod, property, businessObject, transmorph, paramType, defaultValue);
        }
    }

    private static void injectValue(String propertyName, Method propMethod, String[] property, Object businessObject, Transmorph transmorph, Class<?> paramType, String[] defaultValue) throws DevFailed {
        Boolean propConverted = null;
        String trimmedDefaultValue = null;
        trimmedDefaultValue = defaultValue.length == 0 ? "" : defaultValue[0].trim();
        String valueToInject = property.length == 0 || property[0].isEmpty() ? trimmedDefaultValue : property[0].trim();
        if (!valueToInject.isEmpty()) {
            LOGGER.debug("{} inject: {}", (Object)propertyName, (Object)valueToInject);
            if (Boolean.class.isAssignableFrom(paramType) || Boolean.TYPE.isAssignableFrom(paramType)) {
                propConverted = valueToInject.equalsIgnoreCase("false") || valueToInject.equals("0") ? Boolean.valueOf(false) : Boolean.valueOf(true);
            } else {
                try {
                    propConverted = transmorph.convert((Object)valueToInject, paramType);
                }
                catch (ConverterException e) {
                    String errorMsg = "could not set property " + propertyName + ", error converting " + valueToInject + " to " + paramType.getCanonicalName();
                    if (property.length == 0 || property[0].isEmpty()) {
                        LOGGER.debug("{} is empty", (Object)propertyName);
                    }
                    throw DevFailedUtils.newDevFailed("PROPERTY_ERROR", errorMsg);
                }
            }
            try {
                if (propConverted != null) {
                    propMethod.invoke(businessObject, propConverted);
                }
            }
            catch (IllegalArgumentException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (IllegalAccessException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof DevFailed) {
                    throw (DevFailed)e.getCause();
                }
                throw DevFailedUtils.newDevFailed(e.getCause());
            }
        }
    }

    public static void setDevicePipePropertiesInDB(String deviceName, String pipeName, Map<String, String[]> properties) throws DevFailed {
        LOGGER.debug("update pipe {} device properties {} in DB ", (Object)pipeName, (Object)properties.keySet());
        DatabaseFactory.getDatabase().setDevicePipeProperties(deviceName, pipeName, properties);
    }

    private static void injectArray(String propertyName, Method propMethod, String[] property, Object businessObject, Transmorph transmorph, Class<?> paramType, String[] defaultValue) throws DevFailed {
        int i;
        Object[] trimProp;
        Object propConverted = null;
        if (property.length == 0 || property.length == 1 && property[0].isEmpty()) {
            trimProp = new String[defaultValue.length];
            for (i = 0; i < defaultValue.length; ++i) {
                trimProp[i] = defaultValue[i].trim();
            }
        } else {
            trimProp = new String[property.length];
            for (i = 0; i < property.length; ++i) {
                trimProp[i] = property[i].trim();
            }
        }
        LOGGER.debug("{} inject: {}", (Object)propertyName, (Object)Arrays.toString(trimProp));
        try {
            propConverted = transmorph.convert((Object)trimProp, paramType);
        }
        catch (ConverterException e) {
            String errorMsg = "could not set property " + propertyName + ", error converting " + Arrays.toString(trimProp) + " to " + paramType.getCanonicalName();
            if (property.length == 1 && property[0].isEmpty()) {
                LOGGER.error(errorMsg);
            }
            throw DevFailedUtils.newDevFailed("PROPERTY_ERROR", errorMsg);
        }
        try {
            if (propConverted != null) {
                propMethod.invoke(businessObject, propConverted);
            }
        }
        catch (IllegalArgumentException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        catch (IllegalAccessException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof DevFailed) {
                throw (DevFailed)e.getCause();
            }
            throw DevFailedUtils.newDevFailed(e.getCause());
        }
    }
}

