/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.pipe;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.StateMachineBehavior;
import org.tango.server.attribute.ReflectAttributeBehavior;
import org.tango.server.pipe.IPipeBehavior;
import org.tango.server.pipe.PipeConfiguration;
import org.tango.server.pipe.PipeValue;
import org.tango.utils.DevFailedUtils;

public final class ReflectPipeBehavior
implements IPipeBehavior {
    private final Logger logger = LoggerFactory.getLogger(ReflectAttributeBehavior.class);
    private final PipeConfiguration config;
    private final Method getter;
    private final Method setter;
    private final Object businessObject;

    public ReflectPipeBehavior(PipeConfiguration config, Object businessObject, Method getter, Method setter) {
        this.businessObject = businessObject;
        this.getter = getter;
        this.setter = setter;
        this.config = config;
    }

    @Override
    public PipeValue getValue() throws DevFailed {
        PipeValue result = null;
        if (this.getter != null) {
            try {
                this.logger.debug("read pipe {} from method '{}'", (Object)this.config.getName(), (Object)this.getter);
                result = (PipeValue)this.getter.invoke(this.businessObject, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (IllegalAccessException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (InvocationTargetException e) {
                this.throwDevFailed(e);
            }
        }
        return result;
    }

    @Override
    public void setValue(PipeValue value) throws DevFailed {
        if (this.setter != null) {
            try {
                this.setter.invoke(this.businessObject, value);
            }
            catch (IllegalArgumentException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (IllegalAccessException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
            catch (InvocationTargetException e) {
                this.throwDevFailed(e);
            }
        }
    }

    @Override
    public StateMachineBehavior getStateMachine() throws DevFailed {
        return null;
    }

    private void throwDevFailed(InvocationTargetException e) throws DevFailed {
        if (e.getCause() instanceof DevFailed) {
            throw (DevFailed)e.getCause();
        }
        throw DevFailedUtils.newDevFailed(e.getCause());
    }

    @Override
    public PipeConfiguration getConfiguration() {
        return this.config;
    }
}

