/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.pipe;

import fr.esrf.Tango.DevFailed;
import org.tango.server.DeviceBehaviorObject;
import org.tango.server.IReadableWritable;
import org.tango.server.pipe.IPipeBehavior;
import org.tango.server.pipe.PipeConfiguration;
import org.tango.server.pipe.PipeValue;

public final class PipeImpl
extends DeviceBehaviorObject
implements Comparable<PipeImpl>,
IReadableWritable<PipeValue> {
    private final IPipeBehavior behavior;
    private final String name;
    private final PipeConfiguration config;
    private PipeValue readValue;
    private PipeValue writeValue;
    private final String deviceName;

    public PipeImpl(IPipeBehavior behavior, String deviceName) {
        this.behavior = behavior;
        this.deviceName = deviceName;
        this.config = behavior.getConfiguration();
        this.name = behavior.getConfiguration().getName();
    }

    @Override
    public void updateValue() throws DevFailed {
        this.updateValue(this.behavior.getValue());
    }

    @Override
    public void updateValue(PipeValue inValue) throws DevFailed {
        this.readValue = inValue;
    }

    @Override
    public void setValue(PipeValue value) throws DevFailed {
        this.writeValue = value;
        this.behavior.setValue(value);
    }

    public PipeConfiguration getConfiguration() {
        return this.config;
    }

    public void loadConfiguration() throws DevFailed {
        this.config.load(this.deviceName);
    }

    public void setConfiguration(String label, String description) throws DevFailed {
        this.config.setLabel(label);
        this.config.setDescription(description);
        this.config.persist(this.deviceName);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(PipeImpl o) {
        return this.getConfiguration().getName().compareTo(o.behavior.getConfiguration().getName());
    }

    @Override
    public PipeValue getWriteValue() {
        return this.writeValue;
    }

    @Override
    public PipeValue getReadValue() {
        return this.readValue;
    }
}

