/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.monitoring;

import fr.esrf.Tango.ClntIdent;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevSource;
import java.io.Closeable;
import org.tango.server.history.DeviceBlackBox;
import org.tango.server.monitoring.TangoStats;

public class DeviceMonitoring {
    private static final String SEPARATOR = " - ";
    private final String deviceName;
    private final DeviceBlackBox blackbox;
    private final TangoStats monitoring;

    public DeviceMonitoring(String deviceName) {
        this.deviceName = deviceName;
        this.blackbox = new DeviceBlackBox();
        this.monitoring = TangoStats.getInstance();
    }

    public Request startRequest(String request) {
        this.blackbox.insertInblackBox(request);
        return new Request(this.deviceName + SEPARATOR + request);
    }

    public Request startRequest(String request, ClntIdent clt) {
        this.blackbox.insertInblackBox(request, clt);
        return new Request(this.deviceName + SEPARATOR + request);
    }

    public Request startRequest(String request, DevSource devSource) {
        this.blackbox.insertInblackBox(request, devSource);
        return new Request(this.deviceName + SEPARATOR + request);
    }

    public Request startRequest(String request, DevSource devSource, ClntIdent clt) {
        this.blackbox.insertInblackBox(request, devSource, clt);
        return new Request(this.deviceName + SEPARATOR + request);
    }

    public void addError() {
        this.monitoring.addError();
    }

    public void endRequest(long id) {
        this.monitoring.endRequest(id);
    }

    public String[] getBlackBox(int size) throws DevFailed {
        return this.blackbox.toArray(size);
    }

    public class Request
    implements Closeable {
        public final long id;

        Request(String request) {
            this.id = DeviceMonitoring.this.monitoring.addRequest(request);
        }

        @Override
        public void close() {
            DeviceMonitoring.this.monitoring.endRequest(this.id);
        }
    }
}

