/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.lock;

import fr.esrf.Tango.ClntIdent;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.LockerLanguage;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.client.database.DatabaseFactory;
import org.tango.orb.ServerRequestInterceptor;
import org.tango.server.Chronometer;
import org.tango.utils.ClientIDUtil;
import org.tango.utils.DevFailedUtils;

public final class ClientLocking {
    private static final int _6 = 6;
    private static final int _3 = 3;
    private final Logger logger = LoggerFactory.getLogger(ClientLocking.class);
    private final String deviceName;
    private final Chronometer clientLockChrono = new Chronometer();
    private ClntIdent clientIdentityLock = new ClntIdent();
    private ClntIdent previousLocker = new ClntIdent();
    private String lockerHost = "";
    private int lockDuration;
    private boolean hasBeenForced = false;
    private String[] allowedCommands = new String[0];
    private int lockingCounter;

    public ClientLocking(String deviceName, String className) {
        this.deviceName = deviceName;
        this.lockingCounter = 0;
        this.hasBeenForced = false;
        try {
            String access = DatabaseFactory.getDatabase().getAccessDeviceName();
            if (!access.isEmpty()) {
                DeviceData in = new DeviceData();
                in.insert(className);
                this.allowedCommands = new DeviceProxy(access).command_inout("GetAllowedCommands", in).extractStringArray();
            }
        }
        catch (DevFailed e) {
            this.logger.error("failed to retrieve tango access control - {}", (Object)DevFailedUtils.toString(e));
        }
    }

    public void init() {
        this.lockingCounter = 0;
    }

    public void relock() throws DevFailed {
        this.unLock(false);
        this.lock(this.lockDuration, this.clientIdentityLock, this.lockerHost);
    }

    public void lock(int validity, ClntIdent clientIdentity, String hostName) throws DevFailed {
        this.logger.debug("locking for client {}- {}", (Object)hostName, (Object)ClientIDUtil.toString(clientIdentity));
        this.clientIdentityLock = clientIdentity;
        this.lockerHost = hostName;
        this.lockDuration = validity;
        this.clientLockChrono.start((long)validity * 1000L);
        ++this.lockingCounter;
    }

    public void unLock(boolean isForced) {
        if (isForced) {
            this.lockingCounter = 0;
            this.hasBeenForced = true;
            this.previousLocker = this.clientIdentityLock;
        } else {
            this.hasBeenForced = false;
            if (this.lockingCounter > 0) {
                --this.lockingCounter;
            }
        }
        if (this.lockingCounter == 0) {
            this.clientLockChrono.stop();
        }
    }

    public boolean isOver() {
        boolean isOver = this.clientLockChrono.isOver();
        if (this.lockingCounter > 0 && isOver) {
            --this.lockingCounter;
        }
        return isOver;
    }

    public void checkClientLocking(ClntIdent clIdent, String ... names) throws DevFailed {
        this.logger.debug("check for client {} - {}", (Object)ServerRequestInterceptor.getInstance().getGiopHostAddress(), (Object)ClientIDUtil.toString(clIdent));
        boolean doCheck = true;
        for (String name : names) {
            if (!ArrayUtils.contains(this.allowedCommands, name)) continue;
            doCheck = false;
            break;
        }
        if (doCheck && !ArrayUtils.contains(names, "State") && !ArrayUtils.contains(names, "Status")) {
            if (!(this.clientLockChrono.isOver() || this.lockerHost.equalsIgnoreCase(ServerRequestInterceptor.getInstance().getGiopHostAddress()) || ClientIDUtil.clientIdentEqual(clIdent, this.clientIdentityLock))) {
                throw DevFailedUtils.newDevFailed("API_DeviceLocked", "device is locked by " + this.lockerHost + "- " + ClientIDUtil.toString(clIdent));
            }
            if (this.hasBeenForced && ClientIDUtil.clientIdentEqual(clIdent, this.previousLocker)) {
                this.hasBeenForced = false;
                throw DevFailedUtils.newDevFailed("API_DeviceUnlocked", "device unlock was forced");
            }
        }
    }

    public DevVarLongStringArray getLockStatus() {
        String[] strings = new String[3];
        int[] longs = new int[6];
        if (!this.clientLockChrono.isOver()) {
            strings[1] = this.lockerHost;
            longs[0] = 1;
            strings[0] = "Device " + this.deviceName + " is locked by " + this.lockerHost;
            if (this.clientIdentityLock.discriminator().equals(LockerLanguage.CPP)) {
                strings[2] = "Not defined";
                longs[1] = this.clientIdentityLock.cpp_clnt();
                for (int i = 2; i < longs.length; ++i) {
                    longs[i] = 0;
                }
            } else {
                strings[2] = this.clientIdentityLock.java_clnt().MainClass;
                longs[1] = 0;
                for (int i = 0; i < this.clientIdentityLock.java_clnt().uuid.length; ++i) {
                    longs[i + 2] = (int)this.clientIdentityLock.java_clnt().uuid[i];
                }
            }
        } else {
            strings[0] = "Device " + this.deviceName + " is not locked";
            strings[1] = "Not defined";
            strings[2] = "Not defined";
            Arrays.fill(longs, 0);
        }
        return new DevVarLongStringArray(longs, strings);
    }

    public boolean isHasBeenForced() {
        return this.hasBeenForced;
    }
}

