/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.TangoConst;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tango.utils.DevFailedUtils;

public enum EventType {
    CHANGE_EVENT(0, TangoConst.eventNames[0]),
    PERIODIC_EVENT(2, TangoConst.eventNames[2]),
    ARCHIVE_EVENT(3, TangoConst.eventNames[3]),
    USER_EVENT(4, TangoConst.eventNames[4]),
    ATT_CONF_EVENT(5, TangoConst.eventNames[5]),
    DATA_READY_EVENT(6, TangoConst.eventNames[6]),
    INTERFACE_CHANGE_EVENT(7, TangoConst.eventNames[7]),
    PIPE_EVENT(8, TangoConst.eventNames[8]);

    private static final Map<String, EventType> EVENT_TYPE_MAP;
    private static final Map<Integer, EventType> EVENT_TYPE_INT_MAP;
    private static final List<EventType> EVENT_ATTR_VALUE_TYPE_LIST;
    private int value;
    private String string;

    private EventType(int value, String string2) {
        this.value = value;
        this.string = string2;
    }

    public static EventType getEvent(String string) throws DevFailed {
        EventType result = EVENT_TYPE_MAP.get(string);
        if (result == null) {
            throw DevFailedUtils.newDevFailed(string + " is not an event type");
        }
        return result;
    }

    public static EventType getEvent(int eventValue) throws DevFailed {
        EventType result = EVENT_TYPE_INT_MAP.get(eventValue);
        if (result == null) {
            throw DevFailedUtils.newDevFailed(eventValue + " is not an event type");
        }
        return result;
    }

    public static List<EventType> getEventAttrValueTypeList() {
        return EVENT_ATTR_VALUE_TYPE_LIST;
    }

    public String getString() {
        return this.string;
    }

    public int getValue() {
        return this.value;
    }

    static {
        EVENT_TYPE_MAP = new HashMap<String, EventType>();
        EVENT_TYPE_INT_MAP = new HashMap<Integer, EventType>();
        EVENT_ATTR_VALUE_TYPE_LIST = new ArrayList<EventType>();
        for (EventType s : EnumSet.allOf(EventType.class)) {
            EVENT_TYPE_MAP.put(s.getString(), s);
        }
        for (EventType s : EnumSet.allOf(EventType.class)) {
            EVENT_TYPE_INT_MAP.put(s.getValue(), s);
        }
        EVENT_ATTR_VALUE_TYPE_LIST.add(CHANGE_EVENT);
        EVENT_ATTR_VALUE_TYPE_LIST.add(PERIODIC_EVENT);
        EVENT_ATTR_VALUE_TYPE_LIST.add(ARCHIVE_EVENT);
        EVENT_ATTR_VALUE_TYPE_LIST.add(USER_EVENT);
    }
}

