/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.EventProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.events.ChangeEventTrigger;
import org.tango.server.events.IEventTrigger;
import org.tango.server.events.PeriodicEventTrigger;
import org.tango.utils.DevFailedUtils;

public class ArchiveEventTrigger
implements IEventTrigger {
    private final Logger logger = LoggerFactory.getLogger(ArchiveEventTrigger.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(ArchiveEventTrigger.class);
    private final ChangeEventTrigger change;
    private PeriodicEventTrigger periodic = null;
    private final AttributeImpl attribute;

    public ArchiveEventTrigger(long period, String absolute, String relative, AttributeImpl attribute) {
        this.attribute = attribute;
        this.periodic = new PeriodicEventTrigger(period, attribute);
        this.change = new ChangeEventTrigger(attribute, absolute, relative);
    }

    @Override
    public boolean isSendEvent() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        boolean isSend = this.periodic.isSendEvent();
        if (!isSend) {
            isSend = this.change.isSendEvent();
        }
        this.logger.debug("ARCHIVE event must send: {}", (Object)isSend);
        this.xlogger.exit();
        return isSend;
    }

    @Override
    public void setError(DevFailed error) {
        this.change.setError(error);
    }

    public static void checkEventCriteria(AttributeImpl attribute) throws DevFailed {
        if (attribute.isState() || attribute.isString()) {
            return;
        }
        EventProperties props = attribute.getProperties().getEventProp();
        if (props.arch_event.period.equals("Not specified") && props.arch_event.abs_change.equals("Not specified") && props.arch_event.rel_change.equals("Not specified")) {
            throw DevFailedUtils.newDevFailed("API_EventPropertiesNotSet", "Archive event properties (archive_abs_change or archive_rel_change or archive_period) for attribute " + attribute.getName() + " are not set");
        }
    }

    @Override
    public void updateProperties() throws DevFailed {
        EventProperties props = this.attribute.getProperties().getEventProp();
        long period = -1L;
        try {
            period = Long.parseLong(props.arch_event.period);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.periodic.setPeriod(period);
        this.change.setCriteria(props.arch_event.abs_change, props.arch_event.rel_change);
    }

    @Override
    public boolean doCheck() {
        return this.attribute.isPushArchiveEvent() ? this.attribute.isCheckArchivingEvent() : true;
    }
}

