/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.annotation.Pipe;
import org.tango.server.build.BuilderUtils;
import org.tango.server.pipe.PipeConfiguration;
import org.tango.server.pipe.PipeImpl;
import org.tango.server.pipe.PipeValue;
import org.tango.server.pipe.ReflectPipeBehavior;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;

final class PipeBuilder {
    private final Logger logger = LoggerFactory.getLogger(PipeBuilder.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(PipeBuilder.class);

    PipeBuilder() {
    }

    public void build(DeviceImpl device, Object businessObject, Field field) throws DevFailed {
        String fieldName = field.getName();
        this.xlogger.entry(fieldName);
        Class<?> type = field.getType();
        if (!type.equals(PipeValue.class)) {
            throw DevFailedUtils.newDevFailed("INIT_ERROR", fieldName + " must be a PipeValue");
        }
        String getterName = "get" + fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
        Method getter = null;
        try {
            getter = businessObject.getClass().getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        String setterName = "set" + fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
        Method setter = null;
        try {
            setter = businessObject.getClass().getMethod(setterName, type);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (setter == null && getter == null) {
            throw DevFailedUtils.newDevFailed("INIT_ERROR", getterName + " or " + setterName + " method not found");
        }
        Pipe annot = field.getAnnotation(Pipe.class);
        String pipeName = BuilderUtils.getPipeName(fieldName, annot);
        PipeConfiguration config = BuilderUtils.getPipeConfiguration(type, getter, setter, annot, pipeName);
        PipeImpl pipe = new PipeImpl(new ReflectPipeBehavior(config, businessObject, getter, setter), device.getName());
        this.logger.debug("Has a pipe: {}", (Object)pipe.getName());
        BuilderUtils.setStateMachine(field, pipe);
        device.addPipe(pipe);
        this.xlogger.exit(field.getName());
    }
}

