/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.annotation.Init;
import org.tango.server.build.BuilderUtils;
import org.tango.server.device.InitImpl;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;

final class InitBuilder {
    private final Logger logger = LoggerFactory.getLogger(InitBuilder.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(InitBuilder.class);

    InitBuilder() {
    }

    public void build(Method method, DeviceImpl device, Object businessObject) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        this.logger.debug("Has an init method: {}", (Object)method.getName());
        if (method.getParameterTypes().length != 0 && method.getReturnType() != Void.TYPE) {
            throw DevFailedUtils.newDevFailed("TANGO_BUILD_FAILED", method + " must not be void void");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw DevFailedUtils.newDevFailed("TANGO_BUILD_FAILED", method + " must not be static");
        }
        Init annot = method.getAnnotation(Init.class);
        InitImpl init = device.buildInit(method, annot.lazyLoading());
        BuilderUtils.setStateMachine(method, init);
        this.xlogger.exit();
    }
}

