/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.annotation.ClassProperty;
import org.tango.server.build.BuilderUtils;
import org.tango.server.properties.ClassPropertyImpl;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;

final class ClassPropertyBuilder {
    private final Logger logger = LoggerFactory.getLogger(ClassPropertyBuilder.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(ClassPropertyBuilder.class);

    ClassPropertyBuilder() {
    }

    public void build(Class<?> clazz, Field field, DeviceImpl device, Object businessObject) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        ClassProperty annot = field.getAnnotation(ClassProperty.class);
        String fieldName = field.getName();
        String propName = annot.name().equals("") ? fieldName : annot.name();
        this.logger.debug("Has a ClassProperty : {}", (Object)propName);
        BuilderUtils.checkStatic(field);
        String setterName = "set" + fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
        Method setter = null;
        try {
            setter = businessObject.getClass().getMethod(setterName, field.getType());
        }
        catch (NoSuchMethodException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        ClassPropertyImpl property = new ClassPropertyImpl(propName, annot.description(), setter, businessObject, device.getClassName(), annot.defaultValue());
        device.addClassProperty(property);
        this.xlogger.exit();
    }
}

